/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2fgdb;

import ch.ehi.basics.settings.Settings;
import ch.ehi.ili2db.converter.AbstractWKBColumnConverter;
import ch.ehi.ili2db.converter.ConverterException;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2fgdb.Fgdb2iox;
import ch.ehi.ili2fgdb.Iox2fgdb;
import ch.ehi.sqlgen.generator_impl.fgdb.GeneratorFgdb;
import ch.interlis.iom.IomObject;
import ch.interlis.iox.IoxException;
import ch.interlis.iox_j.jts.Iox2jtsException;
import ch.interlis.iox_j.wkb.Iox2wkbException;
import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.iharder.Base64;

public class FgdbColumnConverter
extends AbstractWKBColumnConverter {
    private boolean strokeArcs = true;

    public Integer getSrsid(String crsAuthority, String crsCode, Connection conn) throws ConverterException {
        Integer srsid = GeneratorFgdb.getSrsId(crsAuthority, crsCode);
        return srsid;
    }

    public void setup(Connection conn, Settings config) {
        super.setup(conn, config);
        this.strokeArcs = "enable".equals(Config.getStrokeArcs((Settings)config));
    }

    public String getInsertValueWrapperCoord(String wkfValue, int srid) {
        return wkfValue;
    }

    public String getInsertValueWrapperPolyline(String wkfValue, int srid) {
        return wkfValue;
    }

    public String getInsertValueWrapperMultiPolyline(String wkfValue, int srid) {
        return wkfValue;
    }

    public String getInsertValueWrapperSurface(String wkfValue, int srid) {
        return wkfValue;
    }

    public String getInsertValueWrapperMultiSurface(String wkfValue, int srid) {
        return wkfValue;
    }

    public String getSelectValueWrapperDate(String sqlColName) {
        return sqlColName;
    }

    public String getSelectValueWrapperTime(String sqlColName) {
        return sqlColName;
    }

    public String getSelectValueWrapperDateTime(String sqlColName) {
        return sqlColName;
    }

    public String getSelectValueWrapperCoord(String dbNativeValue) {
        return dbNativeValue;
    }

    public String getSelectValueWrapperPolyline(String dbNativeValue) {
        return dbNativeValue;
    }

    public String getSelectValueWrapperMultiPolyline(String dbNativeValue) {
        return dbNativeValue;
    }

    public String getSelectValueWrapperSurface(String dbNativeValue) {
        return dbNativeValue;
    }

    public String getSelectValueWrapperMultiSurface(String dbNativeValue) {
        return dbNativeValue;
    }

    public Object fromIomUuid(String uuid) throws SQLException, ConverterException {
        return uuid;
    }

    public Object fromIomXml(String xml) throws SQLException, ConverterException {
        return xml;
    }

    public Object fromIomBlob(String blob) throws SQLException, ConverterException {
        byte[] bytearray;
        try {
            bytearray = Base64.decode((String)blob);
        }
        catch (IOException e) {
            throw new ConverterException((Throwable)e);
        }
        return bytearray;
    }

    public Object fromIomSurface(IomObject value, int srsid, boolean hasLineAttr, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            Iox2fgdb conv = new Iox2fgdb(is3D ? 3 : 2);
            try {
                return conv.surface2wkb(value, !this.strokeArcs, p, srsid);
            }
            catch (IoxException ex) {
                throw new ConverterException((Throwable)ex);
            }
            catch (Iox2jtsException ex) {
                throw new ConverterException((Throwable)ex);
            }
        }
        return null;
    }

    public Object fromIomMultiSurface(IomObject value, int srsid, boolean hasLineAttr, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            Iox2fgdb conv = new Iox2fgdb(is3D ? 3 : 2);
            try {
                return conv.multisurface2wkb(value, !this.strokeArcs, p, srsid);
            }
            catch (IoxException ex) {
                throw new ConverterException((Throwable)ex);
            }
            catch (Iox2jtsException ex) {
                throw new ConverterException((Throwable)ex);
            }
        }
        return null;
    }

    public Object fromIomCoord(IomObject value, int srsid, boolean is3D) throws SQLException, ConverterException {
        if (value != null) {
            Iox2fgdb conv = new Iox2fgdb(is3D ? 3 : 2);
            try {
                return conv.coord2wkb(value, srsid);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException((Throwable)ex);
            }
        }
        return null;
    }

    public Object fromIomPolyline(IomObject value, int srsid, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            Iox2fgdb conv = new Iox2fgdb(is3D ? 3 : 2);
            try {
                return conv.polyline2wkb(value, false, !this.strokeArcs, p, srsid);
            }
            catch (IoxException ex) {
                throw new ConverterException((Throwable)ex);
            }
            catch (Iox2jtsException ex) {
                throw new ConverterException((Throwable)ex);
            }
        }
        return null;
    }

    public Object fromIomMultiPolyline(IomObject value, int srsid, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            Iox2fgdb conv = new Iox2fgdb(is3D ? 3 : 2);
            try {
                return conv.multiline2wkb(value, !this.strokeArcs, p, srsid);
            }
            catch (IoxException ex) {
                throw new ConverterException((Throwable)ex);
            }
            catch (Iox2jtsException ex) {
                throw new ConverterException((Throwable)ex);
            }
        }
        return null;
    }

    public IomObject toIomCoord(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        byte[] bv = (byte[])geomobj;
        Fgdb2iox conv = new Fgdb2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
        catch (IoxException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public IomObject toIomSurface(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        byte[] bv = (byte[])geomobj;
        Fgdb2iox conv = new Fgdb2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
        catch (IoxException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public IomObject toIomMultiSurface(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        byte[] bv = (byte[])geomobj;
        Fgdb2iox conv = new Fgdb2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
        catch (IoxException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public IomObject toIomPolyline(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        byte[] bv = (byte[])geomobj;
        Fgdb2iox conv = new Fgdb2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
        catch (IoxException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public IomObject toIomMultiPolyline(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        byte[] bv = (byte[])geomobj;
        Fgdb2iox conv = new Fgdb2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
        catch (IoxException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public String toIomXml(Object obj) throws SQLException, ConverterException {
        return (String)obj;
    }

    public String toIomBlob(Object obj) throws SQLException, ConverterException {
        String s = Base64.encodeBytes((byte[])((byte[])obj));
        return s;
    }

    public void setXmlNull(PreparedStatement stmt, int parameterIndex) throws SQLException {
        stmt.setNull(parameterIndex, 12);
    }

    public void setBlobNull(PreparedStatement stmt, int parameterIndex) throws SQLException {
        stmt.setNull(parameterIndex, -3);
    }
}

