/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2fgdb;

import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurveRing;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iox.IoxException;
import ch.interlis.iox_j.jts.Iox2jts;
import ch.interlis.iox_j.jts.Iox2jtsException;
import ch.interlis.iox_j.jts.Iox2jtsext;
import ch.interlis.iox_j.wkb.ByteArrayOutputStream;
import ch.interlis.iox_j.wkb.Iox2wkbException;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class Iox2fgdb {
    private int outputDimension = 2;
    private ByteArrayOutputStream os = null;

    private Iox2fgdb() {
    }

    public Iox2fgdb(int outputDimension) {
        this(outputDimension, ByteOrder.LITTLE_ENDIAN);
    }

    public Iox2fgdb(int outputDimension, ByteOrder byteOrder) {
        this.outputDimension = outputDimension;
        this.os = new ByteArrayOutputStream(byteOrder);
        if (outputDimension < 2 || outputDimension > 3) {
            throw new IllegalArgumentException("Output dimension must be 2 or 3");
        }
    }

    public byte[] coord2wkb(IomObject obj, int srsId) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        this.os.reset();
        this.os.writeInt(1);
        this.writeCoord(obj);
        return this.os.toByteArray();
    }

    public byte[] polyline2wkb(IomObject polylineObj, boolean isSurfaceOrArea, boolean asCompoundCurve, double p, int srsId) throws IoxException, Iox2jtsException {
        if (polylineObj == null) {
            return null;
        }
        byte[] ret = null;
        LineString polyline = null;
        this.os.reset();
        if (asCompoundCurve) {
            polyline = Iox2jtsext.polyline2JTS(polylineObj, false, p);
            int shapeType = 50;
            shapeType |= 0x20000000;
            this.os.writeInt(shapeType |= this.outputDimension == 3 ? Integer.MIN_VALUE : 0);
        } else {
            polyline = Iox2jts.polyline2JTSlineString(polylineObj, false, p);
            if (this.outputDimension == 3) {
                this.os.writeInt(10);
            } else {
                this.os.writeInt(3);
            }
        }
        Envelope env = polyline.getEnvelopeInternal();
        this.os.writeDouble(env.getMinX());
        this.os.writeDouble(env.getMinY());
        this.os.writeDouble(env.getMaxX());
        this.os.writeDouble(env.getMaxY());
        int cPart = 1;
        int cPoints = this.getNumPoints(polyline);
        this.os.writeInt(cPart);
        this.os.writeInt(cPoints);
        int partStart = 0;
        this.os.writeInt(partStart);
        ArrayList<Arc> arcs = null;
        if (asCompoundCurve) {
            arcs = new ArrayList<Arc>();
        }
        ArrayList<Double> zv = null;
        if (this.outputDimension == 3) {
            zv = new ArrayList<Double>();
        }
        double[] zMin = new double[1];
        double[] zMax = new double[1];
        Coordinate coord = polyline.getStartPoint().getCoordinate();
        if (this.outputDimension == 3) {
            zMin[0] = coord.z;
            zMax[0] = coord.z;
        }
        int startPtIdx = 0;
        this.writePoints(polyline, false, zv, zMin, zMax, startPtIdx, arcs);
        if (this.outputDimension == 3) {
            this.os.writeDouble(zMin[0]);
            this.os.writeDouble(zMax[0]);
            for (Double z : zv) {
                this.os.writeDouble(z);
            }
        }
        if (asCompoundCurve) {
            this.writeArcs(arcs);
        }
        ret = this.os.toByteArray();
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] multiline2wkb(IomObject obj, boolean asCompoundCurve, double p, int srsId) throws IoxException, Iox2jtsException {
        void var12_18;
        if (obj == null) {
            return null;
        }
        this.os.reset();
        int polylinec = obj.getattrvaluecount("polyline");
        if (asCompoundCurve) {
            int shapeType = 50;
            shapeType |= 0x20000000;
            this.os.writeInt(shapeType |= this.outputDimension == 3 ? Integer.MIN_VALUE : 0);
        } else if (this.outputDimension == 3) {
            this.os.writeInt(10);
        } else {
            this.os.writeInt(3);
        }
        ArrayList<LineString> curves = new ArrayList<LineString>();
        Envelope env = new Envelope();
        for (int polylinei = 0; polylinei < polylinec; ++polylinei) {
            IomObject polyline = obj.getattrobj("polyline", polylinei);
            Object curve = null;
            curve = asCompoundCurve ? Iox2jtsext.polyline2JTS(polyline, false, p) : Iox2jts.polyline2JTSlineString(polyline, false, p);
            curves.add((LineString)curve);
            env.expandToInclude(((Geometry)curve).getEnvelopeInternal());
        }
        this.os.writeDouble(env.getMinX());
        this.os.writeDouble(env.getMinY());
        this.os.writeDouble(env.getMaxX());
        this.os.writeDouble(env.getMaxY());
        int cPart = curves.size();
        int cPoints = 0;
        for (LineString lineString : curves) {
            cPoints += this.getNumPoints(lineString);
        }
        this.os.writeInt(cPart);
        this.os.writeInt(cPoints);
        int partStart = 0;
        for (LineString curve : curves) {
            this.os.writeInt(partStart);
            partStart += this.getNumPoints(curve);
        }
        Object var12_16 = null;
        if (asCompoundCurve) {
            ArrayList arrayList = new ArrayList();
        }
        ArrayList<Double> zv = null;
        if (this.outputDimension == 3) {
            zv = new ArrayList<Double>();
        }
        double[] zMin = new double[1];
        double[] zMax = new double[1];
        Coordinate coord = ((LineString)curves.get(0)).getStartPoint().getCoordinate();
        if (this.outputDimension == 3) {
            zMin[0] = coord.z;
            zMax[0] = coord.z;
        }
        int startPtIdx = 0;
        for (LineString curve : curves) {
            this.writePoints(curve, true, zv, zMin, zMax, startPtIdx, (List<Arc>)var12_18);
            startPtIdx += this.getNumPoints(curve);
        }
        if (this.outputDimension == 3) {
            this.os.writeDouble(zMin[0]);
            this.os.writeDouble(zMax[0]);
            for (Double z : zv) {
                this.os.writeDouble(z);
            }
        }
        if (asCompoundCurve) {
            this.writeArcs((ArrayList<Arc>)var12_18);
        }
        return this.os.toByteArray();
    }

    private void writeArcs(ArrayList<Arc> arcs) {
        this.os.writeInt(arcs.size());
        for (Arc arc : arcs) {
            this.os.writeInt(arc.startPointIndex);
            this.os.writeInt(1);
            this.os.writeDouble(arc.centerPoint_x);
            this.os.writeDouble(arc.centerPoint_y);
            this.os.writeInt(arc.bits);
        }
    }

    public byte[] surface2wkb(IomObject polygonObj, boolean asCurvePolygon, double strokeP, int srsId) throws IoxException, Iox2jtsException {
        if (polygonObj == null) {
            return null;
        }
        byte[] ret = null;
        Polygon polygon = null;
        this.os.reset();
        if (asCurvePolygon) {
            polygon = Iox2jtsext.surface2JTS(polygonObj, strokeP);
            int shapeType = 51;
            shapeType |= 0x20000000;
            this.os.writeInt(shapeType |= this.outputDimension == 3 ? Integer.MIN_VALUE : 0);
        } else {
            polygon = Iox2jts.surface2JTS(polygonObj, strokeP);
            if (this.outputDimension == 3) {
                this.os.writeInt(19);
            } else {
                this.os.writeInt(5);
            }
        }
        Envelope env = polygon.getEnvelopeInternal();
        this.os.writeDouble(env.getMinX());
        this.os.writeDouble(env.getMinY());
        this.os.writeDouble(env.getMaxX());
        this.os.writeDouble(env.getMaxY());
        int cPart = 1;
        int cPoints = this.getNumPoints(polygon.getExteriorRing());
        int holec = polygon.getNumInteriorRing();
        cPart += holec;
        for (int holei = 0; holei < holec; ++holei) {
            cPoints += this.getNumPoints(polygon.getInteriorRingN(holei));
        }
        this.os.writeInt(cPart);
        this.os.writeInt(cPoints);
        int partStart = 0;
        this.os.writeInt(partStart);
        partStart += this.getNumPoints(polygon.getExteriorRing());
        for (int holei = 0; holei < holec; ++holei) {
            this.os.writeInt(partStart);
            partStart += this.getNumPoints(polygon.getInteriorRingN(holei));
        }
        ArrayList<Arc> arcs = null;
        if (asCurvePolygon) {
            arcs = new ArrayList<Arc>();
        }
        ArrayList<Double> zv = null;
        if (this.outputDimension == 3) {
            zv = new ArrayList<Double>();
        }
        double[] zMin = new double[1];
        double[] zMax = new double[1];
        Coordinate coord = polygon.getExteriorRing().getStartPoint().getCoordinate();
        if (this.outputDimension == 3) {
            zMin[0] = coord.z;
            zMax[0] = coord.z;
        }
        LineString polyline = polygon.getExteriorRing();
        int startPtIdx = 0;
        if (CGAlgorithms.isCCW((polyline = this.asOneLine(polyline)).getCoordinates())) {
            polyline = (LineString)polyline.reverse();
        }
        this.writePoints(polyline, false, zv, zMin, zMax, startPtIdx, arcs);
        startPtIdx += this.getNumPoints(polyline);
        for (int holei = 0; holei < holec; ++holei) {
            polyline = polygon.getInteriorRingN(holei);
            if (!CGAlgorithms.isCCW((polyline = this.asOneLine(polyline)).getCoordinates())) {
                polyline = (LineString)polyline.reverse();
            }
            this.writePoints(polyline, true, zv, zMin, zMax, startPtIdx, arcs);
            startPtIdx += this.getNumPoints(polyline);
        }
        if (this.outputDimension == 3) {
            this.os.writeDouble(zMin[0]);
            this.os.writeDouble(zMax[0]);
            for (Double z : zv) {
                this.os.writeDouble(z);
            }
        }
        if (asCurvePolygon) {
            this.writeArcs(arcs);
        }
        ret = this.os.toByteArray();
        return ret;
    }

    private LineString asOneLine(LineString polyline) {
        if (!(polyline instanceof CompoundCurveRing)) {
            return polyline;
        }
        ArrayList<CurveSegment> segments = new ArrayList<CurveSegment>();
        for (CompoundCurve curve : ((CompoundCurveRing)polyline).getLines()) {
            segments.addAll(curve.getSegments());
        }
        CompoundCurve line = new CompoundCurve(segments, polyline.getFactory());
        return line;
    }

    private int getNumPoints(LineString line) {
        if (line instanceof CompoundCurve) {
            return ((CompoundCurve)line).getNumSegments() + 1;
        }
        if (line instanceof CompoundCurveRing) {
            int ptc = 1;
            for (CompoundCurve curve : ((CompoundCurveRing)line).getLines()) {
                ptc += curve.getNumSegments();
            }
            return ptc;
        }
        return line.getNumPoints();
    }

    private void writePoints(LineString line, boolean isCCW, ArrayList<Double> zv, double[] zMin, double[] zMax, int startPtIdx, List<Arc> arcs) {
        if (line instanceof CompoundCurve) {
            CompoundCurve polyline = (CompoundCurve)line;
            CurveSegment seg = polyline.getSegments().get(0);
            Coordinate coord = seg.getStartPoint();
            this.os.writeDouble(coord.x);
            this.os.writeDouble(coord.y);
            if (zv != null) {
                double z = coord.z;
                zv.add(z);
                if (z < zMin[0]) {
                    zMin[0] = z;
                }
                if (z > zMax[0]) {
                    zMax[0] = z;
                }
            }
            int arcSegc = 0;
            for (int i = 0; i < polyline.getNumSegments(); ++i) {
                CurveSegment seg2 = polyline.getSegments().get(i);
                if (seg2 instanceof ArcSegment) {
                    ++arcSegc;
                    ArcSegment arcSeg = (ArcSegment)seg2;
                    Coordinate ip = arcSeg.getMidPoint();
                    int flags = 0;
                    Arc arc = new Arc(startPtIdx + i, ip.x, ip.y, flags |= 0x80);
                    arcs.add(arc);
                }
                Coordinate coord2 = seg2.getEndPoint();
                this.os.writeDouble(coord2.x);
                this.os.writeDouble(coord2.y);
                if (zv == null) continue;
                double z = coord2.z;
                zv.add(z);
                if (z < zMin[0]) {
                    zMin[0] = z;
                }
                if (!(z > zMax[0])) continue;
                zMax[0] = z;
            }
            return;
        }
        for (Coordinate coord : line.getCoordinates()) {
            this.os.writeDouble(coord.x);
            this.os.writeDouble(coord.y);
            if (zv == null) continue;
            double z = coord.z;
            zv.add(z);
            if (z < zMin[0]) {
                zMin[0] = z;
            }
            if (!(z > zMax[0])) continue;
            zMax[0] = z;
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] multisurface2wkb(IomObject multisurfaceObj, boolean asCurvePolygon, double strokeP, int srsId) throws IoxException, Iox2jtsException {
        void var13_24;
        if (multisurfaceObj == null) {
            return null;
        }
        byte[] ret = null;
        this.os.reset();
        if (asCurvePolygon) {
            int shapeType = 51;
            shapeType |= 0x20000000;
            this.os.writeInt(shapeType |= this.outputDimension == 3 ? Integer.MIN_VALUE : 0);
        } else if (this.outputDimension == 3) {
            this.os.writeInt(19);
        } else {
            this.os.writeInt(5);
        }
        ArrayList<void> polygons = new ArrayList<void>();
        Envelope env = new Envelope();
        int surfacec = multisurfaceObj.getattrvaluecount("surface");
        for (int surfacei = 0; surfacei < surfacec; ++surfacei) {
            void var13_15;
            IomObject surface = multisurfaceObj.getattrobj("surface", surfacei);
            Iom_jObject iomSurfaceClone = new Iom_jObject("MULTISURFACE", null);
            iomSurfaceClone.addattrobj("surface", surface);
            Object var13_16 = null;
            if (asCurvePolygon) {
                Polygon polygon = Iox2jtsext.surface2JTS(iomSurfaceClone, strokeP);
            } else {
                Polygon polygon = Iox2jts.surface2JTS(iomSurfaceClone, strokeP);
            }
            polygons.add(var13_15);
            env.expandToInclude(var13_15.getEnvelopeInternal());
        }
        this.os.writeDouble(env.getMinX());
        this.os.writeDouble(env.getMinY());
        this.os.writeDouble(env.getMaxX());
        this.os.writeDouble(env.getMaxY());
        int cPart = 0;
        int cPoints = 0;
        for (Polygon polygon : polygons) {
            ++cPart;
            cPoints += this.getNumPoints(polygon.getExteriorRing());
            int holec = polygon.getNumInteriorRing();
            cPart += holec;
            for (int holei = 0; holei < holec; ++holei) {
                cPoints += this.getNumPoints(polygon.getInteriorRingN(holei));
            }
        }
        this.os.writeInt(cPart);
        this.os.writeInt(cPoints);
        int partStart = 0;
        for (Polygon polygon : polygons) {
            this.os.writeInt(partStart);
            partStart += this.getNumPoints(polygon.getExteriorRing());
            int holec = polygon.getNumInteriorRing();
            for (int holei = 0; holei < holec; ++holei) {
                this.os.writeInt(partStart);
                partStart += this.getNumPoints(polygon.getInteriorRingN(holei));
            }
        }
        Object var13_22 = null;
        if (asCurvePolygon) {
            ArrayList arrayList = new ArrayList();
        }
        ArrayList<Double> zv = null;
        if (this.outputDimension == 3) {
            zv = new ArrayList<Double>();
        }
        double[] zMin = new double[1];
        double[] zMax = new double[1];
        Coordinate coord = ((Polygon)polygons.get(0)).getExteriorRing().getStartPoint().getCoordinate();
        if (this.outputDimension == 3) {
            zMin[0] = coord.z;
            zMax[0] = coord.z;
        }
        int startPtIdx = 0;
        for (Polygon polygon : polygons) {
            LineString polyline = polygon.getExteriorRing();
            if (CGAlgorithms.isCCW((polyline = this.asOneLine(polyline)).getCoordinates())) {
                polyline = (LineString)polyline.reverse();
            }
            this.writePoints(polyline, false, zv, zMin, zMax, startPtIdx, (List<Arc>)var13_24);
            startPtIdx += this.getNumPoints(polyline);
            int holec = polygon.getNumInteriorRing();
            for (int holei = 0; holei < holec; ++holei) {
                polyline = polygon.getInteriorRingN(holei);
                if (!CGAlgorithms.isCCW((polyline = this.asOneLine(polyline)).getCoordinates())) {
                    polyline = (LineString)polyline.reverse();
                }
                this.writePoints(polyline, true, zv, zMin, zMax, startPtIdx, (List<Arc>)var13_24);
                startPtIdx += this.getNumPoints(polyline);
            }
        }
        if (this.outputDimension == 3) {
            this.os.writeDouble(zMin[0]);
            this.os.writeDouble(zMax[0]);
            for (Double z : zv) {
                this.os.writeDouble(z);
            }
        }
        if (asCurvePolygon) {
            this.writeArcs((ArrayList<Arc>)var13_24);
        }
        ret = this.os.toByteArray();
        return ret;
    }

    private void writeCoord(IomObject value) throws Iox2wkbException {
        double yCoord;
        double xCoord;
        String c1 = value.getattrvalue("C1");
        String c2 = value.getattrvalue("C2");
        String c3 = value.getattrvalue("C3");
        try {
            xCoord = Double.parseDouble(c1);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C1 <" + c1 + ">", ex);
        }
        try {
            yCoord = Double.parseDouble(c2);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C2 <" + c2 + ">", ex);
        }
        double zCoord = 0.0;
        if (this.outputDimension == 3) {
            if (c3 != null) {
                try {
                    zCoord = Double.parseDouble(c3);
                }
                catch (Exception ex) {
                    throw new Iox2wkbException("failed to read C3 <" + c3 + ">", ex);
                }
            } else {
                throw new Iox2wkbException("missing C3");
            }
        }
        this.writeCoord(xCoord, yCoord, zCoord);
    }

    private void writeCoord(double xCoord, double yCoord, double zCoord) {
        this.os.writeDouble(xCoord);
        this.os.writeDouble(yCoord);
        if (this.outputDimension == 3) {
            this.os.writeDouble(zCoord);
        }
    }

    private static class Arc {
        public int startPointIndex;
        public double centerPoint_x;
        public double centerPoint_y;
        public int bits;

        public Arc(int startPointIndex, double ip_x, double ip_y, int bits) {
            this.startPointIndex = startPointIndex;
            this.centerPoint_x = ip_x;
            this.centerPoint_y = ip_y;
            this.bits = bits;
        }
    }
}

