/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2fgdb;

import ch.ehi.ili2db.AbstractMain;
import ch.ehi.ili2db.base.DbUrlConverter;
import ch.ehi.ili2db.base.TableBasedIdGen;
import ch.ehi.ili2db.gui.AbstractDbPanelDescriptor;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2fgdb.FgdbColumnConverter;
import ch.ehi.ili2fgdb.FgdbDbPanelDescriptor;
import ch.ehi.ili2fgdb.FgdbMapping;
import ch.ehi.ili2fgdb.InitFgdbApi;
import ch.ehi.ili2fgdb.jdbc.FgdbDriver;
import ch.ehi.sqlgen.generator_impl.fgdb.GeneratorFgdb;
import java.io.File;
import java.text.ParseException;

public class FgdbMain
extends AbstractMain {
    @Override
    public void initConfig(Config config) {
        super.initConfig(config);
        config.setGeometryConverter(FgdbColumnConverter.class.getName());
        config.setDdlGenerator(GeneratorFgdb.class.getName());
        config.setJdbcDriver(FgdbDriver.class.getName());
        config.setIdGenerator(TableBasedIdGen.class.getName());
        config.setIli2dbCustomStrategy(FgdbMapping.class.getName());
        config.setInitStrategy(InitFgdbApi.class.getName());
        config.setOneGeomPerTable(true);
    }

    @Override
    public DbUrlConverter getDbUrlConverter() {
        return new DbUrlConverter(){

            @Override
            public String makeUrl(Config config) {
                if (config.getDbfile() != null) {
                    return "jdbc:ili2fgdb:" + new File(config.getDbfile()).getAbsolutePath();
                }
                return null;
            }
        };
    }

    @Override
    public AbstractDbPanelDescriptor getDbPanelDescriptor() {
        return new FgdbDbPanelDescriptor();
    }

    public static void main(String[] args) {
        new FgdbMain().domain(args);
    }

    @Override
    public String getAPP_NAME() {
        return "ili2fgdb";
    }

    @Override
    public String getDB_PRODUCT_NAME() {
        return "FileGDB";
    }

    @Override
    public String getJAR_NAME() {
        return "ili2fgdb.jar";
    }

    @Override
    protected void printConnectOptions() {
        System.err.println("--dbfile fgdbfolder       The foldername of the database.");
    }

    @Override
    protected void printSpecificOptions() {
        System.err.println("--fgdbXyResolution value  The precision with which coordinates within a feature class are recorded.");
        System.err.println("--fgdbXyTolerance value   The cluster tolerance used to cluster features with coincident geometry.");
    }

    @Override
    protected int doArgs(String[] args, int argi, Config config) throws ParseException {
        String arg = args[argi];
        if (arg.equals("--dbfile")) {
            config.setDbfile(args[++argi]);
            ++argi;
        } else if (arg.equals("--fgdbXyResolution")) {
            config.setValue("ch.ehi.ilifgdb.xyResolution", args[++argi]);
            ++argi;
        } else if (arg.equals("--fgdbXyTolerance")) {
            config.setValue("ch.ehi.ilifgdb.xyTolerance", args[++argi]);
            ++argi;
        }
        return argi;
    }
}

