/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2fgdb;

import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurvePolygon;
import ch.interlis.iom_j.itf.impl.jtsext.geom.JtsextGeometryFactory;
import ch.interlis.iom_j.itf.impl.jtsext.geom.StraightSegment;
import ch.interlis.iox.IoxException;
import ch.interlis.iox_j.jts.Iox2jtsException;
import ch.interlis.iox_j.jts.Jtsext2iox;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ByteArrayInStream;
import com.vividsolutions.jts.io.ByteOrderDataInStream;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Fgdb2iox {
    @Deprecated
    private int inputDimension = 2;
    private boolean hasZ = false;
    private ByteOrderDataInStream dis = new ByteOrderDataInStream();
    @Deprecated
    private double[] ordValues;

    public IomObject read(byte[] bytes) throws ParseException, IoxException {
        try {
            return this.read((InStream)new ByteArrayInStream(bytes));
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IOException caught: " + ex.getMessage());
        }
    }

    public IomObject read(InStream is) throws IOException, ParseException, IoxException {
        this.dis.setInStream(is);
        IomObject g = this.readGeometry();
        return g;
    }

    private IomObject readGeometry() throws IOException, ParseException, IoxException {
        int i;
        this.dis.setOrder(2);
        int typeInt = this.dis.readInt();
        int geometryType = typeInt & 0xFF;
        if (geometryType == 0) {
            return null;
        }
        this.hasZ = geometryType == 11 || geometryType == 9 || geometryType == 18 || geometryType == 20 || geometryType == 13 || geometryType == 10 || geometryType == 15 || geometryType == 19 || (geometryType == 52 || geometryType == 50 || geometryType == 51 || geometryType == 53 || geometryType == 54) && (typeInt & Integer.MIN_VALUE) != 0;
        boolean hasM = geometryType == 11 || geometryType == 21 || geometryType == 18 || geometryType == 28 || geometryType == 13 || geometryType == 23 || geometryType == 15 || geometryType == 25 || (geometryType == 52 || geometryType == 50 || geometryType == 51 || geometryType == 53 || geometryType == 54) && (typeInt & 0x40000000) != 0;
        boolean hasCurves = (geometryType == 50 || geometryType == 51) && (typeInt & 0x3F000000) != 0 || (typeInt & 0x20000000) != 0;
        int n = this.inputDimension = this.hasZ ? 3 : 2;
        if (this.ordValues == null || this.ordValues.length < this.inputDimension) {
            this.ordValues = new double[this.inputDimension];
        }
        if (geometryType == 1 || geometryType == 11 || geometryType == 9 || geometryType == 52) {
            double x = this.dis.readDouble();
            double y = this.dis.readDouble();
            Iom_jObject ret = new Iom_jObject("COORD", null);
            ret.setattrvalue("C1", Double.toString(x));
            ret.setattrvalue("C2", Double.toString(y));
            if (this.hasZ) {
                double z = this.dis.readDouble();
                ret.setattrvalue("C3", Double.toString(z));
            }
            return ret;
        }
        if (geometryType == 54) {
            throw new IoxException("unexpected geometryType " + geometryType);
        }
        double min_x = this.dis.readDouble();
        double min_y = this.dis.readDouble();
        double max_x = this.dis.readDouble();
        double max_y = this.dis.readDouble();
        int cParts = 0;
        int[] partStart = null;
        if (geometryType != 8 && geometryType != 18 && geometryType != 20 && geometryType != 53) {
            cParts = this.dis.readInt();
            partStart = new int[cParts];
        }
        int cPoints = this.dis.readInt();
        if (cParts > 0) {
            for (int i2 = 0; i2 < cParts; ++i2) {
                partStart[i2] = this.dis.readInt();
            }
        }
        Coordinate[] points = new Coordinate[cPoints];
        for (int i3 = 0; i3 < cPoints; ++i3) {
            points[i3] = new Coordinate();
            points[i3].x = this.dis.readDouble();
            points[i3].y = this.dis.readDouble();
        }
        if (geometryType == 8 || geometryType == 18 || geometryType == 20 || geometryType == 53) {
            throw new IoxException("unexpected geometryType " + geometryType);
        }
        if (geometryType != 3 && geometryType != 13 && geometryType != 10 && geometryType != 50 && geometryType != 5 && geometryType != 15 && geometryType != 19 && geometryType != 51) {
            throw new IoxException("unexpected geometryType " + geometryType);
        }
        if (this.hasZ) {
            double min_z = this.dis.readDouble();
            double max_z = this.dis.readDouble();
            for (i = 0; i < cPoints; ++i) {
                points[i].z = this.dis.readDouble();
            }
        }
        if (hasM) {
            double min_m = this.dis.readDouble();
            double max_m = this.dis.readDouble();
            for (i = 0; i < cPoints; ++i) {
                this.dis.readDouble();
            }
        }
        HashMap<Integer, Arc> arcs = null;
        if (hasCurves) {
            int cSegmentModifiers = this.dis.readInt();
            arcs = new HashMap<Integer, Arc>();
            for (int i4 = 0; i4 < cSegmentModifiers; ++i4) {
                double skip2;
                double skip1;
                int startPointIndex = this.dis.readInt();
                int segmentType = this.dis.readInt();
                if (segmentType == 1) {
                    double v1 = this.dis.readDouble();
                    double v2 = this.dis.readDouble();
                    int bits = this.dis.readInt();
                    if ((bits & 1) == 0 && (bits & 0x20) == 0) {
                        if ((bits & 0x40) != 0) {
                            throw new IoxException("not supported SegmentArc.Bits " + bits);
                        }
                        if ((bits & 0x80) != 0 || (bits & 8) != 0) {
                            // empty if block
                        }
                    }
                    arcs.put(startPointIndex, new Arc(startPointIndex, v1, v2, bits));
                    continue;
                }
                if (segmentType == 2 || segmentType == 3) continue;
                if (segmentType == 4) {
                    skip1 = this.dis.readDouble();
                    skip2 = this.dis.readDouble();
                    double skip3 = this.dis.readDouble();
                    double d = this.dis.readDouble();
                    continue;
                }
                if (segmentType == 5) {
                    skip1 = this.dis.readDouble();
                    skip2 = this.dis.readDouble();
                    double skip3 = this.dis.readDouble();
                    double skip4 = this.dis.readDouble();
                    double skip5 = this.dis.readDouble();
                    int n2 = this.dis.readInt();
                    continue;
                }
                if (segmentType == 0) break;
                throw new IoxException("unexpected segmentType " + segmentType);
            }
        }
        JtsextGeometryFactory fact = new JtsextGeometryFactory();
        if (geometryType == 3 || geometryType == 13 || geometryType == 10 || geometryType == 50) {
            if (cParts == 1) {
                IomObject ret;
                LineString line = this.getPolyline(fact, 0, points, partStart, arcs, false);
                try {
                    ret = Jtsext2iox.JTS2polyline((LineString)line);
                }
                catch (Iox2jtsException e) {
                    throw new IoxException((Throwable)e);
                }
                return ret;
            }
            Iom_jObject ret = new Iom_jObject("MULTIPOLYLINE", null);
            for (int i5 = 0; i5 < cParts; ++i5) {
                LineString line = this.getPolyline(fact, i5, points, partStart, arcs, false);
                try {
                    IomObject lineObj = Jtsext2iox.JTS2polyline((LineString)line);
                    ret.addattrobj("polyline", lineObj);
                    continue;
                }
                catch (Iox2jtsException e) {
                    throw new IoxException((Throwable)e);
                }
            }
            return ret;
        }
        if (geometryType == 5 || geometryType == 15 || geometryType == 19 || geometryType == 51) {
            if (cParts == 1) {
                IomObject ret;
                LineString line = this.getPolyline(fact, 0, points, partStart, arcs, true);
                if (line.getCoordinateSequence().size() <= 3) {
                    throw new IoxException("Not a Ring");
                }
                CurvePolygon polygon = fact.createCurvePolygon(fact.createRing(line));
                try {
                    ret = Jtsext2iox.JTS2surface((Polygon)polygon);
                }
                catch (Iox2jtsException e) {
                    throw new IoxException((Throwable)e);
                }
                return ret;
            }
            ArrayList<LineString> shells = new ArrayList<LineString>();
            ArrayList<LineString> holes = new ArrayList<LineString>();
            for (i = 0; i < cParts; ++i) {
                LineString line = this.getPolyline(fact, i, points, partStart, arcs, true);
                if (line.getCoordinateSequence().size() <= 3) {
                    throw new IoxException("Not a Ring");
                }
                if (CGAlgorithms.isCCW((Coordinate[])line.getCoordinates())) {
                    holes.add(line);
                    continue;
                }
                shells.add(line);
            }
            if (shells.size() == 0) {
                throw new IoxException("polygon without shell");
            }
            if (shells.size() == 1) {
                LineString shell = (LineString)shells.get(0);
                return this.createIoxSurface(fact, shell, holes);
            }
            Iom_jObject iomMultiSurface = new Iom_jObject("MULTISURFACE", null);
            for (LineString shell : shells) {
                ArrayList<LineString> holesPerShell = new ArrayList<LineString>();
                for (int holei = holes.size() - 1; holei >= 0; --holei) {
                    LineString hole = holes.get(holei);
                    if (!shell.contains((Geometry)hole)) continue;
                    holesPerShell.add(hole);
                    holes.remove(holei);
                }
                IomObject iomSingleSurface = this.createIoxSurface(fact, shell, holesPerShell);
                IomObject iomSurface = iomSingleSurface.getattrobj("surface", 0);
                iomMultiSurface.addattrobj("surface", iomSurface);
            }
            return iomMultiSurface;
        }
        throw new IoxException("unexpected geometryType " + geometryType);
    }

    private IomObject createIoxSurface(JtsextGeometryFactory fact, LineString shellx, ArrayList<LineString> holes) throws IoxException {
        LinearRing shell = fact.createRing(shellx);
        Polygon polygon = null;
        if (holes.size() == 0) {
            polygon = fact.createPolygon(shell);
        } else {
            LinearRing[] hole = new LinearRing[holes.size()];
            int i = 0;
            for (LineString line : holes) {
                hole[i] = fact.createRing(line);
                ++i;
            }
            polygon = fact.createPolygon(shell, hole);
        }
        IomObject ret = null;
        try {
            ret = Jtsext2iox.JTS2surface((Polygon)polygon);
        }
        catch (Iox2jtsException e) {
            throw new IoxException((Throwable)e);
        }
        return ret;
    }

    private LineString getPolyline(JtsextGeometryFactory fact, int part, Coordinate[] points, int[] partsStart, Map<Integer, Arc> arcs, boolean closeIt) {
        int from = partsStart[part];
        int to = points.length;
        if (part < partsStart.length - 1) {
            to = partsStart[part + 1];
        }
        if (arcs == null || arcs.size() == 0) {
            Coordinate[] coords = null;
            if (closeIt && !points[from].equals2D(points[to - 1])) {
                coords = Arrays.copyOfRange(points, from, to + 1);
                coords[to] = coords[0];
            } else {
                coords = Arrays.copyOfRange(points, from, to);
            }
            return fact.createLineString(coords);
        }
        ArrayList<StraightSegment> segs = new ArrayList<StraightSegment>();
        Coordinate start = points[from];
        for (int i = from + 1; i < to; ++i) {
            Coordinate end = points[i];
            Arc arc = arcs.get(i - 1);
            StraightSegment seg = null;
            if (arc != null) {
                if ((arc.bits & 0x80) != 0) {
                    Coordinate midpt = new Coordinate(arc.centerPoint_x, arc.centerPoint_y);
                    seg = new ArcSegment(start, midpt, end);
                } else {
                    boolean isMinor;
                    Coordinate center = new Coordinate(arc.centerPoint_x, arc.centerPoint_y);
                    double radius = ArcSegment.dist((Coordinate)start, (Coordinate)center);
                    double sign = 0.0;
                    boolean bl = isMinor = (arc.bits & 0x10) != 0;
                    sign = CGAlgorithms.computeOrientation((Coordinate)start, (Coordinate)end, (Coordinate)center) < 0 ? (isMinor ? 1.0 : -1.0) : (isMinor ? -1.0 : 1.0);
                    Coordinate midpt = ArcSegment.calcArcPt((Coordinate)start, (Coordinate)end, (Coordinate)center, (double)radius, (double)sign);
                    seg = new ArcSegment(start, midpt, end);
                }
            } else {
                seg = new StraightSegment(start, end);
            }
            segs.add(seg);
            start = end;
        }
        if (closeIt && !points[from].equals2D(points[to - 1])) {
            segs.add(new StraightSegment(points[to - 1], points[from]));
        }
        return fact.createCompoundCurve(segs);
    }

    private static class Arc {
        public int startPointIndex;
        public double centerPoint_x;
        public double centerPoint_y;
        public int bits;

        public Arc(int startPointIndex, double centerPoint_x, double centerPoint_y, int bits) {
            this.startPointIndex = startPointIndex;
            this.centerPoint_x = centerPoint_x;
            this.centerPoint_y = centerPoint_y;
            this.bits = bits;
        }
    }
}

