/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2fgdb.jdbc;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import ch.ehi.fgdb4j.jni.EnumRows;
import ch.ehi.fgdb4j.jni.Table;
import ch.ehi.fgdb4j.jni.fgbd4j;
import ch.ehi.ili2fgdb.jdbc.FgdbConnection;
import ch.ehi.ili2fgdb.jdbc.FgdbResultSet;
import ch.ehi.ili2fgdb.jdbc.MemResultSet;
import ch.ehi.ili2fgdb.jdbc.parser.SqlLexer;
import ch.ehi.ili2fgdb.jdbc.parser.SqlSyntax;
import ch.ehi.ili2fgdb.jdbc.sql.AbstractSelectStmt;
import ch.ehi.ili2fgdb.jdbc.sql.ColRef;
import ch.ehi.ili2fgdb.jdbc.sql.ComplexSelectStmt;
import ch.ehi.ili2fgdb.jdbc.sql.FgdbSelectStmt;
import ch.ehi.ili2fgdb.jdbc.sql.IntConst;
import ch.ehi.ili2fgdb.jdbc.sql.IsNull;
import ch.ehi.ili2fgdb.jdbc.sql.SelectValue;
import ch.ehi.ili2fgdb.jdbc.sql.SelectValueField;
import ch.ehi.ili2fgdb.jdbc.sql.SqlStmt;
import ch.ehi.ili2fgdb.jdbc.sql.StringConst;
import ch.ehi.ili2fgdb.jdbc.sql.Value;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public class FgdbStatement
implements Statement {
    private FgdbConnection conn = null;

    protected FgdbStatement(FgdbConnection conn) {
        this.conn = conn;
    }

    @Override
    public void addBatch(String arg0) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean execute(String arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        return false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return null;
    }

    @Override
    public ResultSet executeQuery(String stmtStr) throws SQLException {
        SqlStmt stmt = null;
        SqlLexer lexer = new SqlLexer(new StringReader(stmtStr));
        SqlSyntax parser = new SqlSyntax(lexer);
        try {
            stmt = parser.statement();
        }
        catch (RecognitionException e) {
            throw new SQLException(e);
        }
        catch (TokenStreamException e) {
            throw new SQLException(e);
        }
        ResultSet ret = null;
        ret = stmt instanceof ComplexSelectStmt ? this.executeComplexSelectStmt((ComplexSelectStmt)stmt) : (stmt instanceof FgdbSelectStmt ? this.executeFgdbSelectStmt((FgdbSelectStmt)stmt) : this.executeStringQuery(stmtStr));
        return ret;
    }

    private ResultSet executeSelectStmt(AbstractSelectStmt stmt) throws SQLException {
        ResultSet ret = null;
        if (stmt instanceof ComplexSelectStmt) {
            ret = this.executeComplexSelectStmt((ComplexSelectStmt)stmt);
        } else if (stmt instanceof FgdbSelectStmt) {
            ret = this.executeFgdbSelectStmt((FgdbSelectStmt)stmt);
        } else {
            throw new IllegalArgumentException("unexpceted type " + stmt.getClass().getName());
        }
        return ret;
    }

    private ResultSet executeComplexSelectStmt(ComplexSelectStmt stmt) throws SQLException {
        MemResultSet ret = new MemResultSet(this.executeSelectStmt(stmt.getSubSelect()), null, null);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeStringQuery(String stmtStr) throws SQLException {
        FgdbResultSet ret;
        EnumRows rows = null;
        try {
            rows = new EnumRows();
            int err = 0;
            err = this.conn.getGeodatabase().ExecuteSQL(stmtStr, true, rows);
            if (err != 0) {
                StringBuffer errDesc = new StringBuffer();
                fgbd4j.GetErrorDescription((int)err, (StringBuffer)errDesc);
                throw new SQLException(errDesc.toString());
            }
            ret = new FgdbResultSet(this.conn, null, rows, null);
            rows = null;
        }
        finally {
            if (rows != null) {
                rows.Close();
                rows.delete();
                rows = null;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeFgdbSelectStmt(FgdbSelectStmt ustmt) throws SQLException {
        List<SelectValue> selectvalues = null;
        int err = 0;
        Table table = null;
        EnumRows rows = null;
        try {
            table = new Table();
            err = this.conn.getGeodatabase().OpenTable(ustmt.getTableName(), table);
            if (err != 0) {
                StringBuffer errDesc = new StringBuffer();
                fgbd4j.GetErrorDescription((int)err, (StringBuffer)errDesc);
                throw new SQLException(errDesc.toString(), "22000", err);
            }
            StringBuffer where = new StringBuffer();
            String sep = "";
            for (Map.Entry<Value, Value> cond : ustmt.getConditions()) {
                where.append(((ColRef)cond.getKey()).getName());
                Value rh = cond.getValue();
                if (rh instanceof IsNull) {
                    where.append("IS NULL");
                } else {
                    where.append("=");
                    if (rh instanceof IntConst) {
                        where.append(Integer.toString(((IntConst)rh).getValue()));
                    } else {
                        where.append("'");
                        where.append(((StringConst)rh).getValue());
                        where.append("'");
                    }
                }
                sep = " AND ";
            }
            StringBuffer fields = new StringBuffer();
            String sep2 = "";
            for (SelectValue colref : ustmt.getFields()) {
                if (!(colref instanceof SelectValueField)) continue;
                fields.append(sep2);
                sep2 = ",";
                fields.append(colref.getColumnName());
            }
            if (fields.length() == 0) {
                fields.append("*");
            }
            rows = new EnumRows();
            err = table.Search(fields.toString(), where.toString(), false, rows);
            selectvalues = ustmt.getFields();
            if (err != 0) {
                StringBuffer errDesc = new StringBuffer();
                fgbd4j.GetErrorDescription((int)err, (StringBuffer)errDesc);
                throw new SQLException(errDesc.toString());
            }
            FgdbResultSet ret = new FgdbResultSet(this.conn, table, rows, selectvalues);
            rows = null;
            table = null;
            FgdbResultSet fgdbResultSet = ret;
            return fgdbResultSet;
        }
        finally {
            if (rows != null) {
                rows.Close();
                rows.delete();
                rows = null;
            }
            if (table != null) {
                this.conn.getGeodatabase().CloseTable(table);
                table.delete();
                table = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String stmtStr) throws SQLException {
        EnumRows rows = null;
        int err = 0;
        try {
            rows = new EnumRows();
            err = this.conn.getGeodatabase().ExecuteSQL(stmtStr, true, rows);
            if (err != 0) {
                StringBuffer errDesc = new StringBuffer();
                fgbd4j.GetErrorDescription((int)err, (StringBuffer)errDesc);
                throw new SQLException(errDesc.toString());
            }
        }
        finally {
            if (rows != null) {
                rows.Close();
                rows.delete();
                rows = null;
            }
        }
        return 0;
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        return 0;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return null;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws SQLException {
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
    }

    @Override
    public void setMaxRows(int arg0) throws SQLException {
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

