/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2fgdb.jdbc;

import ch.ehi.fgdb4j.jni.ByteArray;
import ch.ehi.fgdb4j.jni.EnumRows;
import ch.ehi.fgdb4j.jni.FieldInfo;
import ch.ehi.fgdb4j.jni.FieldType;
import ch.ehi.fgdb4j.jni.Row;
import ch.ehi.fgdb4j.jni.ShapeBuffer;
import ch.ehi.fgdb4j.jni.Table;
import ch.ehi.fgdb4j.jni.ce_time;
import ch.ehi.fgdb4j.jni.fgbd4j;
import ch.ehi.ili2fgdb.jdbc.AbstractResultSet;
import ch.ehi.ili2fgdb.jdbc.FgdbConnection;
import ch.ehi.ili2fgdb.jdbc.sql.SelectValue;
import ch.ehi.ili2fgdb.jdbc.sql.SelectValueNull;
import ch.ehi.ili2fgdb.jdbc.sql.SelectValueString;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.List;
import javax.sql.rowset.RowSetMetaDataImpl;

public class FgdbResultSet
extends AbstractResultSet
implements ResultSet {
    public static final int MAGIC_HOUR_DATEONLY = 0;
    public static final int MAGIC_YEAR_TIMEONLY = -1;
    public static final int MAGIC_MON_TIMEONLY = 11;
    public static final int MAGIC_MDAY_TIMEONLY = 30;
    public static final int MAGIC_ISDST_TIMEONLY = -1;
    public static final int MAGIC_WDAY_TIMEONLY = 6;
    public static final int MAGIC_YDAY_TIMEONLY = 363;
    private EnumRows rowIterator = null;
    private Row fgdbCurrentRow = null;
    FieldInfo fgdbFieldInfo = null;
    private int fgdbFieldCount = 0;
    private boolean lastGetWasNull = false;
    private List<SelectValue> selectValues = null;
    private Table fgdbTable = null;
    private FgdbConnection conn = null;

    public FgdbResultSet(FgdbConnection conn, Table table, EnumRows rows, List<SelectValue> selectvalues) throws SQLException {
        this.conn = conn;
        this.rowIterator = rows;
        this.fgdbTable = table;
        this.fgdbFieldInfo = new FieldInfo();
        int err = this.rowIterator.GetFieldInformation(this.fgdbFieldInfo);
        if (err != 0) {
            StringBuffer errDesc = new StringBuffer();
            fgbd4j.GetErrorDescription((int)err, (StringBuffer)errDesc);
            throw new SQLException(errDesc.toString());
        }
        int[] fieldCounto = new int[1];
        err = this.fgdbFieldInfo.GetFieldCount(fieldCounto);
        if (err != 0) {
            StringBuffer errDesc = new StringBuffer();
            fgbd4j.GetErrorDescription((int)err, (StringBuffer)errDesc);
            throw new SQLException(errDesc.toString());
        }
        this.fgdbFieldCount = fieldCounto[0];
        this.selectValues = selectvalues;
    }

    @Override
    public void close() throws SQLException {
        if (this.fgdbCurrentRow != null) {
            this.fgdbCurrentRow.delete();
            this.fgdbCurrentRow = null;
        }
        if (this.rowIterator != null) {
            this.rowIterator.Close();
            this.rowIterator.delete();
            this.rowIterator = null;
        }
        if (this.fgdbFieldInfo != null) {
            this.fgdbFieldInfo.delete();
            this.fgdbFieldInfo = null;
        }
        if (this.fgdbTable != null) {
            this.conn.getGeodatabase().CloseTable(this.fgdbTable);
            this.fgdbTable.delete();
            this.fgdbTable = null;
        }
    }

    @Override
    public int findColumn(String colName) throws SQLException {
        if (this.selectValues != null) {
            int colIdx = 0;
            for (SelectValue sv : this.selectValues) {
                String fieldName = null;
                fieldName = sv.getColumnName();
                if (fieldName.equals(colName)) {
                    return colIdx + 1;
                }
                ++colIdx;
            }
        } else {
            return this.findFgdbColumn(colName) + 1;
        }
        throw new SQLException("unknown column " + colName);
    }

    private int findFgdbColumn(String colName) throws SQLException {
        for (int colIdx = 0; colIdx < this.fgdbFieldCount; ++colIdx) {
            StringBuffer fieldName = new StringBuffer();
            this.fgdbFieldInfo.GetFieldName(colIdx, fieldName);
            if (!fieldName.toString().equals(colName)) continue;
            return colIdx;
        }
        throw new SQLException("unknown column " + colName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Object getObject(int colIdx) throws SQLException {
        --colIdx;
        if (this.selectValues != null) {
            sv = this.selectValues.get(colIdx);
            if (sv instanceof SelectValueString) {
                this.lastGetWasNull = false;
                return ((SelectValueString)sv).getLiteralValue();
            }
            if (sv instanceof SelectValueNull) {
                this.lastGetWasNull = true;
                return null;
            }
            colIdx = this.findFgdbColumn(sv.getColumnName());
        }
        if ((err = this.fgdbCurrentRow.IsNull(colIdx, isNull = new boolean[1])) != 0) {
            throw new SQLException(this.getErrorDescription(err));
        }
        if (isNull[0]) {
            this.lastGetWasNull = true;
            return null;
        }
        this.lastGetWasNull = false;
        valueo = null;
        fieldType = new int[1];
        err = this.fgdbFieldInfo.GetFieldType(colIdx, fieldType);
        if (err != 0) {
            throw new SQLException(this.getErrorDescription(err));
        }
        if (fieldType[0] == FieldType.fieldTypeOID.swigValue()) {
            value = new int[1];
            err = this.fgdbCurrentRow.GetOID(value);
            if (err == 0) {
                valueo = value[0];
            }
        } else if (fieldType[0] == FieldType.fieldTypeInteger.swigValue()) {
            value = new int[1];
            err = this.fgdbCurrentRow.GetInteger(colIdx, value);
            if (err == 0) {
                valueo = value[0];
            }
        } else if (fieldType[0] == FieldType.fieldTypeSmallInteger.swigValue()) {
            value = new short[1];
            err = this.fgdbCurrentRow.GetShort(colIdx, value);
            if (err == 0) {
                valueo = value[0];
            }
        } else if (fieldType[0] == FieldType.fieldTypeDouble.swigValue()) {
            value = new double[1];
            err = this.fgdbCurrentRow.GetDouble(colIdx, value);
            if (err == 0) {
                valueo = value[0];
            }
        } else if (fieldType[0] == FieldType.fieldTypeString.swigValue()) {
            value = new StringBuffer();
            err = this.fgdbCurrentRow.GetString(colIdx, value);
            if (err == 0) {
                valueo = value.toString();
            }
        } else if (fieldType[0] == FieldType.fieldTypeGeometry.swigValue()) {
            value = null;
            try {
                value = new ShapeBuffer();
                err = this.fgdbCurrentRow.GetGeometry(value);
                if (err != 0) ** GOTO lbl119
                bytebuf = value.getBuffer();
                valueo = bytebuf;
                if (bytebuf == null || bytebuf.length < 4 || bytebuf[0] != 0 || bytebuf[1] != 0 || bytebuf[2] != 0 || bytebuf[3] != 0) ** GOTO lbl119
                this.lastGetWasNull = true;
                valueo = null;
            }
            finally {
                if (value != null) {
                    value.delete();
                    value = null;
                }
            }
        } else if (fieldType[0] == FieldType.fieldTypeBlob.swigValue()) {
            value = null;
            try {
                value = new ByteArray();
                err = this.fgdbCurrentRow.GetBinary(colIdx, value);
                if (err != 0) ** GOTO lbl119
                valueo = value.getBuffer();
            }
            finally {
                if (value != null) {
                    value.delete();
                    value = null;
                }
            }
        } else if (fieldType[0] == FieldType.fieldTypeDate.swigValue()) {
            value = null;
            try {
                value = new ce_time();
                err = this.fgdbCurrentRow.getDateTime(colIdx, value);
                if (err != 0) ** GOTO lbl119
                time = new GregorianCalendar();
                year = value.getTm_year();
                time.set(1, year + 1900);
                month = value.getTm_mon();
                time.set(2, month);
                day = value.getTm_mday();
                time.set(5, day);
                hour = value.getTm_hour();
                time.set(11, hour);
                min = value.getTm_min();
                time.set(12, min);
                sec = value.getTm_sec();
                time.set(13, sec);
                time.set(14, 0);
                isdst = value.getTm_isdst();
                wday = value.getTm_wday();
                yday = value.getTm_yday();
                if (year == -1 || year == 1) {
                    valueo = new Time(time.getTimeInMillis());
                }
                if (hour == 0) {
                    valueo = new Date(time.getTimeInMillis());
                }
                valueo = new Timestamp(time.getTimeInMillis());
            }
            finally {
                if (value != null) {
                    value.delete();
                    value = null;
                }
            }
        } else {
            throw new SQLException("unexpected field type " + fieldType[0]);
        }
lbl119:
        // 14 sources

        if (err != 0) {
            throw new SQLException(this.getErrorDescription(err));
        }
        return valueo;
    }

    private String getErrorDescription(int err) {
        StringBuffer errDesc = new StringBuffer();
        fgbd4j.GetErrorDescription((int)err, (StringBuffer)errDesc);
        return errDesc.toString();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.rowIterator == null;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.fgdbCurrentRow != null) {
            this.fgdbCurrentRow.delete();
            this.fgdbCurrentRow = null;
        }
        this.fgdbCurrentRow = new Row();
        return this.rowIterator.Next(this.fgdbCurrentRow) == 0;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastGetWasNull;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        RowSetMetaDataImpl ret = new RowSetMetaDataImpl();
        if (this.selectValues != null) {
            ret.setColumnCount(this.selectValues.size());
        } else {
            ret.setColumnCount(this.fgdbFieldCount);
        }
        return ret;
    }
}

