/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2duckdb;

import ch.ehi.ili2db.AbstractMain;
import ch.ehi.ili2db.base.DbUrlConverter;
import ch.ehi.ili2db.gui.AbstractDbPanelDescriptor;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2duckdb.DuckDBColumnConverter;
import ch.ehi.ili2duckdb.DuckDBIdGen;
import ch.ehi.ili2duckdb.DuckDBMapping;
import ch.ehi.ili2duckdb.GeneratorDuckDB;
import java.text.ParseException;

public class DuckDBMain
extends AbstractMain {
    public void initConfig(Config config) {
        super.initConfig(config);
        config.setGeometryConverter(DuckDBColumnConverter.class.getName());
        config.setDdlGenerator(GeneratorDuckDB.class.getName());
        config.setJdbcDriver("org.duckdb.DuckDBDriver");
        config.setIdGenerator(DuckDBIdGen.class.getName());
        config.setIli2dbCustomStrategy(DuckDBMapping.class.getName());
        config.setUuidDefaultValue("uuid()");
    }

    public DbUrlConverter getDbUrlConverter() {
        return new DbUrlConverter(){

            public String makeUrl(Config config) {
                if (config.getDbfile() != null) {
                    return "jdbc:duckdb:" + config.getDbfile();
                }
                return null;
            }
        };
    }

    public AbstractDbPanelDescriptor getDbPanelDescriptor() {
        return null;
    }

    public static void main(String[] args) {
        new DuckDBMain().domain(args);
    }

    public String getAPP_NAME() {
        return "ili2duckdb";
    }

    public String getDB_PRODUCT_NAME() {
        return "DuckDB";
    }

    public String getJAR_NAME() {
        return "ili2duckdb.jar";
    }

    protected void printConnectOptions() {
        System.err.println("--dbfile path          The path to the database file.");
    }

    protected void printSpecificOptions() {
        System.err.println("--dbschema  schema     The name of the schema in the database. Defaults to not set.");
    }

    protected int doArgs(String[] args, int argi, Config config) throws ParseException {
        String arg = args[argi];
        if (arg.equals("--dbfile")) {
            config.setDbfile(args[++argi]);
            ++argi;
        } else if (arg.equals("--dbschema")) {
            config.setDbschema(args[++argi]);
            ++argi;
        }
        return argi;
    }
}

