/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl.jtsext.algorithm;

import ch.interlis.iom_j.itf.impl.hrg.HrgUtility;
import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;

public class CurveSegmentIntersector {
    RobustLineIntersector li = new RobustLineIntersector();
    private boolean hasIntersection_;
    private boolean isOverlay_;
    private int isNum;
    private Coordinate[] is = new Coordinate[2];
    private Double overlap = null;

    public void computeIntersection(CurveSegment seg1, CurveSegment seg2) {
        this.isOverlay_ = false;
        this.overlap = null;
        boolean seg1isArc = CurveSegmentIntersector.isTrueArc(seg1);
        boolean seg2isArc = CurveSegmentIntersector.isTrueArc(seg2);
        if (seg1isArc && seg2isArc) {
            Coordinate startPt1 = ((ArcSegment)seg1).getNormalizedStartPoint();
            Coordinate endPt1 = ((ArcSegment)seg1).getNormalizedEndPoint();
            Coordinate startPt2 = ((ArcSegment)seg2).getNormalizedStartPoint();
            Coordinate endPt2 = ((ArcSegment)seg2).getNormalizedEndPoint();
            double[] AV1I = null;
            double[] AV2I = null;
            double[] AW1I = null;
            double[] AW2I = null;
            if (((ArcSegment)seg1).getRadius() < ((ArcSegment)seg2).getRadius()) {
                AV1I = new double[]{0.0, startPt1.x, ((ArcSegment)seg1).getMidPoint().x, endPt1.x};
                AV2I = new double[]{0.0, startPt1.y, ((ArcSegment)seg1).getMidPoint().y, endPt1.y};
                AW1I = new double[]{0.0, startPt2.x, ((ArcSegment)seg2).getMidPoint().x, endPt2.x};
                AW2I = new double[]{0.0, startPt2.y, ((ArcSegment)seg2).getMidPoint().y, endPt2.y};
            } else {
                AV1I = new double[]{0.0, startPt2.x, ((ArcSegment)seg2).getMidPoint().x, endPt2.x};
                AV2I = new double[]{0.0, startPt2.y, ((ArcSegment)seg2).getMidPoint().y, endPt2.y};
                AW1I = new double[]{0.0, startPt1.x, ((ArcSegment)seg1).getMidPoint().x, endPt1.x};
                AW2I = new double[]{0.0, startPt1.y, ((ArcSegment)seg1).getMidPoint().y, endPt1.y};
            }
            int[] NHO = new int[1];
            double[] H1O = new double[3];
            double[] H2O = new double[3];
            double[] OVERLAP = new double[1];
            HrgUtility.ISCICR(AV1I, AV2I, AW1I, AW2I, NHO, H1O, H2O, OVERLAP);
            if (NHO[0] == 1) {
                this.hasIntersection_ = true;
                this.isNum = 1;
                this.is[0] = new Coordinate(H1O[1], H2O[1]);
                this.overlap = OVERLAP[0];
            } else if (NHO[0] == 2) {
                this.hasIntersection_ = true;
                this.isNum = 2;
                this.is[0] = new Coordinate(H1O[1], H2O[1]);
                this.is[1] = new Coordinate(H1O[2], H2O[2]);
                this.normalizeIs();
                this.overlap = OVERLAP[0];
            } else if (NHO[0] == 3) {
                this.isOverlay_ = true;
                this.hasIntersection_ = true;
                this.isNum = 2;
                this.is[0] = new Coordinate(H1O[1], H2O[1]);
                this.is[1] = new Coordinate(H1O[2], H2O[2]);
                this.normalizeIs();
                this.overlap = OVERLAP[0];
            } else {
                this.hasIntersection_ = false;
                this.isNum = 0;
            }
        } else if (seg1isArc) {
            this.intersectArcStraight((ArcSegment)seg1, seg2);
        } else if (seg2isArc) {
            this.intersectArcStraight((ArcSegment)seg2, seg1);
        } else {
            Coordinate startPt1 = seg1.getStartPoint();
            Coordinate endPt1 = seg1.getEndPoint();
            Coordinate startPt2 = seg2.getStartPoint();
            Coordinate endPt2 = seg2.getEndPoint();
            this.li.computeIntersection(startPt1, endPt1, startPt2, endPt2);
            this.hasIntersection_ = this.li.hasIntersection();
            this.isNum = this.li.getIntersectionNum();
            this.isOverlay_ = this.hasIntersection_ ? this.isNum == 2 : false;
            for (int i = 0; i < this.isNum; ++i) {
                this.is[i] = this.li.getIntersection(i);
            }
            this.normalizeIs();
        }
    }

    private void normalizeIs() {
        if (this.isNum > 1 && this.is[0].compareTo((Object)this.is[1]) > 0) {
            Coordinate t = this.is[0];
            this.is[0] = this.is[1];
            this.is[1] = t;
        }
    }

    public boolean isOverlay() {
        return this.isOverlay_;
    }

    public static boolean isTrueArc(CurveSegment seg) {
        return seg instanceof ArcSegment && !((ArcSegment)seg).isStraight();
    }

    public void intersectArcStraight(ArcSegment seg1, CurveSegment seg2) {
        Coordinate startPt1 = seg1.getNormalizedStartPoint();
        Coordinate endPt1 = seg1.getNormalizedEndPoint();
        Coordinate startPt2 = seg2.getStartPoint();
        Coordinate endPt2 = seg2.getEndPoint();
        double[] AV1I = new double[]{0.0, startPt1.x, seg1.getMidPoint().x, endPt1.x};
        double[] AV2I = new double[]{0.0, startPt1.y, seg1.getMidPoint().y, endPt1.y};
        double[] AW1I = new double[]{0.0, startPt2.x, endPt2.x};
        double[] AW2I = new double[]{0.0, startPt2.y, endPt2.y};
        int[] NHO = new int[1];
        double[] H1O = new double[3];
        double[] H2O = new double[3];
        double[] OVERLAP = new double[1];
        HrgUtility.ISCISR(AV1I, AV2I, AW1I, AW2I, NHO, H1O, H2O, OVERLAP);
        if (NHO[0] == 1) {
            this.hasIntersection_ = true;
            this.isNum = 1;
            this.is[0] = new Coordinate(H1O[1], H2O[1]);
            this.overlap = OVERLAP[0];
        } else if (NHO[0] == 2) {
            this.hasIntersection_ = true;
            this.isNum = 2;
            this.is[0] = new Coordinate(H1O[1], H2O[1]);
            this.is[1] = new Coordinate(H1O[2], H2O[2]);
            this.normalizeIs();
            this.overlap = OVERLAP[0];
        } else {
            this.hasIntersection_ = false;
            this.isNum = 0;
        }
    }

    public boolean hasIntersection() {
        return this.hasIntersection_;
    }

    public int getIntersectionNum() {
        return this.isNum;
    }

    public boolean isIntersection(Coordinate p00) {
        if (this.isNum > 0) {
            if (p00.equals2D(this.is[0])) {
                return true;
            }
            if (this.isNum > 1 && p00.equals2D(this.is[1])) {
                return true;
            }
        }
        return false;
    }

    public Coordinate getIntersection(int i) {
        if (i < 0 || i >= this.isNum) {
            throw new IllegalArgumentException("i " + i + ", isNum " + this.isNum);
        }
        return this.is[i];
    }

    public Double getOverlap() {
        return this.overlap;
    }
}

