/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import java.beans.PropertyVetoException;
import java.util.List;

public class PlausibilityConstraint
extends Constraint {
    protected double percentage = 50.0;
    protected int direction = 0;
    public static final int DIRECTION_AT_LEAST = 0;
    public static final int DIRECTION_AT_MOST = 1;

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) throws PropertyVetoException {
        int oldValue = this.direction;
        int newValue = direction;
        if (oldValue == newValue) {
            return;
        }
        if (newValue != 0 && newValue != 1) {
            throw new IllegalArgumentException("direction");
        }
        this.fireVetoableChange("direction", new Integer(oldValue), new Integer(newValue));
        this.direction = direction;
        this.firePropertyChange("direction", new Integer(oldValue), new Integer(newValue));
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(double percentage) throws PropertyVetoException {
        Double oldValue = new Double(this.percentage);
        Double newValue = new Double(percentage);
        if (percentage < 0.0 || percentage > 100.0) {
            throw new IllegalArgumentException(rsrc.getString("err_percentageBetween0and100"));
        }
        this.fireVetoableChange("percentage", oldValue, newValue);
        this.percentage = percentage;
        this.firePropertyChange("percentage", oldValue, newValue);
    }

    @Override
    public void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) throws IllegalStateException {
        Ili2cSemanticException err;
        super.checkTranslationOf(errs, name, baseName);
        PlausibilityConstraint baseElement = (PlausibilityConstraint)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        if (this.percentage != baseElement.percentage) {
            err = new Ili2cSemanticException(this.getSourceLine(), Element.formatMessage("err_diff_plausibilityConstraintPercentageMismatch", Double.toString(this.percentage), Double.toString(baseElement.percentage)));
            errs.add(err);
        }
        if (this.direction != baseElement.direction) {
            err = new Ili2cSemanticException(this.getSourceLine(), Element.formatMessage("err_diff_plausibilityConstraintDirectionMismatch"));
            errs.add(err);
        }
    }
}

