/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;

public class FacetSequence {
    private CoordinateSequence pts;
    private int start;
    private int end;
    private Coordinate pt = new Coordinate();
    private Coordinate seqPt = new Coordinate();
    private Coordinate p0 = new Coordinate();
    private Coordinate p1 = new Coordinate();
    private Coordinate q0 = new Coordinate();
    private Coordinate q1 = new Coordinate();

    public FacetSequence(CoordinateSequence pts, int start, int end) {
        this.pts = pts;
        this.start = start;
        this.end = end;
    }

    public FacetSequence(CoordinateSequence pts, int start) {
        this.pts = pts;
        this.start = start;
        this.end = start + 1;
    }

    public Envelope getEnvelope() {
        Envelope env = new Envelope();
        int i = this.start;
        while (i < this.end) {
            env.expandToInclude(this.pts.getX(i), this.pts.getY(i));
            ++i;
        }
        return env;
    }

    public int size() {
        return this.end - this.start;
    }

    public Coordinate getCoordinate(int index) {
        return this.pts.getCoordinate(this.start + index);
    }

    public boolean isPoint() {
        return this.end - this.start == 1;
    }

    public double distance(FacetSequence facetSeq) {
        boolean isPoint = this.isPoint();
        boolean isPointOther = facetSeq.isPoint();
        if (isPoint && isPointOther) {
            this.pts.getCoordinate(this.start, this.pt);
            facetSeq.pts.getCoordinate(facetSeq.start, this.seqPt);
            return this.pt.distance(this.seqPt);
        }
        if (isPoint) {
            this.pts.getCoordinate(this.start, this.pt);
            return this.computePointLineDistance(this.pt, facetSeq);
        }
        if (isPointOther) {
            facetSeq.pts.getCoordinate(facetSeq.start, this.seqPt);
            return this.computePointLineDistance(this.seqPt, this);
        }
        return this.computeLineLineDistance(facetSeq);
    }

    private double computeLineLineDistance(FacetSequence facetSeq) {
        double minDistance = Double.MAX_VALUE;
        int i = this.start;
        while (i < this.end - 1) {
            int j = facetSeq.start;
            while (j < facetSeq.end - 1) {
                this.pts.getCoordinate(i, this.p0);
                this.pts.getCoordinate(i + 1, this.p1);
                facetSeq.pts.getCoordinate(j, this.q0);
                facetSeq.pts.getCoordinate(j + 1, this.q1);
                double dist = CGAlgorithms.distanceLineLine(this.p0, this.p1, this.q0, this.q1);
                if (dist == 0.0) {
                    return 0.0;
                }
                if (dist < minDistance) {
                    minDistance = dist;
                }
                ++j;
            }
            ++i;
        }
        return minDistance;
    }

    private double computePointLineDistance(Coordinate pt, FacetSequence facetSeq) {
        double minDistance = Double.MAX_VALUE;
        int i = facetSeq.start;
        while (i < facetSeq.end - 1) {
            facetSeq.pts.getCoordinate(i, this.q0);
            facetSeq.pts.getCoordinate(i + 1, this.q1);
            double dist = CGAlgorithms.distancePointLine(pt, this.q0, this.q1);
            if (dist == 0.0) {
                return 0.0;
            }
            if (dist < minDistance) {
                minDistance = dist;
            }
            ++i;
        }
        return minDistance;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("LINESTRING ( ");
        Coordinate p = new Coordinate();
        int i = this.start;
        while (i < this.end) {
            if (i > this.start) {
                buf.append(", ");
            }
            this.pts.getCoordinate(i, p);
            buf.append(String.valueOf(p.x) + " " + p.y);
            ++i;
        }
        buf.append(" )");
        return buf.toString();
    }
}

