/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.BaseUnit;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.Unit;
import java.beans.PropertyVetoException;

public class StructuredUnit
extends Unit {
    protected Unit firstUnit = null;
    protected Part[] parts = new Part[0];
    protected boolean continuous = false;

    public Part[] getParts() {
        return this.parts;
    }

    public void setParts(Part[] parts) throws PropertyVetoException {
        Part[] oldValue = this.parts;
        Part[] newValue = parts;
        if (oldValue == newValue) {
            return;
        }
        Unit commonBase = this.firstUnit == null ? newValue[0].getUnit() : this.firstUnit;
        if (this.extending != null) {
            throw new IllegalArgumentException("This order not implemented yet. Call setExtending() later.");
        }
        for (int i = 0; i < parts.length; ++i) {
            Unit u = parts[i].getUnit();
            if (u != null && u.isAbstract()) {
                throw new IllegalArgumentException(StructuredUnit.formatMessage("err_abstractStructUnitPart", this.toString(), parts[i].getUnit().toString()));
            }
            if (i < parts.length - 1 && (parts[i].getMinimum() != null && parts[i].getMinimum().getExponent() != 0 || parts[i].getMaximum() != null && parts[i].getMaximum().getExponent() != 0)) {
                throw new IllegalArgumentException(StructuredUnit.formatMessage("err_structuredUnit_fractionalPart", this.toString()));
            }
            commonBase = parts[i].getUnit().findCommonBase(commonBase);
            while (commonBase != null && !(commonBase instanceof BaseUnit)) {
                commonBase = commonBase.extending;
            }
            if (commonBase != null) continue;
            throw new IllegalArgumentException(StructuredUnit.formatMessage("err_structUnitPartsWithoutCommonBase", this.toString()));
        }
        this.fireVetoableChange("parts", oldValue, newValue);
        this.parts = newValue;
        this.firePropertyChange("parts", oldValue, newValue);
    }

    public Unit getFirstUnit() {
        return this.firstUnit;
    }

    public void setFirstUnit(Unit firstUnit) throws PropertyVetoException {
        Unit oldValue = this.firstUnit;
        Unit newValue = firstUnit;
        if (oldValue == newValue) {
            return;
        }
        if (firstUnit.isAbstract()) {
            throw new IllegalArgumentException(StructuredUnit.formatMessage("err_abstractStructUnitPart", this.toString(), firstUnit.toString()));
        }
        this.fireVetoableChange("firstUnit", oldValue, newValue);
        this.firstUnit = newValue;
        this.firePropertyChange("firstUnit", oldValue, newValue);
    }

    @Override
    public boolean isDependentOn(Element e) {
        if (this.firstUnit != null && this.firstUnit.isDependentOn(e)) {
            return true;
        }
        for (int i = 0; i < this.parts.length; ++i) {
            Part p = this.parts[i];
            if (!p.getUnit().isDependentOn(e)) continue;
            return true;
        }
        return super.isDependentOn(e);
    }

    public void setExtending(Unit extending) throws PropertyVetoException {
        if (extending != null) {
            throw new IllegalArgumentException(StructuredUnit.formatMessage("err_cantExtendStructUnit", this.toString(), extending.toString()));
        }
        super.setExtending(extending);
    }

    @Override
    public void setAbstract(boolean abst) throws PropertyVetoException {
        if (abst) {
            throw new IllegalArgumentException(StructuredUnit.formatMessage("err_abstractStructUnit", this.toString()));
        }
        super.setAbstract(abst);
    }

    public void setContinuous(boolean continuous) throws PropertyVetoException {
        boolean oldValue = this.continuous;
        boolean newValue = continuous;
        if (oldValue == newValue) {
            return;
        }
        this.fireVetoableChange("continuous", oldValue, newValue);
        this.continuous = newValue;
        this.firePropertyChange("continuous", oldValue, newValue);
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public static class Part {
        protected Unit unit;
        protected PrecisionDecimal min;
        protected PrecisionDecimal max;

        public Part(Unit unit, PrecisionDecimal min, PrecisionDecimal max) {
            this.unit = unit;
            this.min = min;
            this.max = max;
            if (min == null || max == null) {
                throw new IllegalArgumentException(Element.rsrc.getString("err_nullNotAcceptable"));
            }
            if (min.compareTo(max) == 1) {
                throw new IllegalArgumentException(Element.rsrc.getString("err_structuredUnit_minGreaterMax"));
            }
            if (min.doubleValue() < 0.0) {
                throw new IllegalArgumentException(Element.rsrc.getString("err_structuredUnit_negMin"));
            }
            if (max.doubleValue() < 0.0) {
                throw new IllegalArgumentException(Element.rsrc.getString("err_structuredUnit_negMax"));
            }
            if (min.getExponent() != 0) {
                throw new IllegalArgumentException(Element.rsrc.getString("err_structuredUnit_scaledMin"));
            }
            if (max.getExponent() != 0) {
                throw new IllegalArgumentException(Element.rsrc.getString("err_structuredUnit_scaledMax"));
            }
        }

        public Unit getUnit() {
            return this.unit;
        }

        public PrecisionDecimal getMinimum() {
            return this.min;
        }

        public PrecisionDecimal getMaximum() {
            return this.max;
        }
    }
}

