/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2duckdb;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.ili2db.base.DbIdGen;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.sqlgen.DbUtility;
import ch.ehi.sqlgen.generator.Generator;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTableName;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DuckDBIdGen
implements DbIdGen {
    public static final String SQL_ILI2DB_SEQ_NAME = "t_ili2db_seq";
    Connection conn = null;
    String dbusr = null;
    String schema = null;
    Long minValue = null;
    Long maxValue = null;
    long lastLocalId = 0L;

    @Override
    public void init(String schema, Config config) {
        this.schema = schema;
        this.minValue = config.getMinIdSeqValue();
        this.maxValue = config.getMaxIdSeqValue();
    }

    @Override
    public void initDb(Connection conn, String dbusr) {
        this.conn = conn;
        this.dbusr = dbusr;
    }

    @Override
    public void addMappingTable(DbSchema schema) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initDbDefs(Generator gen) {
        DbTableName sqlName = new DbTableName(this.schema, SQL_ILI2DB_SEQ_NAME);
        String stmt = "CREATE SEQUENCE " + sqlName.getQName();
        if (this.minValue != null) {
            stmt = stmt + " MINVALUE " + this.minValue;
        }
        if (this.maxValue != null) {
            stmt = stmt + " MAXVALUE " + this.maxValue;
        }
        stmt = stmt + ";";
        if (gen instanceof GeneratorJdbc) {
            GeneratorJdbc generatorJdbc = (GeneratorJdbc)gen;
            GeneratorJdbc generatorJdbc2 = (GeneratorJdbc)gen;
            generatorJdbc2.getClass();
            generatorJdbc.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt(generatorJdbc2, stmt));
            GeneratorJdbc generatorJdbc3 = (GeneratorJdbc)gen;
            GeneratorJdbc generatorJdbc4 = (GeneratorJdbc)gen;
            generatorJdbc4.getClass();
            generatorJdbc3.addDropLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt(generatorJdbc4, "DROP SEQUENCE " + sqlName.getQName() + ";"));
        }
        if (this.conn != null) {
            if (DbUtility.sequenceExists((Connection)this.conn, (DbTableName)sqlName)) {
                return;
            }
            EhiLogger.traceBackendCmd((String)stmt);
            PreparedStatement updstmt = null;
            try {
                updstmt = this.conn.prepareStatement(stmt);
                updstmt.execute();
            }
            catch (SQLException ex) {
                EhiLogger.logError((String)("failed to create sequence " + sqlName.getQName()), (Throwable)ex);
            }
            finally {
                if (updstmt != null) {
                    try {
                        updstmt.close();
                    }
                    catch (SQLException ex) {
                        EhiLogger.logError((Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    public long newObjSqlId() {
        this.lastLocalId = this.getSeqCount();
        return this.lastLocalId;
    }

    @Override
    public long getLastSqlId() {
        return this.lastLocalId;
    }

    private long getSeqCount() {
        String sqlName = SQL_ILI2DB_SEQ_NAME;
        if (this.schema != null) {
            sqlName = this.schema + "." + sqlName;
        }
        Statement getstmt = null;
        ResultSet res = null;
        try {
            String stmt = "SELECT nextval('" + sqlName + "')";
            EhiLogger.traceBackendCmd((String)stmt);
            getstmt = this.conn.prepareStatement(stmt);
            res = getstmt.executeQuery();
            long ret = 0L;
            if (res.next()) {
                long l = ret = res.getLong(1);
                return l;
            }
        }
        catch (SQLException ex) {
            EhiLogger.logError((String)("failed to query " + sqlName), (Throwable)ex);
            throw new IllegalStateException(ex);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
                res = null;
            }
            if (getstmt != null) {
                try {
                    getstmt.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
                getstmt = null;
            }
        }
        throw new IllegalStateException("no nextval " + sqlName);
    }

    @Override
    public String getDefaultValueSql() {
        String sqlName = SQL_ILI2DB_SEQ_NAME;
        if (this.schema != null) {
            sqlName = this.schema + "." + sqlName;
        }
        return "nextval('" + sqlName + "')";
    }
}

