/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.generator;

import ch.ehi.basics.io.IndentPrintWriter;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.generator.TransformationParameter;
import ch.interlis.ili2c.generator.nls.Ili2TranslationXml;
import ch.interlis.ili2c.generator.nls.ModelElements;
import ch.interlis.ili2c.generator.nls.TranslationElement;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractCoordType;
import ch.interlis.ili2c.metamodel.AbstractEnumerationType;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AssociationPath;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.AttributePathType;
import ch.interlis.ili2c.metamodel.AttributeRef;
import ch.interlis.ili2c.metamodel.BasketType;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.ClassType;
import ch.interlis.ili2c.metamodel.ComposedUnit;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.ConditionalExpression;
import ch.interlis.ili2c.metamodel.Constant;
import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.ContextDef;
import ch.interlis.ili2c.metamodel.DecompositionView;
import ch.interlis.ili2c.metamodel.DerivedUnit;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.DomainConstraint;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumTreeValueType;
import ch.interlis.ili2c.metamodel.EnumValType;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.ExistenceConstraint;
import ch.interlis.ili2c.metamodel.Expression;
import ch.interlis.ili2c.metamodel.ExpressionSelection;
import ch.interlis.ili2c.metamodel.ExtendableContainer;
import ch.interlis.ili2c.metamodel.FormalArgument;
import ch.interlis.ili2c.metamodel.FormattedType;
import ch.interlis.ili2c.metamodel.FormattedTypeBaseAttrRef;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.FunctionCall;
import ch.interlis.ili2c.metamodel.FunctionallyDerivedUnit;
import ch.interlis.ili2c.metamodel.Graphic;
import ch.interlis.ili2c.metamodel.GraphicParameterDef;
import ch.interlis.ili2c.metamodel.JoinView;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.MandatoryConstraint;
import ch.interlis.ili2c.metamodel.MetaDataUseDef;
import ch.interlis.ili2c.metamodel.MetaObject;
import ch.interlis.ili2c.metamodel.MetaobjectType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.MultiAreaType;
import ch.interlis.ili2c.metamodel.MultiCoordType;
import ch.interlis.ili2c.metamodel.MultiPolylineType;
import ch.interlis.ili2c.metamodel.MultiSurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.MultiSurfaceType;
import ch.interlis.ili2c.metamodel.NoOid;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.NumericallyDerivedUnit;
import ch.interlis.ili2c.metamodel.OIDType;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.Objects;
import ch.interlis.ili2c.metamodel.Parameter;
import ch.interlis.ili2c.metamodel.ParameterAssignment;
import ch.interlis.ili2c.metamodel.ParameterValue;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.PathElAbstractClassRole;
import ch.interlis.ili2c.metamodel.PathElAssocRole;
import ch.interlis.ili2c.metamodel.PathElBase;
import ch.interlis.ili2c.metamodel.PathElThis;
import ch.interlis.ili2c.metamodel.PlausibilityConstraint;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.Projection;
import ch.interlis.ili2c.metamodel.RefSystemModel;
import ch.interlis.ili2c.metamodel.RefSystemRef;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SetConstraint;
import ch.interlis.ili2c.metamodel.SignAttribute;
import ch.interlis.ili2c.metamodel.SignInstruction;
import ch.interlis.ili2c.metamodel.StructuredUnit;
import ch.interlis.ili2c.metamodel.StructuredUnitType;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.SymbologyModel;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.TypeModel;
import ch.interlis.ili2c.metamodel.UnionView;
import ch.interlis.ili2c.metamodel.UniqueEl;
import ch.interlis.ili2c.metamodel.UniquenessConstraint;
import ch.interlis.ili2c.metamodel.Unit;
import ch.interlis.ili2c.metamodel.ValueRefThis;
import ch.interlis.ili2c.metamodel.View;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableAlias;
import ch.interlis.ili2c.parser.InterlisString;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

public class Interlis2Generator {
    protected IndentPrintWriter ipw;
    TransferDescription td;
    PredefinedModel modelInterlis;
    Unit anyUnit;
    boolean withPredefined;
    private boolean onlyLastFile;
    int numErrors = 0;
    private boolean doIli24 = false;
    private static final String FR = "fr";
    private static final String IT = "it";
    private static final String EN = "en";
    private static final String DE = "de";
    private List<Constraint> selfStandingConstraints = null;
    private ModelElements translationConfig;
    private TransformationParameter params = null;

    public static Interlis2Generator generateElements(Writer out, TransferDescription td) {
        return Interlis2Generator.generateElements(out, td, null);
    }

    public static Interlis2Generator generateElements(Writer out, TransferDescription td, ModelElements modelElements) {
        Interlis2Generator i = new Interlis2Generator();
        i.setup(out, td, false, false, modelElements, null, null);
        return i;
    }

    public static Interlis2Generator generateElements24(Writer out, TransferDescription td) {
        Interlis2Generator i = new Interlis2Generator();
        i.setup(out, td, false, false, null, null, true);
        return i;
    }

    public static String debugToString(TransferDescription td, Element ele) {
        StringWriter syntaxBuffer = new StringWriter();
        Interlis2Generator makeSyntax = Interlis2Generator.generateElements(syntaxBuffer, td, null);
        makeSyntax.printElement(ele.getContainer(), null, ele, null);
        makeSyntax.ipw.flush();
        return syntaxBuffer.toString();
    }

    private void finish() {
        this.ipw.close();
    }

    protected void printError() {
        this.ipw.print(Element.makeErrorName(null));
        ++this.numErrors;
    }

    public int generate(Writer out, TransferDescription rd, boolean withPredefined) {
        this.setup(out, rd, withPredefined, false, null, null, null);
        this.printTransferDescription(rd, null);
        this.finish();
        return this.numErrors;
    }

    public int generateWithNewCrs(Writer out, TransferDescription rd, TransformationParameter params) {
        this.setup(out, rd, false, true, null, params, null);
        this.printTransferDescription(rd, null);
        this.finish();
        return this.numErrors;
    }

    public int generateWithNewLanguage(Writer out, TransferDescription td, ModelElements modelEles, String language) {
        this.setup(out, td, false, true, modelEles, null, null);
        this.printTransferDescription(td, language);
        this.finish();
        return this.numErrors;
    }

    private void setup(Writer out, TransferDescription td, boolean withPredefined, boolean onlyLastFile, ModelElements modelEles, TransformationParameter params, Boolean doIli24) {
        this.ipw = new IndentPrintWriter(out);
        this.td = td;
        this.modelInterlis = td.INTERLIS;
        this.anyUnit = td.INTERLIS.ANYUNIT;
        this.withPredefined = withPredefined;
        this.translationConfig = modelEles;
        this.params = params;
        this.onlyLastFile = onlyLastFile;
        this.doIli24 = doIli24 != null ? doIli24 : !td.getLastModel().isIli23();
    }

    private boolean printModifierHelper(boolean first, boolean flag, String what) {
        if (flag) {
            if (!first) {
                this.ipw.print(", ");
            }
            this.ipw.print(what);
            return false;
        }
        return first;
    }

    protected void printModifiers(boolean _abstract, boolean _final, boolean _extended, boolean _ordered, boolean _external, boolean _transient, boolean _generic) {
        if (!(_abstract || _final || _extended || _ordered || _external || _transient || _generic)) {
            return;
        }
        boolean first = true;
        this.ipw.print(" (");
        first = this.printModifierHelper(first, _abstract, "ABSTRACT");
        first = this.printModifierHelper(first, _final, "FINAL");
        first = this.printModifierHelper(first, _extended, "EXTENDED");
        first = this.printModifierHelper(first, _ordered, "ORDERED");
        first = this.printModifierHelper(first, _external, "EXTERNAL");
        first = this.printModifierHelper(first, _transient, "TRANSIENT");
        first = this.printModifierHelper(first, _generic, "GENERIC");
        this.ipw.print(')');
    }

    protected void printTopic(Topic topic, String language) {
        Iterator it;
        Domain classOid;
        if (topic == null) {
            return;
        }
        this.selfStandingConstraints = new ArrayList<Constraint>();
        Topic extending = (Topic)topic.getExtending();
        this.printDocumentation(topic, language);
        this.printMetaValues(topic, topic.getMetaValues(), language, topic.getScopedName());
        this.ipw.print("TOPIC ");
        this.printName(topic, language);
        this.printModifiers(topic.isAbstract(), topic.isFinal(), false, false, false, false, false);
        if (extending != null) {
            this.ipw.print(" EXTENDS ");
            this.printRef(topic, extending, language);
        }
        this.ipw.println(" =");
        this.ipw.indent();
        Domain basketOid = this.getTopicBasketOid(topic);
        if (basketOid != null) {
            this.ipw.print("BASKET OID AS ");
            this.printRef(topic, basketOid, language);
            this.ipw.println(';');
        }
        if ((classOid = this.getTopicClassOid(topic)) != null) {
            this.ipw.print("OID AS ");
            this.printRef(topic, classOid, language);
            this.ipw.println(';');
        }
        if ((it = this.getTopicDependsOn(topic)).hasNext()) {
            this.ipw.print("DEPENDS ON ");
            Topic depTopic = (Topic)it.next();
            this.printRef(topic, depTopic, language);
            while (it.hasNext()) {
                this.ipw.print(", ");
                depTopic = (Topic)it.next();
                this.printRef(topic, depTopic, language);
            }
            this.ipw.println(';');
        }
        this.printElements(topic, language);
        this.printSelfStandingConstraints(this.selfStandingConstraints, language);
        this.ipw.unindent();
        this.ipw.println();
        this.ipw.print("END ");
        this.printName(topic, language);
        this.ipw.println(';');
        this.selfStandingConstraints = null;
    }

    protected void printSelfStandingConstraints(List<Constraint> selfStandingConstraints, String language) {
        Iterator<Constraint> csi = selfStandingConstraints.iterator();
        Viewable view = null;
        Viewable lastView = null;
        while (csi.hasNext()) {
            Constraint cs = csi.next();
            view = (Viewable)cs.getContainer();
            if (view != lastView) {
                if (lastView != null) {
                    this.ipw.unindent();
                    this.ipw.println("END;");
                } else {
                    this.ipw.println();
                }
                lastView = view;
                this.ipw.print("CONSTRAINTS OF ");
                if (language == null) {
                    this.ipw.print(view.getName());
                } else {
                    String name = this.getNameInLanguage(view, language);
                    if (name == null || name == "") {
                        this.ipw.print(view.getName());
                    } else {
                        this.ipw.print(name);
                    }
                }
                this.ipw.println('=');
                this.ipw.indent();
            }
            this.printConstraint(cs, language);
        }
        if (lastView != null) {
            this.ipw.unindent();
            this.ipw.println("END;");
        }
    }

    protected Iterator getTopicDependsOn(Topic topic) {
        return topic.getDependentOn();
    }

    protected Domain getTopicClassOid(Topic topic) {
        Domain classOid = topic.getOid();
        return classOid;
    }

    protected Domain getTopicBasketOid(Topic topic) {
        Domain basketOid = topic.getBasketOid();
        return basketOid;
    }

    protected void printAbstractClassDef(AbstractClassDef def, String language) {
        String keyword;
        this.printDocumentation(def, language);
        this.printMetaValues(def, def.getMetaValues(), language, def.getScopedName());
        if (def instanceof Table) {
            Table tdef = (Table)def;
            keyword = tdef.isIdentifiable() ? "CLASS" : "STRUCTURE";
        } else if (def instanceof AssociationDef) {
            keyword = "ASSOCIATION";
        } else {
            throw new IllegalArgumentException();
        }
        this.printStart(keyword, def, null, language);
        this.ipw.println(" =");
        this.ipw.indent();
        Domain oid = this.getAbstarctClassDefOid(def);
        if (oid != null) {
            if (oid instanceof NoOid) {
                this.ipw.println("NO OID;");
            } else {
                this.ipw.print("OID AS ");
                this.printRef(def.getContainer(), oid, language);
                this.ipw.println(";");
            }
        }
        this.printElements(def, language);
        this.printEnd(def, language);
    }

    protected Domain getAbstarctClassDefOid(AbstractClassDef def) {
        Domain oid = def.getDefinedOid();
        return oid;
    }

    private void printRenamedViewableRef(View view, ViewableAlias ref, String language) {
        String scopedName;
        if (ref == null) {
            this.printError();
            return;
        }
        String name = ref.getName();
        if (language != null && ((name = this.getNameInLanguage(scopedName = view.getScopedName() + "." + ref.getName(), language)) == null || name.equals(""))) {
            name = ref.getName();
        }
        Viewable v = ref.getAliasing();
        if (name == null || v == null) {
            this.printError();
            return;
        }
        if (!name.equals(v.getName())) {
            this.ipw.print(name);
            this.ipw.print('~');
        }
        this.printRef(view.getContainer(), v, language);
    }

    protected void printRenamedViewableRefs(View scope, ViewableAlias[] refs, String language) {
        if (refs == null || refs.length == 0) {
            return;
        }
        this.printRenamedViewableRef(scope, refs[0], language);
        for (int i = 1; i < refs.length; ++i) {
            this.ipw.print(", ");
            this.printRenamedViewableRef(scope, refs[i], language);
        }
    }

    protected void printStart(String keyword, ExtendableContainer ec, Viewable basedOn, String language) {
        if (ec == null) {
            return;
        }
        ExtendableContainer extending = (ExtendableContainer)ec.getExtending();
        boolean extendingSameName = false;
        if (extending != null) {
            Topic myTopic = (Topic)ec.getContainer(Topic.class);
            Topic extendedTopic = (Topic)extending.getContainer(Topic.class);
            if (myTopic != null && extendedTopic != null && myTopic.isExtending(extendedTopic) && ec.getName().equals(extending.getName())) {
                extendingSameName = true;
            }
        }
        this.ipw.print(keyword);
        this.ipw.print(' ');
        this.printName(ec, language);
        boolean _transient = false;
        if (ec instanceof View) {
            _transient = ((View)ec).isTransient();
        }
        this.printModifiers(ec.isAbstract(), ec.isFinal(), extendingSameName, false, false, _transient, false);
        if (extending != null && !extendingSameName) {
            this.ipw.print(" EXTENDS ");
            this.printRef(ec.getContainer(), extending, language);
        }
        if (basedOn != null) {
            this.ipw.print(" BASED ON ");
            this.printRef(ec.getContainer(), basedOn, language);
        }
    }

    protected void printEnd(ExtendableContainer ec, String language) {
        if (ec == null) {
            return;
        }
        this.ipw.unindent();
        this.ipw.print("END ");
        this.printName(ec, language);
        this.ipw.println(';');
    }

    public void printView(View view) {
        this.printView(view, null);
    }

    public void printView(View view, String language) {
        this.printView(view, false, language);
    }

    public void printView(View view, boolean suppressDoc) {
        this.printView(view, suppressDoc, null);
    }

    public void printView(View view, boolean suppressDoc, String language) {
        if (!suppressDoc) {
            this.printDocumentation(view, language);
            this.printMetaValues(view, view.getMetaValues(), language, view.getScopedName());
        }
        this.printStart("VIEW", view, null, language);
        this.ipw.println("");
        this.ipw.indent();
        if (view instanceof Projection) {
            this.ipw.print("PROJECTION OF ");
            this.printRenamedViewableRef(view, ((Projection)view).getSelected(), language);
        } else if (view instanceof JoinView) {
            this.ipw.print("JOIN OF ");
            this.printRenamedViewableRefs(view, ((JoinView)view).getJoining(), language);
        } else if (view instanceof UnionView) {
            this.ipw.print("UNION OF ");
            this.printRenamedViewableRefs(view, ((UnionView)view).getUnited(), language);
        } else if (view instanceof DecompositionView) {
            Object decomposedViewable = null;
            ObjectPath decomposedAttribute = ((DecompositionView)view).getDecomposedAttribute();
            if (((DecompositionView)view).isAreaDecomposition()) {
                this.ipw.print("AREA ");
            }
            this.ipw.print("DECOMPOSITION OF ");
            if (decomposedAttribute == null) {
                this.printError();
            }
        } else {
            this.printError();
            this.ipw.println("<unknown view type>");
        }
        this.ipw.println(";");
        this.printSelection(view, language);
        this.ipw.println("=");
        this.printElements(view, language);
        this.printEnd(view, language);
    }

    protected void printSelection(Container view, String language) {
        Iterator it = view.iterator();
        while (it.hasNext()) {
            Element elt = (Element)it.next();
            if (!(elt instanceof ExpressionSelection)) continue;
            this.ipw.println("WHERE");
            this.ipw.indent();
            this.printExpression(((ExpressionSelection)elt).getSelected(), ((ExpressionSelection)elt).getCondition(), language);
            this.ipw.println(';');
            this.ipw.unindent();
        }
    }

    public void printGraphic(Graphic graph) {
        this.printGraphic(graph, null);
    }

    public void printGraphic(Graphic graph, String language) {
        this.printGraphic(graph, false, language);
    }

    public void printGraphic(Graphic graph, boolean suppressDoc) {
        this.printGraphic(graph, suppressDoc, null);
    }

    public void printGraphic(Graphic graph, boolean suppressDoc, String language) {
        if (graph == null) {
            return;
        }
        if (!suppressDoc) {
            this.printDocumentation(graph, language);
            this.printMetaValues(graph, graph.getMetaValues(), language, graph.getScopedName());
        }
        this.printStart("GRAPHIC", graph, graph.getBasedOn(), language);
        this.ipw.println(" =");
        this.ipw.indent();
        this.printSelection(graph, language);
        this.printElements(graph, language);
        this.printEnd(graph, language);
    }

    protected void printExpression(Container scope, Evaluable expr, String language) {
        this.printExpression(scope, expr, 0, language);
    }

    protected void printExpression(Container scope, Evaluable expr, int precedence, String language) {
        int exprPrec = 0;
        if (expr instanceof ObjectPath) {
            this.printAttributePath(scope, (ObjectPath)expr, language);
            return;
        }
        if (expr instanceof Constant.Undefined) {
            this.ipw.print("UNDEFINED");
            return;
        }
        if (expr instanceof Constant.Numeric) {
            Constant.Numeric cnum = (Constant.Numeric)expr;
            this.ipw.print((Object)cnum.getValue());
            if (cnum.getUnit() != null) {
                this.ipw.print('[');
                this.printRef(scope, cnum.getUnit(), language);
                this.ipw.print(']');
            }
            return;
        }
        if (expr instanceof Constant.Text) {
            String value = ((Constant.Text)expr).getValue();
            this.ipw.print('\"');
            this.ipw.print(InterlisString.escapeSpecialChars(value));
            this.ipw.print('\"');
            return;
        }
        if (expr instanceof Constant.AttributePath) {
            this.ipw.print(">>");
            if (language == null) {
                this.ipw.print(((Constant.AttributePath)expr).getValue().getName());
            } else {
                String name = this.getNameInLanguage(((Constant.AttributePath)expr).getValue(), language);
                if (name != null && name != "") {
                    this.ipw.print(name);
                }
            }
            return;
        }
        if (expr instanceof Constant.Enumeration) {
            this.ipw.print('#');
            String[] val = ((Constant.Enumeration)expr).getValue();
            if (val == null) {
                this.printError();
            } else {
                String scopedName = null;
                Element attrEle = ((Constant.Enumeration)expr).getSourceOfType();
                if (attrEle != null) {
                    if (attrEle instanceof AttributeDef) {
                        AttributeDef attr = (AttributeDef)attrEle;
                        if (attr.getDomain() instanceof TypeAlias) {
                            Domain domain = ((TypeAlias)attr.getDomain()).getAliasing();
                            scopedName = domain.getScopedName();
                        } else {
                            scopedName = attr.getScopedName();
                        }
                    } else if (attrEle instanceof Domain) {
                        scopedName = ((Domain)attrEle).getScopedName();
                    }
                }
                if (language == null) {
                    for (int i = 0; i < val.length; ++i) {
                        if (i > 0) {
                            this.ipw.print('.');
                        }
                        if (val[i] == null) {
                            this.printError();
                            continue;
                        }
                        this.ipw.print(val[i]);
                    }
                } else {
                    String[] namePrefix = new String[val.length + 1];
                    namePrefix[0] = scopedName;
                    for (int i = 0; i < val.length; ++i) {
                        if (i > 0) {
                            this.ipw.print('.');
                        }
                        namePrefix[i + 1] = namePrefix[i] + "." + val[i];
                        String nameEle = this.getNameInLanguage(namePrefix[i + 1], language);
                        if (nameEle != null && nameEle.length() > 0) {
                            this.ipw.print(nameEle);
                            continue;
                        }
                        this.ipw.print(val[i]);
                    }
                }
            }
            return;
        }
        if (expr instanceof Constant.ReferenceToMetaObject) {
            MetaObject refMO = ((Constant.ReferenceToMetaObject)expr).getReferred();
            this.ipw.print('{');
            if (refMO != null) {
                if (language == null) {
                    this.ipw.print(refMO.getName());
                } else {
                    String name = this.getNameInLanguage(refMO, language);
                    if (name == null || name == "") {
                        this.ipw.print(refMO.getName());
                    } else {
                        this.ipw.print(name);
                    }
                }
            } else {
                this.printError();
            }
            this.ipw.print('}');
            return;
        }
        if (expr instanceof Constant.Structured) {
            String val = ((Constant.Structured)expr).toString();
            if (val == null) {
                this.printError();
            } else {
                this.ipw.print(val);
            }
            return;
        }
        if (expr instanceof FunctionCall) {
            FunctionCall f = (FunctionCall)expr;
            this.printRef(scope, f.getFunction(), language);
            this.ipw.print("(");
            Evaluable[] args = f.getArguments();
            if (args == null) {
                this.printError();
            } else {
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        this.ipw.print(", ");
                    }
                    this.printExpression(scope, args[i], language);
                }
            }
            this.ipw.print(')');
            return;
        }
        if (expr instanceof ParameterValue) {
            this.ipw.print("PARAMETER ");
            this.printRef(scope, ((ParameterValue)expr).getParameter(), language);
            return;
        }
        if (expr instanceof Expression.Implication) {
            this.printExpression(scope, ((Expression.Implication)expr).getLeft(), exprPrec, language);
            this.ipw.print(" => ");
            this.printExpression(scope, ((Expression.Implication)expr).getRight(), exprPrec, language);
            return;
        }
        if (expr instanceof Expression.Disjunction) {
            Evaluable[] disjoined = ((Expression.Disjunction)expr).getDisjoined();
            for (int i = 0; i < disjoined.length; ++i) {
                if (i > 0) {
                    this.ipw.print(" OR ");
                }
                this.printExpression(scope, disjoined[i], exprPrec, language);
            }
            return;
        }
        if (expr instanceof Expression.Addition) {
            this.printExpression(scope, ((Expression.Addition)expr).getLeft(), exprPrec, language);
            this.ipw.print(" + ");
            this.printExpression(scope, ((Expression.Addition)expr).getRight(), exprPrec, language);
            return;
        }
        if (expr instanceof Expression.Subtraction) {
            this.printExpression(scope, ((Expression.Subtraction)expr).getLeft(), exprPrec, language);
            this.ipw.print(" - ");
            this.printExpression(scope, ((Expression.Subtraction)expr).getRight(), exprPrec, language);
            return;
        }
        if (expr instanceof Expression.Conjunction) {
            Evaluable[] conjoined = ((Expression.Conjunction)expr).getConjoined();
            for (int i = 0; i < conjoined.length; ++i) {
                if (i > 0) {
                    this.ipw.print(" AND ");
                }
                this.printExpression(scope, conjoined[i], exprPrec, language);
            }
            return;
        }
        if (expr instanceof Expression.Multiplication) {
            this.printExpression(scope, ((Expression.Multiplication)expr).getLeft(), exprPrec, language);
            this.ipw.print(" * ");
            this.printExpression(scope, ((Expression.Multiplication)expr).getRight(), exprPrec, language);
            return;
        }
        if (expr instanceof Expression.Division) {
            this.printExpression(scope, ((Expression.Division)expr).getLeft(), exprPrec, language);
            this.ipw.print(" / ");
            this.printExpression(scope, ((Expression.Division)expr).getRight(), exprPrec, language);
            return;
        }
        if (expr instanceof Expression.Negation) {
            this.ipw.print("NOT (");
            this.printExpression(scope, ((Expression.Negation)expr).getNegated(), exprPrec, language);
            this.ipw.print(")");
            return;
        }
        if (expr instanceof Expression.Subexpression) {
            this.ipw.print("(");
            this.printExpression(scope, ((Expression.Subexpression)expr).getSubexpression(), exprPrec, language);
            this.ipw.print(")");
            return;
        }
        if (expr instanceof Expression.Equality) {
            this.printExpression(scope, ((Expression.Equality)expr).getLeft(), exprPrec, language);
            this.ipw.print(" == ");
            this.printExpression(scope, ((Expression.Equality)expr).getRight(), exprPrec, language);
            return;
        }
        if (expr instanceof Expression.Inequality) {
            this.printExpression(scope, ((Expression.Inequality)expr).getLeft(), exprPrec, language);
            this.ipw.print(" <> ");
            this.printExpression(scope, ((Expression.Inequality)expr).getRight(), exprPrec, language);
            return;
        }
        if (expr instanceof Expression.LessThanOrEqual) {
            this.printExpression(scope, ((Expression.LessThanOrEqual)expr).getLeft(), exprPrec, language);
            this.ipw.print(" <= ");
            this.printExpression(scope, ((Expression.LessThanOrEqual)expr).getRight(), exprPrec, language);
            return;
        }
        if (expr instanceof Expression.GreaterThanOrEqual) {
            this.printExpression(scope, ((Expression.GreaterThanOrEqual)expr).getLeft(), exprPrec, language);
            this.ipw.print(" >= ");
            this.printExpression(scope, ((Expression.GreaterThanOrEqual)expr).getRight(), exprPrec, language);
            return;
        }
        if (expr instanceof Expression.LessThan) {
            this.printExpression(scope, ((Expression.LessThan)expr).getLeft(), exprPrec, language);
            this.ipw.print(" < ");
            this.printExpression(scope, ((Expression.LessThan)expr).getRight(), exprPrec, language);
            return;
        }
        if (expr instanceof Expression.GreaterThan) {
            this.printExpression(scope, ((Expression.GreaterThan)expr).getLeft(), exprPrec, language);
            this.ipw.print(" > ");
            this.printExpression(scope, ((Expression.GreaterThan)expr).getRight(), exprPrec, language);
            return;
        }
        if (expr instanceof Expression.DefinedCheck) {
            this.ipw.print("DEFINED(");
            this.printExpression(scope, ((Expression.DefinedCheck)expr).getArgument(), exprPrec, language);
            this.ipw.print(')');
            return;
        }
        if (expr instanceof ConditionalExpression) {
            ConditionalExpression.Condition[] conds = ((ConditionalExpression)expr).getConditions();
            this.ipw.print("WITH ");
            this.printAttributePath(scope, ((ConditionalExpression)expr).getAttribute(), language);
            this.ipw.println(" (");
            this.ipw.indent();
            if (conds == null) {
                this.printError();
            } else {
                for (int i = 0; i < conds.length; ++i) {
                    if (i != 0) {
                        this.ipw.println(",");
                    }
                    if (conds[i] == null) {
                        this.printError();
                        continue;
                    }
                    this.printExpression(scope, conds[i].getValue(), language);
                    this.ipw.print(" WHEN IN ");
                    this.printExpression(scope, conds[i].getCondition(), language);
                }
            }
            this.ipw.unindent();
            this.ipw.print(')');
            return;
        }
        if (expr instanceof Objects) {
            this.ipw.print("ALL");
            return;
        }
        if (expr instanceof ValueRefThis) {
            this.ipw.print("THIS");
            return;
        }
        this.printError();
    }

    protected void printExistenceConstraint(ExistenceConstraint ec, String language) {
        this.ipw.print("EXISTENCE CONSTRAINT ");
        if (ec.hasCustomName()) {
            this.ipw.print(ec.getName() + ": ");
        }
        ObjectPath attr = ec.getRestrictedAttribute();
        this.printAttributePath(ec.getContainer(), attr, language);
        this.ipw.print(" REQUIRED IN ");
        Iterator<ObjectPath> reqi = ec.iteratorRequiredIn();
        String next = "";
        while (reqi.hasNext()) {
            ObjectPath req = reqi.next();
            this.ipw.print(next);
            next = " OR ";
            this.printRef(ec.getContainer(), req.getRoot(), language);
            this.ipw.print(":");
            this.printAttributePath(ec.getContainer(), req, language);
        }
        this.ipw.println(';');
    }

    protected void printSetConstraint(SetConstraint sc, String language) {
        this.ipw.print("SET CONSTRAINT");
        if (sc.perBasket()) {
            this.ipw.print(" (BASKET)");
        }
        if (sc.hasCustomName()) {
            this.ipw.print(" " + sc.getName() + ":");
        }
        if (sc.getPreCondition() != null) {
            this.ipw.print(" WHERE ");
            this.printExpression(sc.getContainer(), sc.getPreCondition(), language);
            this.ipw.print(":");
        }
        this.ipw.println();
        this.ipw.indent();
        this.printExpression(sc.getContainer(), sc.getCondition(), language);
        this.ipw.println(';');
        this.ipw.unindent();
    }

    protected void printUniquenessConstraint(UniquenessConstraint uc, String language) {
        UniqueEl uel = uc.getElements();
        Iterator<ObjectPath> pathi = uel.iteratorAttribute();
        this.ipw.print("UNIQUE ");
        if (uc.perBasket()) {
            this.ipw.print("(BASKET) ");
        }
        if (uc.hasCustomName()) {
            this.ipw.print(uc.getName() + ": ");
        }
        if (uc.getPreCondition() != null) {
            this.ipw.print("WHERE ");
            this.printExpression(uc.getContainer(), uc.getPreCondition(), language);
            this.ipw.println(": ");
        }
        if (uc.getLocal()) {
            this.ipw.print("(LOCAL) ");
            ObjectPath prefix = uc.getPrefix();
            this.printAttributePath(uc.getContainer(), prefix, language);
            String next = ": ";
            while (pathi.hasNext()) {
                ObjectPath path = pathi.next();
                this.ipw.print(next);
                next = ", ";
                this.printAttributePath(uc.getContainer(), path, language);
            }
        } else {
            String next = "";
            while (pathi.hasNext()) {
                ObjectPath path = pathi.next();
                this.ipw.print(next);
                next = ", ";
                this.printAttributePath(uc.getContainer(), path, language);
            }
        }
        this.ipw.println(';');
    }

    protected void printPlausibilityConstraint(PlausibilityConstraint pc, String language) {
        this.ipw.print("CONSTRAINT ");
        if (pc.hasCustomName()) {
            this.ipw.print(pc.getName() + ": ");
        }
        if (pc.getDirection() == 0) {
            this.ipw.print(">= ");
        } else {
            this.ipw.print("<= ");
        }
        this.ipw.print(pc.getPercentage());
        this.ipw.print("% ");
        this.printExpression(pc.getContainer(), pc.getCondition(), language);
        this.ipw.println(';');
    }

    protected void printMandatoryConstraint(MandatoryConstraint mc, String language) {
        this.ipw.print("MANDATORY CONSTRAINT ");
        if (mc.hasCustomName()) {
            this.ipw.print(mc.getName() + ": ");
        }
        this.printExpression(mc.getContainer(), mc.getCondition(), language);
        this.ipw.println(';');
    }

    protected void printDomainConstraint(DomainConstraint constraint, String language) {
        this.ipw.print(constraint.getName() + ": ");
        this.printExpression(constraint.getContainer(), constraint.getCondition(), language);
    }

    public void printConstraint(Constraint elt) {
        this.printConstraint(elt, null);
    }

    public void printConstraint(Constraint elt, String language) {
        this.printConstraint(elt, false, language);
    }

    public void printConstraint(Constraint elt, boolean suppressDoc) {
        this.printConstraint(elt, suppressDoc, null);
    }

    public void printConstraint(Constraint elt, boolean suppressDoc, String language) {
        if (!suppressDoc) {
            this.printDocumentation(elt, language);
            this.printMetaValues(elt, elt.getMetaValues(), language, elt.getScopedName());
        }
        if (elt instanceof MandatoryConstraint) {
            this.printMandatoryConstraint((MandatoryConstraint)elt, language);
        } else if (elt instanceof PlausibilityConstraint) {
            this.printPlausibilityConstraint((PlausibilityConstraint)elt, language);
        } else if (elt instanceof UniquenessConstraint) {
            this.printUniquenessConstraint((UniquenessConstraint)elt, language);
        } else if (elt instanceof ExistenceConstraint) {
            this.printExistenceConstraint((ExistenceConstraint)elt, language);
        } else if (elt instanceof SetConstraint) {
            this.printSetConstraint((SetConstraint)elt, language);
        } else if (elt instanceof DomainConstraint) {
            this.printDomainConstraint((DomainConstraint)elt, language);
        }
    }

    public void printGraphicParameterDef(GraphicParameterDef gfxp) {
        this.printGraphicParameterDef(gfxp, null);
    }

    public void printGraphicParameterDef(GraphicParameterDef gfxp, String language) {
        this.printGraphicParameterDef(gfxp, false, language);
    }

    public void printGraphicParameterDef(GraphicParameterDef gfxp, boolean suppressDoc) {
        this.printGraphicParameterDef(gfxp, suppressDoc, null);
    }

    public void printGraphicParameterDef(GraphicParameterDef gfxp, boolean suppressDoc, String language) {
        if (!suppressDoc) {
            this.printDocumentation(gfxp, language);
            this.printMetaValues(gfxp, gfxp.getMetaValues(), language, gfxp.getScopedName());
        }
        this.printName(gfxp, language);
        String scopedNamePrefix = gfxp.getScopedName();
        this.ipw.print(" : ");
        this.printType(gfxp.getContainer(), gfxp.getDomain(), language, scopedNamePrefix);
        this.ipw.println(";");
    }

    public void printMetaDataUseDef(MetaDataUseDef mu) {
        this.printMetaDataUseDef(mu, null);
    }

    public void printMetaDataUseDef(MetaDataUseDef mu, String language) {
        this.printMetaDataUseDef(mu, false, language);
    }

    public void printMetaDataUseDef(MetaDataUseDef mu, boolean suppressDoc) {
        this.printMetaDataUseDef(mu, suppressDoc, null);
    }

    public void printMetaDataUseDef(MetaDataUseDef mu, boolean suppressDoc, String language) {
        if (!suppressDoc) {
            this.printDocumentation(mu, language);
            this.printMetaValues(mu, mu.getMetaValues(), language, mu.getScopedName());
        }
        if (mu.isSignData()) {
            this.ipw.print("SIGN BASKET ");
        } else {
            this.ipw.print("REFSYSTEM BASKET ");
        }
        this.printName(mu, language);
        this.printModifiers(false, mu.isFinal(), false, false, false, false, false);
        Topic topic = mu.getTopic();
        this.ipw.print("~");
        this.printRef(mu.getContainer(), topic, language);
        this.ipw.indent();
        this.ipw.indent();
        Table lastTable = null;
        String sep = "";
        Iterator moi = mu.iterator();
        while (moi.hasNext()) {
            Object moo = moi.next();
            if (!(moo instanceof MetaObject)) continue;
            MetaObject mo = (MetaObject)moo;
            Table table = mo.getTable();
            if (table != lastTable) {
                this.ipw.println();
                this.ipw.unindent();
                this.ipw.print("OBJECTS OF ");
                this.printName(table, language);
                this.ipw.println(":");
                this.ipw.indent();
                lastTable = table;
            } else {
                this.ipw.println(",");
            }
            if (language == null) {
                this.printDocumentation(mo.getDocumentation());
            } else {
                String docu = this.getElementDocumentation(mo, language);
                if (docu == null || docu == "") {
                    this.printDocumentation(mo.getDocumentation());
                } else {
                    this.printDocumentation(docu);
                }
            }
            this.printMetaValues(mo, mo.getMetaValues(), language, mo.getScopedName());
            this.printName(mo, language);
        }
        this.ipw.println(";");
        this.ipw.unindent();
        this.ipw.unindent();
    }

    public void printUnit(Container scope, Unit u) {
        this.printUnit(scope, u, null);
    }

    public void printUnit(Container scope, Unit u, String language) {
        this.printUnit(scope, u, false, language);
    }

    public void printUnit(Container scope, Unit u, boolean suppressDoc) {
        this.printUnit(scope, u, suppressDoc, null);
    }

    public void printUnit(Container scope, Unit u, boolean suppressDoc, String language) {
        if (u == null) {
            this.printError();
            return;
        }
        Unit extending = (Unit)u.getExtending();
        if (!suppressDoc) {
            this.printDocumentation(u, language);
            this.printMetaValues(u, u.getMetaValues(), language, u.getScopedName());
        }
        this.ipw.print(u.getDocName());
        if (!u.getDocName().equals(u.getName())) {
            this.ipw.print(" [");
            if (language == null) {
                this.ipw.print(u.getName());
            } else {
                String value = this.getNameInLanguage(u, language);
                if (value == null || value == "") {
                    this.ipw.print(u.getName());
                } else {
                    this.ipw.print(value);
                }
            }
            this.ipw.print(']');
        }
        this.printModifiers(u.isAbstract(), false, false, false, false, false, false);
        if (extending != null && extending != this.anyUnit && !(u instanceof DerivedUnit)) {
            this.ipw.print(" EXTENDS ");
            this.printRef(scope, extending, language);
        }
        if (u instanceof NumericallyDerivedUnit) {
            NumericallyDerivedUnit.Factor[] factors = ((NumericallyDerivedUnit)u).getConversionFactors();
            this.ipw.print(" =");
            if (factors.length >= 1) {
                for (int i = 0; i < factors.length; ++i) {
                    if (i > 0) {
                        this.ipw.print(' ');
                        this.ipw.print(factors[i].getConversionOperator());
                    }
                    this.ipw.print(' ');
                    this.printNumericConst(factors[i].getConversionFactor());
                }
            }
            this.ipw.print(" [");
            this.printRef(scope, ((NumericallyDerivedUnit)u).getExtending(), language);
            this.ipw.print(']');
        } else if (u instanceof FunctionallyDerivedUnit) {
            this.ipw.print(" = FUNCTION ");
            this.printExplanation(((FunctionallyDerivedUnit)u).getExplanation());
            this.ipw.print(" [");
            this.printRef(scope, ((FunctionallyDerivedUnit)u).getExtending(), language);
            this.ipw.print(']');
        } else if (u instanceof ComposedUnit) {
            ComposedUnit.Composed[] composed = ((ComposedUnit)u).getComposedUnits();
            this.ipw.print(" = (");
            for (int i = 0; i < composed.length; ++i) {
                if (i > 0) {
                    this.ipw.print(' ');
                    this.ipw.print(composed[i].getCompositionOperator());
                    this.ipw.print(' ');
                }
                this.printRef(scope, composed[i].getUnit(), language);
            }
            this.ipw.print(')');
        } else if (u instanceof StructuredUnit) {
            StructuredUnit.Part[] parts = ((StructuredUnit)u).getParts();
            this.ipw.print(" = {");
            this.printRef(scope, ((StructuredUnit)u).getFirstUnit(), language);
            for (int i = 0; i < parts.length; ++i) {
                this.ipw.print(':');
                this.printRef(scope, parts[i].getUnit(), language);
                this.ipw.print('[');
                this.ipw.print((Object)parts[i].getMinimum());
                this.ipw.print("..");
                this.ipw.print((Object)parts[i].getMaximum());
                this.ipw.print(']');
            }
            this.ipw.print('}');
            if (((StructuredUnit)u).isContinuous()) {
                this.ipw.print(" CONTINUOUS");
            }
        }
        if (u instanceof StructuredUnit) {
            EhiLogger.logError((String)("UNIT " + u.getName() + ": StructuredUnit not supported by INTERLIS 2.3"));
            this.ipw.println("; !! Hint: comment out/remove");
        } else {
            this.ipw.println(';');
        }
    }

    public void printContextSyntax(Container<?> scope, ContextDef contextDef) {
        this.printContextSyntax(scope, contextDef, null);
    }

    public void printContextSyntax(Container<?> scope, ContextDef contextDef, String language) {
        this.printRef(scope, contextDef.getGeneric(), language);
        this.ipw.print(" = ");
        boolean first = true;
        for (Domain domain : contextDef.getConcretes()) {
            if (first) {
                first = false;
            } else {
                this.ipw.print(" OR ");
            }
            this.printRef(scope, domain, language);
        }
        this.ipw.println(";");
    }

    public void printContext(Container<?> scope, ContextDef contextDef) {
        this.printContext(scope, contextDef, false, null);
    }

    public void printContext(Container<?> scope, ContextDef contextDef, boolean suppressDoc, String language) {
        if (contextDef == null) {
            this.printError();
            return;
        }
        if (!suppressDoc) {
            this.printDocumentation(contextDef, language);
            this.printMetaValues(contextDef, contextDef.getMetaValues(), language, contextDef.getScopedName());
        }
        this.ipw.print(contextDef.getName());
        this.ipw.println(" =");
        this.ipw.indent();
        this.printContextSyntax(scope, contextDef, language);
        this.ipw.unindent();
    }

    private void printName(Element elt, String language) {
        this.ipw.print(this.getElementName(elt, language));
    }

    protected String getElementName(Element elt, String language) {
        if (language == null) {
            if (this.params != null && this.params.getNewModelName() != null && elt instanceof Model) {
                return this.params.getNewModelName();
            }
            return elt.getName();
        }
        String name = this.getNameInLanguage(elt, language);
        if (name == null || name == "") {
            return elt.getName();
        }
        return name;
    }

    protected void printRef(Container scope, Element elt, String language) {
        if (elt == null) {
            this.printError();
        } else if (elt == this.modelInterlis.ANYCLASS) {
            this.ipw.print("ANYCLASS");
        } else if (elt == this.modelInterlis.ANYSTRUCTURE) {
            this.ipw.print("ANYSTRUCTURE");
        } else if (elt == this.modelInterlis.XmlDate && this.doIli24) {
            this.ipw.print("DATE");
        } else if (elt == this.modelInterlis.XmlDateTime && this.doIli24) {
            this.ipw.print("DATETIME");
        } else if (elt == this.modelInterlis.XmlTime && this.doIli24) {
            this.ipw.print("TIMEOFDAY");
        } else if (language == null) {
            if (this.params != null && this.params.getImportModels() != null) {
                TransformationParameter.ModelTransformation[] importModels;
                for (TransformationParameter.ModelTransformation importModel : importModels = this.params.getImportModels()) {
                    if (elt.getScopedName(scope).contains(importModel.getFromModel())) {
                        String[] scopeName;
                        String newScopeName = "";
                        for (String scopeN : scopeName = elt.getScopedName(scope).split("\\.")) {
                            newScopeName = scopeN.equals(importModel.getFromModel()) ? importModel.getToModel() : newScopeName + "." + scopeN;
                        }
                        this.ipw.print(newScopeName);
                        continue;
                    }
                    this.ipw.print(elt.getScopedName(null));
                }
            } else {
                this.ipw.print(elt.getScopedName(null));
            }
        } else {
            String text = this.getNameInLanguage(elt, language);
            if (text == "" || text == null) {
                this.ipw.print(elt.getScopedName(null));
            } else {
                this.ipw.print(text);
            }
        }
    }

    public void printParameter(Container scope, Parameter par) {
        this.printParameter(scope, par, null);
    }

    public void printParameter(Container scope, Parameter par, String language) {
        this.printParameter(scope, par, false, language);
    }

    public void printParameter(Container scope, Parameter par, boolean suppressDoc) {
        this.printParameter(scope, par, suppressDoc, null);
    }

    public void printParameter(Container scope, Parameter par, boolean suppressDoc, String language) {
        String scopedNamePrefix = "";
        if (par == null) {
            this.printError();
            return;
        }
        if (!suppressDoc) {
            this.printDocumentation(par, language);
            this.printMetaValues(par, par.getMetaValues(), language, par.getScopedName());
        }
        if (language == null) {
            this.ipw.print(par.getName());
        } else {
            String name = this.getNameInLanguage(par, language);
            if (name == "" || name == null) {
                this.ipw.print(par.getName());
            } else {
                this.ipw.print(name);
            }
        }
        Parameter ext = par.getExtending();
        if (ext != null) {
            if (par.getName().equals(ext.getName())) {
                this.ipw.print(" (EXTENDED)");
            } else {
                this.ipw.print(" EXTENDS ");
                this.printRef(scope, ext, language);
            }
        }
        this.ipw.print(": ");
        Type typ = par.getType();
        if (typ instanceof ReferenceType) {
            this.ipw.print("-> ");
            this.printRef(scope, ((ReferenceType)typ).getReferred(), language);
        } else {
            scopedNamePrefix = typ.getScopedName();
        }
        this.printType(scope, typ, language, scopedNamePrefix);
        this.ipw.println(';');
    }

    private void printNumericConst(PrecisionDecimal num) {
        if (num == PrecisionDecimal.PI) {
            this.ipw.print("PI");
            return;
        }
        if (num == PrecisionDecimal.LNBASE) {
            this.ipw.print("LNBASE");
            return;
        }
        this.ipw.print(num.toString());
    }

    protected void printRoleDef(Container scope, RoleDef role, String language) {
        this.printDocumentation(role, language);
        this.printMetaValues(role, role.getMetaValues(), language, role.getScopedName());
        this.printName(role, language);
        this.printModifiers(role.isAbstract(), role.isFinal(), role.isExtended(), role.isOrdered(), role.isExternal(), false, false);
        String kind = "";
        switch (role.getKind()) {
            case 1: {
                kind = " -- ";
                break;
            }
            case 2: {
                kind = " -<> ";
                break;
            }
            case 3: {
                kind = " -<#> ";
            }
        }
        this.ipw.print(kind);
        if (role.getDefinedCardinality() != null) {
            this.ipw.print(role.getDefinedCardinality() + " ");
        }
        this.printRef(scope, role.getDestination(), language);
        Iterator<AbstractClassDef> resti = role.getReference().iteratorRestrictedTo();
        String sep = " RESTRICTION (";
        boolean hasRestriction = false;
        while (resti.hasNext()) {
            AbstractClassDef rest = resti.next();
            this.ipw.print(sep);
            sep = ";";
            this.printRef(scope, rest, language);
            hasRestriction = true;
        }
        if (hasRestriction) {
            this.ipw.print(")");
        }
        this.ipw.println(';');
    }

    protected void printAttribute(Container scope, AttributeDef attrib, String language) {
        LocalAttribute la;
        LocalAttribute la2;
        if (attrib == null) {
            this.printError();
            return;
        }
        if (attrib instanceof LocalAttribute && (la2 = (LocalAttribute)attrib).isGeneratedByAllOf()) {
            return;
        }
        Type proxyType = attrib.getDomain();
        if (proxyType != null && proxyType instanceof ObjectType) {
            if (((ObjectType)proxyType).isAllOf()) {
                this.ipw.print("ALL OF ");
                this.printName(attrib, language);
                this.ipw.println(";");
            }
            return;
        }
        this.printDocumentation(attrib, language);
        this.printMetaValues(attrib, attrib.getMetaValues(), language, attrib.getScopedName());
        if (attrib instanceof LocalAttribute && (la = (LocalAttribute)attrib).isSubdivision()) {
            if (la.isContinuous()) {
                this.ipw.print("CONTINUOUS ");
            }
            this.ipw.print("SUBDIVISION ");
        }
        this.printName(attrib, language);
        this.printModifiers(attrib.isAbstract(), attrib.isFinal(), attrib.getExtending() != null, false, false, attrib.isTransient(), false);
        if (attrib instanceof LocalAttribute) {
            if (attrib.getDomain() != null || !(scope instanceof View)) {
                this.ipw.print(" : ");
                String scopedNamePrefix = attrib.getScopedName();
                this.printType(scope, attrib.getDomain(), language, scopedNamePrefix);
            }
            this.printAttributeBasePath(scope, attrib, language);
        }
        if (attrib instanceof LocalAttribute && attrib.getDomain() instanceof StructuredUnitType) {
            EhiLogger.logError((String)("ATTRIBUTE " + attrib.getScopedName(null) + ": StructuredUnitType not supported by INTERLIS 2.3; replace by TextType or FormattedType/XMLDate"));
            this.ipw.println("; !! Hint: replace by TextType or FormattedType/XMLDate");
        } else {
            this.ipw.println(';');
        }
    }

    public void printAttributeBasePath(Container scope, AttributeDef attrib) {
        this.printAttributeBasePath(scope, attrib, null);
    }

    public void printAttributeBasePath(Container scope, AttributeDef attrib, String language) {
        Evaluable[] paths = ((LocalAttribute)attrib).getBasePaths();
        if (paths != null && paths.length != 0) {
            this.ipw.print(" := ");
            for (int i = 0; i < paths.length; ++i) {
                if (i > 0) {
                    this.ipw.print(", ");
                }
                this.printExpression(scope, paths[i], language);
            }
        }
    }

    protected void printSignAttribute(Graphic scope, SignAttribute attrib, String language) {
        SignAttribute extending = (SignAttribute)attrib.getExtending();
        this.printDocumentation(attrib, language);
        this.printName(attrib, language);
        this.printModifiers(false, false, extending != null, false, false, false, false);
        if (extending == null || attrib.getGenerating() != extending.getGenerating()) {
            this.ipw.print(" OF ");
            this.printRef(scope, attrib.getGenerating(), language);
        }
        this.ipw.println(":");
        this.ipw.indent();
        SignInstruction[] instructions = attrib.getInstructions();
        for (int i = 0; i < instructions.length; ++i) {
            if (i > 0) {
                this.ipw.println(',');
            }
            this.printSignInstruction(scope.getBasedOn(), instructions[i], language);
        }
        this.ipw.unindent();
        this.ipw.println(';');
    }

    protected void printSignInstruction(Viewable basedOn, SignInstruction instr, String language) {
        if (instr == null) {
            this.printError();
            return;
        }
        Evaluable restrictor = instr.getRestrictor();
        if (restrictor != null) {
            this.ipw.print("WHERE ");
            this.printExpression(basedOn, restrictor, language);
            this.ipw.println();
        }
        this.ipw.println('(');
        this.ipw.indent();
        ParameterAssignment[] assignments = instr.getAssignments();
        for (int i = 0; i < assignments.length; ++i) {
            if (i > 0) {
                this.ipw.println(';');
            }
            this.printParameterAssignment(basedOn, assignments[i], language);
        }
        this.ipw.unindent();
        this.ipw.println();
        this.ipw.print(')');
    }

    protected void printParameterAssignment(Viewable basedOn, ParameterAssignment parass, String language) {
        if (parass == null) {
            this.printError();
            return;
        }
        Parameter assigned = parass.getAssigned();
        if (assigned == null) {
            this.printError();
        } else {
            this.printName(assigned, language);
        }
        this.ipw.print(" := ");
        this.printExpression(basedOn, parass.getValue(), language);
    }

    public void printMetaValues(Settings values) {
        this.printMetaValues(null, values, null, null);
    }

    public void printMetaValues(Settings values, String language, String scopedNamePrefix) {
        this.printMetaValues(null, values, language, scopedNamePrefix);
    }

    protected void printMetaValues(Object ili2cElement, Settings values, String language, String scopedNamePrefix) {
        if (values != null) {
            for (String name : values.getValues()) {
                String metaValue;
                String value = "";
                value = this.params != null && name.equals("CRS") ? String.valueOf(this.params.getEpsgCode()) : values.getValue(name);
                this.ipw.print("!!@ ");
                this.ipw.print(name);
                this.ipw.print("=");
                String scopedName = scopedNamePrefix + ".METAOBJECT." + name;
                if (value.indexOf(32) != -1 || value.indexOf(61) != -1 || value.indexOf(59) != -1 || value.indexOf(44) != -1 || value.indexOf(34) != -1 || value.indexOf(92) != -1) {
                    if (language == null) {
                        this.ipw.println("\"" + value + "\"");
                        continue;
                    }
                    metaValue = this.getElementNameInLanguage(scopedName, language);
                    if (metaValue == null || metaValue == "") {
                        this.ipw.println("\"" + value + "\"");
                        continue;
                    }
                    this.ipw.println("\"" + metaValue + "\"");
                    continue;
                }
                if (language == null) {
                    this.ipw.println(value);
                    continue;
                }
                metaValue = this.getElementNameInLanguage(scopedName, language);
                if (metaValue == "" || metaValue == null) {
                    this.ipw.println(value);
                    continue;
                }
                this.ipw.println(metaValue);
            }
        }
    }

    public void printDocumentation(Element def, String language) {
        if (language == null) {
            this.printDocumentation(def.getDocumentation());
        } else {
            String documentation = this.getElementDocumentation(def, language);
            if (documentation == "" || documentation == null) {
                this.printDocumentation(def.getDocumentation());
            } else {
                this.printDocumentation(documentation);
            }
        }
    }

    public void printDocumentation(String doc) {
        String line;
        if (doc == null) {
            return;
        }
        if (doc.length() == 0) {
            return;
        }
        String beg = "/** ";
        int last = 0;
        int next = doc.indexOf("\n", last);
        while (next > -1) {
            line = doc.substring(last, next);
            this.ipw.println(beg + line);
            beg = " * ";
            last = next + 1;
            next = doc.indexOf("\n", last);
        }
        line = doc.substring(last);
        this.ipw.println(beg + line);
        this.ipw.println(" */");
    }

    protected void printModel(Model mdef, String language) {
        this.printDocumentation(mdef, language);
        this.printMetaValues(mdef, mdef.getMetaValues(), language, mdef.getScopedName());
        if (mdef.isContracted()) {
            this.ipw.print("CONTRACTED ");
        }
        if (mdef instanceof RefSystemModel) {
            this.ipw.print("REFSYSTEM ");
        } else if (mdef instanceof SymbologyModel) {
            this.ipw.print("SYMBOLOGY ");
        } else if (mdef instanceof TypeModel) {
            this.ipw.print("TYPE ");
        }
        this.ipw.print("MODEL ");
        this.printName(mdef, language);
        if (language == null) {
            if (mdef.getLanguage() != null) {
                this.ipw.print(" (" + mdef.getLanguage() + ")");
            }
        } else {
            this.ipw.print(" (" + language + ")");
        }
        this.ipw.println();
        this.ipw.indent();
        String issuer = this.getModelIssuer(mdef);
        this.ipw.println("AT \"" + InterlisString.escapeSpecialChars(issuer) + "\"");
        String version = this.getModelVersion(mdef);
        this.ipw.print("VERSION \"" + InterlisString.escapeSpecialChars(version) + "\"");
        String expl = this.getModelVersionExpl(mdef);
        if (expl != null && expl.length() > 0) {
            this.ipw.print(' ');
            this.printExplanation(expl);
        }
        this.ipw.println("");
        if (this.translationConfig != null) {
            String translationText = "TRANSLATION OF " + mdef.getName() + " [\"" + InterlisString.escapeSpecialChars(mdef.getModelVersion()) + "\"]";
            this.ipw.println(translationText);
        }
        this.ipw.println("=");
        Model[] imported = mdef.getImporting();
        String sep = "";
        boolean modelsImported = false;
        for (int i = 0; i < imported.length; ++i) {
            Model curImport = imported[i];
            if (curImport instanceof Model) {
                if (curImport == this.modelInterlis) continue;
                if (!modelsImported) {
                    this.ipw.print("IMPORTS ");
                    modelsImported = true;
                }
                if (this.params != null) {
                    TransformationParameter.ModelTransformation[] importModels;
                    for (TransformationParameter.ModelTransformation importModel : importModels = this.params.getImportModels()) {
                        if (importModel.getFromModel().equals(curImport.getName())) {
                            this.ipw.print(sep + importModel.getToModel());
                            continue;
                        }
                        this.ipw.print(sep + curImport.getName());
                    }
                } else {
                    this.ipw.print(sep + curImport.getName());
                }
                sep = ", ";
                continue;
            }
            this.printError();
        }
        if (modelsImported) {
            this.ipw.println(';');
        }
        this.printElements(mdef, language);
        this.ipw.unindent();
        this.ipw.println();
        this.ipw.print("END ");
        this.printName(mdef, language);
        this.ipw.println('.');
    }

    protected String getModelVersionExpl(Model mdef) {
        String expl = mdef.getModelVersionExpl();
        return expl;
    }

    protected String getModelIssuer(Model mdef) {
        String issuer = mdef.getIssuer();
        if (issuer == null) {
            issuer = "mailto:" + System.getProperty("user.name") + "@localhost";
        }
        return issuer;
    }

    protected String getModelVersion(Model mdef) {
        String version = mdef.getModelVersion();
        if (version == null) {
            Calendar current = Calendar.getInstance();
            DecimalFormat digit4 = new DecimalFormat("0000");
            DecimalFormat digit2 = new DecimalFormat("00");
            version = digit4.format(current.get(1)) + "-" + digit2.format(current.get(2) + 1) + "-" + digit2.format(current.get(5));
        }
        return version;
    }

    private String getElementDocumentation(Element ele, String language) {
        String modelName = "";
        for (TranslationElement element : this.translationConfig) {
            if (!Ili2TranslationXml.getElementInRootLanguage(ele).getScopedName().equals(element.getScopedName())) continue;
            if (language.equals(FR)) {
                modelName = element.getDocumentation_fr();
                return modelName;
            }
            if (language.equals(EN)) {
                modelName = element.getDocumentation_en();
                return modelName;
            }
            if (language.equals(IT)) {
                modelName = element.getDocumentation_it();
                return modelName;
            }
            if (!language.equals(DE)) continue;
            modelName = element.getDocumentation_de();
            return modelName;
        }
        return "";
    }

    private String getNameInLanguage(Element ele, String language) {
        String scopedName = Ili2TranslationXml.getElementInRootLanguage(ele).getScopedName();
        return this.getNameInLanguage(scopedName, language);
    }

    private String getNameInLanguage(String scopedName, String language) {
        for (TranslationElement element : this.translationConfig) {
            if (!scopedName.equals(element.getScopedName())) continue;
            if (language.equals(FR)) {
                String modelName = element.getName_fr();
                return modelName;
            }
            if (language.equals(EN)) {
                String modelName = element.getName_en();
                return modelName;
            }
            if (language.equals(IT)) {
                String modelName = element.getName_it();
                return modelName;
            }
            if (!language.equals(DE)) continue;
            String modelName = element.getName_de();
            return modelName;
        }
        return "";
    }

    protected void printExplanation(String explanationText) {
        this.ipw.print("//");
        this.ipw.print(explanationText);
        this.ipw.print("//");
    }

    protected void printDomainDef(Container scope, Domain dd, String language) {
        Domain extending = dd.getExtending();
        String scopedNamePrefix = dd.getScopedName();
        this.printDocumentation(dd, language);
        this.printMetaValues(dd, dd.getMetaValues(), language, dd.getScopedName());
        this.printName(dd, language);
        if (dd.getType() instanceof TypeAlias && ((TypeAlias)dd.getType()).getAliasing() == this.td.INTERLIS.INTERLIS_1_DATE) {
            Domain dd2 = ((TypeAlias)dd.getType()).getAliasing();
            this.printModifiers(dd2.isAbstract(), dd2.isFinal(), false, false, false, false, false);
            this.ipw.print(" = ");
            this.printType(scope, dd2.getType(), language, scopedNamePrefix);
            this.ipw.println(';');
        } else {
            boolean generic = false;
            if (dd.getType() instanceof AbstractCoordType) {
                AbstractCoordType coordType = (AbstractCoordType)dd.getType();
                generic = coordType.isGeneric();
            }
            this.printModifiers(dd.isAbstract(), dd.isFinal(), false, false, false, false, generic);
            if (extending != null) {
                this.ipw.print(" EXTENDS ");
                this.printRef(scope, extending, language);
            }
            this.ipw.print(" = ");
            this.printType(scope, dd.getType(), language, scopedNamePrefix);
            Iterator<DomainConstraint> iterator = dd.iteratorConstraints();
            if (iterator.hasNext()) {
                this.ipw.print(" CONSTRAINTS ");
                boolean first = true;
                while (iterator.hasNext()) {
                    DomainConstraint constraint = iterator.next();
                    if (first) {
                        first = false;
                    } else {
                        this.ipw.print(", ");
                    }
                    this.printConstraint((Constraint)constraint, language);
                }
            }
            if (dd.getType() instanceof StructuredUnitType) {
                EhiLogger.logError((String)("DOMAIN " + dd.getName() + ": StructuredUnitType not supported by INTERLIS 2.3; replace by TextType or FormattedType/XMLDate"));
                this.ipw.println("; !! Hint: replace by TextType or FormattedType/XMLDate");
            } else {
                this.ipw.println(';');
            }
        }
    }

    public void printReferenceSysRef(Container scope, RefSystemRef rsr) {
        this.printReferenceSysRef(scope, rsr, null);
    }

    public void printReferenceSysRef(Container scope, RefSystemRef rsr, String language) {
        if (rsr == null) {
            this.printError();
            return;
        }
        if (rsr instanceof RefSystemRef.CoordSystem) {
            RefSystemRef.CoordSystem cs = (RefSystemRef.CoordSystem)rsr;
            this.ipw.print('{');
            this.printRef(scope, cs.getSystem(), language);
            this.ipw.print('}');
        } else if (rsr instanceof RefSystemRef.CoordSystemAxis) {
            RefSystemRef.CoordSystemAxis csa = (RefSystemRef.CoordSystemAxis)rsr;
            this.ipw.print('{');
            this.printRef(scope, csa.getSystem(), language);
            this.ipw.print('[');
            this.ipw.print(csa.getAxisNumber());
            this.ipw.print(']');
            this.ipw.print('}');
        } else if (rsr instanceof RefSystemRef.CoordDomain) {
            RefSystemRef.CoordDomain cda = (RefSystemRef.CoordDomain)rsr;
            this.ipw.print('<');
            this.printRef(scope, cda.getReferredDomain(), language);
            this.ipw.print('>');
        } else if (rsr instanceof RefSystemRef.CoordDomainAxis) {
            RefSystemRef.CoordDomainAxis cda = (RefSystemRef.CoordDomainAxis)rsr;
            this.ipw.print('<');
            this.printRef(scope, cda.getReferredDomain(), language);
            this.ipw.print('[');
            this.ipw.print(cda.getAxisNumber());
            this.ipw.print(']');
            this.ipw.print('>');
        } else {
            this.printError();
        }
    }

    public void printType(Container scope, Type dd) {
        this.printType(scope, dd, null, null, true);
    }

    public void printType(Container scope, Type dd, boolean withCardinality) {
        this.printType(scope, dd, null, null, withCardinality);
    }

    public void printType(Container scope, Type dd, String language, String scopedNamePrefix) {
        this.printType(scope, dd, language, scopedNamePrefix, true);
    }

    public void printType(Container scope, Type dd, String language, String scopedNamePrefix, boolean withCardinality) {
        Type ot;
        Type ct;
        Type bt;
        AbstractEnumerationType et;
        if (dd == null) {
            this.printError();
            return;
        }
        if (withCardinality) {
            Cardinality card = dd.getCardinality();
            if (card.getMaximum() == 1L) {
                if (card.getMinimum() == 1L) {
                    this.ipw.print("MANDATORY ");
                }
            } else {
                this.ipw.print(dd.isOrdered() ? "LIST " : "BAG ");
                this.ipw.print((Object)card);
                this.ipw.print(' ');
                this.ipw.print("OF ");
            }
        }
        if (dd instanceof NumericalType) {
            this.printNumericalType(scope, (NumericalType)dd, language, 0);
        } else if (dd instanceof TextType) {
            int len = ((TextType)dd).getMaxLength();
            if (((TextType)dd).isNormalized()) {
                this.ipw.print("TEXT");
            } else {
                this.ipw.print("MTEXT");
            }
            if (len != -1) {
                this.ipw.print('*');
                this.ipw.print(len);
            }
        } else if (dd instanceof FormattedType) {
            FormattedType ft = (FormattedType)dd;
            if (ft.getDefinedBaseStruct() != null) {
                this.ipw.print("FORMAT BASED ON ");
                this.printRef(scope, ft.getDefinedBaseStruct(), language);
                Iterator<FormattedTypeBaseAttrRef> baseAttri = ft.iteratorDefinedBaseAttrRef();
                if (baseAttri.hasNext()) {
                    this.ipw.print(" (");
                    String sep = "";
                    if (ft.getExtending() != null) {
                        this.ipw.print("INHERITANCE");
                        sep = " ";
                    }
                    if (ft.getDefinedPrefix() != null) {
                        this.ipw.print("\"" + InterlisString.escapeSpecialChars(ft.getDefinedPrefix()) + "\"");
                        sep = " ";
                    }
                    while (baseAttri.hasNext()) {
                        String name;
                        this.ipw.print(sep);
                        FormattedTypeBaseAttrRef baseAttr = baseAttri.next();
                        if (baseAttr.getFormatted() != null) {
                            if (language == null) {
                                this.ipw.print(baseAttr.getAttr().getName());
                            } else {
                                name = this.getNameInLanguage(baseAttr.getAttr(), language);
                                if (name == null || name == "") {
                                    this.ipw.print(baseAttr.getAttr().getName());
                                } else {
                                    this.ipw.print(name);
                                }
                            }
                            this.ipw.print("/");
                            this.printRef(scope, baseAttr.getFormatted(), language);
                        } else {
                            if (language == null) {
                                this.ipw.print(baseAttr.getAttr().getName());
                            } else {
                                name = this.getNameInLanguage(baseAttr.getAttr(), language);
                                if (name == null || name == "") {
                                    this.ipw.print(baseAttr.getAttr().getName());
                                } else {
                                    this.ipw.print(name);
                                }
                            }
                            if (baseAttr.getIntPos() != 0) {
                                this.ipw.print("/");
                                this.ipw.print(baseAttr.getIntPos());
                            }
                        }
                        if (baseAttr.getPostfix() != null) {
                            this.ipw.print(" \"" + InterlisString.escapeSpecialChars(baseAttr.getPostfix()) + "\"");
                        }
                        sep = " ";
                    }
                    this.ipw.print(")");
                }
                if (ft.getDefinedMinimum() != null) {
                    this.ipw.print(" ");
                    this.printFormatedTypeMinMax(ft);
                }
            } else if (ft.getDefinedBaseDomain() != null) {
                this.ipw.print("FORMAT ");
                this.printRef(scope, ft.getDefinedBaseDomain(), language);
                this.ipw.print(" ");
                this.printFormatedTypeMinMax(ft);
            } else {
                this.printFormatedTypeMinMax(ft);
            }
        } else if (dd instanceof EnumerationType) {
            et = (EnumerationType)dd;
            this.printEnumeration(((EnumerationType)et).getEnumeration(), language, scopedNamePrefix);
            if (((EnumerationType)et).isCircular()) {
                this.ipw.print(" CIRCULAR");
            } else if (((EnumerationType)et).isOrdered()) {
                this.ipw.print(" ORDERED");
            }
        } else if (dd instanceof EnumTreeValueType) {
            et = (EnumTreeValueType)dd;
            this.ipw.print("ALL OF ");
            this.printRef(scope, ((EnumTreeValueType)et).getEnumType(), language);
        } else if (dd instanceof EnumValType) {
            if (((EnumValType)dd).isOnlyLeafs()) {
                this.ipw.print("ENUMVAL");
            } else {
                this.ipw.print("ENUMTREEVAL");
            }
        } else if (dd instanceof TypeAlias) {
            Domain def = ((TypeAlias)dd).getAliasing();
            if (def == this.modelInterlis.BOOLEAN) {
                this.ipw.print("BOOLEAN");
            } else if (def == this.modelInterlis.VALIGNMENT) {
                this.ipw.print("VALIGNMENT");
            } else if (def == this.modelInterlis.HALIGNMENT) {
                this.ipw.print("HALIGNMENT");
            } else {
                this.printRef(scope, ((TypeAlias)dd).getAliasing(), language);
            }
        } else if (dd instanceof CompositionType) {
            CompositionType comp = (CompositionType)dd;
            this.printRef(scope, comp.getComponentType(), language);
        } else if (dd instanceof ReferenceType) {
            ReferenceType ref = (ReferenceType)dd;
            this.ipw.print("REFERENCE TO ");
            if (ref.isExternal()) {
                this.ipw.print("(EXTERNAL) ");
            }
            this.printRef(scope, ref.getReferred(), language);
            Iterator<AbstractClassDef> resti = ref.iteratorRestrictedTo();
            String sep = " RESTRICTION (";
            boolean hasRestriction = false;
            while (resti.hasNext()) {
                AbstractClassDef rest = resti.next();
                this.ipw.print(sep);
                sep = ";";
                this.printRef(scope, rest, language);
                hasRestriction = true;
            }
            if (hasRestriction) {
                this.ipw.print(")");
            }
        } else if (dd instanceof AbstractCoordType) {
            NumericalType[] nts = ((AbstractCoordType)dd).getDimensions();
            int nullAxis = ((AbstractCoordType)dd).getNullAxis();
            int piHalfAxis = ((AbstractCoordType)dd).getPiHalfAxis();
            if (dd instanceof MultiCoordType) {
                this.ipw.print("MULTICOORD ");
            } else {
                this.ipw.print("COORD ");
            }
            this.ipw.indent();
            for (int i = 0; i < nts.length; ++i) {
                if (i > 0) {
                    this.ipw.print(", ");
                }
                this.printNumericalType(scope, nts[i], language, i);
            }
            if (nullAxis != 0) {
                this.ipw.println(',');
                this.ipw.print("ROTATION ");
                this.ipw.print(nullAxis);
                this.ipw.print(" -> ");
                if (piHalfAxis > 0) {
                    this.ipw.print(piHalfAxis);
                } else {
                    this.printError();
                }
            }
            this.ipw.unindent();
        } else if (dd instanceof LineType) {
            LineType lt = (LineType)dd;
            if (lt instanceof PolylineType) {
                this.ipw.print(((PolylineType)lt).isDirected() ? "DIRECTED POLYLINE" : "POLYLINE");
            } else if (lt instanceof MultiPolylineType) {
                this.ipw.print(((MultiPolylineType)lt).isDirected() ? "DIRECTED MULTIPOLYLINE" : "MULTIPOLYLINE");
            } else if (lt instanceof SurfaceType) {
                this.ipw.print("SURFACE");
            } else if (lt instanceof MultiSurfaceType) {
                this.ipw.print("MULTISURFACE");
            } else if (lt instanceof AreaType) {
                this.ipw.print("AREA");
            } else if (lt instanceof MultiAreaType) {
                this.ipw.print("MULTIAREA");
            } else {
                this.printError();
            }
            LineForm[] lineForms = lt.getDefinedLineForms();
            PrecisionDecimal maxOverlap = lt.getDefinedMaxOverlap();
            Domain controlPointDomain = lt.getDefinedControlPointDomain();
            Table lineAttributeStructure = null;
            if (lt instanceof SurfaceOrAreaType) {
                lineAttributeStructure = ((SurfaceOrAreaType)lt).getLineAttributeStructure();
            } else if (lt instanceof MultiSurfaceOrAreaType) {
                lineAttributeStructure = ((MultiSurfaceOrAreaType)lt).getLineAttributeStructure();
            }
            this.ipw.indent();
            boolean needNewLine = false;
            if (lineForms.length > 0) {
                if (needNewLine) {
                    this.ipw.println();
                }
                this.ipw.print(" WITH (");
                for (int i = 0; i < lineForms.length; ++i) {
                    if (i > 0) {
                        this.ipw.print(", ");
                    }
                    if (language == null) {
                        this.ipw.print(lineForms[i].getName());
                        continue;
                    }
                    String name = this.getNameInLanguage(lineForms[i], language);
                    if (name == "" || name == null) {
                        this.ipw.print(lineForms[i].getName());
                        continue;
                    }
                    this.ipw.print(name);
                }
                this.ipw.print(')');
                needNewLine = true;
            }
            if (controlPointDomain != null) {
                this.ipw.print(" VERTEX ");
                this.printRef(scope, controlPointDomain, language);
                needNewLine = true;
            }
            if (maxOverlap != null) {
                if (needNewLine) {
                    this.ipw.println();
                }
                this.ipw.print(" WITHOUT OVERLAPS > ");
                this.ipw.print(maxOverlap.toString());
            }
            if (lineAttributeStructure != null) {
                this.ipw.println();
                this.ipw.print("LINE ATTRIBUTES ");
                this.printRef(scope, lineAttributeStructure, language);
            }
            this.ipw.unindent();
        } else if (dd instanceof OIDType) {
            Type type = ((OIDType)dd).getOIDType();
            if (type == null) {
                this.ipw.print("OID ANY");
            } else {
                this.ipw.print("OID ");
                scopedNamePrefix = dd.getScopedName();
                this.printType(scope, type, language, scopedNamePrefix);
            }
        } else if (dd instanceof BlackboxType) {
            bt = (BlackboxType)dd;
            this.ipw.print("BLACKBOX");
            int kind = ((BlackboxType)bt).getKind();
            if (kind == 1) {
                this.ipw.print(" XML");
            } else if (kind == 2) {
                this.ipw.print(" BINARY");
            }
        } else if (dd instanceof BasketType) {
            bt = (BasketType)dd;
            this.ipw.print("BASKET");
            int kind = ((BasketType)bt).getKind();
            if (kind == 16) {
                this.ipw.print(" (DATA)");
            } else if (kind == 32) {
                this.ipw.print(" (VIEW)");
            } else if (kind == 64) {
                this.ipw.print(" (BASE)");
            } else if (kind == 128) {
                this.ipw.print(" (GRAPHIC)");
            }
            Topic spec = ((BasketType)bt).getTopic();
            if (spec != null) {
                this.ipw.print(" OF ");
                this.printRef(scope, spec, language);
            }
        } else if (dd instanceof ClassType) {
            ct = (ClassType)dd;
            if (((ClassType)ct).isStructure()) {
                this.ipw.print("STRUCTURE");
            } else {
                this.ipw.print("CLASS");
            }
            String next = " RESTRICTED TO ";
            Iterator<Viewable<?>> resti = ((ClassType)ct).iteratorRestrictedTo();
            while (resti.hasNext()) {
                Table rest = (Table)resti.next();
                this.ipw.print(next);
                this.printRef(scope, rest, language);
                next = " ,";
            }
        } else if (dd instanceof AttributePathType) {
            ct = (AttributePathType)dd;
            this.ipw.print("ATTRIBUTE");
            FormalArgument argRestr = ((AttributePathType)ct).getArgRestriction();
            ObjectPath attrRestr = ((AttributePathType)ct).getAttrRestriction();
            if (argRestr != null) {
                this.ipw.print(" OF @ ");
                if (language == null) {
                    this.ipw.print(argRestr.getName());
                } else {
                    String name = this.getNameInLanguage(argRestr, language);
                    if (name == null || name == "") {
                        this.ipw.print(argRestr.getName());
                    } else {
                        this.ipw.print(name);
                    }
                }
            } else if (attrRestr != null) {
                this.ipw.print(" OF ");
                this.printAttributePath(scope, attrRestr, language);
            }
            Type[] typeRestr = ((AttributePathType)ct).getTypeRestriction();
            if (typeRestr != null) {
                this.ipw.print(" RESTRICTION ( ");
                String sep = "";
                for (int typei = 0; typei < typeRestr.length; ++typei) {
                    this.ipw.print(sep);
                    this.printType(scope, typeRestr[typei], language, scopedNamePrefix);
                    sep = ";";
                }
                this.ipw.print(" )");
            }
        } else if (dd instanceof ObjectType) {
            ot = (ObjectType)dd;
            if (((ObjectType)ot).isObjects()) {
                this.ipw.print("OBJECTS OF ");
            } else {
                this.ipw.print("OBJECT OF ");
            }
            Viewable ref = ((ObjectType)ot).getRef();
            this.printRef(scope, ref, language);
        } else if (dd instanceof MetaobjectType) {
            ot = (MetaobjectType)dd;
            this.ipw.print("METAOBJECT");
            Table ref = ((MetaobjectType)ot).getReferred();
            if (ref != scope) {
                this.ipw.print(" OF ");
                this.printRef(scope, ref, language);
            }
        }
    }

    private void printFormatedTypeMinMax(FormattedType ft) {
        this.ipw.print("\"");
        this.ipw.print(InterlisString.escapeSpecialChars(ft.getDefinedMinimum()));
        this.ipw.print("\" .. \"");
        this.ipw.print(InterlisString.escapeSpecialChars(ft.getDefinedMaximum()));
        this.ipw.print("\"");
    }

    protected void printNumericalType(Container scope, NumericalType type, String language, int i) {
        Unit unit;
        if (type == null) {
            this.printError();
            return;
        }
        if (type instanceof NumericType) {
            NumericType ntyp = (NumericType)type;
            PrecisionDecimal min = ntyp.getMinimum();
            PrecisionDecimal max = ntyp.getMaximum();
            if (min == null) {
                this.ipw.print("NUMERIC");
            } else if (this.params != null) {
                if (i % 2 == 0) {
                    int j;
                    int value = (int)((double)((int)(this.params.getFactor_x() * min.doubleValue())) + this.params.getDiff_x());
                    String newValue = String.valueOf(value);
                    for (j = 0; j < min.getAccuracy(); ++j) {
                        newValue = j == 0 ? newValue + ".0" : newValue + "0";
                    }
                    this.ipw.print(newValue);
                    this.ipw.print(" .. ");
                    value = (int)((double)((int)(this.params.getFactor_x() * max.doubleValue())) + this.params.getDiff_x());
                    newValue = String.valueOf(value);
                    for (j = 0; j < min.getAccuracy(); ++j) {
                        newValue = j == 0 ? newValue + ".0" : newValue + "0";
                    }
                    this.ipw.print(newValue);
                } else {
                    int j;
                    int value = (int)((double)((int)(this.params.getFactor_y() * min.doubleValue())) + this.params.getDiff_y());
                    String newValue = String.valueOf(value);
                    for (j = 0; j < min.getAccuracy(); ++j) {
                        newValue = j == 0 ? newValue + ".0" : newValue + "0";
                    }
                    this.ipw.print(newValue);
                    this.ipw.print(" .. ");
                    value = (int)((double)((int)(this.params.getFactor_y() * max.doubleValue())) + this.params.getDiff_y());
                    newValue = String.valueOf(value);
                    for (j = 0; j < min.getAccuracy(); ++j) {
                        newValue = j == 0 ? newValue + ".0" : newValue + "0";
                    }
                    this.ipw.print(newValue);
                }
            } else {
                this.ipw.print(min.toString());
                this.ipw.print(" .. ");
                this.ipw.print(max.toString());
            }
        } else if (type instanceof StructuredUnitType) {
            this.ipw.print(((StructuredUnitType)type).getMinimum().toString());
            this.ipw.print(" .. ");
            this.ipw.print(((StructuredUnitType)type).getMaximum().toString());
        }
        if (type.isCircular()) {
            this.ipw.print(" CIRCULAR");
        }
        if ((unit = this.getTypeUnit(type)) != null) {
            this.ipw.print(" [");
            this.ipw.print(unit.getScopedName(scope));
            this.ipw.print(']');
        }
        switch (type.getRotation()) {
            case 2: {
                this.ipw.print(" COUNTERCLOCKWISE");
                break;
            }
            case 1: {
                this.ipw.print(" CLOCKWISE");
            }
        }
        RefSystemRef referenceSystem = this.getTypeReferenceSystem(type);
        if (referenceSystem != null) {
            this.ipw.print(' ');
            this.printReferenceSysRef(scope, referenceSystem, language);
        }
    }

    protected RefSystemRef getTypeReferenceSystem(NumericalType type) {
        return type.getReferenceSystem();
    }

    protected Unit getTypeUnit(NumericalType type) {
        return type.getUnit();
    }

    protected void printEnumeration(Enumeration enumer, String language, String scopedNamePrefix) {
        this.ipw.println('(');
        this.ipw.indent();
        if (enumer == null) {
            this.printError();
        } else {
            Iterator<Enumeration.Element> iter = enumer.getElements();
            while (iter.hasNext()) {
                this.printEnumerationElement(iter.next(), language, scopedNamePrefix);
                if (!iter.hasNext()) continue;
                this.ipw.println(',');
            }
        }
        this.ipw.println("");
        this.ipw.unindent();
        this.ipw.print(')');
    }

    protected void printEnumerationElement(Enumeration.Element ee, String language, String scopedNamePrefix) {
        String scopedName = scopedNamePrefix + "." + ee.getName();
        if (language == null) {
            this.printDocumentation(ee.getDocumentation());
            this.printMetaValues(ee, ee.getMetaValues(), language, scopedName);
            this.ipw.print(ee.getName());
        } else {
            String docu = this.getElementDocumentationInLanguage(scopedName, language);
            if (docu == null || docu == "") {
                this.printDocumentation(ee.getDocumentation());
            } else {
                this.printDocumentation(docu);
            }
            this.printMetaValues(ee, ee.getMetaValues(), language, scopedName);
            String name = this.getElementNameInLanguage(scopedName, language);
            if (name == null || name == "") {
                this.ipw.print(ee.getName());
            } else {
                this.ipw.print(name);
            }
        }
        Enumeration subEnum = ee.getSubEnumeration();
        if (subEnum != null) {
            this.ipw.print(' ');
            this.printEnumeration(subEnum, language, scopedName);
        }
    }

    private String getElementNameInLanguage(String scopedNamePrefix, String language) {
        String modelName = "";
        for (TranslationElement element : this.translationConfig) {
            if (!scopedNamePrefix.equals(element.getScopedName())) continue;
            if (language.equals(FR)) {
                modelName = element.getName_fr();
                return modelName;
            }
            if (language.equals(EN)) {
                modelName = element.getName_en();
                return modelName;
            }
            if (language.equals(IT)) {
                modelName = element.getName_it();
                return modelName;
            }
            if (!language.equals(DE)) continue;
            modelName = element.getName_de();
            return modelName;
        }
        return "";
    }

    private String getElementDocumentationInLanguage(String scopedNamePrefix, String language) {
        String modelName = "";
        for (TranslationElement element : this.translationConfig) {
            if (!scopedNamePrefix.equals(element.getScopedName())) continue;
            if (language.equals(FR)) {
                modelName = element.getDocumentation_fr();
                return modelName;
            }
            if (language.equals(EN)) {
                modelName = element.getDocumentation_en();
                return modelName;
            }
            if (language.equals(IT)) {
                modelName = element.getDocumentation_it();
                return modelName;
            }
            if (!language.equals(DE)) continue;
            modelName = element.getDocumentation_de();
            return modelName;
        }
        return "";
    }

    public void printLineFormTypeDef(Container scope, LineForm lf) {
        this.printLineFormTypeDef(scope, lf, null);
    }

    public void printLineFormTypeDef(Container scope, LineForm lf, String language) {
        Table segmentStructure;
        if (lf == null) {
            this.printError();
            return;
        }
        this.printDocumentation(lf, language);
        this.printMetaValues(lf, lf.getMetaValues(), language, lf.getScopedName());
        if (language == null) {
            this.ipw.print(lf.getName());
        } else {
            String name = this.getNameInLanguage(lf, language);
            if (name == null || name == "") {
                this.ipw.print(lf.getName());
            } else {
                this.ipw.print(name);
            }
        }
        String explanation = lf.getExplanation();
        if (explanation != null) {
            this.ipw.print(' ');
            this.printExplanation(explanation);
        }
        if (!(segmentStructure = lf.getSegmentStructure()).isEmpty()) {
            this.ipw.print(" : ");
            if (language == null) {
                this.ipw.print(segmentStructure.getName());
            } else {
                String name = this.getNameInLanguage(segmentStructure, language);
                if (name == null || name == "") {
                    this.ipw.print(segmentStructure.getName());
                } else {
                    this.ipw.print(name);
                }
            }
        }
        this.ipw.println(';');
    }

    public void printFunctionDeclaration(Container scope, Function f) {
        this.printFunctionDeclaration(scope, f, null);
    }

    public void printFunctionDeclaration(Container scope, Function f, String language) {
        this.printFunctionDeclaration(scope, f, false, language);
    }

    public void printFunctionDeclaration(Container scope, Function f, boolean suppressDoc) {
        this.printFunctionDeclaration(scope, f, suppressDoc, null);
    }

    public void printFunctionDeclaration(Container scope, Function f, boolean suppressDoc, String language) {
        if (f == null) {
            this.printError();
            return;
        }
        if (!suppressDoc) {
            this.printDocumentation(f, language);
            this.printMetaValues(f, f.getMetaValues(), language, f.getScopedName());
        }
        this.ipw.print("FUNCTION ");
        this.printName(f, language);
        this.ipw.print("(");
        FormalArgument[] args = f.getArguments();
        if (args == null) {
            this.printError();
        } else {
            String sep = "";
            for (int i = 0; i < args.length; ++i) {
                String scopedName;
                FormalArgument arg = args[i];
                String name = arg.getName();
                if (language != null && ((name = this.getNameInLanguage(scopedName = f.getScopedName() + "." + arg.getName(), language)) == null || name.equals(""))) {
                    name = arg.getName();
                }
                this.ipw.print(sep + name + ": ");
                this.printType(scope, args[i].getType(), language, scope.getScopedName());
                sep = "; ";
            }
        }
        this.ipw.print(") : ");
        this.printType(scope, f.getDomain(), language, scope.getScopedName());
        String explanation = f.getExplanation();
        if (explanation != null) {
            this.printExplanation(explanation);
        }
        this.ipw.println(';');
    }

    protected void printAttributeRefs(AttributeRef[] refs) {
        if (refs == null) {
            this.printError();
            return;
        }
        for (int i = 0; i < refs.length; ++i) {
            if (i > 0) {
                this.ipw.print('.');
            }
            if (refs[i] == null) {
                this.printError();
                continue;
            }
            this.ipw.print(refs[i].getName());
        }
    }

    protected void printAttributePath(Container scope, ObjectPath path, String language) {
        if (path == null) {
            this.printError();
            return;
        }
        PathEl[] elv = path.getPathElements();
        String sep = "";
        for (int i = 0; i < elv.length; ++i) {
            PathEl assocRole;
            String name;
            this.ipw.print(sep);
            sep = "->";
            if (language == null) {
                this.ipw.print(elv[i].getName());
                continue;
            }
            if (elv[i] instanceof AttributeRef) {
                AttributeRef attr = (AttributeRef)elv[i];
                if (!(attr.getAttr() instanceof LocalAttribute)) continue;
                name = this.getElementNameInLanguage(attr.getAttr().getScopedName(), language);
                if (name == null || name == "") {
                    this.ipw.print(elv[i].getName());
                    continue;
                }
                this.ipw.print(name);
                continue;
            }
            if (elv[i] instanceof PathElBase) {
                PathElBase pathEl = (PathElBase)elv[i];
                String scopedEleName = pathEl.getCurrentViewable().getScopedName() + "." + pathEl.getName();
                String name2 = this.getElementNameInLanguage(scopedEleName, language);
                if (name2 == null || name2 == "") {
                    this.ipw.print(elv[i].getName());
                    continue;
                }
                this.ipw.print(name2);
                continue;
            }
            if (elv[i] instanceof PathElAssocRole) {
                assocRole = (PathElAssocRole)elv[i];
                if (!(((PathElAssocRole)assocRole).getRole() instanceof RoleDef)) continue;
                name = this.getElementNameInLanguage(((PathElAssocRole)assocRole).getRole().getScopedName(), language);
                if (name == null || name == "") {
                    this.ipw.print(elv[i].getName());
                    continue;
                }
                this.ipw.print(name);
                continue;
            }
            if (elv[i] instanceof PathElAbstractClassRole) {
                assocRole = (PathElAbstractClassRole)elv[i];
                if (!(((PathElAbstractClassRole)assocRole).getRole() instanceof RoleDef)) continue;
                name = this.getElementNameInLanguage(((PathElAbstractClassRole)assocRole).getRole().getScopedName(), language);
                if (name == null || name == "") {
                    this.ipw.print(elv[i].getName());
                    continue;
                }
                this.ipw.print(name);
                continue;
            }
            if (elv[i] instanceof AssociationPath) {
                assocRole = (AssociationPath)elv[i];
                if (!(((AssociationPath)assocRole).getTargetRole() instanceof RoleDef)) continue;
                name = this.getElementNameInLanguage(((AssociationPath)assocRole).getTargetRole().getScopedName(), language);
                if (name == null || name == "") {
                    this.ipw.print("\\\\" + elv[i].getName());
                    continue;
                }
                this.ipw.print("\\\\" + name);
                continue;
            }
            if (!(elv[i] instanceof PathElThis)) continue;
            this.ipw.print("THIS");
        }
    }

    protected void printElements(Container container, String language) {
        Class lastClass = null;
        if (this.onlyLastFile && container instanceof TransferDescription) {
            for (Model model : ((TransferDescription)container).getModelsFromLastFile()) {
                lastClass = this.printElement(container, lastClass, model, language);
            }
        } else {
            Iterator it = container.iterator();
            while (it.hasNext()) {
                Element elt = (Element)it.next();
                if (container instanceof Topic && this.selfStandingConstraints.size() > 0) {
                    ArrayList<Constraint> flushConstraints = new ArrayList<Constraint>();
                    for (Constraint cs : this.selfStandingConstraints) {
                        if (elt.getSourceLine() <= cs.getSourceLine()) continue;
                        flushConstraints.add(cs);
                    }
                    if (flushConstraints.size() > 0) {
                        this.selfStandingConstraints.removeAll(flushConstraints);
                        this.printSelfStandingConstraints(flushConstraints, language);
                    }
                }
                lastClass = this.printElement(container, lastClass, elt, language);
            }
        }
    }

    protected Class printElement(Container container, Class lastClass, Element elt, String language) {
        if (elt instanceof AttributeDef) {
            this.printAttribute(container, (AttributeDef)elt, language);
            lastClass = AttributeDef.class;
        } else if (elt instanceof RoleDef) {
            this.printRoleDef(container, (RoleDef)elt, language);
            lastClass = RoleDef.class;
        } else if (elt instanceof Function) {
            if (lastClass != null && lastClass != Function.class) {
                this.ipw.println();
            }
            this.printFunctionDeclaration(container, (Function)elt, language);
            lastClass = Function.class;
        } else if (elt instanceof Parameter) {
            if (lastClass != Parameter.class) {
                this.ipw.println("PARAMETER");
            }
            this.printParameter(container, (Parameter)elt, language);
            lastClass = Parameter.class;
        } else if (elt instanceof ContextDef) {
            if (lastClass != ContextDef.class) {
                this.ipw.println();
                this.ipw.println("CONTEXT");
            }
            this.ipw.indent();
            this.printContext(container, (ContextDef)elt);
            this.ipw.unindent();
            lastClass = ContextDef.class;
        } else if (elt instanceof Domain) {
            if (lastClass != Domain.class) {
                this.ipw.println();
                this.ipw.println("DOMAIN");
            }
            this.ipw.indent();
            this.printDomainDef(container, (Domain)elt, language);
            this.ipw.unindent();
            lastClass = Domain.class;
        } else if (elt instanceof LineForm) {
            if (lastClass != LineForm.class) {
                this.ipw.println();
                this.ipw.println("LINE FORM");
            }
            this.ipw.indent();
            this.printLineFormTypeDef(container, (LineForm)elt, language);
            this.ipw.unindent();
            lastClass = LineForm.class;
        } else if (elt instanceof Unit) {
            if (lastClass != Unit.class) {
                this.ipw.println();
                this.ipw.println("UNIT");
            }
            this.ipw.indent();
            this.printUnit(container, (Unit)elt, language);
            this.ipw.unindent();
            lastClass = Unit.class;
        } else if (elt instanceof Model) {
            if (this.withPredefined || !(elt instanceof PredefinedModel)) {
                this.ipw.println();
                this.printModel((Model)elt, language);
                lastClass = Model.class;
            }
        } else if (elt instanceof Topic) {
            this.ipw.println();
            this.printTopic((Topic)elt, language);
            lastClass = Topic.class;
        } else if (elt instanceof MetaDataUseDef) {
            this.ipw.println();
            this.printMetaDataUseDef((MetaDataUseDef)elt, language);
            lastClass = MetaDataUseDef.class;
        } else if (elt instanceof Table) {
            if (!((Table)elt).isImplicit()) {
                this.ipw.println();
                this.printAbstractClassDef((Table)elt, language);
                lastClass = AbstractClassDef.class;
            }
        } else if (elt instanceof AssociationDef) {
            this.ipw.println();
            this.printAbstractClassDef((AssociationDef)elt, language);
            lastClass = AbstractClassDef.class;
        } else if (elt instanceof View) {
            this.ipw.println();
            this.printView((View)elt, language);
            lastClass = View.class;
        } else if (elt instanceof Graphic) {
            this.ipw.println();
            this.printGraphic((Graphic)elt, language);
            lastClass = Graphic.class;
        } else if (elt instanceof Constraint) {
            if (((Constraint)elt).isSelfStanding()) {
                this.selfStandingConstraints.add((Constraint)elt);
            } else {
                this.printConstraint((Constraint)elt, language);
                lastClass = Constraint.class;
            }
        } else if (elt instanceof SignAttribute) {
            if (lastClass != SignAttribute.class && lastClass != null) {
                this.ipw.println();
            }
            this.printSignAttribute((Graphic)container, (SignAttribute)elt, language);
            lastClass = SignAttribute.class;
        }
        return lastClass;
    }

    protected void printTransferDescription(TransferDescription td, String language) {
        if (this.doIli24) {
            this.ipw.println("INTERLIS 2.4;");
        } else {
            this.ipw.println("INTERLIS 2.3;");
        }
        this.printElements(td, language);
    }
}

