/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2duckdb;

import ch.ehi.basics.settings.Settings;
import ch.ehi.ili2db.converter.AbstractWKBColumnConverter;
import ch.ehi.ili2db.converter.ConverterException;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2db.json.Iox2jsonUtility;
import ch.ehi.ili2db.toxtf.ToXtfRecordConverter;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.iom.IomObject;
import ch.interlis.iox_j.wkb.Iox2wkb;
import ch.interlis.iox_j.wkb.Iox2wkbException;
import ch.interlis.iox_j.wkb.Wkb2iox;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.ByteOrder;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.UUID;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.iharder.Base64;

public class DuckDBColumnConverter
extends AbstractWKBColumnConverter {
    private boolean strokeArcs = true;
    private boolean repairTouchingLines;
    private TransferDescription td = null;

    @Override
    public void setup(Connection conn, Settings config) {
        super.setup(conn, config);
        if (!"enable".equals(Config.getStrokeArcs(config))) {
            throw new IllegalArgumentException("DuckDB supports only straights");
        }
        this.repairTouchingLines = ((Config)config).getRepairTouchingLines();
    }

    @Override
    public Integer getSrsid(String crsAuthority, String crsCode, Connection conn) throws ConverterException {
        int srsid = -1;
        return srsid;
    }

    @Override
    public String getInsertValueWrapperCoord(String wkfValue, int srid) {
        return "ST_GeomFromWKB(" + wkfValue + "::blob)";
    }

    @Override
    public String getInsertValueWrapperMultiCoord(String wkfValue, int srid) {
        return "ST_GeomFromWKB(" + wkfValue + "::blob)";
    }

    @Override
    public String getInsertValueWrapperPolyline(String wkfValue, int srid) {
        return "ST_GeomFromWKB(" + wkfValue + "::blob)";
    }

    @Override
    public String getInsertValueWrapperMultiPolyline(String wkfValue, int srid) {
        return "ST_GeomFromWKB(" + wkfValue + "::blob)";
    }

    @Override
    public String getInsertValueWrapperSurface(String wkfValue, int srid) {
        return "ST_GeomFromWKB(" + wkfValue + "::blob)";
    }

    @Override
    public String getInsertValueWrapperMultiSurface(String wkfValue, int srid) {
        return "ST_GeomFromWKB(" + wkfValue + "::blob)";
    }

    @Override
    public String getInsertValueWrapperArray(String sqlColName) {
        return sqlColName;
    }

    @Override
    public String getSelectValueWrapperCoord(String dbNativeValue) {
        return "ST_AsWKB(" + dbNativeValue + ")::blob";
    }

    @Override
    public String getSelectValueWrapperMultiCoord(String dbNativeValue) {
        return "ST_AsWKB(" + dbNativeValue + ")::blob";
    }

    @Override
    public String getSelectValueWrapperPolyline(String dbNativeValue) {
        return "ST_AsWKB(" + dbNativeValue + ")::blob";
    }

    @Override
    public String getSelectValueWrapperMultiPolyline(String dbNativeValue) {
        return "ST_AsWKB(" + dbNativeValue + ")::blob";
    }

    @Override
    public String getSelectValueWrapperSurface(String dbNativeValue) {
        return "ST_AsWKB(" + dbNativeValue + ")::blob";
    }

    @Override
    public String getSelectValueWrapperMultiSurface(String dbNativeValue) {
        return "ST_AsWKB(" + dbNativeValue + ")::blob";
    }

    @Override
    public String getSelectValueWrapperArray(String dbColName) {
        return dbColName;
    }

    @Override
    public Object fromIomUuid(String uuid) throws SQLException, ConverterException {
        return uuid;
    }

    @Override
    public Object fromIomXml(String xml) throws SQLException, ConverterException {
        return xml;
    }

    @Override
    public Object fromIomBlob(String blob) throws SQLException, ConverterException {
        byte[] bytearray;
        try {
            bytearray = Base64.decode((String)blob);
        }
        catch (IOException e) {
            throw new ConverterException(e);
        }
        return bytearray;
    }

    @Override
    public Object fromIomSurface(IomObject value, int srid, boolean hasLineAttr, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            Iox2wkb conv = new Iox2wkb(2, ByteOrder.BIG_ENDIAN, false);
            try {
                return conv.surface2wkb(value, !this.strokeArcs, p, this.repairTouchingLines);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException(ex);
            }
        }
        return null;
    }

    @Override
    public Object fromIomMultiSurface(IomObject value, int srid, boolean hasLineAttr, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            Iox2wkb conv = new Iox2wkb(2, ByteOrder.BIG_ENDIAN, false);
            try {
                return conv.multisurface2wkb(value, !this.strokeArcs, p, this.repairTouchingLines);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException(ex);
            }
        }
        return null;
    }

    @Override
    public Object fromIomCoord(IomObject value, int srid, boolean is3D) throws SQLException, ConverterException {
        if (value != null) {
            Iox2wkb conv = new Iox2wkb(2, ByteOrder.BIG_ENDIAN, false);
            try {
                return conv.coord2wkb(value);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException(ex);
            }
        }
        return null;
    }

    @Override
    public Object fromIomMultiCoord(IomObject value, int srid, boolean is3D) throws SQLException, ConverterException {
        if (value != null) {
            Iox2wkb conv = new Iox2wkb(2, ByteOrder.BIG_ENDIAN, false);
            try {
                return conv.multicoord2wkb(value);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException(ex);
            }
        }
        return null;
    }

    @Override
    public Object fromIomPolyline(IomObject value, int srid, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            Iox2wkb conv = new Iox2wkb(2, ByteOrder.BIG_ENDIAN, false);
            try {
                return conv.polyline2wkb(value, false, !this.strokeArcs, p);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException(ex);
            }
        }
        return null;
    }

    @Override
    public Object fromIomMultiPolyline(IomObject value, int srid, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            Iox2wkb conv = new Iox2wkb(2, ByteOrder.BIG_ENDIAN, false);
            try {
                return conv.multiline2wkb(value, !this.strokeArcs, p);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException(ex);
            }
        }
        return null;
    }

    @Override
    public Object fromIomArray(AttributeDef attr, String[] iomValues, Class<? extends DbColumn> dbColHint) throws SQLException, ConverterException {
        Array array = null;
        Type type = attr.getDomainResolvingAliases();
        if (attr.isDomainBoolean()) {
            Object[] values = new Boolean[iomValues.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = iomValues[i].equals("true") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            array = this.conn.createArrayOf("BOOLEAN", values);
        } else if (attr.isDomainIli1Date()) {
            Object[] values = new Date[iomValues.length];
            for (int i = 0; i < values.length; ++i) {
                String iomValue = iomValues[i];
                GregorianCalendar gdate = new GregorianCalendar(Integer.parseInt(iomValue.substring(0, 4)), Integer.parseInt(iomValue.substring(4, 6)) - 1, Integer.parseInt(iomValue.substring(6, 8)));
                values[i] = new Date(gdate.getTimeInMillis());
            }
            array = this.conn.createArrayOf("DATE", values);
        } else if (attr.isDomainIliUuid()) {
            Object[] values = new Object[iomValues.length];
            for (int i = 0; i < values.length; ++i) {
                String iomValue = iomValues[i];
                values[i] = this.fromIomUuid(iomValue);
            }
            array = this.conn.createArrayOf("UUID", values);
        } else if (attr.isDomainIli2Date()) {
            Object[] values = new Date[iomValues.length];
            for (int i = 0; i < values.length; ++i) {
                XMLGregorianCalendar xmldate;
                String iomValue = iomValues[i];
                try {
                    xmldate = DatatypeFactory.newInstance().newXMLGregorianCalendar(iomValue);
                }
                catch (DatatypeConfigurationException e) {
                    throw new ConverterException(e);
                }
                values[i] = new Date(xmldate.toGregorianCalendar().getTimeInMillis());
            }
            array = this.conn.createArrayOf("DATE", values);
        } else if (attr.isDomainIli2DateTime()) {
            Object[] values = new Timestamp[iomValues.length];
            for (int i = 0; i < values.length; ++i) {
                XMLGregorianCalendar xmldate;
                String iomValue = iomValues[i];
                try {
                    xmldate = DatatypeFactory.newInstance().newXMLGregorianCalendar(iomValue);
                }
                catch (DatatypeConfigurationException e) {
                    throw new ConverterException(e);
                }
                values[i] = new Timestamp(xmldate.toGregorianCalendar().getTimeInMillis());
            }
            array = this.conn.createArrayOf("TIMESTAMP", values);
        } else if (attr.isDomainIli2Time()) {
            Object[] values = new Time[iomValues.length];
            for (int i = 0; i < values.length; ++i) {
                XMLGregorianCalendar xmldate;
                String iomValue = iomValues[i];
                try {
                    xmldate = DatatypeFactory.newInstance().newXMLGregorianCalendar(iomValue);
                }
                catch (DatatypeConfigurationException e) {
                    throw new ConverterException(e);
                }
                values[i] = new Time(xmldate.toGregorianCalendar().getTimeInMillis());
            }
            array = this.conn.createArrayOf("TIME", values);
        } else if (type instanceof EnumerationType) {
            if (DbColNumber.class.equals(dbColHint)) {
                Object[] values = new Long[iomValues.length];
                for (int i = 0; i < values.length; ++i) {
                    String iomValue = iomValues[i];
                    long itfCode = Long.parseLong(iomValue);
                    values[i] = itfCode;
                }
                array = this.conn.createArrayOf("BIGINT", values);
            } else {
                array = this.conn.createArrayOf("VARCHAR", iomValues);
            }
        } else if (type instanceof NumericType) {
            if (!type.isAbstract()) {
                PrecisionDecimal min = ((NumericType)type).getMinimum();
                PrecisionDecimal max = ((NumericType)type).getMaximum();
                if (min.getAccuracy() > 0) {
                    Object[] values = new Double[iomValues.length];
                    for (int i = 0; i < values.length; ++i) {
                        String iomValue = iomValues[i];
                        double value = Double.parseDouble(iomValue);
                        values[i] = value;
                    }
                    array = this.conn.createArrayOf("DECIMAL", values);
                } else {
                    Object[] values = new Integer[iomValues.length];
                    for (int i = 0; i < values.length; ++i) {
                        String iomValue = iomValues[i];
                        int value = (int)Math.round(Double.parseDouble(iomValue));
                        values[i] = value;
                    }
                    array = this.conn.createArrayOf("INTEGER", values);
                }
            }
        } else if (type instanceof TextType) {
            array = this.conn.createArrayOf("VARCHAR", iomValues);
        } else if (type instanceof BlackboxType) {
            if (((BlackboxType)type).getKind() == 1) {
                Object[] values = new Object[iomValues.length];
                for (int i = 0; i < values.length; ++i) {
                    String iomValue = iomValues[i];
                    values[i] = this.fromIomXml(iomValue);
                }
                array = this.conn.createArrayOf("VARCHAR", values);
            } else {
                Object[] values = new Object[iomValues.length];
                for (int i = 0; i < values.length; ++i) {
                    String iomValue = iomValues[i];
                    values[i] = this.fromIomBlob(iomValue);
                }
                array = this.conn.createArrayOf("BLOB", values);
            }
        } else if (type instanceof ReferenceType) {
            if (DbColId.class.equals(dbColHint)) {
                Object[] values = new Long[iomValues.length];
                for (int i = 0; i < values.length; ++i) {
                    String iomValue = iomValues[i];
                    long itfCode = Long.parseLong(iomValue);
                    values[i] = itfCode;
                }
                array = this.conn.createArrayOf("BIGINT", values);
            } else {
                array = this.conn.createArrayOf("VARCHAR", iomValues);
            }
        } else {
            throw new IllegalArgumentException(attr.getScopedName());
        }
        return array;
    }

    @Override
    public IomObject toIomCoord(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        Blob blob = (Blob)geomobj;
        int blobLength = (int)blob.length();
        byte[] bv = blob.getBytes(1L, blobLength);
        Wkb2iox conv = new Wkb2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public IomObject toIomMultiCoord(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        Blob blob = (Blob)geomobj;
        int blobLength = (int)blob.length();
        byte[] bv = blob.getBytes(1L, blobLength);
        Wkb2iox conv = new Wkb2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public IomObject toIomSurface(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        Blob blob = (Blob)geomobj;
        int blobLength = (int)blob.length();
        byte[] bv = blob.getBytes(1L, blobLength);
        Wkb2iox conv = new Wkb2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public IomObject toIomMultiSurface(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        Blob blob = (Blob)geomobj;
        int blobLength = (int)blob.length();
        byte[] bv = blob.getBytes(1L, blobLength);
        Wkb2iox conv = new Wkb2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public IomObject toIomPolyline(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        Blob blob = (Blob)geomobj;
        int blobLength = (int)blob.length();
        byte[] bv = blob.getBytes(1L, blobLength);
        Wkb2iox conv = new Wkb2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public IomObject toIomMultiPolyline(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        Blob blob = (Blob)geomobj;
        int blobLength = (int)blob.length();
        byte[] bv = blob.getBytes(1L, blobLength);
        Wkb2iox conv = new Wkb2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public String toIomXml(Object obj) throws SQLException, ConverterException {
        return obj.toString();
    }

    @Override
    public String toIomBlob(Object obj) throws SQLException, ConverterException {
        Blob blob = (Blob)obj;
        int blobLength = (int)blob.length();
        byte[] bytes = blob.getBytes(1L, blobLength);
        String s = Base64.encodeBytes((byte[])bytes);
        return s;
    }

    @Override
    public IomObject[] toIomStructureFromJson(AttributeDef iliEleAttr, Object sqlArray) throws SQLException, ConverterException {
        JsonFactory jsonF = new JsonFactory();
        StringReader in = new StringReader(sqlArray.toString());
        IomObject[] iomObj = null;
        try {
            JsonParser jg = jsonF.createJsonParser((Reader)in);
            iomObj = Iox2jsonUtility.read(jg);
        }
        catch (IOException ex) {
            throw new ConverterException(ex);
        }
        return iomObj;
    }

    @Override
    public void setTimestamp(PreparedStatement ps, int valuei, Timestamp datetime) throws SQLException {
        ps.setTimestamp(valuei, datetime);
    }

    @Override
    public void setDate(PreparedStatement ps, int valuei, Date date) throws SQLException {
        ps.setDate(valuei, date);
    }

    @Override
    public void setTime(PreparedStatement ps, int valuei, Time time) throws SQLException {
        ps.setObject(valuei, time.toString());
    }

    @Override
    public String[] toIomArray(AttributeDef attr, Object sqlArray, Class<? extends DbColumn> dbColHint) throws SQLException, ConverterException {
        Array array = (Array)sqlArray;
        String[] ret = null;
        Type type = attr.getDomainResolvingAliases();
        if (attr.isDomainBoolean()) {
            Boolean[] values = (Boolean[])array.getArray();
            ret = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i] != false ? "true" : "false";
            }
        } else if (attr.isDomainIli1Date()) {
            Date[] values = (Date[])array.getArray();
            ret = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
                GregorianCalendar date = new GregorianCalendar();
                date.setGregorianChange(ToXtfRecordConverter.PURE_GREGORIAN_CALENDAR);
                fmt.setCalendar(date);
                ret[i] = fmt.format(values[i]);
            }
        } else if (attr.isDomainIliUuid()) {
            UUID[] values = (UUID[])array.getArray();
            ret = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].toString();
            }
        } else if (attr.isDomainIli2Date()) {
            Date[] values = (Date[])array.getArray();
            ret = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                GregorianCalendar date = new GregorianCalendar();
                date.setGregorianChange(ToXtfRecordConverter.PURE_GREGORIAN_CALENDAR);
                fmt.setCalendar(date);
                ret[i] = fmt.format(values[i]);
            }
        } else if (attr.isDomainIli2DateTime()) {
            Timestamp[] values = (Timestamp[])array.getArray();
            ret = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                GregorianCalendar date = new GregorianCalendar();
                date.setGregorianChange(ToXtfRecordConverter.PURE_GREGORIAN_CALENDAR);
                fmt.setCalendar(date);
                ret[i] = fmt.format(values[i]);
            }
        } else if (attr.isDomainIli2Time()) {
            Time[] values = (Time[])array.getArray();
            ret = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss.SSS");
                ret[i] = fmt.format(values[i]);
            }
        } else if (type instanceof EnumerationType) {
            if (DbColNumber.class.equals(dbColHint)) {
                Long[] values = (Long[])array.getArray();
                ret = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = values[i].toString();
                }
            } else {
                ret = (String[])array.getArray();
            }
        } else if (type instanceof NumericType) {
            if (!type.isAbstract()) {
                PrecisionDecimal min = ((NumericType)type).getMinimum();
                PrecisionDecimal max = ((NumericType)type).getMaximum();
                if (min.getAccuracy() > 0) {
                    BigDecimal[] values = (BigDecimal[])array.getArray();
                    ret = new String[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        ret[i] = values[i].toString();
                    }
                } else {
                    Integer[] values = (Integer[])array.getArray();
                    ret = new String[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        ret[i] = values[i].toString();
                    }
                }
            }
        } else if (type instanceof TextType) {
            ret = (String[])array.getArray();
        } else if (type instanceof BlackboxType) {
            if (((BlackboxType)type).getKind() == 1) {
                Object[] values = (Object[])array.getArray();
                ret = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = this.toIomXml(values[i]);
                }
            } else {
                Object[] values = (Object[])array.getArray();
                ret = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = this.toIomBlob(values[i]);
                }
            }
        } else if (type instanceof ReferenceType) {
            if (DbColId.class.equals(dbColHint)) {
                Long[] values = (Long[])array.getArray();
                ret = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = values[i].toString();
                }
            } else {
                ret = (String[])array.getArray();
            }
        } else {
            throw new IllegalArgumentException(attr.getScopedName());
        }
        return ret;
    }

    @Override
    public void setXmlNull(PreparedStatement stmt, int parameterIndex) throws SQLException {
        stmt.setNull(parameterIndex, 12);
    }

    @Override
    public void setBlobNull(PreparedStatement stmt, int parameterIndex) throws SQLException {
        stmt.setNull(parameterIndex, -2);
    }

    @Override
    public void setArrayNull(PreparedStatement stmt, int parameterIndex) throws SQLException {
        stmt.setNull(parameterIndex, 2003);
    }
}

