/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2duckdb;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.ili2db.base.AbstractJdbcMapping;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2duckdb.GeneratorDuckDB;
import ch.ehi.sqlgen.repository.DbTableName;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class DuckDBMapping
extends AbstractJdbcMapping {
    private Boolean isNewFile = null;

    public void preConnect(String url, String dbusr, String dbpwd, Config config) {
        String fileName = config.getDbfile();
        if (fileName != null) {
            this.isNewFile = new File(fileName).exists() ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConnect(Connection conn, Config config) {
        if (this.isNewFile != null) {
            Statement dbstmt = null;
            try {
                try {
                    String line = "INSTALL spatial;";
                    dbstmt = conn.createStatement();
                    EhiLogger.traceBackendCmd((String)line);
                    dbstmt.execute(line);
                    line = "LOAD spatial;";
                    EhiLogger.traceBackendCmd((String)line);
                    dbstmt.execute(line);
                }
                finally {
                    if (dbstmt != null) {
                        dbstmt.close();
                        dbstmt = null;
                    }
                }
            }
            catch (SQLException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public void postPostScript(Connection conn, Config config) {
        Statement dbstmt = null;
        try {
            if (dbstmt != null) {
                dbstmt.close();
                dbstmt = null;
            }
        }
        catch (SQLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public boolean tableExists(Connection conn, DbTableName tableName) {
        return GeneratorDuckDB.tableExists(conn, tableName);
    }
}

