/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.mapping;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.ili2db.base.Ili2cUtility;
import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.ili2db.fromili.TransferFromIli;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2db.mapping.ArrayMappings;
import ch.ehi.ili2db.mapping.ColumnWrapper;
import ch.ehi.ili2db.mapping.MultiLineMappings;
import ch.ehi.ili2db.mapping.MultiPointMappings;
import ch.ehi.ili2db.mapping.MultiSurfaceMappings;
import ch.ehi.ili2db.mapping.NameMapping;
import ch.ehi.ili2db.mapping.StructAttrPath;
import ch.ehi.ili2db.mapping.TrafoConfig;
import ch.ehi.ili2db.mapping.Viewable2TableMapping;
import ch.ehi.ili2db.mapping.ViewableWrapper;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractCoordType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Viewable2TableMapper {
    private Config config = null;
    private String sqlSchemaname = null;
    private TrafoConfig trafoConfig = null;
    private NameMapping nameMapping = null;
    private boolean singleGeom = false;
    private boolean coalesceMultiSurface = false;
    private boolean coalesceMultiLine = false;
    private boolean coalesceMultiPoint = false;
    private boolean coalesceArray = false;
    private boolean coalesceJson = false;
    private boolean expandStruct = false;
    private boolean createItfLineTables = false;
    private Integer defaultCrsCode = null;
    private String srsModelAssignment = null;
    private TransferDescription td = null;

    private Viewable2TableMapper(Config config1, TrafoConfig trafoConfig1, NameMapping nameMapping1) {
        this.config = config1;
        this.trafoConfig = trafoConfig1;
        this.nameMapping = nameMapping1;
        this.sqlSchemaname = this.config.getDbschema();
        if (this.config.getDefaultSrsCode() != null) {
            this.defaultCrsCode = Integer.parseInt(this.config.getDefaultSrsCode());
        }
        this.srsModelAssignment = this.config.getSrsModelAssignment();
    }

    public static Viewable2TableMapping getClass2TableMapping(boolean isIli1, Config config, TrafoConfig trafoConfig, List<Element> eles, NameMapping nameMapping) throws Ili2dbException {
        Viewable2TableMapper mapper = new Viewable2TableMapper(config, trafoConfig, nameMapping);
        mapper.singleGeom = config.isOneGeomPerTable();
        mapper.coalesceMultiSurface = "coalesce".equals(config.getMultiSurfaceTrafo());
        mapper.coalesceMultiLine = "coalesce".equals(config.getMultiLineTrafo());
        mapper.coalesceMultiPoint = "coalesce".equals(config.getMultiPointTrafo());
        mapper.coalesceArray = "coalesce".equals(config.getArrayTrafo());
        mapper.coalesceJson = "coalesce".equals(config.getJsonTrafo());
        mapper.expandStruct = "expand".equals(config.getStructTrafo());
        mapper.createItfLineTables = isIli1 && config.getDoItfLineTables();
        return mapper.doit(eles);
    }

    private Viewable2TableMapping doit(List<Element> eles) throws Ili2dbException {
        if ("smart1".equals(this.config.getInheritanceTrafo())) {
            this.doSmart1(eles);
        } else if ("smart2".equals(this.config.getInheritanceTrafo())) {
            this.doSmart2(eles);
        } else {
            this.doSmartOff(eles);
        }
        Viewable2TableMapping ret = new Viewable2TableMapping();
        for (Element ele : eles) {
            List<ColumnWrapper> props;
            ViewableWrapper wrapper;
            if (!(ele instanceof Viewable)) continue;
            Viewable aclass = (Viewable)ele;
            String inheritanceStrategy = this.trafoConfig.getViewableConfig(aclass, "ch.ehi.ili2db.inheritance");
            if ("newClass".equals(inheritanceStrategy) || "newAndSubClass".equals(inheritanceStrategy)) {
                String baseInheritanceStrategy;
                ViewableWrapper baseWrapper;
                String baseInheritanceStrategy2;
                Viewable base;
                String sqlTablename = this.nameMapping.mapIliClassDef(aclass);
                wrapper = new ViewableWrapper(this.sqlSchemaname, sqlTablename, aclass);
                for (base = (Viewable)aclass.getExtending(); base != null && !"newClass".equals(baseInheritanceStrategy2 = this.trafoConfig.getViewableConfig(base, "ch.ehi.ili2db.inheritance")); base = (Viewable)base.getExtending()) {
                }
                if (base != null && (baseWrapper = ret.get(base)) != wrapper) {
                    wrapper.setExtending(baseWrapper);
                }
                props = new ArrayList<ColumnWrapper>();
                if (aclass instanceof AssociationDef) {
                    this.addProps(wrapper, props, wrapper.getViewable(), this.getRoles((AssociationDef)aclass), null);
                }
                this.addProps(wrapper, props, wrapper.getViewable(), aclass.getDefinedAttributesAndRoles2(), null);
                for (Viewable base2 = (Viewable)aclass.getExtending(); base2 != null && ("subClass".equals(baseInheritanceStrategy = this.trafoConfig.getViewableConfig(base2, "ch.ehi.ili2db.inheritance")) || "newAndSubClass".equals(baseInheritanceStrategy)); base2 = (Viewable)base2.getExtending()) {
                    if (base2 instanceof AssociationDef) {
                        this.addProps(wrapper, props, wrapper.getViewable(), this.getRoles((AssociationDef)base2), null);
                    }
                    this.addProps(wrapper, props, wrapper.getViewable(), base2.getDefinedAttributesAndRoles2(), null);
                }
                wrapper.setAttrv(props);
                if (wrapper.getExtending() != null) {
                    wrapper.setMultipleTypes(false);
                } else {
                    if (Viewable2TableMapper.hasAnyConcreteBaseWithSubClass(this.trafoConfig, aclass)) {
                        wrapper.setMultipleTypes(true);
                    } else if ("newClass".equals(inheritanceStrategy) && Viewable2TableMapper.hasAnyConreteExtension(aclass)) {
                        wrapper.setMultipleTypes(true);
                    } else if ("newAndSubClass".equals(inheritanceStrategy) && Viewable2TableMapper.hasAnyConreteExtensionWithoutNewClass(this.trafoConfig, aclass)) {
                        wrapper.setMultipleTypes(true);
                    } else {
                        wrapper.setMultipleTypes(false);
                    }
                    aclass.getDirectExtensions();
                }
                ret.add(aclass, wrapper);
                continue;
            }
            if ("superClass".equals(inheritanceStrategy)) {
                String baseInheritanceStrategy;
                Viewable base;
                for (base = (Viewable)aclass.getExtending(); base != null && !"newClass".equals(baseInheritanceStrategy = this.trafoConfig.getViewableConfig(base, "ch.ehi.ili2db.inheritance")) && !"newAndSubClass".equals(baseInheritanceStrategy); base = (Viewable)base.getExtending()) {
                }
                wrapper = ret.get(base);
                props = wrapper.getAttrv();
                this.addProps(wrapper, props, wrapper.getViewable(), aclass.getDefinedAttributesAndRoles2(), null);
                wrapper.setAttrv(props);
                ret.add(aclass, wrapper);
                continue;
            }
            if ("subClass".equals(inheritanceStrategy) || "embedded".equals(inheritanceStrategy)) continue;
            throw new IllegalStateException("unexpected inheritance config <" + inheritanceStrategy + ">");
        }
        return ret;
    }

    private Iterator<ViewableTransferElement> getRoles(AssociationDef aclass) {
        ArrayList<ViewableTransferElement> roles = new ArrayList<ViewableTransferElement>();
        Iterator roleIt = aclass.getAttributesAndRoles2();
        while (roleIt.hasNext()) {
            ViewableTransferElement prop = (ViewableTransferElement)roleIt.next();
            if (!(prop.obj instanceof RoleDef) || prop.embedded) continue;
            roles.add(new ViewableTransferElement(prop.obj, false));
        }
        return roles.iterator();
    }

    private void doSmartOff(List<Element> eles) {
        for (Element ele : eles) {
            if (!(ele instanceof Viewable)) continue;
            Viewable aclass = (Viewable)ele;
            if (this.trafoConfig.getViewableConfig(aclass, "ch.ehi.ili2db.inheritance") == null) {
                if (aclass instanceof AssociationDef && TransferFromIli.isLightweightAssociation((AssociationDef)aclass)) {
                    this.trafoConfig.setViewableConfig(aclass, "ch.ehi.ili2db.inheritance", "embedded");
                } else {
                    this.trafoConfig.setViewableConfig(aclass, "ch.ehi.ili2db.inheritance", "newClass");
                }
            }
            String sqlTablename = this.nameMapping.mapIliClassDef(aclass);
            EhiLogger.traceState((String)("viewable " + aclass.getScopedName(null) + " " + this.trafoConfig.getViewableConfig(aclass, "ch.ehi.ili2db.inheritance") + ", " + sqlTablename));
        }
    }

    private void doSmart1(List<Element> eles) {
        for (Element ele : eles) {
            if (!(ele instanceof Viewable)) continue;
            Viewable aclass = (Viewable)ele;
            if (this.trafoConfig.getViewableConfig(aclass, "ch.ehi.ili2db.inheritance") == null) {
                if (aclass instanceof AssociationDef && TransferFromIli.isLightweightAssociation((AssociationDef)aclass)) {
                    this.trafoConfig.setViewableConfig(aclass, "ch.ehi.ili2db.inheritance", "embedded");
                } else if (Viewable2TableMapper.isReferenced(aclass) && Viewable2TableMapper.noBaseIsNewClass(this.trafoConfig, aclass)) {
                    this.trafoConfig.setViewableConfig(aclass, "ch.ehi.ili2db.inheritance", "newClass");
                } else if (aclass.isAbstract()) {
                    this.trafoConfig.setViewableConfig(aclass, "ch.ehi.ili2db.inheritance", "subClass");
                } else {
                    Viewable base = (Viewable)aclass.getExtending();
                    if (base == null || "subClass".equals(this.trafoConfig.getViewableConfig(base, "ch.ehi.ili2db.inheritance"))) {
                        this.trafoConfig.setViewableConfig(aclass, "ch.ehi.ili2db.inheritance", "newClass");
                    } else {
                        this.trafoConfig.setViewableConfig(aclass, "ch.ehi.ili2db.inheritance", "superClass");
                    }
                }
            }
            String sqlTablename = this.nameMapping.mapIliClassDef(aclass);
            EhiLogger.traceState((String)("viewable " + aclass.getScopedName(null) + " " + this.trafoConfig.getViewableConfig(aclass, "ch.ehi.ili2db.inheritance") + ", " + sqlTablename));
        }
    }

    private void doSmart2(List<Element> eles) {
        for (Element ele : eles) {
            if (!(ele instanceof Viewable)) continue;
            Viewable aclass = (Viewable)ele;
            if (this.trafoConfig.getViewableConfig(aclass, "ch.ehi.ili2db.inheritance") == null) {
                if (aclass instanceof AssociationDef && TransferFromIli.isLightweightAssociation((AssociationDef)aclass)) {
                    this.trafoConfig.setViewableConfig(aclass, "ch.ehi.ili2db.inheritance", "embedded");
                } else if (aclass.isAbstract()) {
                    this.trafoConfig.setViewableConfig(aclass, "ch.ehi.ili2db.inheritance", "subClass");
                } else {
                    this.trafoConfig.setViewableConfig(aclass, "ch.ehi.ili2db.inheritance", "newAndSubClass");
                }
            }
            String sqlTablename = this.nameMapping.mapIliClassDef(aclass);
            EhiLogger.traceState((String)("viewable " + aclass.getScopedName(null) + " " + this.trafoConfig.getViewableConfig(aclass, "ch.ehi.ili2db.inheritance") + ", " + sqlTablename));
        }
    }

    private TransferDescription getTransferDescription(Element e) {
        if (this.td == null) {
            this.td = (TransferDescription)e.getContainer(TransferDescription.class);
        }
        return this.td;
    }

    private void addProps(ViewableWrapper table, List<ColumnWrapper> existingColumns, Viewable iliclassOfAttrs, Iterator<ViewableTransferElement> additionalAttrs, StructAttrPath.PathEl[] structAttrPrefix) throws Ili2dbException {
        boolean hasGeometry = false;
        if (this.singleGeom) {
            for (ColumnWrapper propE : existingColumns) {
                AttributeDef attr;
                Type type;
                if (!propE.isIliAttr() || !((type = (attr = (AttributeDef)propE.getViewableTransferElement().obj).getDomainResolvingAliases()) instanceof AbstractCoordType) && !(type instanceof LineType) && (!Ili2cUtility.isMultiSurfaceAttr(this.getTransferDescription((Element)attr), attr) || !this.coalesceMultiSurface && !"coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multiSurfaceTrafo"))) && (!Ili2cUtility.isMultiLineAttr(this.getTransferDescription((Element)attr), attr) || !this.coalesceMultiLine && !"coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multiLineTrafo"))) && (!Ili2cUtility.isMultiPointAttr(this.getTransferDescription((Element)attr), attr) || !this.coalesceMultiPoint && !"coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multiPointTrafo")))) continue;
                hasGeometry = true;
                break;
            }
        }
        structAttrPrefix = structAttrPrefix == null ? new StructAttrPath.PathEl[1] : Arrays.copyOf(structAttrPrefix, structAttrPrefix.length + 1);
        while (additionalAttrs.hasNext()) {
            ViewableTransferElement viewableTransferElement = additionalAttrs.next();
            if (viewableTransferElement.obj instanceof AttributeDef) {
                Type proxyType;
                AttributeDef attr = (AttributeDef)viewableTransferElement.obj;
                if (attr.isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType) continue;
                attr = Viewable2TableMapper.getBaseAttr(iliclassOfAttrs, attr);
                viewableTransferElement.obj = attr;
                for (Integer epsgCode : this.getEpsgCodes(attr)) {
                    String sqlSecondaryTableName = this.trafoConfig.getAttrConfig(iliclassOfAttrs, attr, epsgCode, "ch.ehi.ili2db.secondaryTable");
                    if (sqlSecondaryTableName == null) {
                        sqlSecondaryTableName = this.trafoConfig.getAttrConfig(iliclassOfAttrs, attr, "ch.ehi.ili2db.secondaryTable");
                    }
                    if (sqlSecondaryTableName != null) {
                        ViewableWrapper attrWrapperSecondaryTable = table.getSecondaryTable(sqlSecondaryTableName);
                        if (attrWrapperSecondaryTable == null) {
                            attrWrapperSecondaryTable = table.createSecondaryTable(sqlSecondaryTableName);
                        }
                        ArrayList<ColumnWrapper> attrPropsSecondaryTable = new ArrayList<ColumnWrapper>();
                        ColumnWrapper newProp = new ColumnWrapper(new StructAttrPath(viewableTransferElement), epsgCode);
                        this.addColumn(table, attrPropsSecondaryTable, newProp);
                        attrWrapperSecondaryTable.setAttrv(attrPropsSecondaryTable);
                        continue;
                    }
                    Cardinality cardinality = attr.getDomainOrDerivedDomain().getCardinality();
                    Type type = attr.getDomainResolvingAll();
                    if (type instanceof AbstractCoordType || type instanceof LineType || Ili2cUtility.isMultiSurfaceAttr(this.getTransferDescription((Element)attr), attr) && (this.coalesceMultiSurface || "coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multiSurfaceTrafo"))) || Ili2cUtility.isMultiLineAttr(this.getTransferDescription((Element)attr), attr) && (this.coalesceMultiLine || "coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multiLineTrafo"))) || Ili2cUtility.isMultiPointAttr(this.getTransferDescription((Element)attr), attr) && (this.coalesceMultiPoint || "coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multiPointTrafo")))) {
                        if (epsgCode == null) {
                            throw new Ili2dbException("no CRS for attribute " + attr.getScopedName());
                        }
                        if (this.createItfLineTables && type instanceof SurfaceType) continue;
                        if (this.singleGeom && hasGeometry) {
                            ColumnWrapper newProp = new ColumnWrapper(new StructAttrPath(viewableTransferElement), epsgCode);
                            if (this.columnAlreadyAdded(table, existingColumns, newProp)) continue;
                            sqlSecondaryTableName = this.nameMapping.mapAttributeAsTable(iliclassOfAttrs, attr, epsgCode);
                            ViewableWrapper attrWrapperSecondaryTable = table.getSecondaryTable(sqlSecondaryTableName);
                            if (attrWrapperSecondaryTable == null) {
                                attrWrapperSecondaryTable = table.createSecondaryTable(sqlSecondaryTableName);
                            }
                            ArrayList<ColumnWrapper> attrPropsSecondaryTable = new ArrayList<ColumnWrapper>();
                            this.addColumn(table, attrPropsSecondaryTable, newProp);
                            attrWrapperSecondaryTable.setAttrv(attrPropsSecondaryTable);
                            this.trafoConfig.setAttrConfig(iliclassOfAttrs, attr, epsgCode, "ch.ehi.ili2db.secondaryTable", sqlSecondaryTableName);
                            continue;
                        }
                        hasGeometry = true;
                        structAttrPrefix[structAttrPrefix.length - 1] = new StructAttrPath.PathElAttr(viewableTransferElement);
                        StructAttrPath structAttrPath = new StructAttrPath(structAttrPrefix);
                        this.addColumn(table, existingColumns, new ColumnWrapper(structAttrPath, epsgCode));
                        continue;
                    }
                    if (!(cardinality.getMaximum() <= 1L || type instanceof CompositionType || Ili2cUtility.isJsonMapping(attr) && this.coalesceJson || Ili2cUtility.isArrayAttr(this.td, attr) && this.coalesceArray || Ili2cUtility.isExpandMapping(attr) && this.expandStruct)) {
                        sqlSecondaryTableName = this.nameMapping.mapAttributeAsTable(iliclassOfAttrs, attr, epsgCode);
                        ViewableWrapper secondaryTable = table.createSecondaryTable(sqlSecondaryTableName);
                        this.addColumn(table, secondaryTable.getAttrv(), new ColumnWrapper(new StructAttrPath(viewableTransferElement)));
                        this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.secondaryTable", sqlSecondaryTableName);
                        continue;
                    }
                    if (cardinality.getMaximum() <= (long)ArrayMappings.MAX_ARRAY_EXPAND && Ili2cUtility.isExpandMapping(attr) && this.expandStruct) {
                        if (type instanceof CompositionType) {
                            this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.structTrafo", "expand");
                            long maxIdx = cardinality.getMaximum();
                            int idx = 0;
                            while ((long)idx < maxIdx) {
                                structAttrPrefix[structAttrPrefix.length - 1] = new StructAttrPath.PathElAttr(viewableTransferElement, idx);
                                Table struct = ((CompositionType)type).getComponentType();
                                StructAttrPath.PathEl[] structAttrPrefixProps = Arrays.copyOf(structAttrPrefix, structAttrPrefix.length + 1);
                                structAttrPrefixProps[structAttrPrefixProps.length - 1] = new StructAttrPath.PathElType();
                                StructAttrPath structAttrPath = new StructAttrPath(structAttrPrefixProps);
                                this.addColumn(table, existingColumns, new ColumnWrapper(structAttrPath));
                                this.addProps(table, existingColumns, (Viewable)struct, struct.getDefinedAttributesAndRoles2(), structAttrPrefix);
                                ++idx;
                            }
                            continue;
                        }
                        this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.arrayTrafo", "expand");
                        long maxIdx = cardinality.getMaximum();
                        int idx = 0;
                        while ((long)idx < maxIdx) {
                            structAttrPrefix[structAttrPrefix.length - 1] = new StructAttrPath.PathElAttr(viewableTransferElement, idx);
                            StructAttrPath structAttrPath = new StructAttrPath(structAttrPrefix);
                            this.addColumn(table, existingColumns, new ColumnWrapper(structAttrPath));
                            ++idx;
                        }
                        continue;
                    }
                    structAttrPrefix[structAttrPrefix.length - 1] = new StructAttrPath.PathElAttr(viewableTransferElement);
                    StructAttrPath structAttrPath = new StructAttrPath(structAttrPrefix);
                    this.addColumn(table, existingColumns, new ColumnWrapper(structAttrPath));
                }
                continue;
            }
            if (!(viewableTransferElement.obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)viewableTransferElement.obj;
            AssociationDef roleOwner = (AssociationDef)role.getContainer();
            if (viewableTransferElement.embedded) {
                if (!TransferFromIli.isLightweightAssociation(roleOwner) || roleOwner.getDerivedFrom() != null) continue;
                this.addColumn(table, existingColumns, new ColumnWrapper(new StructAttrPath(viewableTransferElement)));
                continue;
            }
            this.addColumn(table, existingColumns, new ColumnWrapper(new StructAttrPath(viewableTransferElement)));
        }
    }

    private void addColumn(ViewableWrapper current, List<ColumnWrapper> existingProps, ColumnWrapper additionalProp) {
        if (this.columnAlreadyAdded(current, existingProps, additionalProp)) {
            return;
        }
        existingProps.add(additionalProp);
    }

    private boolean columnAlreadyAdded(ViewableWrapper current, List<ColumnWrapper> existingProps, ColumnWrapper additionalProp) {
        for (ColumnWrapper exst : existingProps) {
            if (!this.columnWrapperEquals(additionalProp, exst)) continue;
            return true;
        }
        for (ViewableWrapper secondary : current.getSecondaryTables()) {
            for (ColumnWrapper exst : secondary.getAttrv()) {
                if (!this.columnWrapperEquals(additionalProp, exst)) continue;
                return true;
            }
        }
        for (ViewableWrapper base = current.getExtending(); base != null; base = base.getExtending()) {
            for (ColumnWrapper exst : base.getAttrv()) {
                if (!this.columnWrapperEquals(additionalProp, exst)) continue;
                return true;
            }
            for (ViewableWrapper secondary : base.getSecondaryTables()) {
                for (ColumnWrapper exst : secondary.getAttrv()) {
                    if (!this.columnWrapperEquals(additionalProp, exst)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean columnWrapperEquals(ColumnWrapper col1, ColumnWrapper col2) {
        return this.structAttrPathEquals(col2.getStructAttrPath(), col1.getStructAttrPath()) && this.epsgCodeEqual(col2.getEpsgCode(), col1.getEpsgCode());
    }

    private boolean structAttrPathEquals(StructAttrPath path1, StructAttrPath path2) {
        if (path1 == null && path2 == null) {
            return true;
        }
        if (path1 != null && path2 != null) {
            if (path1.getPath().length != path2.getPath().length) {
                return false;
            }
            for (int i = 0; i < path1.getPath().length; ++i) {
                StructAttrPath.PathEl el1 = path1.getPath()[i];
                StructAttrPath.PathEl el2 = path2.getPath()[i];
                if (el1.getIdx() != el2.getIdx()) {
                    return false;
                }
                if (!el1.getClass().equals(el2.getClass())) {
                    return false;
                }
                if (!(el1 instanceof StructAttrPath.PathElAttr) || this.getRootProp(((StructAttrPath.PathElAttr)el1).getAttr().obj) == this.getRootProp(((StructAttrPath.PathElAttr)el2).getAttr().obj)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean epsgCodeEqual(Integer epsgCode1, Integer epsgCode2) {
        if (epsgCode1 == null && epsgCode2 == null) {
            return true;
        }
        return epsgCode1 != null && epsgCode2 != null && epsgCode1.equals(epsgCode2);
    }

    private Object getRootProp(Object obj) {
        if (obj instanceof AttributeDef) {
            return Ili2cUtility.getRootBaseAttr((AttributeDef)obj);
        }
        if (obj instanceof RoleDef) {
            return Ili2cUtility.getRootBaseRole((RoleDef)obj);
        }
        throw new IllegalArgumentException("unexpected " + obj);
    }

    private static AttributeDef getBaseAttr(Viewable iliclass, AttributeDef attr) {
        AttributeDef baseAttr1;
        AttributeDef baseAttr = attr;
        while ((baseAttr1 = (AttributeDef)baseAttr.getExtending()) != null && ((Viewable)baseAttr1.getContainer()).isExtending((Element)iliclass)) {
            baseAttr = baseAttr1;
        }
        return baseAttr;
    }

    private static boolean noBaseIsNewClass(TrafoConfig trafoConfig, Viewable aclass) {
        for (Viewable base = (Viewable)aclass.getExtending(); base != null; base = (Viewable)base.getExtending()) {
            String baseInheritanceStrategy = trafoConfig.getViewableConfig(base, "ch.ehi.ili2db.inheritance");
            if (!"newClass".equals(baseInheritanceStrategy)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasAnyConcreteBaseWithSubClass(TrafoConfig trafoConfig, Viewable aclass) {
        for (Viewable base = (Viewable)aclass.getExtending(); base != null; base = (Viewable)base.getExtending()) {
            String baseInheritanceStrategy;
            if (base.isAbstract() || !"subClass".equals(baseInheritanceStrategy = trafoConfig.getViewableConfig(base, "ch.ehi.ili2db.inheritance"))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnyConreteExtensionWithoutNewClass(TrafoConfig trafoConfig, Viewable aclass) {
        for (Viewable ext : aclass.getExtensions()) {
            String extInheritanceStrategy;
            if (ext == aclass || ext.isAbstract() || "newClass".equals(extInheritanceStrategy = trafoConfig.getViewableConfig(ext, "ch.ehi.ili2db.inheritance")) || "newAndSubClass".equals(extInheritanceStrategy)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnyConreteExtension(Viewable aclass) {
        for (Viewable ext : aclass.getExtensions()) {
            if (ext == aclass || ext.isAbstract()) continue;
            return true;
        }
        return false;
    }

    private static boolean isReferenced(Viewable viewable) {
        if (viewable instanceof AbstractClassDef) {
            AbstractClassDef aclass = (AbstractClassDef)viewable;
            Iterator rolei = aclass.getDefinedTargetForRoles();
            while (rolei.hasNext()) {
                RoleDef role = (RoleDef)rolei.next();
                AssociationDef assoc = (AssociationDef)role.getContainer();
                if (!assoc.isLightweight()) {
                    return true;
                }
                if (role.isAssociationEmbedded()) continue;
                return true;
            }
        }
        return false;
    }

    private Integer[] getEpsgCodes(AttributeDef attr) {
        TransferDescription td = this.getTransferDescription((Element)attr);
        if (Ili2cUtility.isMultiSurfaceAttr(td, attr)) {
            AttributeDef surfaceAttr;
            MultiSurfaceMappings multiSurfaceAttrs = new MultiSurfaceMappings();
            multiSurfaceAttrs.addMultiSurfaceAttr(attr);
            attr = surfaceAttr = multiSurfaceAttrs.getSurfaceAttr(attr);
        } else if (Ili2cUtility.isMultiLineAttr(td, attr)) {
            AttributeDef polylineAttr;
            MultiLineMappings multiLineAttrs = new MultiLineMappings();
            multiLineAttrs.addMultiLineAttr(attr);
            attr = polylineAttr = multiLineAttrs.getPolylineAttr(attr);
        } else if (Ili2cUtility.isMultiPointAttr(td, attr)) {
            AttributeDef multipointAttr;
            MultiPointMappings multiPointAttrs = new MultiPointMappings();
            multiPointAttrs.addMultiPointAttr(attr);
            attr = multipointAttr = multiPointAttrs.getCoordAttr(attr);
        }
        int[] epsgCodes = TransferFromIli.getEpsgCodes(attr, this.srsModelAssignment, this.defaultCrsCode);
        if (epsgCodes == null) {
            return new Integer[]{null};
        }
        Integer[] ret = new Integer[epsgCodes.length];
        for (int i = 0; i < epsgCodes.length; ++i) {
            ret[i] = epsgCodes[i];
        }
        return ret;
    }
}

