/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.ili2db.base.DbUrlConverter;
import ch.ehi.ili2db.base.Ili2db;
import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.ili2db.base.TableBasedIdGen;
import ch.ehi.ili2db.gui.AbstractDbPanelDescriptor;
import ch.ehi.ili2db.gui.Config;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;

public abstract class AbstractMain {
    private String version = null;

    public abstract String getAPP_NAME();

    public abstract String getDB_PRODUCT_NAME();

    public abstract String getJAR_NAME();

    public abstract AbstractDbPanelDescriptor getDbPanelDescriptor();

    protected abstract void printConnectOptions();

    protected abstract void printSpecificOptions();

    protected abstract int doArgs(String[] var1, int var2, Config var3) throws ParseException;

    public void initConfig(Config config) {
        config.setSender(this.getAPP_NAME() + "-" + this.getVersion());
        config.setIdGenerator(TableBasedIdGen.class.getName());
    }

    public abstract DbUrlConverter getDbUrlConverter();

    public void domain(String[] args) {
        int argi;
        Config config = new Config();
        this.initConfig(config);
        Settings settings = new Settings();
        config.setAppSettings(settings);
        if (args.length == 0) {
            Ili2db.readAppSettings(settings);
            this.runGUI(config);
            Ili2db.writeAppSettings(settings);
            return;
        }
        for (argi = 0; argi < args.length; ++argi) {
            String arg = args[argi];
            if (!arg.equals("--gui")) continue;
            Ili2db.readAppSettings(settings);
            break;
        }
        argi = 0;
        boolean doGui = false;
        try {
            while (argi < args.length) {
                while (argi < args.length) {
                    int oldargi = argi;
                    if ((argi = this.doArgs(args, argi, config)) != oldargi) continue;
                    break;
                }
                if (argi < args.length) {
                    String arg = args[argi];
                    if (arg.equals("--modeldir")) {
                        config.setModeldir(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--models")) {
                        config.setModels(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--exportModels")) {
                        config.setExportModels(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--exportCrsModels")) {
                        config.setCrsExportModels(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--nameLang")) {
                        config.setNameLanguage(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--dataset")) {
                        config.setDatasetName(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--baskets")) {
                        config.setBaskets(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--topics")) {
                        config.setTopics(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--gui")) {
                        doGui = this.parseBooleanArgument(arg);
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--validate")) {
                        if (this.parseBooleanArgument(arg)) {
                            config.setFunction(8);
                        }
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--import")) {
                        if (this.parseBooleanArgument(arg)) {
                            config.setFunction(1);
                        }
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--update")) {
                        if (this.parseBooleanArgument(arg)) {
                            config.setFunction(4);
                        }
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--delete")) {
                        if (this.parseBooleanArgument(arg)) {
                            config.setFunction(5);
                        }
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--replace")) {
                        if (this.parseBooleanArgument(arg)) {
                            config.setFunction(6);
                        }
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--export")) {
                        if (this.parseBooleanArgument(arg)) {
                            config.setFunction(3);
                        }
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--exportMetaConfig")) {
                        if (this.parseBooleanArgument(arg)) {
                            config.setFunction(9);
                        }
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--export3")) {
                        if (this.parseBooleanArgument(arg)) {
                            config.setFunction(3);
                            config.setVer3_export(true);
                        }
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--schemaimport")) {
                        if (this.parseBooleanArgument(arg)) {
                            config.setFunction(2);
                        }
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--preScript")) {
                        config.setPreScript(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--postScript")) {
                        config.setPostScript(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--deleteData")) {
                        if (this.parseBooleanArgument(arg)) {
                            config.setDeleteMode("data");
                        }
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--trace")) {
                        EhiLogger.getInstance().setTraceFilter(!this.parseBooleanArgument(arg));
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--dbparams")) {
                        config.setDbParams(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--dropscript")) {
                        config.setDropscript(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--createscript")) {
                        config.setCreatescript(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--log")) {
                        config.setLogfile(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--logtime")) {
                        ++argi;
                        config.setLogtime(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (arg.equals("--xtflog")) {
                        config.setXtfLogfile(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--defaultSrsAuth")) {
                        String auth;
                        if ((auth = args[++argi]).equalsIgnoreCase("NULL")) {
                            auth = null;
                        }
                        config.setDefaultSrsAuthority(auth);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--defaultSrsCode")) {
                        config.setDefaultSrsCode(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--modelSrsCode")) {
                        config.setModelSrsCode(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--multiSrs")) {
                        config.setUseEpsgInNames(this.parseBooleanArgument(arg));
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--domains")) {
                        config.setDomainAssignments(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--altSrsModel")) {
                        config.setSrsModelAssignment(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--attachmentsPath")) {
                        config.setAttachmentsPath(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--validConfig")) {
                        config.setValidConfigFile(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--metaConfig")) {
                        config.setMetaConfigFile(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--disableValidation")) {
                        ++argi;
                        config.setValidation(!this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--disableAreaValidation")) {
                        ++argi;
                        config.setDisableAreaValidation(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--disableRounding")) {
                        ++argi;
                        config.setDisableRounding(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--disableBoundaryRecoding")) {
                        ++argi;
                        config.setRepairTouchingLines(!this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--forceTypeValidation")) {
                        ++argi;
                        config.setOnlyMultiplicityReduction(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--createSingleEnumTab")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setCreateEnumDefs("singleTable");
                        continue;
                    }
                    if (this.isOption(arg, "--createEnumTabs")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setCreateEnumDefs("multiTable");
                        continue;
                    }
                    if (this.isOption(arg, "--createEnumTabsWithId")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setCreateEnumDefs("multiTableWithId");
                        continue;
                    }
                    if (this.isOption(arg, "--createEnumTxtCol")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setCreateEnumCols("addTxtCol");
                        continue;
                    }
                    if (this.isOption(arg, "--createEnumColAsItfCode")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setValue("ch.ehi.ili2db.createEnumColAsItfCode", "yes");
                        continue;
                    }
                    if (this.isOption(arg, "--beautifyEnumDispName")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setBeautifyEnumDispName("underscore");
                        continue;
                    }
                    if (this.isOption(arg, "--noSmartMapping")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        Ili2db.setNoSmartMapping(config);
                        continue;
                    }
                    if (this.isOption(arg, "--smart1Inheritance")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setInheritanceTrafo("smart1");
                        continue;
                    }
                    if (this.isOption(arg, "--smart2Inheritance")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setInheritanceTrafo("smart2");
                        continue;
                    }
                    if (this.isOption(arg, "--coalesceCatalogueRef")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setCatalogueRefTrafo("coalesce");
                        continue;
                    }
                    if (this.isOption(arg, "--coalesceMultiSurface")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setMultiSurfaceTrafo("coalesce");
                        continue;
                    }
                    if (this.isOption(arg, "--coalesceMultiLine")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setMultiLineTrafo("coalesce");
                        continue;
                    }
                    if (this.isOption(arg, "--coalesceMultiPoint")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setMultiPointTrafo("coalesce");
                        continue;
                    }
                    if (this.isOption(arg, "--coalesceArray")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setArrayTrafo("coalesce");
                        continue;
                    }
                    if (this.isOption(arg, "--coalesceJson")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setJsonTrafo("coalesce");
                        continue;
                    }
                    if (this.isOption(arg, "--expandStruct")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setStructTrafo("expand");
                        continue;
                    }
                    if (this.isOption(arg, "--expandMultilingual")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setMultilingualTrafo("expand");
                        continue;
                    }
                    if (this.isOption(arg, "--expandLocalised")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setLocalisedTrafo("expand");
                        continue;
                    }
                    if (this.isOption(arg, "--createFk")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setCreateFk("yes");
                        continue;
                    }
                    if (this.isOption(arg, "--createFkIdx")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setCreateFkIdx("yes");
                        continue;
                    }
                    if (this.isOption(arg, "--createUnique")) {
                        ++argi;
                        config.setCreateUniqueConstraints(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--createNumChecks")) {
                        ++argi;
                        config.setCreateNumChecks(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--createTextChecks")) {
                        ++argi;
                        config.setCreateTextChecks(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--createDateTimeChecks")) {
                        ++argi;
                        config.setCreateDateTimeChecks(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--createMandatoryChecks")) {
                        ++argi;
                        config.setCreateMandatoryChecks(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--createImportTabs")) {
                        ++argi;
                        config.setCreateImportTabs(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--createStdCols")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setCreateStdCols("all");
                        continue;
                    }
                    if (arg.equals("--t_id_Name")) {
                        config.setColT_ID(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--idSeqMin")) {
                        config.setMinIdSeqValue(Long.parseLong(args[++argi]));
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--idSeqMax")) {
                        config.setMaxIdSeqValue(Long.parseLong(args[++argi]));
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--createTypeDiscriminator")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setCreateTypeDiscriminator("always");
                        continue;
                    }
                    if (this.isOption(arg, "--createGeomIdx")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setValue("ch.ehi.sqlgen.createGeomIndex", "True");
                        continue;
                    }
                    if (this.isOption(arg, "--disableNameOptimization")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setNameOptimization("disable");
                        continue;
                    }
                    if (this.isOption(arg, "--nameByTopic")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setNameOptimization("topic");
                        continue;
                    }
                    if (arg.equals("--maxNameLength")) {
                        config.setMaxSqlNameLength(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--sqlColsAsText")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setSqlColsAsText("enable");
                        continue;
                    }
                    if (this.isOption(arg, "--sqlEnableNull")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setSqlNull("enable");
                        continue;
                    }
                    if (this.isOption(arg, "--sqlExtRefCols")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setSqlExtRefCols("enable");
                        continue;
                    }
                    if (this.isOption(arg, "--strokeArcs")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        Config.setStrokeArcs(config, "enable");
                        continue;
                    }
                    if (this.isOption(arg, "--skipPolygonBuilding")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        Ili2db.setSkipPolygonBuilding(config);
                        continue;
                    }
                    if (this.isOption(arg, "--skipPolygonBuildingErrors")) {
                        ++argi;
                        config.setSkipGeometryErrors(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--skipReferenceErrors")) {
                        ++argi;
                        config.setSkipReferenceErrors(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--skipGeometryErrors")) {
                        ++argi;
                        config.setSkipGeometryErrors(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--keepAreaRef")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setAreaRef("keep");
                        continue;
                    }
                    if (this.isOption(arg, "--createTidCol")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setTidHandling("property");
                        continue;
                    }
                    if (this.isOption(arg, "--importTid")) {
                        ++argi;
                        config.setImportTid(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--exportTid")) {
                        ++argi;
                        config.setExportTid(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--importBid")) {
                        ++argi;
                        config.setImportBid(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--exportFetchSize")) {
                        config.setFetchSize(Integer.parseInt(args[++argi]));
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--importBatchSize")) {
                        config.setBatchSize(Integer.parseInt(args[++argi]));
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--createBasketCol")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setBasketHandling("readWrite");
                        continue;
                    }
                    if (this.isOption(arg, "--createDatasetCol")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setCreateDatasetCols("addDatasetCol");
                        continue;
                    }
                    if (this.isOption(arg, "--ILIGML20")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setTransferFileFormat("ILIGML20");
                        continue;
                    }
                    if (this.isOption(arg, "--ver4-noSchemaImport")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setDoImplicitSchemaImport(false);
                        EhiLogger.logAdaption((String)"--ver4-noSchemaImport is a deprecated option");
                        continue;
                    }
                    if (this.isOption(arg, "--doSchemaImport")) {
                        ++argi;
                        config.setDoImplicitSchemaImport(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--ver4-translation")) {
                        ++argi;
                        if (!this.parseBooleanArgument(arg)) continue;
                        config.setVer3_translation(false);
                        EhiLogger.logAdaption((String)"--ver4-translation is a deprecated option");
                        continue;
                    }
                    if (this.isOption(arg, "--ver3-translation")) {
                        ++argi;
                        config.setVer3_translation(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (arg.equals("--translation")) {
                        config.setIli1Translation(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--proxy")) {
                        config.setValue("ch.interlis.ili2c.http_proxy_host", args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--proxyPort")) {
                        config.setValue("ch.interlis.ili2c.http_proxy_port", args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--createMetaInfo")) {
                        ++argi;
                        config.setCreateMetaInfo(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (this.isOption(arg, "--createNlsTab")) {
                        ++argi;
                        config.setCreateNlsTab(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (arg.equals("--version")) {
                        this.printVersion();
                        return;
                    }
                    if (arg.equals("--iliMetaAttrs")) {
                        config.setIliMetaAttrsFile(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (this.isOption(arg, "--createTypeConstraint")) {
                        ++argi;
                        config.setCreateTypeConstraint(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (arg.equals("--verbose")) {
                        ++argi;
                        config.setVerbose(this.parseBooleanArgument(arg));
                        continue;
                    }
                    if (arg.equals("--plugins")) {
                        config.setPluginsFolder(args[++argi]);
                        ++argi;
                        continue;
                    }
                    if (arg.equals("--help")) {
                        this.printVersion();
                        System.err.println();
                        this.printDescription();
                        System.err.println();
                        this.printUsage();
                        System.err.println();
                        System.err.println("OPTIONS");
                        System.err.println();
                        System.err.println("--import               do an import.");
                        System.err.println("--update               do an update.");
                        System.err.println("--replace              do a replace.");
                        System.err.println("--delete               do a delete.");
                        System.err.println("--export               do an export.");
                        System.err.println("--validate             validates the data in the db (without export).");
                        System.err.println("--schemaimport         do a schema import.");
                        System.err.println("--exportMetaConfig     exports a Meta-Config file of an existing db.");
                        System.err.println("--preScript file       before running a function, run a script.");
                        System.err.println("--postScript file      after running a function, run a script.");
                        System.err.println("--dbparams file        config file with connection parameters.");
                        this.printConnectOptions();
                        System.err.println("--metaConfig file      Meta-Config file for ili2db.");
                        System.err.println("--validConfig file     Config file for validation.");
                        System.err.println("--disableValidation    Disable validation of data.");
                        System.err.println("--disableAreaValidation Disable AREA validation.");
                        System.err.println("--forceTypeValidation  restrict customization of validation related to \"multiplicity\"");
                        System.err.println("--disableBoundaryRecoding disables the correction of self touching lines");
                        System.err.println("--disableRounding      Disable rounding of import/export data.");
                        System.err.println("--deleteData           on schema/data import, delete existing data from existing tables.");
                        System.err.println("--defaultSrsAuth  auth Default SRS authority " + config.getDefaultSrsAuthority());
                        System.err.println("--defaultSrsCode  code Default SRS code");
                        System.err.println("--modelSrsCode  model=code SRS code per model");
                        System.err.println("--multiSrs             create a DB schema that supports multiple SRS codes");
                        System.err.println("--domains genericDomain=concreteDomain overrides the generic domain assignments on export");
                        System.err.println("--altSrsModel originalSrsModel=alternativeSrsModel assigns a model with an alternative SRS (but same structure as orinal model)");
                        System.err.println("--modeldir  path       Path(s) of directories containing ili-files.");
                        System.err.println("--models modelname     Name(s) of ili-models to generate an db schema for.");
                        System.err.println("--dataset name         Name of dataset.");
                        System.err.println("--baskets BID          Basket-Id(s) of ili-baskets to export.");
                        System.err.println("--topics topicname     Name(s) of ili-topics to export.");
                        System.err.println("--createscript filename  Generate a sql script that creates the db schema.");
                        System.err.println("--dropscript filename  Generate a sql script that drops the generated db schema.");
                        System.err.println("--noSmartMapping       disable all smart mappings");
                        System.err.println("--smart1Inheritance     enable smart1 mapping of class/structure inheritance");
                        System.err.println("--smart2Inheritance     enable smart2 mapping of class/structure inheritance");
                        System.err.println("--coalesceCatalogueRef enable smart mapping of CHBase:CatalogueReference");
                        System.err.println("--coalesceMultiSurface enable smart mapping of CHBase:MultiSurface");
                        System.err.println("--coalesceMultiLine    enable smart mapping of CHBase:MultiLine");
                        System.err.println("--coalesceMultiPoint   enable smart mapping of MultiPoint structures");
                        System.err.println("--coalesceArray        enable smart mapping of ARRAY structures");
                        System.err.println("--coalesceJson         enable smart mapping of JSON structures");
                        System.err.println("--expandStruct         enable unfolding/expanding of structures");
                        System.err.println("--expandMultilingual   enable smart mapping of CHBase:MultilingualText");
                        System.err.println("--expandLocalised      enable smart mapping of CHBase:LocalisedText");
                        System.err.println("--createGeomIdx        create a spatial index on geometry columns.");
                        System.err.println("--createEnumColAsItfCode create enum type column with value according to ITF (instead of XTF).");
                        System.err.println("--createEnumTxtCol     create an additional column with the text of the enumeration value.");
                        System.err.println("--createEnumTabs       generate tables for enum definitions and use xtfcode to reference entries in generated enum tables.");
                        System.err.println("--createEnumTabsWithId generate tables with T_Id for enum definitions and use ids to reference entries in generated enum tables.");
                        System.err.println("--createSingleEnumTab  generate all enum definitions in a single table.");
                        System.err.println("--beautifyEnumDispName replace underscore with space in dispName of enum table entries");
                        System.err.println("--createStdCols        generate T_User, T_CreateDate, T_LastChange columns.");
                        System.err.println("--t_id_Name name       change name of t_id column (T_Id)");
                        System.err.println("--idSeqMin minValue    sets the minimum value of the id sequence generator.");
                        System.err.println("--idSeqMax maxValue    sets the maximum value of the id sequence generator.");
                        System.err.println("--createTypeDiscriminator  generate always a type discriminator column.");
                        System.err.println("--disableNameOptimization disable use of unqualified class name as table name.");
                        System.err.println("--nameByTopic          use topic+class name as table name.");
                        System.err.println("--nameLang lang        use names of ili model in given language as table/column name.");
                        System.err.println("--maxNameLength length max length of sql names (" + config.getMaxSqlNameLength() + ")");
                        System.err.println("--sqlEnableNull        create no NOT NULL constraints in db schema.");
                        System.err.println("--sqlColsAsText        Every simple-type attribute will be mapped to a text column, to enable the import of invalid data");
                        System.err.println("--sqlExtRefCols        external references will be mapped to a column with the ili OID domain, to enable the import of not available objects");
                        System.err.println("--strokeArcs           stroke ARCS on import.");
                        System.err.println("--skipPolygonBuilding  keep linetables; don't build polygons on import.");
                        System.err.println("--skipReferenceErrors  ignore/do not report reference errors.");
                        System.err.println("--skipGeometryErrors   ignore/do not report geometry errors.");
                        System.err.println("--keepAreaRef          keep areaRef as additional column on import.");
                        System.err.println("--createTidCol         create an additional column T_Ili_Tid");
                        System.err.println("--importTid            read transient TIDs into column T_Ili_Tid");
                        System.err.println("--exportTid            write transient TIDs from column T_Ili_Tid");
                        System.err.println("--importBid            read transient BIDs into T_ILI2DB_BASKET.T_Ili_Tid");
                        System.err.println("--exportFetchSize nrOfRecords      set the fetch size for the SQL query statements");
                        System.err.println("--importBatchSize nrOfRecords     set the batch size for the SQL insert/update statements");
                        System.err.println("--createImportTabs     create tables with import statistics. (T_ILI2DB_IMPORT)");
                        System.err.println("--createBasketCol      generate T_basket column.");
                        System.err.println("--createDatasetCol     generate T_datasetname column (Requires --dataset)");
                        System.err.println("--createFk             generate foreign key constraints.");
                        System.err.println("--createFkIdx          create an index on foreign key columns.");
                        System.err.println("--createUnique         create UNIQUE db constraints.");
                        System.err.println("--createNumChecks      create CHECK db constraints for numeric data types.");
                        System.err.println("--createTextChecks     create CHECK db constraints for text data types.");
                        System.err.println("--createDateTimeChecks create CHECK db constraints for date/time data types.");
                        System.err.println("--createMandatoryChecks create CHECK db constraints for MANDATORY attributes.");
                        System.err.println("--ILIGML20             use eCH-0118-2.0 as transferformat");
                        System.err.println("--exportModels modelname  export data according to the given base ili-models");
                        System.err.println("--exportCrsModels modelname  export data according to the given ili-model (with alternate CRS)");
                        System.err.println("--ver4-noSchemaImport  do no implicit schema import during data import");
                        System.err.println("--doSchemaImport       do implicit schema import during data import");
                        System.err.println("--ver4-translation     supports TRANSLATION OF in ili2db 4.x mode (incompatible with ili2db 3.x versions).");
                        System.err.println("--ver3-translation     supports TRANSLATION OF in ili2db 3.x mode (incompatible with ili2db 4.x versions).");
                        System.err.println("--translation translatedModel=originModel assigns a translated model to its orginal language equivalent.");
                        System.err.println("--createMetaInfo       Create aditional ili-model information.");
                        System.err.println("--createNlsTab         Create a helper table with multilingual data about model elements.");
                        System.err.println("--iliMetaAttrs file    Import meta-attributes from a .toml file (Requires --createMetaInfo)");
                        System.err.println("--createTypeConstraints   Create CHECK constraint on t_type columns.");
                        System.err.println("--plugins folder       directory with jar files that contain user defined functions.");
                        this.printSpecificOptions();
                        System.err.println("--proxy host           proxy server to access model repositories.");
                        System.err.println("--proxyPort port       proxy port to access model repositories.");
                        System.err.println("--log filename         log messages to given file.");
                        System.err.println("--logtime              include timestamps in logfile.");
                        System.err.println("--xtflog filename      log messages to given XTF file.");
                        System.err.println("--verbose              print additional information in validation results.");
                        System.err.println("--gui                  start GUI.");
                        System.err.println("--trace                enable trace messages.");
                        System.err.println("--help                 Display this help text.");
                        System.err.println("--version              Display the version of " + this.getAPP_NAME());
                        System.err.println();
                        return;
                    }
                    if (arg.startsWith("-")) {
                        EhiLogger.logError((String)(arg + ": unknown option"));
                        System.exit(1);
                        continue;
                    }
                    if (argi + 1 < args.length) {
                        EhiLogger.logError((String)(arg + ": invalid placed argument"));
                        System.exit(1);
                        continue;
                    }
                }
                break;
            }
        }
        catch (ParseException ex) {
            EhiLogger.logError((Throwable)ex);
            System.exit(1);
        }
        if (config.getFunction() == 0 && (config.getCreatescript() != null || config.getDropscript() != null)) {
            config.setFunction(7);
        }
        if (argi + 1 == args.length) {
            String xtfFilename = args[argi];
            config.setXtffile(xtfFilename);
            if (Ili2db.isItfFilename(xtfFilename)) {
                config.setItfTransferfile(true);
            }
        }
        if (doGui) {
            this.runGUI(config);
            Ili2db.writeAppSettings(settings);
        } else {
            try {
                if (config.getFunction() != 7) {
                    String dbUrl = this.getDbUrlConverter().makeUrl(config);
                    config.setDburl(dbUrl);
                    if (dbUrl == null) {
                        this.printConnectOptions();
                        throw new Ili2dbException("incomplete DB connect options given");
                    }
                }
                if (config.getFunction() != 7) {
                    Ili2db.readSettingsFromDb(config);
                }
                Ili2db.run(config, this.getAPP_HOME());
            }
            catch (Exception ex) {
                EhiLogger.logError((Throwable)ex);
                System.exit(1);
            }
        }
    }

    protected boolean parseBooleanArgument(String arg) throws ParseException {
        int indexEquals = arg.indexOf(61);
        if (indexEquals >= 0) {
            String value = arg.substring(indexEquals + 1);
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
            String errorMessage = String.format("Could not parse boolean value <%s> for option <%s>.", value, arg.substring(0, indexEquals));
            EhiLogger.logAdaption((String)errorMessage);
            throw new ParseException(errorMessage, indexEquals + 1);
        }
        return true;
    }

    protected boolean isOption(String arg, String optionName) {
        return arg.equals(optionName) || arg.startsWith(optionName + '=');
    }

    private void printVersion() {
        System.err.println("INTERLIS 2-loader for " + this.getDB_PRODUCT_NAME() + ", Version " + this.getVersion());
        System.err.println("  Developed by Eisenhut Informatik AG, CH-3401 Burgdorf");
        System.err.println("  See http://www.interlis.ch for information about INTERLIS");
        System.err.println("  Parts of this program have been generated by ANTLR; see http://www.antlr.org");
        System.err.println("  This product includes software developed by the");
        System.err.println("  Apache Software Foundation (http://www.apache.org/).");
    }

    private void printDescription() {
        System.err.println("DESCRIPTION");
        System.err.println("  Translates INTERLIS 2 data model definitions to a " + this.getDB_PRODUCT_NAME() + " schema.");
        System.err.println("  Loads INTERLIS 2 data into a " + this.getDB_PRODUCT_NAME() + " database.");
        System.err.println("  Unloads INTERLIS 2 data from a " + this.getDB_PRODUCT_NAME() + " database.");
    }

    private void printUsage() {
        System.err.println("USAGE");
        System.err.println("  java -jar " + this.getJAR_NAME() + " [Options] [file.xtf]");
    }

    public String getVersion() {
        if (this.version == null) {
            java.util.ResourceBundle resVersion = java.util.ResourceBundle.getBundle(ResourceBundle.class2qpackageName(AbstractMain.class) + ".Version");
            StringBuffer ret = new StringBuffer(20);
            ret.append(resVersion.getString("version"));
            ret.append('-');
            ret.append(resVersion.getString("versionCommit"));
            this.version = ret.toString();
        }
        return this.version;
    }

    public String getAPP_HOME() {
        int start;
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf(this.getJAR_NAME());
        if (index > (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            return classpath.substring(start, index - 1);
        }
        return null;
    }

    public boolean runGUI(Config config) {
        Class<?> dialogClass = null;
        try {
            dialogClass = Class.forName(AbstractMain.preventOptimziation("ch.ehi.ili2db.gui.MainWizard"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Method mainFrameShowDialog = null;
        if (dialogClass != null) {
            try {
                mainFrameShowDialog = dialogClass.getMethod("showDialog", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (mainFrameShowDialog != null) {
            try {
                Object dialog = dialogClass.newInstance();
                Object ret = mainFrameShowDialog.invoke(dialog, new Object[0]);
                return (Boolean)ret;
            }
            catch (IllegalArgumentException ex) {
                EhiLogger.logError((String)"failed to open GUI", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                EhiLogger.logError((String)"failed to open GUI", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                EhiLogger.logError((String)"failed to open GUI", (Throwable)ex);
            }
            catch (InstantiationException ex) {
                EhiLogger.logError((String)"failed to open GUI", (Throwable)ex);
            }
        } else {
            EhiLogger.logError((String)(this.getAPP_NAME() + ": no GUI available"));
        }
        return false;
    }

    private static String preventOptimziation(String val) {
        StringBuffer buf = new StringBuffer(val.length());
        buf.append(val);
        return buf.toString();
    }
}

