/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.dbmetainfo;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.ili2db.base.Ili2db;
import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.ili2db.dbmetainfo.ColKey;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import ch.ehi.sqlgen.repository.DbTableName;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class DbExtMetaInfo {
    public static final String TAG_COL_FOREIGNKEY = "ch.ehi.ili2db.foreignKey";
    public static final String TAG_COL_ENUMDOMAIN = "ch.ehi.ili2db.enumDomain";
    public static final String TAG_COL_UNIT = "ch.ehi.ili2db.unit";
    public static final String TAG_COL_TYPEKIND = "ch.ehi.ili2db.typeKind";
    public static final String TAG_COL_TYPEKIND_MTEXT = "MTEXT";
    public static final String TAG_COL_TYPEKIND_TEXT = "TEXT";
    public static final String TAG_COL_TYPEKIND_URI = "URI";
    public static final String TAG_COL_TYPEKIND_NAME = "NAME";
    public static final String TAG_COL_TYPEKIND_ENUM = "ENUM";
    public static final String TAG_COL_TYPEKIND_ENUMTREE = "ENUMTREE";
    public static final String TAG_COL_TYPEKIND_BOOLEAN = "BOOLEAN";
    public static final String TAG_COL_TYPEKIND_NUMERIC = "NUMERIC";
    public static final String TAG_COL_TYPEKIND_FORMATTED = "FORMATTED";
    public static final String TAG_COL_TYPEKIND_DATE = "DATE";
    public static final String TAG_COL_TYPEKIND_TIMEOFDAY = "TIMEOFDAY";
    public static final String TAG_COL_TYPEKIND_DATETIME = "DATETIME";
    public static final String TAG_COL_TYPEKIND_COORD = "COORD";
    public static final String TAG_COL_TYPEKIND_MULTICOORD = "MULTICOORD";
    public static final String TAG_COL_TYPEKIND_OID = "OID";
    public static final String TAG_COL_TYPEKIND_XML = "XML";
    public static final String TAG_COL_TYPEKIND_BINARY = "BINARY";
    public static final String TAG_COL_TYPEKIND_CLASSQNAME = "CLASSQNAME";
    public static final String TAG_COL_TYPEKIND_ATTRIBUTEQNAME = "ATTRIBUTEQNAME";
    public static final String TAG_COL_TYPEKIND_POLYLINE = "POLYLINE";
    public static final String TAG_COL_TYPEKIND_SURFACE = "SURFACE";
    public static final String TAG_COL_TYPEKIND_AREA = "AREA";
    public static final String TAG_COL_TYPEKIND_MULTIPOLYLINE = "MULTIPOLYLINE";
    public static final String TAG_COL_TYPEKIND_MULTISURFACE = "MULTISURFACE";
    public static final String TAG_COL_TYPEKIND_MULTIAREA = "MULTIAREA";
    public static final String TAG_COL_TYPEKIND_REFERENCE = "REFERENCE";
    public static final String TAG_COL_TYPEKIND_STRUCTURE = "STRUCTURE";
    public static final String TAG_COL_TEXTKIND = "ch.ehi.ili2db.textKind";
    public static final String TAG_COL_TEXTKIND_MTEXT = "MTEXT";
    public static final String TAG_COL_DISPNAME = "ch.ehi.ili2db.dispName";
    public static final String TAG_COL_C1_MIN = "ch.ehi.ili2db.c1Min";
    public static final String TAG_COL_C1_MAX = "ch.ehi.ili2db.c1Max";
    public static final String TAG_COL_C2_MIN = "ch.ehi.ili2db.c2Min";
    public static final String TAG_COL_C2_MAX = "ch.ehi.ili2db.c2Max";
    public static final String TAG_COL_C3_MIN = "ch.ehi.ili2db.c3Min";
    public static final String TAG_COL_C3_MAX = "ch.ehi.ili2db.c3Max";
    public static final String TAG_COL_GEOMTYPE = "ch.ehi.ili2db.geomType";
    public static final String TAG_COL_SRID = "ch.ehi.ili2db.srid";
    public static final String TAG_COL_COORDDIMENSION = "ch.ehi.ili2db.coordDimension";
    public static final String TAG_COL_TYPES = "ch.ehi.ili2db.types";
    public static final String TAG_COL_OIDDOMAIN = "ch.ehi.ili2db.oidDomain";
    public static final String TAG_TAB_TABLEKIND = "ch.ehi.ili2db.tableKind";
    public static final String TAG_TAB_TABLEKIND_ENUM = "ENUM";
    public static final String TAG_TAB_TABLEKIND_SECONDARY = "SECONDARY";
    public static final String TAG_TAB_TABLEKIND_CLASS = "CLASS";
    public static final String TAG_TAB_TABLEKIND_ASSOCIATION = "ASSOCIATION";
    public static final String TAG_TAB_TABLEKIND_STRUCTURE = "STRUCTURE";
    public static final String TAG_TAB_TABLEKIND_CATALOGUE = "CATALOGUE";
    public static final String TAG_TAB_DISPNAME = "ch.ehi.ili2db.dispName";
    HashMap<ColKey, HashMap<String, String>> colInfo = new HashMap();
    HashMap<String, HashMap<String, String>> tabInfo = new HashMap();

    public void setColumnInfo(String table, String column, String tag, String value) {
        this.setColumnInfo(table, null, column, tag, value);
    }

    public void setColumnInfo(String table, String subtype, String column, String tag, String value) {
        ColKey key = new ColKey(table, subtype, column);
        HashMap<String, String> info = this.colInfo.get(key);
        if (info == null) {
            info = new HashMap();
            this.colInfo.put(key, info);
        }
        info.put(tag, value);
    }

    public void setTableInfo(String table, String tag, String value) {
        HashMap<String, String> info = this.tabInfo.get(table);
        if (info == null) {
            info = new HashMap();
            this.tabInfo.put(table, info);
        }
        info.put(tag, value);
    }

    public void updateMetaInfoTables(GeneratorJdbc gen, Connection conn, String schemaName) throws Ili2dbException {
        this.saveColumnTab(gen, conn, schemaName);
        this.saveTableTab(gen, conn, schemaName);
    }

    private void saveColumnTab(GeneratorJdbc gen, Connection conn, String schemaName) throws Ili2dbException {
        DbTableName tabName = new DbTableName(schemaName, "T_ILI2DB_COLUMN_PROP");
        String sqlName = tabName.getQName();
        if (conn != null) {
            HashMap<ColKey, HashMap<String, String>> exstEntries = this.readColumnTab(conn, sqlName);
            try {
                String insStmt = "INSERT INTO " + sqlName + " (" + "tablename" + "," + "subtype" + "," + "columnname" + "," + "tag" + "," + "setting" + ") VALUES (?,?,?,?,?)";
                EhiLogger.traceBackendCmd((String)insStmt);
                try (PreparedStatement insPrepStmt = conn.prepareStatement(insStmt);){
                    for (ColKey colKey : this.colInfo.keySet()) {
                        HashMap<String, String> exstValues = exstEntries.get(colKey);
                        if (exstValues == null) {
                            exstValues = new HashMap();
                        }
                        HashMap<String, String> newValues = this.colInfo.get(colKey);
                        for (String tag : newValues.keySet()) {
                            if (exstValues.containsKey(tag)) continue;
                            String value = newValues.get(tag);
                            insPrepStmt.setString(1, colKey.getTable());
                            insPrepStmt.setString(2, colKey.getSubtype());
                            insPrepStmt.setString(3, colKey.getColumn());
                            insPrepStmt.setString(4, tag);
                            insPrepStmt.setString(5, value);
                            insPrepStmt.executeUpdate();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to update meta-info table " + sqlName, ex);
            }
        }
        if (gen != null) {
            for (ColKey colKey : this.colInfo.keySet()) {
                HashMap<String, String> newValues = this.colInfo.get(colKey);
                for (String tag : newValues.keySet()) {
                    String value = newValues.get(tag);
                    String subtype = colKey.getSubtype();
                    String insStmt = "INSERT INTO " + sqlName + " (" + "tablename" + "," + "subtype" + "," + "columnname" + "," + "tag" + "," + "setting" + ") VALUES (" + Ili2db.quoteSqlStringValue(colKey.getTable()) + "," + Ili2db.quoteSqlStringValue(subtype) + "," + Ili2db.quoteSqlStringValue(colKey.getColumn()) + "," + Ili2db.quoteSqlStringValue(tag) + "," + Ili2db.quoteSqlStringValue(value) + ")";
                    GeneratorJdbc generatorJdbc = gen;
                    generatorJdbc.getClass();
                    gen.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt(generatorJdbc, insStmt));
                }
            }
        }
    }

    private HashMap<ColKey, HashMap<String, String>> readColumnTab(Connection conn, String sqlName) throws Ili2dbException {
        HashMap<ColKey, HashMap<String, String>> exstEntries = new HashMap<ColKey, HashMap<String, String>>();
        try {
            String selStmt = "SELECT tablename,subtype,columnname,tag,setting FROM " + sqlName;
            EhiLogger.traceBackendCmd((String)selStmt);
            PreparedStatement selPrepStmt = null;
            ResultSet rs = null;
            try {
                selPrepStmt = conn.prepareStatement(selStmt);
                rs = selPrepStmt.executeQuery();
                while (rs.next()) {
                    String table = rs.getString(1);
                    String subtype = rs.getString(2);
                    String col = rs.getString(3);
                    String tag = rs.getString(4);
                    String val = rs.getString(5);
                    ColKey colKey = new ColKey(table, subtype, col);
                    HashMap<String, String> exstValues = exstEntries.get(colKey);
                    if (exstValues == null) {
                        exstValues = new HashMap();
                        exstEntries.put(colKey, exstValues);
                    }
                    exstValues.put(tag, val);
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to read meta info values from " + sqlName, ex);
            }
            finally {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (selPrepStmt != null) {
                    selPrepStmt.close();
                    selPrepStmt = null;
                }
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to read meta-info table " + sqlName, ex);
        }
        return exstEntries;
    }

    private void saveTableTab(GeneratorJdbc gen, Connection conn, String schemaName) throws Ili2dbException {
        DbTableName tabName = new DbTableName(schemaName, "T_ILI2DB_TABLE_PROP");
        String sqlName = tabName.getQName();
        if (conn != null) {
            HashMap<String, HashMap<String, String>> exstEntries = this.readTableTab(conn, sqlName);
            try {
                String insStmt = "INSERT INTO " + sqlName + " (" + "tablename" + "," + "tag" + "," + "setting" + ") VALUES (?,?,?)";
                EhiLogger.traceBackendCmd((String)insStmt);
                try (PreparedStatement insPrepStmt = conn.prepareStatement(insStmt);){
                    for (String table : this.tabInfo.keySet()) {
                        HashMap<String, String> exstValues = exstEntries.get(table);
                        if (exstValues == null) {
                            exstValues = new HashMap();
                        }
                        HashMap<String, String> newValues = this.tabInfo.get(table);
                        for (String tag : newValues.keySet()) {
                            if (exstValues.containsKey(tag)) continue;
                            String value = newValues.get(tag);
                            insPrepStmt.setString(1, table);
                            insPrepStmt.setString(2, tag);
                            insPrepStmt.setString(3, value);
                            insPrepStmt.executeUpdate();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to update meta-info table " + sqlName, ex);
            }
        }
        if (gen != null) {
            for (String table : this.tabInfo.keySet()) {
                HashMap<String, String> newValues = this.tabInfo.get(table);
                for (String tag : newValues.keySet()) {
                    String value = newValues.get(tag);
                    String insStmt = "INSERT INTO " + sqlName + " (" + "tablename" + "," + "tag" + "," + "setting" + ") VALUES ('" + table + "','" + tag + "','" + value + "')";
                    GeneratorJdbc generatorJdbc = gen;
                    generatorJdbc.getClass();
                    gen.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt(generatorJdbc, insStmt));
                }
            }
        }
    }

    private HashMap<String, HashMap<String, String>> readTableTab(Connection conn, String sqlName) throws Ili2dbException {
        HashMap<String, HashMap<String, String>> exstEntries = new HashMap<String, HashMap<String, String>>();
        try {
            String selStmt = "SELECT tablename,tag,setting FROM " + sqlName;
            EhiLogger.traceBackendCmd((String)selStmt);
            PreparedStatement selPrepStmt = null;
            ResultSet rs = null;
            try {
                selPrepStmt = conn.prepareStatement(selStmt);
                rs = selPrepStmt.executeQuery();
                while (rs.next()) {
                    String table = rs.getString(1);
                    String tag = rs.getString(2);
                    String value = rs.getString(3);
                    HashMap<String, String> exstValues = exstEntries.get(table);
                    if (exstValues == null) {
                        exstValues = new HashMap();
                        exstEntries.put(table, exstValues);
                    }
                    exstValues.put(tag, value);
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to read meta info values from " + sqlName, ex);
            }
            finally {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (selPrepStmt != null) {
                    selPrepStmt.close();
                    selPrepStmt = null;
                }
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to read meta-info table " + sqlName, ex);
        }
        return exstEntries;
    }

    public static void addMetaInfoTables(DbSchema schema) {
        DbTable tab = new DbTable();
        tab.setName(new DbTableName(schema.getName(), "T_ILI2DB_COLUMN_PROP"));
        DbColVarchar tableName = new DbColVarchar();
        tableName.setName("tablename");
        tableName.setNotNull(true);
        tableName.setSize(255);
        tab.addColumn((DbColumn)tableName);
        DbColVarchar subType = new DbColVarchar();
        subType.setName("subtype");
        subType.setNotNull(false);
        subType.setSize(255);
        tab.addColumn((DbColumn)subType);
        DbColVarchar columnName = new DbColVarchar();
        columnName.setName("columnname");
        columnName.setNotNull(true);
        columnName.setSize(255);
        tab.addColumn((DbColumn)columnName);
        DbColVarchar tag = new DbColVarchar();
        tag.setName("tag");
        tag.setNotNull(true);
        tag.setSize(1024);
        tab.addColumn((DbColumn)tag);
        DbColVarchar setting = new DbColVarchar();
        setting.setName("setting");
        setting.setNotNull(true);
        setting.setSize(8000);
        tab.addColumn((DbColumn)setting);
        schema.addTable(tab);
        tab = new DbTable();
        tab.setName(new DbTableName(schema.getName(), "T_ILI2DB_TABLE_PROP"));
        tableName = new DbColVarchar();
        tableName.setName("tablename");
        tableName.setNotNull(true);
        tableName.setSize(255);
        tab.addColumn((DbColumn)tableName);
        DbColVarchar tag2 = new DbColVarchar();
        tag2.setName("tag");
        tag2.setNotNull(true);
        tag2.setSize(1024);
        tab.addColumn((DbColumn)tag2);
        DbColVarchar setting2 = new DbColVarchar();
        setting2.setName("setting");
        setting2.setNotNull(true);
        setting2.setSize(8000);
        tab.addColumn((DbColumn)setting2);
        schema.addTable(tab);
    }
}

