/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.iox.objpool.ObjectPoolManager;
import ch.ehi.iox.objpool.impl.IomObjectSerializer;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iom_j.itf.impl.ItfSurfaceLinetable2Polygon;
import ch.interlis.iom_j.itf.impl.LineSet;
import ch.interlis.iom_j.itf.impl.Linetable2Polygon;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurveRing;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurvePolygon;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.JtsextGeometryFactory;
import ch.interlis.iom_j.itf.impl.jtsext.noding.CompoundCurveNoder;
import ch.interlis.iom_j.itf.impl.jtsext.noding.Intersection;
import ch.interlis.iom_j.itf.impl.jtsext.operation.polygonize.IoxPolygonizer;
import ch.interlis.iox.IoxException;
import ch.interlis.iox_j.IoxInvalidDataException;
import ch.interlis.iox_j.jts.Iox2jtsException;
import ch.interlis.iox_j.jts.Iox2jtsext;
import ch.interlis.iox_j.jts.Jtsext2iox;
import com.vividsolutions.jts.algorithm.locate.SimplePointInAreaLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ItfAreaLinetable2Polygon
implements Linetable2Polygon {
    private Map<String, Polygon> polygons = new HashMap<String, Polygon>();
    private Map<String, IomObject> mainTids = new HashMap<String, IomObject>();
    private Map<String, IomObject> lines = null;
    private Map<String, IomObject> lineattrs = null;
    private boolean surfacesBuilt = false;
    private String helperTableGeomAttrName = null;
    private Table linattrTab = null;
    private double maxOverlaps = 0.0;
    private double newVertexOffset = 0.0;
    private JtsextGeometryFactory jtsFact = new JtsextGeometryFactory();
    private ObjectPoolManager objPool = null;
    private int ignorePolygonBuildingErrors;
    ArrayList<IoxInvalidDataException> dataerrs = new ArrayList();
    private String linetableIliqname = null;
    private String geomattrIliqname = null;
    private boolean allowItfAreaHoles = true;
    private boolean keepLinetables = false;
    private String mainTableRef1 = null;
    private String mainTableRef2 = null;

    public ItfAreaLinetable2Polygon(AttributeDef surfaceAttr, boolean ignorePolygonBuildingErrors1) {
        this(surfaceAttr, ignorePolygonBuildingErrors1 ? 1 : 0);
    }

    public ItfAreaLinetable2Polygon(AttributeDef surfaceAttr, int ignorePolygonBuildingErrors1) {
        NumericalType[] dimensions;
        double size;
        this.linetableIliqname = surfaceAttr.getContainer().getScopedName(null) + "_" + surfaceAttr.getName();
        this.geomattrIliqname = surfaceAttr.getContainer().getScopedName(null) + "." + surfaceAttr.getName();
        this.ignorePolygonBuildingErrors = ignorePolygonBuildingErrors1;
        this.maxOverlaps = ((AreaType)surfaceAttr.getDomainResolvingAliases()).getMaxOverlap().doubleValue();
        if (this.maxOverlaps > 0.0 && (size = (double)((NumericType)(dimensions = ((CoordType)((AreaType)surfaceAttr.getDomainResolvingAliases()).getControlPointDomain().getType()).getDimensions())[0]).getMinimum().getAccuracy()) > 0.0) {
            this.newVertexOffset = 2.0 * Math.pow(10.0, -size);
        }
        this.linattrTab = ((AreaType)surfaceAttr.getDomainResolvingAliases()).getLineAttributeStructure();
        this.helperTableGeomAttrName = ModelUtilities.getHelperTableGeomAttrName(surfaceAttr);
        this.objPool = new ObjectPoolManager();
    }

    public ItfAreaLinetable2Polygon(String geomAttr) {
        this.helperTableGeomAttrName = geomAttr;
        this.objPool = new ObjectPoolManager();
    }

    public ItfAreaLinetable2Polygon(String geomAttr, double maxOverlaps1, double accuracy) {
        this.helperTableGeomAttrName = geomAttr;
        this.objPool = new ObjectPoolManager();
        this.maxOverlaps = maxOverlaps1;
        if (this.maxOverlaps > 0.0 && accuracy > 0.0) {
            this.newVertexOffset = 2.0 * Math.pow(10.0, -accuracy);
        }
    }

    @Override
    public void close() {
        this.lines = null;
        this.lineattrs = null;
        this.mainTids = null;
        if (this.objPool != null) {
            this.objPool.close();
            this.objPool = null;
        }
    }

    @Override
    public void addItfLinetableObject(IomObject iomObj) {
        IomObject polyline;
        if (this.lines == null) {
            this.lines = this.objPool.newObjectPoolImpl2(this.getClass().getSimpleName(), new IomObjectSerializer());
            this.lineattrs = this.objPool.newObjectPoolImpl2(this.getClass().getSimpleName(), new IomObjectSerializer());
        }
        if ((polyline = iomObj.getattrobj(this.helperTableGeomAttrName, 0)) == null) {
            this.dataerrs.add(new IoxInvalidDataException("empty line", this.linetableIliqname, iomObj.getobjectoid(), iomObj));
        } else {
            this.lines.put(iomObj.getobjectoid(), iomObj);
            Iom_jObject lineattr = new Iom_jObject(iomObj);
            lineattr.setattrundefined(this.helperTableGeomAttrName);
            this.lineattrs.put(iomObj.getobjectoid(), lineattr);
        }
    }

    public void addGeoRef(String tid, IomObject iomCoord) {
        this.mainTids.put(tid, iomCoord);
    }

    @Override
    public Iterator<String> mainTableTidIterator() {
        return this.mainTids.keySet().iterator();
    }

    @Override
    public Iterator<String> lineTableTidIterator() {
        if (!this.keepLinetables || this.lines == null) {
            throw new IllegalStateException("no linetable kept");
        }
        return this.lines.keySet().iterator();
    }

    @Override
    public IomObject getSurfaceObject(String mainObjectTid) throws IoxException {
        if (!this.surfacesBuilt) {
            this.buildSurfaces();
        }
        if (this.polygons.containsKey(mainObjectTid)) {
            Polygon poly = this.polygons.get(mainObjectTid);
            poly.normalize();
            try {
                return Jtsext2iox.JTS2surface(poly);
            }
            catch (Iox2jtsException e) {
                throw new IoxException(e);
            }
        }
        return null;
    }

    private static long getUsedMemory() {
        System.gc();
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Override
    public void buildSurfaces() throws IoxException {
        Collection invalidRingLines;
        Collection dangles;
        this.surfacesBuilt = true;
        if (this.lines == null) {
            return;
        }
        LineSet lineset = new LineSet(false, this.linattrTab, this.helperTableGeomAttrName);
        ArrayList<CompoundCurve> segv = lineset.buildBoundaries(this.lines, this.jtsFact);
        lineset = null;
        this.lines = null;
        EhiLogger.traceState("validate noding..." + this.helperTableGeomAttrName + ", maxOverlaps " + this.maxOverlaps + ", offset " + this.newVertexOffset);
        for (CompoundCurve seg : segv) {
            ItfSurfaceLinetable2Polygon.removeValidSelfIntersections(seg, this.maxOverlaps, this.newVertexOffset);
        }
        CompoundCurveNoder validator = new CompoundCurveNoder(segv, false);
        if (!validator.isValid()) {
            boolean hasIntersections = false;
            for (Intersection is : validator.getIntersections()) {
                CompoundCurve e0 = is.getCurve1();
                CompoundCurve compoundCurve = is.getCurve2();
                CurveSegment seg0 = is.getSegment1();
                CurveSegment seg1 = is.getSegment2();
                int segIndex0 = e0.getSegments().indexOf(is.getSegment1());
                int segIndex1 = compoundCurve.getSegments().indexOf(is.getSegment2());
                Coordinate p00 = e0.getSegments().get(segIndex0).getStartPoint();
                Coordinate p01 = e0.getSegments().get(segIndex0).getEndPoint();
                Coordinate p10 = compoundCurve.getSegments().get(segIndex1).getStartPoint();
                Coordinate p11 = compoundCurve.getSegments().get(segIndex1).getEndPoint();
                if (is.isOverlay()) {
                    this.dataerrs.add(new IoxInvalidDataException(is.toShortString(), this.linetableIliqname, null, Jtsext2iox.JTS2coord(is.getPt()[0])));
                    hasIntersections = true;
                    continue;
                }
                if (!(e0 == compoundCurve || segIndex0 != 0 && segIndex0 != e0.getSegments().size() - 1 || segIndex1 != 0 && segIndex1 != compoundCurve.getSegments().size() - 1 || is.getOverlap() == null) && is.getOverlap() < this.maxOverlaps) continue;
                if (e0 == compoundCurve && (Math.abs(segIndex0 - segIndex1) == 1 || Math.abs(segIndex0 - segIndex1) == e0.getNumSegments() - 1) && (is.isIntersection(p00) || is.isIntersection(p01)) && (is.isIntersection(p10) || is.isIntersection(p11)) && is.getOverlap() != null && is.getOverlap() < this.maxOverlaps) {
                    throw new IllegalStateException("unexpected overlap; should have been removed before; " + is);
                }
                this.dataerrs.add(new IoxInvalidDataException(is.toShortString(), this.linetableIliqname, null, Jtsext2iox.JTS2coord(is.getPt()[0])));
                hasIntersections = true;
            }
            if (hasIntersections) {
                throw new IoxInvalidDataException("intersections");
            }
        }
        EhiLogger.traceState("polygonize..." + this.helperTableGeomAttrName);
        IoxPolygonizer polygonizer = new IoxPolygonizer(this.newVertexOffset);
        if (this.keepLinetables) {
            this.lines = this.objPool.newObjectPoolImpl2(this.getClass().getSimpleName(), new IomObjectSerializer());
        }
        try {
            HashMap<String, Integer> tidCount = new HashMap<String, Integer>();
            HashMap tidIdxs = new HashMap();
            for (CompoundCurve compoundCurve : validator.getNodedSubstrings()) {
                String tid = (String)compoundCurve.getUserData();
                Integer count = (Integer)tidCount.get(tid);
                if (count == null) {
                    tidCount.put(tid, 1);
                    tidIdxs.put(tid, 1);
                    continue;
                }
                count = count + 1;
                tidCount.put(tid, count);
            }
            for (CompoundCurve compoundCurve : validator.getNodedSubstrings()) {
                String lineTid = (String)compoundCurve.getUserData();
                int tidIdx = (Integer)tidIdxs.get(lineTid);
                tidIdxs.put(lineTid, tidIdx + 1);
                if ((Integer)tidCount.get(lineTid) > 1) {
                    lineTid = lineTid + ":" + tidIdx;
                }
                if (this.keepLinetables) {
                    IomObject iomLine = Jtsext2iox.JTS2polyline(compoundCurve);
                    Iom_jObject iomLinetableObj = new Iom_jObject(this.linetableIliqname, lineTid);
                    iomLinetableObj.addattrobj(this.helperTableGeomAttrName, iomLine);
                    this.lines.put(lineTid, iomLinetableObj);
                }
                compoundCurve.setUserData(lineTid);
                compoundCurve.setSegmentsUserData(lineTid);
                polygonizer.add((Geometry)compoundCurve);
            }
        }
        catch (Iox2jtsException e) {
            throw new IllegalStateException(e);
        }
        validator = null;
        Collection cutEdges = polygonizer.getCutEdges();
        if (!cutEdges.isEmpty()) {
            for (Object edge : cutEdges) {
                try {
                    this.dataerrs.add(new IoxInvalidDataException("cut edge " + IoxInvalidDataException.formatTids((CompoundCurve)((Object)edge)), this.linetableIliqname, null, Jtsext2iox.JTS2polyline((CompoundCurve)((Object)edge))));
                }
                catch (Iox2jtsException iox2jtsException) {
                    throw new IllegalStateException(iox2jtsException);
                }
            }
            if (this.ignorePolygonBuildingErrors == 0) {
                throw new IoxInvalidDataException("cut edges");
            }
        }
        if (!(dangles = polygonizer.getDangles()).isEmpty()) {
            for (Object e : dangles) {
                try {
                    this.dataerrs.add(new IoxInvalidDataException("dangle " + IoxInvalidDataException.formatTids((CompoundCurve)((Object)e)), this.linetableIliqname, null, Jtsext2iox.JTS2polyline((CompoundCurve)((Object)e))));
                }
                catch (Iox2jtsException e2) {
                    throw new IllegalStateException(e2);
                }
            }
            if (this.ignorePolygonBuildingErrors == 0) {
                throw new IoxInvalidDataException("dangles");
            }
        }
        if (!(invalidRingLines = polygonizer.getInvalidRingLines()).isEmpty()) {
            for (Object invalidRingLine : invalidRingLines) {
                try {
                    this.dataerrs.add(new IoxInvalidDataException("invald ring line " + IoxInvalidDataException.formatTids((CompoundCurve)((Object)invalidRingLine)), this.linetableIliqname, null, Jtsext2iox.JTS2polyline((CompoundCurve)((Object)invalidRingLine))));
                }
                catch (Iox2jtsException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (this.ignorePolygonBuildingErrors == 0) {
                throw new IoxInvalidDataException("invalid ring lines");
            }
        }
        Collection collection = polygonizer.getPolygons();
        EhiLogger.traceState("georef polygons..." + this.helperTableGeomAttrName);
        STRtree polyidx = new STRtree();
        for (Polygon poly : collection) {
            polyidx.insert(poly.getEnvelopeInternal(), (Object)poly);
        }
        HashMap<Polygon, String> hitPolys = new HashMap<Polygon, String>();
        for (String tid : this.mainTids.keySet()) {
            IomObject georef = this.mainTids.get(tid);
            Coordinate coord = Iox2jtsext.coord2JTS(georef);
            Point point = this.jtsFact.createPoint(coord);
            List hits = polyidx.query(new Envelope(coord));
            Polygon hit = null;
            for (Polygon candHit : hits) {
                if (SimplePointInAreaLocator.locate((Coordinate)coord, (Geometry)candHit) != 0) continue;
                hit = candHit;
            }
            if (hit == null) {
                IoxInvalidDataException ex = new IoxInvalidDataException("no polygon for tid " + tid, this.geomattrIliqname, tid, Jtsext2iox.JTS2coord(coord));
                if (this.ignorePolygonBuildingErrors != 0) {
                    this.dataerrs.add(ex);
                    continue;
                }
                throw ex;
            }
            if (hitPolys.containsKey(hit)) {
                String tid2 = (String)hitPolys.get(hit);
                IomObject georef2 = this.mainTids.get(tid2);
                Coordinate coord2 = Iox2jtsext.coord2JTS(georef2);
                String hitTids = this.getTids(hit);
                String[] tids = new String[]{tid, tid2};
                IoxInvalidDataException ex = null;
                try {
                    ex = new IoxInvalidDataException("multiple area-refs to polygon " + IoxInvalidDataException.formatTids(tids), this.geomattrIliqname, null, Jtsext2iox.JTS2surface(hit));
                }
                catch (Iox2jtsException e) {
                    throw new IllegalStateException(e);
                }
                if (this.ignorePolygonBuildingErrors != 0) {
                    this.dataerrs.add(ex);
                } else {
                    throw ex;
                }
            }
            this.polygons.put(tid, hit);
            hitPolys.put(hit, tid);
        }
        if (!this.allowItfAreaHoles) {
            for (Polygon poly : collection) {
                if (hitPolys.containsKey(poly)) continue;
                IoxInvalidDataException ex = null;
                try {
                    ex = new IoxInvalidDataException("no area-ref to polygon of lines " + this.getTids(poly), this.geomattrIliqname, Jtsext2iox.JTS2surface(poly));
                }
                catch (Iox2jtsException e) {
                    throw new IllegalStateException(e);
                }
                if (this.ignorePolygonBuildingErrors != 0) {
                    this.dataerrs.add(ex);
                    continue;
                }
                throw ex;
            }
        }
        if (this.keepLinetables) {
            for (String tid : this.mainTids.keySet()) {
                Polygon poly = this.polygons.get(tid);
                for (String lineTid : this.getTidAsArray(poly)) {
                    IomObject ref;
                    IomObject line = this.getLineObject(lineTid);
                    if (line == null) {
                        throw new IllegalStateException();
                    }
                    if (line.getattrvaluecount(this.mainTableRef1) == 0) {
                        ref = new Iom_jObject("REF", null);
                        ref.setobjectrefoid(tid);
                        line.addattrobj(this.mainTableRef1, ref);
                    } else if (line.getattrvaluecount(this.mainTableRef2) == 0) {
                        ref = line.getattrobj(this.mainTableRef1, 0);
                        String ref1 = ref.getobjectrefoid();
                        if (ref1.compareTo(tid) > 0) {
                            ref.setobjectrefoid(tid);
                            ref = new Iom_jObject("REF", null);
                            ref.setobjectrefoid(ref1);
                            line.addattrobj(this.mainTableRef2, ref);
                        } else {
                            ref = new Iom_jObject("REF", null);
                            ref.setobjectrefoid(tid);
                            line.addattrobj(this.mainTableRef2, ref);
                        }
                    } else {
                        throw new IllegalStateException("more than two refs in line");
                    }
                    this.lines.put(lineTid, line);
                }
            }
        }
    }

    public String getTids(Polygon hit) {
        StringBuilder hitTids = new StringBuilder();
        if (hit instanceof CurvePolygon) {
            CurvePolygon cp = (CurvePolygon)hit;
            String sep = "";
            ArrayList<CurveSegment> segs = new ArrayList<CurveSegment>();
            CompoundCurveRing c = (CompoundCurveRing)cp.getExteriorRing();
            for (CompoundCurve cv : c.getLines()) {
                segs.addAll(cv.getSegments());
            }
            for (int ri = 0; ri < cp.getNumInteriorRing(); ++ri) {
                c = (CompoundCurveRing)cp.getInteriorRingN(ri);
                for (CompoundCurve cv : c.getLines()) {
                    segs.addAll(cv.getSegments());
                }
            }
            HashSet<String> uniqueTids = new HashSet<String>();
            for (CurveSegment seg : segs) {
                String tidx = seg.getUserData().toString();
                if (uniqueTids.contains(tidx)) continue;
                hitTids.append(sep);
                hitTids.append(tidx);
                sep = ", ";
                uniqueTids.add(tidx);
            }
        }
        return hitTids.toString();
    }

    public String[] getTidAsArray(Polygon hit) {
        ArrayList<String> hitTids = new ArrayList<String>();
        if (hit instanceof CurvePolygon) {
            CurvePolygon cp = (CurvePolygon)hit;
            ArrayList<CurveSegment> segs = new ArrayList<CurveSegment>();
            CompoundCurveRing c = (CompoundCurveRing)cp.getExteriorRing();
            for (CompoundCurve cv : c.getLines()) {
                segs.addAll(cv.getSegments());
            }
            for (int ri = 0; ri < cp.getNumInteriorRing(); ++ri) {
                c = (CompoundCurveRing)cp.getInteriorRingN(ri);
                for (CompoundCurve cv : c.getLines()) {
                    segs.addAll(cv.getSegments());
                }
            }
            HashSet<String> uniqueTids = new HashSet<String>();
            for (CurveSegment seg : segs) {
                String tidx = seg.getUserData().toString();
                if (uniqueTids.contains(tidx = this.removeOverlapRemovalPrefix(tidx))) continue;
                hitTids.add(tidx);
                uniqueTids.add(tidx);
            }
        }
        return hitTids.toArray(new String[hitTids.size()]);
    }

    private String removeOverlapRemovalPrefix(String tidx) {
        if (tidx.startsWith("modified-")) {
            tidx = tidx.substring("modified-".length());
        } else if (tidx.startsWith("overlap-")) {
            tidx = tidx.substring("overlap-".length());
        }
        return tidx;
    }

    @Override
    public ArrayList<IoxInvalidDataException> getDataerrs() {
        return this.dataerrs;
    }

    public boolean isAllowItfAreaHoles() {
        return this.allowItfAreaHoles;
    }

    public void setAllowItfAreaHoles(boolean allowItfAreaHoles) {
        this.allowItfAreaHoles = allowItfAreaHoles;
    }

    @Override
    public boolean isKeepLinetables() {
        return this.keepLinetables;
    }

    @Override
    public void setKeepLinetables(boolean keepLinetables, String ref1, String ref2) {
        this.keepLinetables = keepLinetables;
        this.mainTableRef1 = ref1;
        this.mainTableRef2 = ref2;
    }

    @Override
    public IomObject getLineObject(String lineTid) {
        if (!this.keepLinetables || this.lines == null) {
            throw new IllegalStateException("no linetable kept");
        }
        IomObject line = this.lines.get(lineTid);
        String pureLineTid = lineTid.replaceAll(":[0-9]+\\z", "");
        pureLineTid = this.removeOverlapRemovalPrefix(pureLineTid);
        IomObject lineattr = this.lineattrs.get(pureLineTid);
        this.mergeAttrs(line, lineattr);
        return line;
    }

    private void mergeAttrs(IomObject line, IomObject src) {
        int attrc = src.getattrcount();
        for (int attri = 0; attri < attrc; ++attri) {
            String attrName = src.getattrname(attri);
            int valuec = src.getattrvaluecount(attrName);
            for (int valuei = 0; valuei < valuec; ++valuei) {
                String valueStr = src.getattrprim(attrName, valuei);
                if (valueStr == null) continue;
                line.setattrvalue(attrName, valueStr);
            }
        }
    }
}

