/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.csv;

import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.view.GenericFileFilter;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.iom.IomObject;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxFactoryCollection;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox_j.DefaultIoxFactoryCollection;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.IoxIliReader;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.StartTransferEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CsvReader
implements IoxReader,
IoxIliReader {
    private int state = 0;
    private static final int START = 0;
    private static final int INSIDE_TRANSFER = 1;
    private static final int INSIDE_BASKET = 2;
    private static final int INSIDE_OBJECT = 3;
    private static final int INSIDE_RECORD_DELIMITER = 4;
    private static final int INSIDE_DELIMITER = 5;
    private static final int INSIDE_NO_DELIMITER = 6;
    private static final int END_DELIMITER = 7;
    private static final int END_RECORD_DELIMITER = 8;
    private static final int INSIDE_NEWLINE = 9;
    private static final int END_OBJECT = 10;
    private static final int END_BASKET = 11;
    private static final int END_TRANSFER = 12;
    private static final int END = 13;
    private static final char DEFAULT_VALUE_DELIMITER = '\"';
    private static final char DEFAULT_VALUE_SEPARATOR = ',';
    private static final char NEWLINE_CARRIAGERETURN = '\r';
    private static final char NEWLINE_LINEFEED = '\n';
    public static final String ENCODING = "ch.interlis.iom_j.csv.encoding";
    private IoxFactoryCollection factory;
    private TransferDescription td = null;
    private File inputFile = null;
    private int nextId = 1;
    private int lineCount = 1;
    private BufferedReader reader = null;
    private boolean firstLineIsHeader = false;
    private List<String> headerAttributes = null;
    private List<String> pendingValues = null;
    private String modelName = null;
    private String topicName = "Topic";
    private String className = "Class" + this.nextId;
    private char currentValueDelimiter = (char)34;
    private char currentValueSeparator = (char)44;
    private String lineSeparator = System.getProperty("line.separator");

    public CsvReader(File csvFile) throws IoxException {
        this(csvFile, null);
    }

    public CsvReader(File csvFile, Settings settings) throws IoxException {
        try {
            this.inputFile = csvFile;
            String encoding = null;
            if (settings != null) {
                encoding = settings.getValue(ENCODING);
            }
            if (encoding == null) {
                encoding = Charset.defaultCharset().name();
            }
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.inputFile), encoding));
            if (encoding.equals("UTF-8")) {
                this.reader.mark(1);
                int c1 = this.reader.read();
                if (c1 != 65279) {
                    this.reader.reset();
                }
            }
            this.init();
        }
        catch (IOException ex) {
            throw new IoxException(ex);
        }
    }

    private void init() throws IoxException, FileNotFoundException {
        this.factory = new DefaultIoxFactoryCollection();
    }

    @Override
    public void setModel(TransferDescription td) {
        this.td = td;
    }

    public String[] getAttributes() {
        return this.headerAttributes.toArray(new String[this.headerAttributes.size()]);
    }

    @Override
    public IoxEvent read() throws IoxException {
        Object csvAttributes = null;
        IomObject iomObj = null;
        if (this.state == 0) {
            this.state = 1;
            return new StartTransferEvent();
        }
        if (this.state == 1) {
            this.state = 2;
        }
        if (this.state == 2) {
            if (this.td != null) {
                this.setupNameMapping();
                if (this.firstLineIsHeader) {
                    try {
                        this.headerAttributes = this.readValues(this.reader, this.currentValueSeparator, this.currentValueDelimiter);
                        Viewable aClass = this.getViewableByAttributeNames(this.headerAttributes);
                        if (aClass == null) {
                            throw new IoxException("attributes of headerrecord: " + this.headerAttributes.toString() + " not found in iliModel: " + this.modelName);
                        }
                        this.className = aClass.getName();
                        this.topicName = aClass.getContainer().getName();
                    }
                    catch (IOException e) {
                        throw new IoxException(e);
                    }
                } else {
                    try {
                        this.pendingValues = this.readValues(this.reader, this.currentValueSeparator, this.currentValueDelimiter);
                        int valueCount = this.pendingValues.size();
                        this.headerAttributes = new ArrayList<String>();
                        Viewable aClass = this.getViewableByAttributeCount(valueCount, this.headerAttributes);
                        if (aClass == null) {
                            throw new IoxException("attributes size of first line: " + valueCount + " not found in iliModel: " + this.modelName);
                        }
                        this.className = aClass.getName();
                        this.topicName = aClass.getContainer().getName();
                    }
                    catch (IOException e) {
                        throw new IoxException(e);
                    }
                }
            } else {
                this.modelName = this.getNameOfFile(this.inputFile);
                if (this.firstLineIsHeader) {
                    try {
                        this.headerAttributes = this.readValues(this.reader, this.currentValueSeparator, this.currentValueDelimiter);
                    }
                    catch (IOException e) {
                        throw new IoxException(e);
                    }
                }
                try {
                    this.pendingValues = this.readValues(this.reader, this.currentValueSeparator, this.currentValueDelimiter);
                }
                catch (IOException e) {
                    throw new IoxException(e);
                }
                int valueCount = this.pendingValues.size();
                this.headerAttributes = new ArrayList<String>();
                for (int i = 1; i <= valueCount; ++i) {
                    this.headerAttributes.add("attr" + i);
                }
            }
            this.state = 3;
            String bid = "b" + this.getNewId();
            return new StartBasketEvent(this.modelName + "." + this.topicName, bid);
        }
        if (this.state == 3) {
            try {
                List<String> record = null;
                if (this.pendingValues != null) {
                    record = this.pendingValues;
                    this.pendingValues = null;
                } else {
                    record = this.readValues(this.reader, this.currentValueSeparator, this.currentValueDelimiter);
                }
                if (record != null && record.size() > 0) {
                    iomObj = this.createIomObject(this.modelName + "." + this.topicName + "." + this.className, null);
                    iomObj.setobjectline(this.lineCount);
                    for (int i = 0; i < this.headerAttributes.size(); ++i) {
                        String value = null;
                        if (record.size() > i) {
                            value = record.get(i);
                        }
                        if (value == null || value.length() <= 0) continue;
                        iomObj.setattrvalue(this.headerAttributes.get(i), value);
                    }
                    return new ObjectEvent(iomObj);
                }
            }
            catch (IOException e) {
                throw new IoxException(e);
            }
            this.state = 11;
        }
        if (this.state == 11) {
            this.state = 12;
            return new EndBasketEvent();
        }
        if (this.state == 12) {
            this.state = 13;
            return new EndTransferEvent();
        }
        return null;
    }

    private ArrayList<ArrayList<Viewable>> setupNameMapping() {
        ArrayList<ArrayList<Viewable>> models = new ArrayList<ArrayList<Viewable>>();
        Iterator tdIterator = this.td.iterator();
        while (tdIterator.hasNext()) {
            Object modelObj = tdIterator.next();
            if (!(modelObj instanceof Model) || modelObj instanceof PredefinedModel) continue;
            Model model = (Model)modelObj;
            this.modelName = model.getName();
            ArrayList<Table> classes = new ArrayList<Table>();
            Iterator modelIterator = model.iterator();
            while (modelIterator.hasNext()) {
                Object topicObj = modelIterator.next();
                if (!(topicObj instanceof Topic)) continue;
                Topic topic = (Topic)topicObj;
                Iterator classIter = topic.iterator();
                while (classIter.hasNext()) {
                    Table viewable;
                    Object classObj = classIter.next();
                    if (!(classObj instanceof Table) || (viewable = (Table)classObj).isAbstract() || !viewable.isIdentifiable()) continue;
                    classes.add(viewable);
                }
            }
            models.add(classes);
        }
        return models;
    }

    private Viewable getViewableByAttributeNames(List<String> headerAttrs) throws IoxException {
        Viewable viewable = null;
        ArrayList<String> foundClasses = new ArrayList<String>();
        ArrayList newHeaderAttrs = null;
        ArrayList<ArrayList<Viewable>> models = this.setupNameMapping();
        for (int modeli = models.size() - 1; modeli >= 0; --modeli) {
            ArrayList<Viewable> classes = models.get(modeli);
            for (int classi = classes.size() - 1; classi >= 0; --classi) {
                Viewable iliViewable = classes.get(classi);
                HashMap<String, String> iliAttrs = new HashMap<String, String>();
                Iterator<Extendable> attrIter = iliViewable.getAttributes();
                while (attrIter.hasNext()) {
                    Element attribute = (Element)((Object)attrIter.next());
                    String attrName = attribute.getName();
                    iliAttrs.put(attrName.toLowerCase(), attrName);
                }
                if (!this.containsAttrs(iliAttrs, headerAttrs)) continue;
                viewable = iliViewable;
                this.modelName = iliViewable.getContainerOrSame(Model.class).getName();
                foundClasses.add(viewable.getScopedName());
                newHeaderAttrs = new ArrayList();
                for (String headerAttr : headerAttrs) {
                    newHeaderAttrs.add(iliAttrs.get(headerAttr.toLowerCase()));
                }
            }
        }
        if (foundClasses.size() > 1) {
            throw new IoxException("several possible classes were found: " + ((Object)foundClasses).toString());
        }
        if (foundClasses.size() == 1) {
            headerAttrs.clear();
            headerAttrs.addAll(newHeaderAttrs);
            return viewable;
        }
        return null;
    }

    private boolean containsAttrs(Map<String, String> iliAttrs, List<String> headerAttrs) {
        for (String headerAttr : headerAttrs) {
            if (iliAttrs.containsKey(headerAttr.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private Viewable getViewableByAttributeCount(Integer attrCountOfRecord, List<String> iliAttrs) throws IoxException {
        int attrCountOfMatchedClasses = 0;
        Viewable matchedIliViewable = null;
        StringBuilder multipleMatchedClasses = new StringBuilder();
        ArrayList<ArrayList<Viewable>> models = this.setupNameMapping();
        String comma = "";
        for (int modeli = models.size() - 1; modeli >= 0; --modeli) {
            ArrayList<Viewable> classes = models.get(modeli);
            for (int classi = classes.size() - 1; classi >= 0; --classi) {
                Viewable iliViewable = classes.get(classi);
                iliAttrs.clear();
                Iterator<Extendable> attrIter = iliViewable.getAttributes();
                while (attrIter.hasNext()) {
                    Element attribute = (Element)((Object)attrIter.next());
                    iliAttrs.add(attribute.getName());
                }
                if (iliAttrs.size() != attrCountOfRecord.intValue()) continue;
                this.modelName = iliViewable.getContainerOrSame(Model.class).getName();
                ++attrCountOfMatchedClasses;
                matchedIliViewable = iliViewable;
                multipleMatchedClasses.append(comma);
                multipleMatchedClasses.append(matchedIliViewable.getName());
                comma = ",";
            }
        }
        if (attrCountOfMatchedClasses == 1) {
            return matchedIliViewable;
        }
        if (attrCountOfMatchedClasses > 1) {
            throw new IoxException("multiple class candidates: " + multipleMatchedClasses.toString());
        }
        return null;
    }

    private String getNameOfFile(File file) throws IoxException {
        String path = file.getName();
        if (path != null) {
            String fileName = GenericFileFilter.stripFileExtension(path);
            return fileName;
        }
        throw new IoxException("expected csv file");
    }

    private List<String> readValues(BufferedReader bufferedReader, char separator, char limiter) throws IOException, IoxException {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer currentValue = new StringBuffer();
        if (!bufferedReader.ready()) {
            return result;
        }
        int readChar = 0;
        int state = 3;
        while ((readChar = bufferedReader.read()) != -1) {
            int charCount;
            char currentChar = (char)readChar;
            if (state == 3 && (state = currentChar == this.currentValueDelimiter ? 4 : 6) == 4) {
                state = 5;
                continue;
            }
            if (state == 5) {
                if (currentChar == this.currentValueDelimiter) {
                    state = 7;
                    continue;
                }
                currentValue.append(currentChar);
                continue;
            }
            if (state == 6) {
                if (currentChar == this.currentValueDelimiter) {
                    state = 7;
                    continue;
                }
                if (currentChar == this.currentValueSeparator) {
                    result.add(currentValue.toString());
                    charCount = currentValue.length();
                    currentValue.delete(0, charCount);
                    state = 3;
                    continue;
                }
                if (currentChar == '\n') {
                    state = 9;
                } else {
                    if (currentChar == '\r') continue;
                    currentValue.append(currentChar);
                    continue;
                }
            }
            if (state == 9) {
                ++this.lineCount;
                result.add(currentValue.toString());
                charCount = currentValue.length();
                currentValue.delete(0, charCount);
                state = 10;
            }
            if (state == 7) {
                if (currentChar == this.currentValueDelimiter) {
                    currentValue.append(currentChar);
                    state = 5;
                    continue;
                }
                if (currentChar == this.currentValueSeparator) {
                    result.add(currentValue.toString());
                    charCount = currentValue.length();
                    currentValue.delete(0, charCount);
                    state = 8;
                    continue;
                }
                if (currentChar == '\r') {
                    ++this.lineCount;
                    result.add(currentValue.toString());
                    charCount = currentValue.length();
                    currentValue.delete(0, charCount);
                    state = 10;
                    continue;
                }
                if (currentChar == '\n') {
                    ++this.lineCount;
                    result.add(currentValue.toString());
                    charCount = currentValue.length();
                    currentValue.delete(0, charCount);
                    state = 10;
                } else {
                    currentValue.append(currentChar);
                    continue;
                }
            }
            if (state == 8) {
                if (currentChar == this.currentValueDelimiter) {
                    state = 5;
                    continue;
                }
                if (currentChar == '\r' || currentChar == '\n') {
                    ++this.lineCount;
                    state = 10;
                } else {
                    state = 6;
                    currentValue.append(currentChar);
                    continue;
                }
            }
            if (state == 10) {
                return result;
            }
            currentValue.append(currentChar);
        }
        result.add(currentValue.toString());
        return result;
    }

    @Override
    public IomObject createIomObject(String type, String oid) throws IoxException {
        if (oid == null) {
            oid = "o" + this.getNewId();
        }
        return this.factory.createIomObject(type, oid);
    }

    private String getNewId() {
        int count = this.nextId++;
        return String.valueOf(count);
    }

    @Override
    public void close() throws IoxException {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e2) {
                throw new IoxException(e2);
            }
            this.reader = null;
        }
    }

    @Override
    public IoxFactoryCollection getFactory() throws IoxException {
        return this.factory;
    }

    @Override
    public void setFactory(IoxFactoryCollection factory) throws IoxException {
        this.factory = factory;
    }

    public void setFirstLineIsHeader(boolean headerState) {
        this.firstLineIsHeader = headerState;
    }

    private char getValueDelimiter() throws IoxException {
        return this.currentValueDelimiter;
    }

    public void setValueDelimiter(char definition) {
        this.currentValueDelimiter = definition;
    }

    private char getValueSeparator() throws IoxException {
        return this.currentValueSeparator;
    }

    public void setValueSeparator(char definition) {
        this.currentValueSeparator = definition;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    @Override
    public void setTopicFilter(String[] topicNames) {
    }

    @Override
    public String getMimeType() {
        return "text/csv";
    }
}

