/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl;

import ch.ehi.basics.tools.StringUtility;
import ch.interlis.ili2c.metamodel.Ili1Format;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iox.IoxException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class ItfRawWriter {
    private Writer os = null;
    private String undefinedCode = "@";
    private char continueCode = (char)92;
    private boolean isFormatFree = true;
    private int fixedTidSize;
    private int fixedLineSize;
    private int currentOutputColumn;
    private static String nl = null;
    private int lineNumber = 0;

    public ItfRawWriter(OutputStream out, Ili1Format format) throws UnsupportedEncodingException, IOException {
        this.os = new BufferedWriter(new OutputStreamWriter(out, "ISO-8859-1"));
        if (format == null) {
            this.undefinedCode = ModelUtilities.code2string(64);
            this.continueCode = ModelUtilities.code2string(92).charAt(0);
            this.isFormatFree = true;
        } else {
            this.undefinedCode = ModelUtilities.code2string(format.undefinedCode);
            this.continueCode = ModelUtilities.code2string(format.continueCode).charAt(0);
            this.isFormatFree = format.isFree;
        }
        if (!this.isFormatFree) {
            this.fixedTidSize = format.tidSize;
            this.fixedLineSize = format.lineSize;
            if (this.fixedTidSize + 5 + 2 > this.fixedLineSize) {
                throw new IllegalArgumentException("fixedTidSize+5+2>fixedLineSize");
            }
        }
    }

    public void close() throws IoxException {
        this.flush();
        this.os = null;
    }

    public void flush() throws IoxException {
        if (this.os != null) {
            try {
                this.os.flush();
            }
            catch (IOException ex) {
                throw new IoxException("failed to flush output stream", (Throwable)ex);
            }
        }
    }

    private void newline() throws IOException {
        if (nl == null) {
            nl = System.getProperty("line.separator");
        }
        this.os.write(nl);
        ++this.lineNumber;
    }

    public void writeRawText(String text) throws IOException {
        this.os.write(text);
        this.currentOutputColumn += text.length();
    }

    public void writeNewline() throws IOException {
        if (!this.isFormatFree) {
            this.os.write(StringUtility.STRING(this.fixedLineSize - this.currentOutputColumn, ' '));
        }
        this.newline();
        this.currentOutputColumn = 0;
    }

    public void writeTid(String tid) throws IOException {
        this.writeValue(tid, true, this.fixedTidSize);
    }

    public void writeValue(String value, boolean isNum, int size) throws IOException {
        if (this.isFormatFree) {
            if (value != null) {
                this.os.write(" " + value);
                this.currentOutputColumn += 1 + value.length();
            } else {
                this.os.write(" " + this.undefinedCode);
                this.currentOutputColumn += 2;
            }
        } else {
            if (this.currentOutputColumn + 2 + size > this.fixedLineSize) {
                this.os.write(StringUtility.STRING(this.fixedLineSize - this.currentOutputColumn, ' ') + this.continueCode);
                this.newline();
                this.os.write("CONT");
                this.currentOutputColumn = 4;
            }
            if (value != null) {
                value = isNum ? StringUtility.STRING(size, ' ') + value : value + StringUtility.STRING(size, ' ');
                value = value.substring(0, size);
                this.os.write("  " + value);
                this.currentOutputColumn += 2 + size;
            } else {
                this.os.write(" " + this.undefinedCode + StringUtility.STRING(size, ' '));
                this.currentOutputColumn += 2 + size;
            }
        }
    }

    public void writeExplanation(String explanation) throws IOException {
        String line;
        if (explanation == null) {
            return;
        }
        if ((explanation = explanation.trim()).length() == 0) {
            return;
        }
        LineNumberReader lines = new LineNumberReader(new StringReader(explanation));
        while ((line = lines.readLine()) != null) {
            this.os.write(line);
            this.newline();
        }
    }
}

