/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.metamodel.BaseType;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.StructuredUnit;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Unit;
import java.util.List;

public abstract class AbstractCoordType
extends BaseType {
    protected boolean _generic = false;
    protected int nullAxis;
    protected int piHalfAxis;
    protected NumericalType[] dimensions;
    protected String crs = null;

    protected AbstractCoordType() {
    }

    public AbstractCoordType(NumericalType[] dimensions, int nullAxis, int piHalfAxis) {
        this.nullAxis = nullAxis;
        this.piHalfAxis = piHalfAxis;
        this.dimensions = dimensions;
        if (dimensions == null) {
            throw new IllegalArgumentException(rsrc.getString("err_nullNotAcceptable"));
        }
        for (int i = 0; i < dimensions.length; ++i) {
            if (dimensions[i] == null) {
                throw new IllegalArgumentException(rsrc.getString("err_nullNotAcceptable"));
            }
            Unit u = dimensions[i].getUnit();
            if (!(u instanceof StructuredUnit) || ((StructuredUnit)u).isContinuous()) continue;
            throw new IllegalArgumentException(AbstractCoordType.formatMessage("err_coordType_structuredUnitNotContinuous", u.toString()));
        }
        if (nullAxis < 0 || nullAxis > dimensions.length) {
            throw new IllegalArgumentException(AbstractCoordType.formatMessage("err_rotationDefInvalid", Integer.toString(nullAxis), Integer.toString(dimensions.length)));
        }
        if (piHalfAxis < 0 || piHalfAxis > dimensions.length) {
            throw new IllegalArgumentException(AbstractCoordType.formatMessage("err_rotationDefInvalid", Integer.toString(piHalfAxis), Integer.toString(dimensions.length)));
        }
        if (nullAxis == piHalfAxis && nullAxis != 0) {
            throw new IllegalArgumentException(rsrc.getString("err_rotationDefSame"));
        }
    }

    public AbstractCoordType(NumericalType[] dimensions) {
        this(dimensions, 0, 0);
    }

    public NumericalType[] getDimensions() {
        return this.dimensions;
    }

    public int getNullAxis() {
        return this.nullAxis;
    }

    public int getPiHalfAxis() {
        return this.piHalfAxis;
    }

    @Override
    public boolean isAbstract(StringBuilder err) {
        if (this._generic) {
            return false;
        }
        for (int i = 0; i < this.dimensions.length; ++i) {
            if (!this.dimensions[i].isAbstract(err)) continue;
            return true;
        }
        return false;
    }

    @Override
    void checkTypeExtension(Type wantToExtend) {
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        if (!(wantToExtend instanceof AbstractCoordType)) {
            throw new Ili2cSemanticException(rsrc.getString("err_coordType_ExtOther"));
        }
        AbstractCoordType coordToExtend = (AbstractCoordType)wantToExtend;
        if (this.dimensions.length != coordToExtend.dimensions.length) {
            throw new Ili2cSemanticException(AbstractCoordType.formatMessage("err_coordType_incompatible", Integer.toString(coordToExtend.dimensions.length), Integer.toString(this.dimensions.length)));
        }
        for (int i = 0; i < this.dimensions.length; ++i) {
            this.dimensions[i].checkTypeExtension(coordToExtend.dimensions[i]);
        }
    }

    @Override
    public boolean checkStructuralEquivalence(Element with) {
        if (!super.checkStructuralEquivalence(with)) {
            return false;
        }
        boolean fine = true;
        AbstractCoordType other = (AbstractCoordType)with;
        if (this.getNullAxis() != other.getNullAxis()) {
            EhiLogger.logError(AbstractCoordType.formatMessage("err_diff_coordType_nullAxis", this.toString(), other.toString()));
            fine = false;
        }
        if (this.getPiHalfAxis() != other.getPiHalfAxis()) {
            EhiLogger.logError(AbstractCoordType.formatMessage("err_diff_coordType_piHalfAxis", this.toString(), other.toString()));
            fine = false;
        }
        return fine &= this.checkStructuralEquivalenceOfArrays(with, this.getDimensions(), other.getDimensions(), "err_diff_coordType_numDimensions");
    }

    @Override
    protected void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) {
        super.checkTranslationOf(errs, name, baseName);
        AbstractCoordType origin = (AbstractCoordType)this.getTranslationOf();
        if (origin == null) {
            return;
        }
        if (this.nullAxis != origin.nullAxis) {
            throw new Ili2cSemanticException();
        }
        if (this.piHalfAxis != origin.piHalfAxis) {
            throw new Ili2cSemanticException();
        }
        if (this.crs != null || origin.crs != null) {
            if (this.crs == null || origin.crs == null) {
                throw new Ili2cSemanticException();
            }
            if (!this.crs.equals(origin.crs)) {
                throw new Ili2cSemanticException();
            }
        }
        if (this._generic != origin._generic) {
            throw new Ili2cSemanticException();
        }
        if (this.dimensions.length != origin.dimensions.length) {
            throw new Ili2cSemanticException();
        }
        for (NumericalType dim : this.dimensions) {
            dim.checkTranslationOf(errs, name, baseName);
        }
    }

    @Override
    protected void linkTranslationOf(Element baseElement) {
        super.linkTranslationOf(baseElement);
        if (this.dimensions.length == ((AbstractCoordType)baseElement).dimensions.length) {
            for (int dimi = 0; dimi < this.dimensions.length; ++dimi) {
                NumericalType dim = this.dimensions[dimi];
                NumericalType baseDim = ((AbstractCoordType)baseElement).dimensions[dimi];
                dim.linkTranslationOf(baseDim);
            }
        }
    }

    @Override
    public AbstractCoordType clone() {
        return (AbstractCoordType)super.clone();
    }

    public boolean isGeneric() {
        return this._generic;
    }

    public void setGeneric(boolean generic) {
        this._generic = generic;
    }

    public String getCrs() {
        return this.crs;
    }

    public String getCrs(Element domainOrAttrDef) {
        String crs = this.getCrs();
        if (crs == null && (crs = domainOrAttrDef.getMetaValue("CRS")) == null) {
            Model model = (Model)domainOrAttrDef.getContainer(Model.class);
            crs = model.getMetaValue("CRS");
        }
        return crs;
    }

    public void setCrs(String crs) {
        this.crs = crs;
    }
}

