/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.db;

import ch.ehi.basics.logging.EhiLogger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DbUtility {
    private static Charset utf16 = null;

    private DbUtility() {
    }

    public static Date getDate(ResultSet rs, String colName, boolean isOptional, String recInfo) {
        Date ret = null;
        try {
            ret = rs.getDate(colName);
            if (rs.wasNull() && !isOptional) {
                EhiLogger.logError(recInfo + ": missing value for column " + colName);
            }
        }
        catch (SQLException ex) {
            EhiLogger.logError(recInfo + ": failed to query column " + colName, ex);
        }
        return ret;
    }

    public static String getString(ResultSet rs, String colName, boolean isOptional, String recInfo) {
        String ret = null;
        try {
            ret = rs.getString(colName);
            if (rs.wasNull() && !isOptional) {
                EhiLogger.logError(recInfo + ": missing value for column " + colName);
            }
        }
        catch (SQLException ex) {
            EhiLogger.logError(recInfo + ": failed to query column " + colName, ex);
        }
        return ret;
    }

    public static Integer getInt(ResultSet rs, String colName, boolean isOptional, String recInfo) {
        Integer ret = null;
        try {
            ret = rs.getInt(colName);
            if (rs.wasNull() && !isOptional) {
                EhiLogger.logError(recInfo + ": missing value for column " + colName);
                ret = null;
            }
        }
        catch (SQLException ex) {
            EhiLogger.logError(recInfo + ": failed to query column " + colName, ex);
        }
        return ret;
    }

    public static Double getDouble(ResultSet rs, String colName, boolean isOptional, String recInfo) {
        Double ret = null;
        try {
            ret = rs.getDouble(colName);
            if (rs.wasNull() && !isOptional) {
                EhiLogger.logError(recInfo + ": missing value for column " + colName);
                ret = null;
            }
        }
        catch (SQLException ex) {
            EhiLogger.logError(recInfo + ": failed to query column " + colName, ex);
        }
        return ret;
    }

    public static String getStringOrNull(ResultSet rs, String colName, boolean isOptional, String recInfo) {
        String val = DbUtility.getString(rs, colName, isOptional, recInfo);
        if (val != null && (val = val.trim()).length() == 0) {
            val = null;
        }
        return val;
    }

    public static String getStringFromBinary(ResultSet rs, String colName, boolean isOptional, String recInfo) {
        String ret = null;
        try {
            byte[] retAsBytes = (byte[])rs.getObject(colName);
            if (utf16 == null) {
                utf16 = Charset.forName("UTF-16LE");
            }
            ret = utf16.decode(ByteBuffer.wrap(retAsBytes)).toString();
            if (rs.wasNull() && !isOptional) {
                EhiLogger.logError(recInfo + ": missing value for column " + colName);
            }
        }
        catch (SQLException ex) {
            EhiLogger.logError(recInfo + ": failed to query column " + colName, ex);
        }
        return ret;
    }

    public static String getRef(ResultSet rs, String colName, boolean isOptional, String recInfo) {
        String val = DbUtility.getString(rs, colName, isOptional, recInfo);
        if (val != null && ((val = val.trim()).length() == 0 || val.equals("0"))) {
            val = null;
        }
        return val;
    }
}

