/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.statistics;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.tools.StringUtility;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.iom.IomObject;
import ch.interlis.iox.EndBasketEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox_j.statistics.BasketStat;
import ch.interlis.iox_j.statistics.ClassStat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class IoxStatistics {
    private String dataset = null;
    private String filename = null;
    private BasketStat basket = null;
    private ArrayList<BasketStat> baskets = new ArrayList();
    private boolean hideBid = false;

    public IoxStatistics(TransferDescription td, Settings settings) {
    }

    public void add(IoxEvent event) {
        if (event instanceof StartBasketEvent) {
            this.basket = this.createBasketStat(event);
            this.baskets.add(this.basket);
        } else if (event instanceof EndBasketEvent) {
            this.basket = null;
        } else if (event instanceof ObjectEvent && this.basket != null) {
            IomObject iomObj = ((ObjectEvent)event).getIomObject();
            this.basket.addObject(iomObj);
        }
    }

    protected BasketStat createBasketStat(IoxEvent event) {
        String fileMd5 = null;
        if (event instanceof ch.interlis.iox_j.StartBasketEvent) {
            fileMd5 = ((ch.interlis.iox_j.StartBasketEvent)event).getFileMd5();
        }
        return new BasketStat(this, this.dataset, this.filename, ((StartBasketEvent)event).getType(), ((StartBasketEvent)event).getBid(), ((StartBasketEvent)event).getEndstate(), fileMd5);
    }

    public List<BasketStat> getBaskets() {
        ArrayList<BasketStat> statv = this.baskets;
        Collections.sort(statv, new Comparator<BasketStat>(){

            @Override
            public int compare(BasketStat b0, BasketStat b1) {
                int ret = IoxStatistics.compareStringOrNull(b0.getDataset(), b1.getDataset());
                if (ret == 0) {
                    ret = IoxStatistics.compareStringOrNull(b0.getFile(), b1.getFile());
                }
                if (ret == 0 && (ret = b0.getTopic().compareTo(b1.getTopic())) == 0) {
                    ret = b0.getBasketId().compareTo(b1.getBasketId());
                }
                return ret;
            }
        });
        return statv;
    }

    public void write2logger() {
        for (BasketStat basketStat : this.getBaskets()) {
            String file = basketStat.getFile();
            String dataset = basketStat.getDataset();
            StringBuffer prefix = new StringBuffer();
            String sep = "";
            if (dataset != null) {
                prefix.append(sep);
                prefix.append(dataset);
                sep = ": ";
            }
            if (file != null) {
                prefix.append(sep);
                prefix.append(file);
                sep = ": ";
            }
            String version = "";
            if (basketStat.getBasketEndState() != null) {
                version = " ENDSTATE=" + basketStat.getBasketEndState();
            }
            if (basketStat.getFileMd5() != null) {
                version = " fileVersion=" + basketStat.getFileMd5();
            }
            if (this.hideBid) {
                EhiLogger.logState(prefix + sep + basketStat.getTopic() + version);
            } else {
                EhiLogger.logState(prefix + sep + basketStat.getTopic() + " BID=" + basketStat.getBasketId() + version);
            }
            Map<String, ClassStat> objStat = basketStat.getObjStat();
            ArrayList<String> classv = new ArrayList<String>(objStat.keySet());
            Collections.sort(classv, new Comparator<String>(){

                @Override
                public int compare(String b0, String b1) {
                    int ret = b0.compareTo(b1);
                    return ret;
                }
            });
            String nbsp = Character.toString('\u00a0');
            for (String className : classv) {
                ClassStat classStat = objStat.get(className);
                String objCount = Long.toString(classStat.getObjcount());
                if (objCount.length() < 6) {
                    objCount = StringUtility.STRING(6 - objCount.length(), ' ') + objCount;
                }
                EhiLogger.logState(nbsp + objCount + " objects in CLASS " + className);
            }
        }
    }

    protected static int compareStringOrNull(String value1, String value2) {
        if (value1 == null) {
            if (value2 == null) {
                return 0;
            }
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        return value1.compareTo(value2);
    }

    protected ClassStat createClassStat(String tag) {
        return new ClassStat(tag);
    }

    public boolean isHideBid() {
        return this.hideBid;
    }

    public void setHideBid(boolean hideBid) {
        this.hideBid = hideBid;
    }

    public String getDataset() {
        return this.dataset;
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

