/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.metamodel.AbstractCoordType;
import ch.interlis.ili2c.metamodel.DomainConstraint;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.ExtendableContainer;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import java.beans.PropertyVetoException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;

public class Domain
extends ExtendableContainer<DomainConstraint> {
    protected String name = null;
    protected Type type = null;
    protected boolean _abstract = false;
    protected boolean _final = false;
    protected boolean _mandatory = false;
    protected Set<Type> aliasedBy = Collections.newSetFromMap(new WeakHashMap());
    protected List<DomainConstraint> constraints = new ArrayList<DomainConstraint>();

    public Domain() {
    }

    public Domain(String name, Type type, Domain extending, boolean _abstract, boolean _final) {
        Domain.checkNameSanity(name, false);
        this.name = name;
        try {
            this.setAbstract(_abstract);
            this.setType(type);
            this.setFinal(_final);
            this.setExtending(extending);
        }
        catch (PropertyVetoException ex) {
            throw new IllegalStateException(ex.toString());
        }
    }

    @Override
    protected Collection<DomainConstraint> createElements() {
        return new AbstractCollection<DomainConstraint>(){

            @Override
            public Iterator<DomainConstraint> iterator() {
                return Domain.this.constraints.iterator();
            }

            @Override
            public int size() {
                return Domain.this.constraints.size();
            }

            @Override
            public boolean add(DomainConstraint domainConstraint) {
                return Domain.this.constraints.add(domainConstraint);
            }
        };
    }

    public Iterator<DomainConstraint> iteratorConstraints() {
        return this.constraints.iterator();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) throws PropertyVetoException {
        String oldValue = this.name;
        String newValue = name;
        Domain.checkNameSanity(name, false);
        this.checkNameUniqueness(name, Domain.class, null, "err_duplicateFunctionName");
        this.fireVetoableChange("name", oldValue, newValue);
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    public String toString() {
        return "DOMAIN " + this.getScopedName(null);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) throws PropertyVetoException {
        Type oldValue = this.type;
        Type newValue = type;
        if (newValue == null) {
            throw new IllegalArgumentException(rsrc.getString("err_nullNotAcceptable"));
        }
        this.fireVetoableChange("type", oldValue, newValue);
        this.type = newValue;
        this.firePropertyChange("type", oldValue, newValue);
        StringBuilder err = new StringBuilder();
        if (type != null && type.isAbstract(err) && !this.isAbstract()) {
            throw new Ili2cSemanticException(Domain.formatMessage("err_domainMustBeAbstractDueToType", this.toString(), err.toString()));
        }
    }

    @Override
    public boolean isAbstract() {
        return this._abstract;
    }

    @Override
    public void setAbstract(boolean abs) throws PropertyVetoException {
        boolean oldValue = this._abstract;
        boolean newValue = abs;
        if (oldValue == newValue) {
            return;
        }
        if (newValue && this.isFinal()) {
            throw new IllegalArgumentException(rsrc.getString("err_abstractFinal"));
        }
        this.firePropertyChange("abstract", oldValue, newValue);
        this._abstract = newValue;
        this.fireVetoableChange("abstract", oldValue, newValue);
    }

    @Override
    public boolean isFinal() {
        return this._final;
    }

    @Override
    public void setFinal(boolean fin) throws PropertyVetoException {
        boolean oldValue = this._final;
        boolean newValue = fin;
        if (oldValue == newValue) {
            return;
        }
        if (newValue && this.isAbstract()) {
            throw new IllegalArgumentException(rsrc.getString("err_abstractFinal"));
        }
        if (fin && !this.extendedBy.isEmpty()) {
            throw new IllegalArgumentException("A type must not be declared FINAL while there exist extending types.");
        }
        this.fireVetoableChange("final", oldValue, newValue);
        this._final = newValue;
        this.firePropertyChange("final", oldValue, newValue);
    }

    @Override
    public Domain getExtending() {
        return (Domain)super.getExtending();
    }

    public boolean isExtendingIndirectly(Domain dd) {
        for (Domain parent = this; parent != null; parent = parent.getExtending()) {
            if (parent != dd) continue;
            return true;
        }
        return false;
    }

    public void setExtending(Domain extending) throws PropertyVetoException {
        super.setExtending(extending);
        if (this.type != null) {
            if (extending == null) {
                this.type.setExtending(null);
            } else {
                this.type.setExtending(extending.getType());
            }
        }
    }

    @Override
    public boolean checkStructuralEquivalence(Element with) {
        if (!super.checkStructuralEquivalence(with)) {
            return false;
        }
        Type myType = this.getType();
        Type otherType = ((Domain)with).getType();
        if (myType == null) {
            return otherType == null;
        }
        if (!myType.checkStructuralEquivalence(otherType)) {
            EhiLogger.logError(Domain.formatMessage("err_diff_domainType", this.toString(), with.toString()));
            return false;
        }
        if (this.isAbstract() != ((Domain)with).isAbstract()) {
            EhiLogger.logError(Domain.formatMessage("err_diff_mismatchInAbstractness", this.toString(), with.toString()));
            return false;
        }
        if (this.isFinal() != ((Domain)with).isFinal()) {
            EhiLogger.logError(Domain.formatMessage("err_diff_mismatchInFinality", this.toString(), with.toString()));
            return false;
        }
        return true;
    }

    @Override
    protected void linkTranslationOf(Element baseElement) {
        super.linkTranslationOf(baseElement);
        Type type = this.getType();
        Type baseType = ((Domain)baseElement).getType();
        if (type.getClass() != baseType.getClass()) {
            throw new Ili2cSemanticException(this.getSourceLine(), Domain.formatMessage("err_diff_domainType", this.getScopedName(), ((Domain)baseElement).getScopedName()));
        }
        if (type instanceof TypeAlias && ((TypeAlias)type).getAliasing().getTranslationOfOrSame() != ((TypeAlias)baseType).getAliasing().getTranslationOfOrSame()) {
            throw new Ili2cSemanticException(this.getSourceLine(), Domain.formatMessage("err_diff_domainType", this.getScopedName(), ((Domain)baseElement).getScopedName()));
        }
        type.linkTranslationOf(baseType);
    }

    @Override
    public void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) throws IllegalStateException {
        super.checkTranslationOf(errs, name, baseName);
        Domain baseElement = (Domain)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        if (this.isAbstract() != baseElement.isAbstract()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Domain.formatMessage("err_diff_mismatchInAbstractness", this.getScopedName(), baseElement.getScopedName())));
        }
        if (this.isFinal() != baseElement.isFinal()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Domain.formatMessage("err_diff_mismatchInFinality", this.getScopedName(), baseElement.getScopedName())));
        }
        Ili2cSemanticException err = null;
        err = Domain.checkElementRef(this.getExtending(), baseElement.getExtending(), this.getSourceLine(), "err_diff_baseDomainMismatch");
        if (err != null) {
            errs.add(err);
        }
        Type type = this.getType();
        try {
            type.checkTranslationOf(errs, this.getScopedName(), baseElement.getScopedName());
            if (type instanceof AbstractCoordType) {
                String crs = ((AbstractCoordType)type).getCrs(this);
                String originCrs = ((AbstractCoordType)baseElement.getType()).getCrs(baseElement);
                if (crs != null || originCrs != null) {
                    if (crs == null || originCrs == null) {
                        throw new Ili2cSemanticException();
                    }
                    if (!crs.equals(originCrs)) {
                        throw new Ili2cSemanticException();
                    }
                }
            }
        }
        catch (Ili2cSemanticException ex) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Domain.formatMessage("err_diff_domainType", this.getScopedName(), baseElement.getScopedName())));
        }
    }

    public boolean isDefinedMandatory() {
        return this._mandatory;
    }

    public void setDefinedMandatory(boolean _mandatory) throws PropertyVetoException {
        this._mandatory = _mandatory;
        if (this.type != null) {
            this.type.setMandatory(true);
        }
    }
}

