/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.iox.objpool.impl;

import ch.ehi.iox.objpool.impl.LongSerializer;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurveRing;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.JtsextGeometryFactory;
import ch.interlis.iom_j.itf.impl.jtsext.geom.StraightSegment;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxFactoryCollection;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractIomObjectSerializer {
    protected static final int MAGIC = 342;
    private static final int PRIMITIVE = 1;
    private static final int COMPLEX = 2;
    private static final int SINGLE_COMPLEX = 3;
    private static final int LINE_STRING = 4;
    private static final int COMPOUND_CURVE = 5;
    private static final int COMPOUND_CURVE_RING = 6;
    private static final byte META_OID = 1;
    private static final byte META_COL = 2;
    private static final byte META_LINE = 4;
    private static final byte META_CONSISTENCY = 8;
    private static final byte META_OPERATION = 16;
    private static final byte META_REFORDERPOS = 32;
    private static final byte META_REFBID = 64;
    private static final byte META_REFOID = -128;
    private HashMap<String, Integer> name2idx = new HashMap();
    private HashMap<Integer, String> idx2name = new HashMap();
    private int nameIdx = 1;
    protected JtsextGeometryFactory jtsFactory = new JtsextGeometryFactory();
    protected IoxFactoryCollection ioxFactory = null;
    private Map<Integer, IomObject> id2obj = null;
    private Map<IomObject, Integer> obj2id = null;
    private int nextId = 0;

    protected void startObject() {
        this.nextId = 1;
        this.id2obj = new HashMap<Integer, IomObject>();
        this.obj2id = new HashMap<IomObject, Integer>();
    }

    protected void endObject() {
        this.id2obj = null;
        this.obj2id = null;
    }

    protected void writeIomObject(ByteArrayOutputStream byteStream, IomObject iomObj) {
        if (this.obj2id.containsKey(iomObj)) {
            boolean metaAttrs = false;
            this.writeInt(byteStream, this.obj2id.get(iomObj));
        } else {
            int i;
            String refoid;
            String refbid;
            long reforderpos;
            int operation;
            int consistency;
            int line;
            int col;
            this.obj2id.put(iomObj, this.nextId);
            this.writeInt(byteStream, this.nextId);
            ++this.nextId;
            byte metaAttrs = 0;
            String oid = iomObj.getobjectoid();
            if (oid != null) {
                metaAttrs = (byte)(metaAttrs | 1);
            }
            if ((col = iomObj.getobjectcol()) != 0) {
                metaAttrs = (byte)(metaAttrs | 2);
            }
            if ((line = iomObj.getobjectline()) != 0) {
                metaAttrs = (byte)(metaAttrs | 4);
            }
            if ((consistency = iomObj.getobjectconsistency()) != 0) {
                metaAttrs = (byte)(metaAttrs | 8);
            }
            if ((operation = iomObj.getobjectoperation()) != 0) {
                metaAttrs = (byte)(metaAttrs | 0x10);
            }
            if ((reforderpos = iomObj.getobjectreforderpos()) != 0L) {
                metaAttrs = (byte)(metaAttrs | 0x20);
            }
            if ((refbid = iomObj.getobjectrefbid()) != null) {
                metaAttrs = (byte)(metaAttrs | 0x40);
            }
            if ((refoid = iomObj.getobjectrefoid()) != null) {
                metaAttrs = (byte)(metaAttrs | 0xFFFFFF80);
            }
            this.writeByte(byteStream, metaAttrs);
            this.writeInt(byteStream, this.mapName2Idx(iomObj.getobjecttag()));
            if (oid != null) {
                this.writeString(byteStream, oid);
            }
            if (col != 0) {
                this.writeInt(byteStream, col);
            }
            if (line != 0) {
                this.writeInt(byteStream, line);
            }
            if (consistency != 0) {
                this.writeInt(byteStream, consistency);
            }
            if (operation != 0) {
                this.writeInt(byteStream, operation);
            }
            if (reforderpos != 0L) {
                this.writeLong(byteStream, reforderpos);
            }
            if (refbid != null) {
                this.writeString(byteStream, refbid);
            }
            if (refoid != null) {
                this.writeString(byteStream, refoid);
            }
            int attrc = iomObj.getattrcount();
            this.writeInt(byteStream, attrc);
            Object[] propNames = new String[attrc];
            for (i = 0; i < attrc; ++i) {
                propNames[i] = iomObj.getattrname(i);
            }
            Arrays.sort(propNames);
            for (i = 0; i < attrc; ++i) {
                Object propName = propNames[i];
                String value = iomObj.getattrprim((String)propName, 0);
                if (value != null) {
                    this.writeByte(byteStream, 1);
                    this.writeInt(byteStream, this.mapName2Idx((String)propName));
                    this.writeString(byteStream, value);
                    continue;
                }
                int propc = iomObj.getattrvaluecount((String)propName);
                if (propc == 1) {
                    this.writeByte(byteStream, 3);
                    this.writeInt(byteStream, this.mapName2Idx((String)propName));
                    IomObject structvalue = iomObj.getattrobj((String)propName, 0);
                    this.writeIomObject(byteStream, structvalue);
                    continue;
                }
                this.writeByte(byteStream, 2);
                this.writeInt(byteStream, this.mapName2Idx((String)propName));
                this.writeInt(byteStream, propc);
                for (int propi = 0; propi < propc; ++propi) {
                    IomObject structvalue = iomObj.getattrobj((String)propName, propi);
                    this.writeIomObject(byteStream, structvalue);
                }
            }
        }
    }

    protected int mapName2Idx(String name) {
        Integer idx = this.name2idx.get(name);
        if (idx == null) {
            idx = this.nameIdx++;
            this.name2idx.put(name, idx);
            this.idx2name.put(idx, name);
        }
        return idx;
    }

    protected String mapIdx2Name(int idx) {
        if (!this.idx2name.containsKey(idx)) {
            throw new IllegalStateException();
        }
        String name = this.idx2name.get(idx);
        return name;
    }

    protected void writeString(ByteArrayOutputStream byteStream, String userData) {
        if (userData == null || userData.length() == 0) {
            this.writeInt(byteStream, 0);
        } else {
            try {
                byte[] stringBytes = userData.getBytes("UTF-8");
                this.writeInt(byteStream, stringBytes.length);
                byteStream.write(stringBytes);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException();
            }
            catch (IOException e) {
                throw new IllegalStateException();
            }
        }
    }

    protected void writeByte(ByteArrayOutputStream byteStream, int value) {
        byteStream.write(value);
    }

    protected void writeInt(ByteArrayOutputStream byteStream, int value) {
        byte[] bytes = new byte[4];
        LongSerializer.integerToBytes(value, bytes, 0);
        try {
            byteStream.write(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    protected void writeLong(ByteArrayOutputStream byteStream, long value) {
        byte[] bytes = new byte[8];
        LongSerializer.longToBytes(value, bytes);
        try {
            byteStream.write(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    protected IomObject readIomObject(ByteArrayInputStream in) {
        int id = this.readInt(in);
        if (this.id2obj.containsKey(id)) {
            return this.id2obj.get(id);
        }
        int metaAttrs = this.readByte(in);
        String tag = this.mapIdx2Name(this.readInt(in));
        String oid = null;
        if ((metaAttrs & 1) != 0) {
            oid = this.readString(in);
        }
        int col = 0;
        if ((metaAttrs & 2) != 0) {
            col = this.readInt(in);
        }
        int line = 0;
        if ((metaAttrs & 4) != 0) {
            line = this.readInt(in);
        }
        int consistency = 0;
        if ((metaAttrs & 8) != 0) {
            consistency = this.readInt(in);
        }
        int operation = 0;
        if ((metaAttrs & 0x10) != 0) {
            operation = this.readInt(in);
        }
        long reforderpos = 0L;
        if ((metaAttrs & 0x20) != 0) {
            reforderpos = this.readLong(in);
        }
        String refbid = null;
        if ((metaAttrs & 0x40) != 0) {
            refbid = this.readString(in);
        }
        String refoid = null;
        if ((metaAttrs & 0xFFFFFF80) != 0) {
            refoid = this.readString(in);
        }
        IomObject ret = null;
        if (this.ioxFactory != null) {
            try {
                ret = this.ioxFactory.createIomObject(tag, oid);
            }
            catch (IoxException e) {
                throw new IllegalStateException(e);
            }
        } else {
            ret = new Iom_jObject(tag, oid);
        }
        this.id2obj.put(id, ret);
        if (col != 0) {
            ret.setobjectcol(col);
        }
        if (line != 0) {
            ret.setobjectline(line);
        }
        if (consistency != 0) {
            ret.setobjectconsistency(consistency);
        }
        if (operation != 0) {
            ret.setobjectoperation(operation);
        }
        if (reforderpos != 0L) {
            ret.setobjectreforderpos(reforderpos);
        }
        if (refbid != null) {
            ret.setobjectrefbid(refbid);
        }
        if (refoid != null) {
            ret.setobjectrefoid(refoid);
        }
        int attrc = this.readInt(in);
        String[] propNames = new String[attrc];
        for (int i = 0; i < attrc; ++i) {
            String propName;
            int propType = this.readByte(in);
            if (propType == 1) {
                propName = propNames[i] = this.mapIdx2Name(this.readInt(in));
                String value = this.readString(in);
                if (value == null) continue;
                ret.setattrvalue(propName, value);
                continue;
            }
            if (propType == 3) {
                propName = propNames[i] = this.mapIdx2Name(this.readInt(in));
                IomObject structValue = this.readIomObject(in);
                ret.addattrobj(propName, structValue);
                continue;
            }
            if (propType == 2) {
                propName = propNames[i] = this.mapIdx2Name(this.readInt(in));
                int propc = this.readInt(in);
                for (int propi = 0; propi < propc; ++propi) {
                    IomObject structValue = this.readIomObject(in);
                    ret.addattrobj(propName, structValue);
                }
                continue;
            }
            throw new IllegalStateException();
        }
        return ret;
    }

    protected String readString(ByteArrayInputStream in) {
        int s = this.readInt(in);
        if (s == 0) {
            return null;
        }
        byte[] b = new byte[s];
        try {
            if (in.read(b) != s) {
                throw new IllegalStateException();
            }
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    protected int readByte(ByteArrayInputStream byteStream) {
        int ret = byteStream.read();
        if (ret == -1) {
            throw new IllegalStateException();
        }
        return ret;
    }

    protected int readInt(ByteArrayInputStream byteStream) {
        byte[] bytes = new byte[4];
        try {
            if (byteStream.read(bytes) != bytes.length) {
                throw new IllegalStateException();
            }
            return LongSerializer.bytesToInteger(bytes, 0);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    protected long readLong(ByteArrayInputStream byteStream) {
        byte[] bytes = new byte[8];
        try {
            if (byteStream.read(bytes) != bytes.length) {
                throw new IllegalStateException();
            }
            return LongSerializer.bytesToLong(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    protected void writeLineString(ByteArrayOutputStream byteStream, LineString shell) {
        if (shell instanceof CompoundCurveRing) {
            this.writeByte(byteStream, 6);
            CompoundCurveRing ring = (CompoundCurveRing)shell;
            ArrayList<CompoundCurve> lines = ring.getLines();
            int linec = lines.size();
            this.writeInt(byteStream, linec);
            for (int i = 0; i < linec; ++i) {
                this.writeCompoundCurve(byteStream, lines.get(i));
            }
        } else if (shell instanceof CompoundCurve) {
            this.writeByte(byteStream, 5);
            this.writeCompoundCurve(byteStream, (CompoundCurve)shell);
        } else {
            this.writeByte(byteStream, 4);
            Coordinate[] coords = shell.getCoordinates();
            this.writeInt(byteStream, coords.length);
            for (int i = 0; i < coords.length; ++i) {
                this.writeCoord(byteStream, coords[i]);
            }
        }
    }

    protected LineString readLineString(ByteArrayInputStream in) {
        Object ret = null;
        int type = this.readByte(in);
        if (type == 6) {
            int linec = this.readInt(in);
            ArrayList<CompoundCurve> lines = new ArrayList<CompoundCurve>();
            for (int i = 0; i < linec; ++i) {
                CompoundCurve curve = this.readCompoundCurve(in);
                lines.add(curve);
            }
            ret = new CompoundCurveRing(lines, (GeometryFactory)this.jtsFactory);
        } else if (type == 5) {
            ret = this.readCompoundCurve(in);
        } else if (type == 4) {
            int coordc = this.readInt(in);
            Coordinate[] coords = new Coordinate[coordc];
            for (int i = 0; i < coords.length; ++i) {
                coords[i] = this.readCoord(in);
            }
            ret = this.jtsFactory.createLineString(coords);
        } else {
            throw new IllegalStateException();
        }
        return ret;
    }

    protected void writeCompoundCurve(ByteArrayOutputStream byteStream, CompoundCurve value) {
        int segc = value.getNumSegments();
        this.writeInt(byteStream, segc);
        for (CurveSegment seg : value.getSegments()) {
            if (seg instanceof StraightSegment) {
                byteStream.write(1);
                this.writeCoord(byteStream, seg.getStartPoint());
                this.writeCoord(byteStream, seg.getEndPoint());
                this.writeString(byteStream, (String)seg.getUserData());
                continue;
            }
            if (seg instanceof ArcSegment) {
                byteStream.write(2);
                this.writeCoord(byteStream, seg.getStartPoint());
                this.writeCoord(byteStream, ((ArcSegment)seg).getMidPoint());
                this.writeCoord(byteStream, seg.getEndPoint());
                this.writeString(byteStream, (String)seg.getUserData());
                continue;
            }
            throw new IllegalStateException();
        }
        this.writeString(byteStream, (String)value.getUserData());
    }

    protected CompoundCurve readCompoundCurve(ByteArrayInputStream in) {
        int segc = this.readInt(in);
        ArrayList<CurveSegment> segs = new ArrayList<CurveSegment>(segc);
        for (int segi = 0; segi < segc; ++segi) {
            Coordinate startPt;
            int segType = in.read();
            CurveSegment seg = null;
            if (segType == 1) {
                startPt = this.readCoord(in);
                Coordinate endPt = this.readCoord(in);
                String userData = this.readString(in);
                seg = new StraightSegment(userData, startPt, endPt);
            } else if (segType == 2) {
                startPt = this.readCoord(in);
                Coordinate midPt = this.readCoord(in);
                Coordinate endPt = this.readCoord(in);
                String userData = this.readString(in);
                seg = new ArcSegment(userData, startPt, midPt, endPt);
            } else {
                throw new IllegalStateException();
            }
            segs.add(seg);
        }
        String userData = this.readString(in);
        CompoundCurve ret = new CompoundCurve(segs, this.jtsFactory);
        ret.setUserData(userData);
        return ret;
    }

    protected void writeCoord(ByteArrayOutputStream byteStream, Coordinate c) {
        byte[] b = new byte[8];
        try {
            LongSerializer.doubleToBytes(c.x, b);
            byteStream.write(b);
            LongSerializer.doubleToBytes(c.y, b);
            byteStream.write(b);
            LongSerializer.doubleToBytes(c.z, b);
            byteStream.write(b);
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    protected Coordinate readCoord(ByteArrayInputStream in) {
        byte[] b = new byte[8];
        try {
            if (in.read(b) != b.length) {
                throw new IllegalStateException();
            }
            double x = LongSerializer.bytesToDouble(b);
            if (in.read(b) != b.length) {
                throw new IllegalStateException();
            }
            double y = LongSerializer.bytesToDouble(b);
            if (in.read(b) != b.length) {
                throw new IllegalStateException();
            }
            double z = LongSerializer.bytesToDouble(b);
            return new Coordinate(x, y, z);
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }
}

