/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl.jtsext.noding;

import ch.ehi.iox.objpool.ObjectPoolManager;
import ch.ehi.iox.objpool.impl.CompoundCurveSerializer;
import ch.ehi.iox.objpool.impl.FileBasedCollection;
import ch.ehi.iox.objpool.impl.SortedSetIntegerSerializer;
import ch.interlis.iom_j.itf.impl.jtsext.algorithm.CurveSegmentIntersector;
import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.JtsextGeometryFactory;
import ch.interlis.iom_j.itf.impl.jtsext.noding.CurvePairInt;
import ch.interlis.iom_j.itf.impl.jtsext.noding.Intersection;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class CompoundCurveNoder {
    private CurveSegmentIntersector li = new CurveSegmentIntersector();
    private List<? extends CompoundCurve> segStrings;
    private List<CompoundCurve> nodedStrings;
    private List<Intersection> segInt = null;
    private Map<CompoundCurve, SortedSet<Integer>> nodes = null;
    private boolean isNoded = false;
    private boolean validateOnly = false;
    private boolean enableCommonSegments = false;
    private HashMap<CurvePairInt, HashSet<Coordinate>> compared = new HashMap();

    public CompoundCurveNoder(List segStrings, boolean validateOnly) {
        this.segStrings = segStrings;
        this.validateOnly = validateOnly;
        this.nodes = new HashMap<CompoundCurve, SortedSet<Integer>>();
        this.nodedStrings = new ArrayList<CompoundCurve>();
    }

    public CompoundCurveNoder(ObjectPoolManager objPoolManager, List segStrings, boolean validateOnly) {
        this.segStrings = segStrings;
        this.validateOnly = validateOnly;
        this.nodes = objPoolManager.newObjectPool2(this.getClass().getSimpleName(), new CompoundCurveSerializer(), new SortedSetIntegerSerializer());
        this.nodedStrings = new FileBasedCollection<CompoundCurve>(objPoolManager, this.getClass().getSimpleName(), new CompoundCurveSerializer());
    }

    public List<Intersection> getIntersections() {
        this.execute();
        return this.segInt;
    }

    public boolean isValid() {
        this.execute();
        return this.segInt.size() == 0;
    }

    private void execute() {
        if (this.segInt == null) {
            this.checkIntersections();
        }
    }

    private void checkIntersections() {
        CompoundCurve e0;
        int i;
        this.segInt = new ArrayList<Intersection>();
        STRtree polyidx = new STRtree();
        for (i = 0; i < this.segStrings.size(); ++i) {
            e0 = this.segStrings.get(i);
            Envelope env = new Envelope(e0.getEnvelopeInternal());
            polyidx.insert(env, (Object)i);
        }
        for (i = 0; i < this.segStrings.size(); ++i) {
            e0 = this.segStrings.get(i);
            List hits = polyidx.query(e0.getEnvelopeInternal());
            Iterator iterator = hits.iterator();
            while (iterator.hasNext()) {
                int e1_i = (Integer)iterator.next();
                CurvePairInt pair = new CurvePairInt(i, e1_i);
                if (this.compared.containsKey(pair)) continue;
                CompoundCurve e1 = this.segStrings.get(e1_i);
                this.compared.put(pair, new HashSet());
                this.computeIntersects(i, e0, e1_i, e1);
            }
        }
    }

    public Collection<? extends CompoundCurve> getNodedSubstrings() {
        if (this.isNoded) {
            return this.nodedStrings;
        }
        for (CompoundCurve compoundCurve : this.segStrings) {
            if (!this.nodes.containsKey((Object)compoundCurve)) {
                this.nodedStrings.add(compoundCurve);
                continue;
            }
            int startSeg = 0;
            JtsextGeometryFactory fact = (JtsextGeometryFactory)compoundCurve.getFactory();
            Iterator iterator = this.nodes.get((Object)compoundCurve).iterator();
            while (iterator.hasNext()) {
                int endSeg = (Integer)iterator.next();
                CompoundCurve newLine = null;
                newLine = fact.createCompoundCurve(compoundCurve.getSegments().subList(startSeg, endSeg));
                newLine.setUserData(compoundCurve.getUserData());
                this.nodedStrings.add(newLine);
                startSeg = endSeg;
            }
            CompoundCurve newLine = null;
            newLine = fact.createCompoundCurve(compoundCurve.getSegments().subList(startSeg, compoundCurve.getNumSegments()));
            newLine.setUserData(compoundCurve.getUserData());
            this.nodedStrings.add(newLine);
        }
        this.isNoded = true;
        return this.nodedStrings;
    }

    private void computeIntersects(int ss0Idx, CompoundCurve ss0, int ss1Idx, CompoundCurve ss1) {
        CurveSegment seg;
        int i;
        Coordinate[] endPts1 = new Coordinate[2];
        Coordinate[] endPts2 = new Coordinate[2];
        endPts1[0] = ss0.getStartPoint().getCoordinate();
        endPts1[1] = ss0.getEndPoint().getCoordinate();
        endPts2[0] = ss1.getStartPoint().getCoordinate();
        endPts2[1] = ss1.getEndPoint().getCoordinate();
        STRtree index0 = new STRtree();
        for (i = 0; i < ss0.getNumSegments(); ++i) {
            seg = ss0.getSegments().get(i);
            index0.insert(seg.computeEnvelopeInternal(), (Object)i);
        }
        if (ss0 == ss1) {
            for (i = 0; i < ss1.getNumSegments(); ++i) {
                seg = ss1.getSegments().get(i);
                List hits = index0.query(seg.computeEnvelopeInternal());
                Collections.sort(hits);
                Iterator iterator = hits.iterator();
                while (iterator.hasNext()) {
                    int hit = (Integer)iterator.next();
                    if (hit <= i) continue;
                    this.checkInteriorIntersections(ss0Idx, ss0, hit, ss1Idx, ss1, i, endPts1, endPts2);
                }
            }
        } else {
            for (i = 0; i < ss1.getNumSegments(); ++i) {
                seg = ss1.getSegments().get(i);
                List hits = index0.query(seg.computeEnvelopeInternal());
                Collections.sort(hits);
                Iterator iterator = hits.iterator();
                while (iterator.hasNext()) {
                    int hit = (Integer)iterator.next();
                    this.checkInteriorIntersections(ss0Idx, ss0, hit, ss1Idx, ss1, i, endPts1, endPts2);
                }
            }
        }
    }

    private void checkInteriorIntersections(int e0_i, CompoundCurve e0, int segIndex0, int e1_i, CompoundCurve e1, int segIndex1, Coordinate[] endPts1, Coordinate[] endPts2) {
        if (e0 == e1 && segIndex0 == segIndex1) {
            return;
        }
        Coordinate p00 = e0.getSegments().get(segIndex0).getStartPoint();
        Coordinate p01 = e0.getSegments().get(segIndex0).getEndPoint();
        Coordinate p10 = e1.getSegments().get(segIndex1).getStartPoint();
        Coordinate p11 = e1.getSegments().get(segIndex1).getEndPoint();
        CurveSegment s0 = e0.getSegments().get(segIndex0);
        CurveSegment s1 = e1.getSegments().get(segIndex1);
        this.li.computeIntersection(s0, s1);
        if (this.li.hasIntersection()) {
            if (this.li.getIntersectionNum() == 1) {
                if ((e0 != e1 || Math.abs(segIndex0 - segIndex1) != 1 && Math.abs(segIndex0 - segIndex1) != e0.getNumSegments() - 1 || !this.li.isIntersection(p00) && !this.li.isIntersection(p01) || !this.li.isIntersection(p10) && !this.li.isIntersection(p11)) && (e0 == e1 || !this.li.isIntersection(endPts1[0]) && !this.li.isIntersection(endPts1[1]) || !this.li.isIntersection(endPts2[0]) && !this.li.isIntersection(endPts2[1]))) {
                    if (this.validateOnly) {
                        this.segIntAdd(this.li.getIntersection(0), e0_i, e0, e1_i, e1, s0, s1, this.li.getOverlap());
                    } else if (this.li.isIntersection(p00)) {
                        if (this.li.isIntersection(p10)) {
                            this.createNode(e0, segIndex0);
                            this.createNode(e1, segIndex1);
                        } else if (this.li.isIntersection(p11)) {
                            this.createNode(e0, segIndex0);
                            this.createNode(e1, segIndex1 + 1);
                        } else {
                            this.segIntAdd(this.li.getIntersection(0), e0_i, e0, e1_i, e1, s0, s1, this.li.getOverlap());
                        }
                    } else if (this.li.isIntersection(p01)) {
                        if (this.li.isIntersection(p10)) {
                            this.createNode(e0, segIndex0 + 1);
                            this.createNode(e1, segIndex1);
                        } else if (this.li.isIntersection(p11)) {
                            this.createNode(e0, segIndex0 + 1);
                            this.createNode(e1, segIndex1 + 1);
                        } else {
                            this.segIntAdd(this.li.getIntersection(0), e0_i, e0, e1_i, e1, s0, s1, this.li.getOverlap());
                        }
                    } else {
                        this.segIntAdd(this.li.getIntersection(0), e0_i, e0, e1_i, e1, s0, s1, this.li.getOverlap());
                    }
                }
            } else if (this.li.isOverlay()) {
                if (this.validateOnly) {
                    this.segIntAdd(this.li.getIntersection(0), this.li.getIntersection(1), e0_i, e0, e1_i, e1, s0, s1, this.li.getOverlap(), true);
                } else if (this.enableCommonSegments) {
                    if (this.li.isIntersection(p00) && this.li.isIntersection(p01) && this.li.isIntersection(p10) && this.li.isIntersection(p11)) {
                        this.createNode(e0, segIndex0);
                        this.createNode(e0, segIndex0 + 1);
                        this.createNode(e1, segIndex1);
                        this.createNode(e1, segIndex1 + 1);
                    } else {
                        this.segIntAdd(this.li.getIntersection(0), this.li.getIntersection(1), e0_i, e0, e1_i, e1, s0, s1, this.li.getOverlap(), true);
                    }
                } else {
                    this.segIntAdd(this.li.getIntersection(0), this.li.getIntersection(1), e0_i, e0, e1_i, e1, s0, s1, this.li.getOverlap(), true);
                }
            } else if (!(e0 != e1 && e0.getNumSegments() == 1 && e1.getNumSegments() == 1 && this.li.isIntersection(endPts1[0]) && this.li.isIntersection(endPts1[1]) && this.li.isIntersection(endPts2[0]) && this.li.isIntersection(endPts2[1]) || e0 == e1 && e0.getNumSegments() == 2 && endPts1[0].equals2D(endPts1[1]) && (s0 instanceof ArcSegment || s1 instanceof ArcSegment))) {
                if (this.validateOnly) {
                    this.segIntAdd(this.li.getIntersection(0), this.li.getIntersection(1), e0_i, e0, e1_i, e1, s0, s1, this.li.getOverlap(), false);
                } else if (this.li.isIntersection(p00) && this.li.isIntersection(p01) && this.li.isIntersection(p10) && this.li.isIntersection(p11)) {
                    this.createNode(e0, segIndex0);
                    this.createNode(e0, segIndex0 + 1);
                    this.createNode(e1, segIndex1);
                    this.createNode(e1, segIndex1 + 1);
                } else {
                    this.segIntAdd(this.li.getIntersection(0), this.li.getIntersection(1), e0_i, e0, e1_i, e1, s0, s1, this.li.getOverlap(), false);
                }
            }
        }
    }

    private void segIntAdd(Coordinate intersection, Coordinate intersection2, int e0_i, CompoundCurve e0, int e1_i, CompoundCurve e1, CurveSegment s0, CurveSegment s1, Double overlap, boolean isOverlay) {
        HashSet<Coordinate> isList = this.compared.get(new CurvePairInt(e0_i, e1_i));
        boolean added = false;
        if (!isList.contains(intersection)) {
            added = true;
            isList.add(intersection);
        }
        if (!isList.contains(intersection2)) {
            added = true;
            isList.add(intersection2);
        }
        if (added) {
            Intersection is = new Intersection(intersection, intersection2, e0, e1, s0, s1, overlap, isOverlay);
            this.segInt.add(is);
        }
    }

    private void segIntAdd(Coordinate intersection, int e0_i, CompoundCurve e0, int e1_i, CompoundCurve e1, CurveSegment s0, CurveSegment s1, Double overlap) {
        HashSet<Coordinate> isList = this.compared.get(new CurvePairInt(e0_i, e1_i));
        if (!isList.contains(intersection)) {
            isList.add(intersection);
            Intersection is = new Intersection(intersection, e0, e1, s0, s1, overlap);
            this.segInt.add(is);
        }
    }

    private void createNode(CompoundCurve line, int nodeSegIndex) {
        if (nodeSegIndex == 0) {
            return;
        }
        if (nodeSegIndex == line.getNumSegments()) {
            return;
        }
        SortedSet<Object> toNodeIdx = null;
        if (this.nodes.containsKey((Object)line)) {
            toNodeIdx = this.nodes.get((Object)line);
        } else {
            toNodeIdx = new TreeSet();
            this.nodes.put(line, toNodeIdx);
        }
        toNodeIdx.add(nodeSegIndex);
        this.nodes.put(line, toNodeIdx);
    }

    public void checkValid() {
        if (!this.isValid()) {
            throw new IllegalArgumentException("intersections");
        }
    }

    public boolean isEnableCommonSegments() {
        return this.enableCommonSegments;
    }

    public void setEnableCommonSegments(boolean removeCommonSegments) {
        this.enableCommonSegments = removeCommonSegments;
    }
}

