/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.types.OutParam;
import ch.ehi.iox.objpool.ObjectPoolManager;
import ch.ehi.iox.objpool.impl.IomObjectArraySerializer;
import ch.ehi.iox.objpool.impl.PolygonSerializer;
import ch.interlis.ili2c.metamodel.AbstractCoordType;
import ch.interlis.ili2c.metamodel.AbstractSurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iom_j.itf.impl.LineSet;
import ch.interlis.iom_j.itf.impl.Linetable2Polygon;
import ch.interlis.iom_j.itf.impl.jtsext.algorithm.CurveSegmentIntersector;
import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.JtsextGeometryFactory;
import ch.interlis.iom_j.itf.impl.jtsext.geom.StraightSegment;
import ch.interlis.iom_j.itf.impl.jtsext.noding.CompoundCurveNoder;
import ch.interlis.iom_j.itf.impl.jtsext.noding.Intersection;
import ch.interlis.iom_j.itf.impl.jtsext.operation.polygonize.IoxPolygonizer;
import ch.interlis.iox.IoxException;
import ch.interlis.iox_j.IoxInvalidDataException;
import ch.interlis.iox_j.jts.Iox2jtsException;
import ch.interlis.iox_j.jts.Iox2jtsext;
import ch.interlis.iox_j.jts.Jtsext2iox;
import ch.interlis.iox_j.logging.LogEventFactory;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ItfSurfaceLinetable2Polygon
implements Linetable2Polygon {
    private Map<String, Polygon> polygons = null;
    private Set<String> mainTids = new HashSet<String>();
    private Map<String, String> lineTid2mainTid = new HashMap<String, String>();
    private Map<String, List<IomObject>> linepool = null;
    private boolean surfacesBuilt = false;
    private String helperTableMainTableRef = null;
    private String helperTableGeomAttrName = null;
    private Table linattrTab = null;
    private JtsextGeometryFactory jtsFact = new JtsextGeometryFactory();
    private double maxOverlaps = 0.0;
    private double newVertexOffset = 0.0;
    private ObjectPoolManager objPool = null;
    private boolean keepLinetables = false;
    private int ignorePolygonBuildingErrors;
    ArrayList<IoxInvalidDataException> dataerrs = new ArrayList();
    private String linetableIliqname = null;
    private String geomattrIliqname = null;

    public ItfSurfaceLinetable2Polygon(AttributeDef surfaceAttr, boolean ignorePolygonBuildingErrors1) {
        this(surfaceAttr, ignorePolygonBuildingErrors1 ? 1 : 0);
    }

    public ItfSurfaceLinetable2Polygon(AttributeDef surfaceAttr, int ignorePolygonBuildingErrors1) {
        this.linetableIliqname = surfaceAttr.getContainer().getScopedName(null) + "_" + surfaceAttr.getName();
        this.geomattrIliqname = surfaceAttr.getContainer().getScopedName(null) + "." + surfaceAttr.getName();
        this.ignorePolygonBuildingErrors = ignorePolygonBuildingErrors1;
        PrecisionDecimal overlapDef = ((SurfaceType)surfaceAttr.getDomainResolvingAliases()).getMaxOverlap();
        if (overlapDef != null) {
            NumericalType[] dimensions;
            double size;
            this.maxOverlaps = overlapDef.doubleValue();
            if (this.maxOverlaps > 0.0 && (size = (double)((NumericType)(dimensions = ((CoordType)((SurfaceType)surfaceAttr.getDomainResolvingAliases()).getControlPointDomain().getType()).getDimensions())[0]).getMinimum().getAccuracy()) > 0.0) {
                this.newVertexOffset = 2.0 * Math.pow(10.0, -size);
            }
        }
        this.linattrTab = ((SurfaceType)surfaceAttr.getDomainResolvingAliases()).getLineAttributeStructure();
        this.helperTableMainTableRef = ModelUtilities.getHelperTableMainTableRef(surfaceAttr);
        this.helperTableGeomAttrName = ModelUtilities.getHelperTableGeomAttrName(surfaceAttr);
        this.objPool = new ObjectPoolManager();
        this.polygons = this.objPool.newObjectPoolImpl2(this.getClass().getSimpleName(), new PolygonSerializer());
    }

    public ItfSurfaceLinetable2Polygon(String tableRef, String geomAttr) {
        this.helperTableMainTableRef = tableRef;
        this.helperTableGeomAttrName = geomAttr;
        this.objPool = new ObjectPoolManager();
        this.polygons = this.objPool.newObjectPoolImpl2(this.getClass().getSimpleName(), new PolygonSerializer());
    }

    public ItfSurfaceLinetable2Polygon(String tableRef, String geomAttr, double maxOverlaps, double accuracy) {
        this.helperTableMainTableRef = tableRef;
        this.helperTableGeomAttrName = geomAttr;
        this.objPool = new ObjectPoolManager();
        this.polygons = this.objPool.newObjectPoolImpl2(this.getClass().getSimpleName(), new PolygonSerializer());
        this.maxOverlaps = maxOverlaps;
        if (accuracy > 0.0) {
            this.newVertexOffset = 2.0 * Math.pow(10.0, -accuracy);
        }
    }

    @Override
    public void close() {
        if (this.objPool != null) {
            this.linepool = null;
            this.polygons = null;
            this.mainTids = null;
            this.objPool.close();
            this.objPool = null;
        }
    }

    @Override
    public void addItfLinetableObject(IomObject iomObj) {
        if (this.linepool == null) {
            this.linepool = this.objPool.newObjectPoolImpl2(this.getClass().getSimpleName(), new IomObjectArraySerializer());
        }
        IomObject structvalue = iomObj.getattrobj(this.helperTableMainTableRef, 0);
        String mainTid = null;
        if (structvalue != null) {
            mainTid = structvalue.getobjectrefoid();
        }
        if (mainTid == null) {
            this.dataerrs.add(new IoxInvalidDataException("boundary line without reference to main table", this.linetableIliqname, iomObj.getobjectoid(), iomObj));
            return;
        }
        ArrayList<IomObject> lines = null;
        if (this.linepool.containsKey(mainTid)) {
            lines = new ArrayList(this.linepool.get(mainTid));
            lines.add(iomObj);
            this.linepool.put(mainTid, lines);
        } else {
            lines = new ArrayList<IomObject>();
            lines.add(iomObj);
            this.linepool.put(mainTid, lines);
        }
        String lineTid = iomObj.getobjectoid();
        this.lineTid2mainTid.put(lineTid, mainTid);
    }

    public void addMainObjectTid(String tid) {
        this.mainTids.add(tid);
    }

    @Override
    public Iterator<String> mainTableTidIterator() {
        return this.mainTids.iterator();
    }

    @Override
    public IomObject getSurfaceObject(String mainObjectTid) throws IoxException {
        if (!this.surfacesBuilt) {
            this.buildSurfaces();
        }
        if (this.polygons.containsKey(mainObjectTid)) {
            try {
                return Jtsext2iox.JTS2surface(this.polygons.get(mainObjectTid));
            }
            catch (Iox2jtsException e) {
                throw new IoxException(e);
            }
        }
        return null;
    }

    @Override
    public void buildSurfaces() throws IoxException {
        this.surfacesBuilt = true;
        if (this.linepool == null) {
            this.linepool = new HashMap<String, List<IomObject>>();
        }
        int totalObj = this.linepool.keySet().size();
        boolean objc = true;
        EhiLogger.traceState("build surfaces..." + this.helperTableGeomAttrName + ", maxOverlaps " + this.maxOverlaps);
        boolean isDisconnected = false;
        for (String mainTid : this.linepool.keySet()) {
            List<IomObject> lines1 = this.linepool.get(mainTid);
            HashMap<String, IomObject> lines = new HashMap<String, IomObject>();
            for (IomObject line : lines1) {
                IomObject polyline = line.getattrobj(this.helperTableGeomAttrName, 0);
                if (polyline == null) {
                    this.dataerrs.add(new IoxInvalidDataException("empty line", this.linetableIliqname, line.getobjectoid(), line));
                    continue;
                }
                lines.put(line.getobjectoid(), line);
            }
            LineSet lineset = new LineSet(true, this.linattrTab, this.helperTableGeomAttrName);
            ArrayList<CompoundCurve> segv = lineset.buildBoundaries(lines, this.jtsFact);
            OutParam<Polygon> poly = new OutParam<Polygon>();
            ItfSurfaceLinetable2Polygon.createPolygon(mainTid, segv, this.maxOverlaps, this.newVertexOffset, this.dataerrs, this.linetableIliqname, this.geomattrIliqname, poly);
            if (poly.value == null) continue;
            this.polygons.put(mainTid, (Polygon)poly.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateMultiPolygon(String mainTid, AttributeDef surfaceAttr, IomObject polygon, LogEventFactory errFact, String validationType, AbstractCoordType controlPointType) throws IoxException {
        NumericalType[] dimensions;
        double size;
        String linetableIliqname = surfaceAttr.getContainer().getScopedName(null) + "." + surfaceAttr.getName();
        boolean polygonValid = true;
        double maxOverlaps = 0.0;
        double newVertexOffset = 0.0;
        AbstractSurfaceOrAreaType polygonType = (AbstractSurfaceOrAreaType)surfaceAttr.getDomainResolvingAliases();
        PrecisionDecimal overlapDef = polygonType.getMaxOverlap();
        if (overlapDef != null && (maxOverlaps = overlapDef.doubleValue()) > 0.0 && (size = (double)((NumericType)(dimensions = controlPointType.getDimensions())[0]).getMinimum().getAccuracy()) > 0.0) {
            newVertexOffset = 2.0 * Math.pow(10.0, -size);
        }
        JtsextGeometryFactory jtsFact = new JtsextGeometryFactory();
        ArrayList<CompoundCurve> segv = Iox2jtsext.multisurface2JTSCompoundCurves(polygon, validationType, 0.0, errFact);
        if (segv == null) {
            return true;
        }
        for (CompoundCurve seg : segv) {
            seg.setUserData(mainTid);
        }
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        ArrayList<IoxInvalidDataException> dataerrs = new ArrayList<IoxInvalidDataException>();
        try {
            ItfSurfaceLinetable2Polygon.createMultiPolygon(mainTid, segv, maxOverlaps, newVertexOffset, dataerrs, linetableIliqname, null, polys);
        }
        finally {
            if (dataerrs.size() > 0) {
                polygonValid = false;
            }
            if (!"off".equals(validationType)) {
                if ("warning".equals(validationType)) {
                    for (IoxInvalidDataException err : dataerrs) {
                        errFact.addEvent(errFact.logWarning(err));
                    }
                } else {
                    for (IoxInvalidDataException err : dataerrs) {
                        errFact.addEvent(errFact.logError(err));
                    }
                }
            }
        }
        return polygonValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validatePolygon(String mainTid, AttributeDef surfaceAttr, IomObject polygon, LogEventFactory errFact, String validationType, AbstractCoordType controlPointType) throws IoxException {
        NumericalType[] dimensions;
        double size;
        String linetableIliqname = surfaceAttr.getContainer().getScopedName(null) + "." + surfaceAttr.getName();
        boolean polygonValid = true;
        double maxOverlaps = 0.0;
        double newVertexOffset = 0.0;
        AbstractSurfaceOrAreaType polygonType = (AbstractSurfaceOrAreaType)surfaceAttr.getDomainResolvingAliases();
        PrecisionDecimal overlapDef = polygonType.getMaxOverlap();
        if (overlapDef != null && (maxOverlaps = overlapDef.doubleValue()) > 0.0 && (size = (double)((NumericType)(dimensions = controlPointType.getDimensions())[0]).getMinimum().getAccuracy()) > 0.0) {
            newVertexOffset = 2.0 * Math.pow(10.0, -size);
        }
        JtsextGeometryFactory jtsFact = new JtsextGeometryFactory();
        ArrayList<CompoundCurve> segv = Iox2jtsext.surface2JTSCompoundCurves(polygon, validationType, 0.0, errFact);
        if (segv == null) {
            return true;
        }
        for (CompoundCurve seg : segv) {
            seg.setUserData(mainTid);
        }
        OutParam<Polygon> poly = new OutParam<Polygon>();
        ArrayList<IoxInvalidDataException> dataerrs = new ArrayList<IoxInvalidDataException>();
        try {
            ItfSurfaceLinetable2Polygon.createPolygon(mainTid, segv, maxOverlaps, newVertexOffset, dataerrs, linetableIliqname, null, poly);
        }
        finally {
            if (dataerrs.size() > 0) {
                polygonValid = false;
            }
            if (!"off".equals(validationType)) {
                if ("warning".equals(validationType)) {
                    for (IoxInvalidDataException err : dataerrs) {
                        errFact.addEvent(errFact.logWarning(err));
                    }
                } else {
                    for (IoxInvalidDataException err : dataerrs) {
                        errFact.addEvent(errFact.logError(err));
                    }
                }
            }
        }
        return polygonValid;
    }

    private static void createPolygon_(String mainTid, ArrayList<CompoundCurve> segv, double maxOverlaps, double newVertexOffset, ArrayList<IoxInvalidDataException> dataerrs, String linetableIliqname, String geomattrIliqname, List<Polygon> returnPolygons) throws IoxInvalidDataException {
        Collection polys;
        Collection invalidRingLines;
        Collection collection;
        boolean hasIntersections = false;
        for (CompoundCurve compoundCurve : segv) {
            ItfSurfaceLinetable2Polygon.removeValidSelfIntersections(compoundCurve, maxOverlaps, newVertexOffset);
        }
        CompoundCurveNoder validator = new CompoundCurveNoder(segv, false);
        if (!validator.isValid()) {
            for (Intersection intersection : validator.getIntersections()) {
                String[] tids;
                CompoundCurve compoundCurve = intersection.getCurve1();
                CompoundCurve e1 = intersection.getCurve2();
                CurveSegment seg0 = intersection.getSegment1();
                CurveSegment seg1 = intersection.getSegment2();
                int segIndex0 = compoundCurve.getSegments().indexOf(intersection.getSegment1());
                int segIndex1 = e1.getSegments().indexOf(intersection.getSegment2());
                Coordinate p00 = compoundCurve.getSegments().get(segIndex0).getStartPoint();
                Coordinate p01 = compoundCurve.getSegments().get(segIndex0).getEndPoint();
                Coordinate p10 = e1.getSegments().get(segIndex1).getStartPoint();
                Coordinate p11 = e1.getSegments().get(segIndex1).getEndPoint();
                if (intersection.isOverlay()) {
                    tids = new String[]{(String)intersection.getCurve1().getUserData(), (String)intersection.getCurve2().getUserData()};
                    if (tids[0].equals(tids[1])) {
                        tids[1] = null;
                    }
                    dataerrs.add(new IoxInvalidDataException(intersection.toShortString(), linetableIliqname, null, Jtsext2iox.JTS2coord(intersection.getPt()[0])));
                    hasIntersections = true;
                    continue;
                }
                if (!(compoundCurve == e1 || segIndex0 != 0 && segIndex0 != compoundCurve.getSegments().size() - 1 || segIndex1 != 0 && segIndex1 != e1.getSegments().size() - 1 || intersection.getOverlap() == null) && intersection.getOverlap() < maxOverlaps) continue;
                if (compoundCurve == e1 && (Math.abs(segIndex0 - segIndex1) == 1 || Math.abs(segIndex0 - segIndex1) == compoundCurve.getNumSegments() - 1) && (intersection.isIntersection(p00) || intersection.isIntersection(p01)) && (intersection.isIntersection(p10) || intersection.isIntersection(p11)) && intersection.getOverlap() != null && intersection.getOverlap() < maxOverlaps) {
                    throw new IllegalStateException("unexpected overlap; should have been removed before;" + intersection);
                }
                tids = new String[]{(String)intersection.getCurve1().getUserData(), (String)intersection.getCurve2().getUserData()};
                dataerrs.add(new IoxInvalidDataException(intersection.toShortString(), linetableIliqname, null, Jtsext2iox.JTS2coord(intersection.getPt()[0])));
                hasIntersections = true;
            }
            if (hasIntersections) {
                return;
            }
        }
        IoxPolygonizer ioxPolygonizer = new IoxPolygonizer(newVertexOffset);
        for (CompoundCurve compoundCurve : validator.getNodedSubstrings()) {
            ioxPolygonizer.add((Geometry)compoundCurve);
        }
        Collection collection2 = ioxPolygonizer.getCutEdges();
        if (!collection2.isEmpty()) {
            for (Object edge : collection2) {
                try {
                    dataerrs.add(new IoxInvalidDataException("cut edge " + IoxInvalidDataException.formatTids((CompoundCurve)((Object)edge)), linetableIliqname, null, Jtsext2iox.JTS2polyline((CompoundCurve)((Object)edge))));
                }
                catch (Iox2jtsException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        if (!(collection = ioxPolygonizer.getDangles()).isEmpty()) {
            for (Object dangle : collection) {
                try {
                    dataerrs.add(new IoxInvalidDataException("dangle " + IoxInvalidDataException.formatTids((CompoundCurve)((Object)dangle)), linetableIliqname, null, Jtsext2iox.JTS2polyline((CompoundCurve)((Object)dangle))));
                }
                catch (Iox2jtsException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        if (!(invalidRingLines = ioxPolygonizer.getInvalidRingLines()).isEmpty()) {
            for (Object invalidRingLine : invalidRingLines) {
                try {
                    dataerrs.add(new IoxInvalidDataException("invald ring line" + IoxInvalidDataException.formatTids((CompoundCurve)((Object)invalidRingLine)), linetableIliqname, null, Jtsext2iox.JTS2polyline((CompoundCurve)((Object)invalidRingLine))));
                }
                catch (Iox2jtsException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        if ((polys = ioxPolygonizer.getPolygons()).isEmpty()) {
            dataerrs.add(new IoxInvalidDataException("no polygon"));
            return;
        }
        returnPolygons.addAll(polys);
    }

    private static void createPolygon(String mainTid, ArrayList<CompoundCurve> segv, double maxOverlaps, double newVertexOffset, ArrayList<IoxInvalidDataException> dataerrs, String linetableIliqname, String geomattrIliqname, OutParam<Polygon> returnPolygon) throws IoxInvalidDataException {
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        ItfSurfaceLinetable2Polygon.createPolygon_(mainTid, segv, maxOverlaps, newVertexOffset, dataerrs, linetableIliqname, geomattrIliqname, polys);
        if (!polys.isEmpty()) {
            Polygon poly = null;
            boolean isDisconnected = false;
            if (polys.size() > 1) {
                Iterator<Polygon> pi = polys.iterator();
                poly = pi.next();
                Envelope shell = poly.getEnvelopeInternal();
                while (pi.hasNext()) {
                    Polygon nextPoly = pi.next();
                    Envelope nextEnv = nextPoly.getEnvelopeInternal();
                    if (!nextEnv.contains(shell)) continue;
                    poly = nextPoly;
                    shell = nextEnv;
                }
                for (Polygon holePoly : polys) {
                    Envelope holeEnv;
                    if (holePoly == poly || shell.contains(holeEnv = holePoly.getEnvelopeInternal()) && !shell.equals((Object)holeEnv)) continue;
                    isDisconnected = true;
                    try {
                        dataerrs.add(new IoxInvalidDataException("superfluous outerboundary " + IoxInvalidDataException.formatTids(new String[]{mainTid}), geomattrIliqname, mainTid, Jtsext2iox.JTS2surface(holePoly)));
                    }
                    catch (Iox2jtsException e) {
                        throw new IllegalStateException(e);
                    }
                }
                if (isDisconnected) {
                    dataerrs.add(new IoxInvalidDataException("multipolygon detected"));
                    return;
                }
            } else {
                poly = polys.iterator().next();
            }
            poly.normalize();
            returnPolygon.value = poly;
        }
    }

    private static void createMultiPolygon(String mainTid, ArrayList<CompoundCurve> segv, double maxOverlaps, double newVertexOffset, ArrayList<IoxInvalidDataException> dataerrs, String linetableIliqname, String geomattrIliqname, List<Polygon> polys) throws IoxInvalidDataException {
        ItfSurfaceLinetable2Polygon.createPolygon_(mainTid, segv, maxOverlaps, newVertexOffset, dataerrs, linetableIliqname, geomattrIliqname, polys);
    }

    public static void removeValidSelfIntersections(CompoundCurve seg, double maxOverlaps, double newVertexOffset) {
        if (seg.getNumSegments() == 1) {
            return;
        }
        for (int segIndex0 = 0; segIndex0 < seg.getNumSegments(); ++segIndex0) {
            int segIndex1 = segIndex0 + 1;
            if (segIndex1 == seg.getNumSegments()) {
                segIndex1 = 0;
            }
            CurveSegment seg0 = seg.getSegments().get(segIndex0);
            CurveSegment seg1 = seg.getSegments().get(segIndex1);
            CurveSegmentIntersector li = new CurveSegmentIntersector();
            li.computeIntersection(seg0, seg1);
            if (!li.hasIntersection()) continue;
            if (li.getIntersectionNum() == 2) {
                if (li.isOverlay() || seg.getNumSegments() == 2 && seg0.getStartPoint().equals2D(seg1.getEndPoint()) || li.getOverlap() == null || !(li.getOverlap() < maxOverlaps)) continue;
                Intersection is = new Intersection(li.getIntersection(0), li.getIntersection(1), seg, seg, seg0, seg1, li.getOverlap(), false);
                EhiLogger.traceState("valoverlap " + is.toString());
                if (seg0 instanceof StraightSegment) {
                    seg.removeOverlap((ArcSegment)seg1, seg0, newVertexOffset);
                    continue;
                }
                if (seg1 instanceof StraightSegment) {
                    seg.removeOverlap((ArcSegment)seg0, seg1, newVertexOffset);
                    continue;
                }
                if (((ArcSegment)seg0).getRadius() > ((ArcSegment)seg1).getRadius()) {
                    seg.removeOverlap((ArcSegment)seg1, seg0, newVertexOffset);
                    continue;
                }
                seg.removeOverlap((ArcSegment)seg0, seg1, newVertexOffset);
                continue;
            }
            if (li.getIntersectionNum() == 1) continue;
            throw new IllegalArgumentException("seg0 and seg1 are not connected");
        }
    }

    @Override
    public ArrayList<IoxInvalidDataException> getDataerrs() {
        return this.dataerrs;
    }

    @Override
    public boolean isKeepLinetables() {
        return this.keepLinetables;
    }

    @Override
    public void setKeepLinetables(boolean keepLinetables, String ref1, String ref2) {
        this.keepLinetables = keepLinetables;
    }

    @Override
    public Iterator<String> lineTableTidIterator() {
        return this.lineTid2mainTid.keySet().iterator();
    }

    @Override
    public IomObject getLineObject(String lineTid) {
        String mainTid = this.lineTid2mainTid.get(lineTid);
        List<IomObject> lines = this.linepool.get(mainTid);
        for (IomObject line : lines) {
            if (!lineTid.equals(line.getobjectoid())) continue;
            return line;
        }
        return null;
    }
}

