/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.tools.TopoSort;
import ch.ehi.basics.view.GenericFileFilter;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.modelscan.IliFile;
import ch.interlis.ili2c.modelscan.IliModel;
import ch.interlis.ili2c.parser.Ili2ModelScan;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ModelScan {
    public static void main(String[] args) {
        EhiLogger.getInstance().setTraceFilter(false);
        ArrayList<String> dirName = new ArrayList<String>(Arrays.asList(args[0].split(";")));
        String model = args[1];
        ArrayList<String> models = new ArrayList<String>();
        models.add(model);
        try {
            ModelScan.getConfig(dirName, models);
        }
        catch (Ili2cException ex) {
            EhiLogger.logError(ex);
        }
    }

    public static IliFile scanIliFile(File file) {
        IliFile iliFile = new IliFile();
        String streamName = file.getAbsolutePath();
        iliFile.setFilename(file);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            Ili2ModelScan.mergeFile(iliFile, stream);
            stream.close();
            return iliFile;
        }
        catch (FileNotFoundException fnfex) {
            EhiLogger.logError(streamName + ": There is no such file.");
        }
        catch (Ili2cSemanticException ex) {
            EhiLogger.logAdaption(streamName + ": failed to scan file (" + ex.getCause().getMessage() + "); file ignored");
        }
        catch (Exception ex) {
            EhiLogger.logError(ex);
        }
        return null;
    }

    public static double getIliFileVersion(File file) {
        String streamName = file.getAbsolutePath();
        InputStreamReader stream = null;
        try {
            stream = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            double version = Ili2ModelScan.getIliVersion(stream);
            ((Reader)stream).close();
            return version;
        }
        catch (FileNotFoundException fnfex) {
            EhiLogger.logError(streamName + ":There is no such file.");
        }
        catch (Exception ex) {
            EhiLogger.logError(ex);
        }
        return 0.0;
    }

    public static HashSet scanIliFileDir(File dir, HashSet skipFiles) throws IOException {
        HashSet<IliFile> ret = new HashSet<IliFile>();
        if (!dir.exists()) {
            EhiLogger.logAdaption("Folder " + dir.getAbsoluteFile() + " doesn't exist; ignored");
            return ret;
        }
        if (!dir.isDirectory()) {
            EhiLogger.logAdaption(dir.getAbsoluteFile() + " isn't a folder; ignored");
            return ret;
        }
        File[] filev = dir.listFiles(new GenericFileFilter("INTERLIS models (*.ili)", "ili"));
        for (int i = 0; i < filev.length; ++i) {
            IliFile iliFile;
            if (filev[i].isDirectory()) continue;
            boolean ignoreFile = false;
            if (skipFiles != null) {
                for (File skipFile : skipFiles) {
                    if (!filev[i].getCanonicalFile().equals(skipFile.getCanonicalFile())) continue;
                    ignoreFile = true;
                    break;
                }
            }
            if (ignoreFile || (iliFile = ModelScan.scanIliFile(filev[i])) == null) continue;
            ret.add(iliFile);
        }
        return ret;
    }

    public static Configuration getConfig(ArrayList ilipathv, ArrayList requiredModels) throws Ili2cException {
        return ModelScan.getConfig(ilipathv, requiredModels, 0.0);
    }

    public static Configuration getConfig(ArrayList ilipathv, ArrayList requiredModels, double iliVersion) throws Ili2cException {
        IliModel model;
        Iterator modeli;
        ArrayList ilifiles = new ArrayList();
        for (int i = 0; i < ilipathv.size(); ++i) {
            String ilipath = (String)ilipathv.get(i);
            try {
                ilifiles.addAll(ModelScan.scanIliFileDir(new File(ilipath), null));
                continue;
            }
            catch (IOException e) {
                throw new Ili2cException("failed to scan folder " + ilipath, e);
            }
        }
        if (iliVersion == 0.0) {
            String firstModel = (String)requiredModels.get(0);
            for (IliFile ilifile : ilifiles) {
                modeli = ilifile.iteratorModel();
                while (modeli.hasNext()) {
                    model = (IliModel)modeli.next();
                    if (!model.getName().equals(firstModel)) continue;
                    iliVersion = model.getIliVersion();
                    break;
                }
                if (iliVersion == 0.0) continue;
                break;
            }
        }
        HashMap<String, IliFile> models = new HashMap<String, IliFile>();
        for (IliFile ilifile : ilifiles) {
            modeli = ilifile.iteratorModel();
            while (modeli.hasNext()) {
                model = (IliModel)modeli.next();
                if (model.getIliVersion() != iliVersion) continue;
                models.put(model.getName(), ilifile);
            }
        }
        HashSet<IliFile> toVisitFiles = new HashSet<IliFile>();
        Iterator it = requiredModels.iterator();
        HashSet<String> missingModels = new HashSet<String>();
        boolean err = false;
        while (it.hasNext()) {
            String model2 = (String)it.next();
            if (model2 == null) continue;
            IliFile file = (IliFile)models.get(model2);
            if (file == null) {
                if (!missingModels.contains(model2)) {
                    EhiLogger.logError(model2 + ": model not found");
                    missingModels.add(model2);
                }
                err = true;
                continue;
            }
            toVisitFiles.add(file);
        }
        if (err) {
            return null;
        }
        return ModelScan.createConfig(toVisitFiles, models);
    }

    public static Configuration getConfigWithFiles(ArrayList ilipaths, ArrayList requiredIliFileNames) throws Ili2cException {
        if (requiredIliFileNames.isEmpty()) {
            throw new Ili2cException("no ili files given");
        }
        HashSet<IliFile> ilifiles = new HashSet<IliFile>();
        HashSet<IliFile> toVisitFiles = new HashSet<IliFile>();
        HashSet<File> requiredFiles = new HashSet<File>();
        Iterator reqFileIt = requiredIliFileNames.iterator();
        HashSet<String> availablemodels = new HashSet<String>();
        double version = 0.0;
        while (reqFileIt.hasNext()) {
            IliModel model;
            String fname = (String)reqFileIt.next();
            File file = new File(fname);
            if (!file.exists()) {
                throw new Ili2cException(fname + ": There is no such file.");
            }
            IliFile iliFile = ModelScan.scanIliFile(file);
            if (iliFile == null) {
                throw new Ili2cException(fname + ": Failed to scan ili-file.");
            }
            if (iliFile == null) continue;
            boolean skipThisFile = false;
            Iterator modeli = iliFile.iteratorModel();
            while (modeli.hasNext()) {
                model = (IliModel)modeli.next();
                if (version == 0.0) {
                    version = model.getIliVersion();
                } else if (version != model.getIliVersion()) {
                    skipThisFile = true;
                    EhiLogger.logAdaption("different ili version; file ignored " + iliFile.getFilename());
                    break;
                }
                if (!availablemodels.contains(model.getName())) continue;
                skipThisFile = true;
                EhiLogger.logAdaption("duplicate model; file ignored " + iliFile.getFilename());
                break;
            }
            if (skipThisFile) continue;
            requiredFiles.add(file);
            ilifiles.add(iliFile);
            toVisitFiles.add(iliFile);
            modeli = iliFile.iteratorModel();
            while (modeli.hasNext()) {
                model = (IliModel)modeli.next();
                availablemodels.add(model.getName());
            }
        }
        if (!ModelScan.isFileSetComplete(ilifiles, availablemodels)) {
            for (String ilidir : ilipaths) {
                HashSet set = null;
                try {
                    set = ModelScan.scanIliFileDir(new File(ilidir), requiredFiles);
                }
                catch (IOException ex) {
                    throw new Ili2cException("failed to scan folder " + ilidir, ex);
                }
                if (set == null || set.isEmpty()) continue;
                ilifiles.addAll(set);
            }
        }
        HashMap<String, IliFile> models = new HashMap<String, IliFile>();
        for (IliFile ilifile : ilifiles) {
            Iterator modeli = ilifile.iteratorModel();
            while (modeli.hasNext()) {
                IliModel model = (IliModel)modeli.next();
                if (model.getIliVersion() != version) continue;
                models.put(model.getName(), ilifile);
            }
        }
        return ModelScan.createConfig(toVisitFiles, models);
    }

    private static boolean isFileSetComplete(Set<IliFile> ilifiles, Set<String> availablemodels) {
        for (IliFile ilifile : ilifiles) {
            Iterator modeli = ilifile.iteratorModel();
            while (modeli.hasNext()) {
                IliModel model = (IliModel)modeli.next();
                for (String dep : model.getDependencies()) {
                    if (availablemodels.contains(dep)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static Configuration createConfig(HashSet toVisitFiles, HashMap models) {
        if (toVisitFiles.isEmpty()) {
            throw new IllegalStateException("toVisitFiles.isEmpty()");
        }
        HashSet<IliFile> visitedFiles = new HashSet<IliFile>();
        TopoSort reqFiles = new TopoSort();
        HashSet<String> missingModels = new HashSet<String>();
        boolean modelsIncomplete = false;
        while (!toVisitFiles.isEmpty()) {
            IliFile ilifile = (IliFile)toVisitFiles.iterator().next();
            reqFiles.add(ilifile);
            Iterator modeli = ilifile.iteratorModel();
            while (modeli.hasNext()) {
                IliModel model = (IliModel)modeli.next();
                for (String dep : model.getDependencies()) {
                    IliFile supplier = (IliFile)models.get(dep);
                    if (supplier == null) {
                        if (!missingModels.contains(dep)) {
                            EhiLogger.logError(dep + ": model not found");
                            missingModels.add(dep);
                        }
                        modelsIncomplete = true;
                        continue;
                    }
                    if (!visitedFiles.contains(supplier)) {
                        toVisitFiles.add(supplier);
                    }
                    if (supplier == ilifile) continue;
                    reqFiles.addcond(supplier, ilifile);
                }
            }
            toVisitFiles.remove(ilifile);
            visitedFiles.add(ilifile);
        }
        if (modelsIncomplete) {
            return null;
        }
        if (!reqFiles.sort()) {
            StringBuilder loopele = new StringBuilder();
            Iterator resi = reqFiles.getResult().iterator();
            String sep = "";
            while (resi.hasNext()) {
                IliFile res = (IliFile)resi.next();
                loopele.append(sep);
                loopele.append(res.getFilename().getName());
                sep = "->";
            }
            EhiLogger.logError("loop in ili-files: " + loopele.toString());
            return null;
        }
        Iterator resi = reqFiles.getResult().iterator();
        Configuration config = new Configuration();
        while (resi.hasNext()) {
            IliFile res = (IliFile)resi.next();
            File iliFile = res.getFilename();
            config.addFileEntry(new FileEntry(iliFile.getAbsolutePath(), 1));
        }
        return config;
    }
}

