/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.parser;

import antlr.ANTLRError;
import antlr.ANTLRException;
import antlr.CommonHiddenStreamToken;
import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.NoViableAltForCharException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamHiddenTokenFilter;
import antlr.TokenStreamRecognitionException;
import antlr.collections.impl.BitSet;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.CompilerLogEvent;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.AttributeRef;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.ComposedUnit;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Contract;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.DataModel;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.ErrorMessages;
import ch.interlis.ili2c.metamodel.Ili1Format;
import ch.interlis.ili2c.metamodel.Ili2cMetaAttrs;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericallyDerivedUnit;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.PathElAbstractClassRole;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.UniqueEl;
import ch.interlis.ili2c.metamodel.UniquenessConstraint;
import ch.interlis.ili2c.metamodel.Unit;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.parser.Ili1Lexer;
import ch.interlis.ili2c.parser.Ili1ParserTokenTypes;
import ch.interlis.ili2c.parser.MetaValue;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class Ili1Parser
extends LLkParser
implements Ili1ParserTokenTypes {
    protected PredefinedModel modelInterlis;
    protected Type predefinedBooleanType;
    protected Table predefinedScalSystemClass;
    protected Table predefinedCoordSystemClass;
    protected TransferDescription td;
    private Ili1Lexer lexer;
    private TokenStreamHiddenTokenFilter filter;
    private Map ili1TableRefAttrs;
    private Ili2cMetaAttrs externalMetaAttrs = new Ili2cMetaAttrs();
    private int ili1AttrCounter = 0;
    private ArrayList ili1assocs = null;
    ResourceBundle rsrc = ResourceBundle.getBundle(ErrorMessages.class.getName(), Locale.getDefault());
    private int numIli1LineAttrStructures = 0;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "'('", "','", "')'", "NAME", "\"END\"", "POSINT", "\"TRANSFER\"", "';'", "\"MODEL\"", "'.'", "\"DOMAIN\"", "'='", "\"TOPIC\"", "\"OPTIONAL\"", "\"TABLE\"", "':'", "'->'", "EXPLANATION", "\"NO\"", "\"IDENT\"", "\"COORD2\"", "\"COORD3\"", "'['", "'..'", "']'", "\"DIM1\"", "\"DIM2\"", "\"RADIANS\"", "\"DEGREES\"", "\"GRADS\"", "\"TEXT\"", "'*'", "\"DATE\"", "\"HALIGNMENT\"", "\"VALIGNMENT\"", "\"POLYLINE\"", "\"WITHOUT\"", "\"SURFACE\"", "\"AREA\"", "\"LINEATTR\"", "\"WITH\"", "\"STRAIGHTS\"", "\"ARCS\"", "\"OVERLAPS\"", "'>'", "\"VERTEX\"", "\"BASE\"", "\"DERIVATIVES\"", "\"VIEW\"", "\"VERTEXINFO\"", "\"PERIPHERY\"", "\"CONTOUR\"", "'<-'", "\"FORMAT\"", "\"FREE\"", "\"FIX\"", "\"LINESIZE\"", "\"TIDSIZE\"", "\"CODE\"", "\"FONT\"", "\"BLANK\"", "\"DEFAULT\"", "\"UNDEFINED\"", "\"CONTINUE\"", "\"TID\"", "\"I16\"", "\"I32\"", "\"ANY\"", "HEXNUMBER", "ILI1_DEC", "NUMBER", "PLUS", "MINUS", "WS", "ILI_METAVALUE", "SL_COMMENT", "ILI_DOC", "ML_COMMENT", "ESC", "STRING", "DIGIT", "LETTER", "ILI1_SCALING", "HEXDIGIT", "NUMERICSTUFF"};
    public static final BitSet _tokenSet_0 = new BitSet(Ili1Parser.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(Ili1Parser.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(Ili1Parser.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(Ili1Parser.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(Ili1Parser.mk_tokenSet_4());
    public static final BitSet _tokenSet_5 = new BitSet(Ili1Parser.mk_tokenSet_5());
    public static final BitSet _tokenSet_6 = new BitSet(Ili1Parser.mk_tokenSet_6());
    public static final BitSet _tokenSet_7 = new BitSet(Ili1Parser.mk_tokenSet_7());
    public static final BitSet _tokenSet_8 = new BitSet(Ili1Parser.mk_tokenSet_8());
    public static final BitSet _tokenSet_9 = new BitSet(Ili1Parser.mk_tokenSet_9());
    public static final BitSet _tokenSet_10 = new BitSet(Ili1Parser.mk_tokenSet_10());
    public static final BitSet _tokenSet_11 = new BitSet(Ili1Parser.mk_tokenSet_11());
    public static final BitSet _tokenSet_12 = new BitSet(Ili1Parser.mk_tokenSet_12());
    public static final BitSet _tokenSet_13 = new BitSet(Ili1Parser.mk_tokenSet_13());
    public static final BitSet _tokenSet_14 = new BitSet(Ili1Parser.mk_tokenSet_14());
    public static final BitSet _tokenSet_15 = new BitSet(Ili1Parser.mk_tokenSet_15());
    public static final BitSet _tokenSet_16 = new BitSet(Ili1Parser.mk_tokenSet_16());
    public static final BitSet _tokenSet_17 = new BitSet(Ili1Parser.mk_tokenSet_17());
    public static final BitSet _tokenSet_18 = new BitSet(Ili1Parser.mk_tokenSet_18());
    public static final BitSet _tokenSet_19 = new BitSet(Ili1Parser.mk_tokenSet_19());
    public static final BitSet _tokenSet_20 = new BitSet(Ili1Parser.mk_tokenSet_20());
    public static final BitSet _tokenSet_21 = new BitSet(Ili1Parser.mk_tokenSet_21());

    public static boolean parseIliFile(TransferDescription td, String filename, Reader stream, int line0Offest, Ili2cMetaAttrs metaAttrs) {
        return Ili1Parser.parseIliFile(td, filename, new Ili1Lexer(stream), line0Offest, metaAttrs);
    }

    public static boolean parseIliFile(TransferDescription td, String filename, InputStream stream, int line0Offest, Ili2cMetaAttrs metaAttrs) {
        return Ili1Parser.parseIliFile(td, filename, new Ili1Lexer(stream), line0Offest, metaAttrs);
    }

    public static boolean parseIliFile(TransferDescription td, String filename, Ili1Lexer lexer, int line0Offest, Ili2cMetaAttrs metaAttrs) {
        try {
            if (filename != null && "".equals(td.getName())) {
                td.setName(filename);
            }
            lexer.setTokenObjectClass("antlr.CommonHiddenStreamToken");
            TokenStreamHiddenTokenFilter filter = new TokenStreamHiddenTokenFilter((TokenStream)lexer);
            filter.hide(80);
            filter.hide(78);
            Ili1Parser parser = new Ili1Parser((TokenStream)filter);
            if (metaAttrs != null) {
                parser.externalMetaAttrs = metaAttrs;
            }
            parser.lexer = lexer;
            parser.filter = filter;
            parser.setFilename(filename);
            return parser.interlisDescription(td);
        }
        catch (RecognitionException ex) {
            int line = ex.getLine();
            CompilerLogEvent.logError(filename, line, ex.getLocalizedMessage());
            return false;
        }
        catch (Ili2cSemanticException ex) {
            int line = ex.getSourceLine();
            CompilerLogEvent.logError(filename, line, ex.getLocalizedMessage());
            return false;
        }
        catch (TokenStreamRecognitionException ex) {
            if (ex.recog instanceof NoViableAltForCharException) {
                NoViableAltForCharException ex2 = (NoViableAltForCharException)ex.recog;
                String msg = "unexpected char: " + ex2.foundChar + " (0x" + Integer.toHexString(ex2.foundChar).toUpperCase() + ")";
                CompilerLogEvent.logError(filename, ex2.getLine(), msg);
            } else {
                CompilerLogEvent.logError(filename, ex.recog.getLine(), ex.getLocalizedMessage());
            }
            return false;
        }
        catch (ANTLRError ex) {
            EhiLogger.traceState((String)(filename + ": " + (Object)((Object)ex)));
            return false;
        }
        catch (Exception ex) {
            CompilerLogEvent.logError(filename, 0, ex);
            return false;
        }
    }

    public void reportError(String message) {
        String filename = this.getFilename();
        CompilerLogEvent.logError(filename, 0, message);
    }

    public void reportWarning(String message) {
        String filename = this.getFilename();
        CompilerLogEvent.logWarning(filename, 0, message);
    }

    private void reportError(String message, int lineNumber) {
        String filename = this.getFilename();
        CompilerLogEvent.logError(filename, lineNumber, message);
    }

    private void reportWarning(String message, int lineNumber) {
        String filename = this.getFilename();
        CompilerLogEvent.logWarning(filename, lineNumber, message);
    }

    private void reportError(Throwable ex, int lineNumber) {
        String filename = this.getFilename();
        if (ex instanceof RecognitionException) {
            CompilerLogEvent.logError(filename, lineNumber, ex.getLocalizedMessage());
        } else if (ex instanceof Ili2cSemanticException) {
            CompilerLogEvent.logError(filename, lineNumber, ex.getLocalizedMessage());
        } else {
            CompilerLogEvent.logError(filename, lineNumber, ex);
        }
    }

    private void reportError(Ili2cSemanticException ex) {
        String filename = this.getFilename();
        CompilerLogEvent.logError(filename, ex.getSourceLine(), ex.getLocalizedMessage());
    }

    protected void reportError(List<Ili2cSemanticException> errs) {
        String filename = this.getFilename();
        for (Ili2cSemanticException ex : errs) {
            CompilerLogEvent.logError(filename, ex.getSourceLine(), ex.getLocalizedMessage());
        }
    }

    public void reportError(RecognitionException ex) {
        String filename = this.getFilename();
        int lineNumber = ex.getLine();
        CompilerLogEvent.logError(filename, lineNumber, ex.getLocalizedMessage());
    }

    private void reportInternalError(int lineNumber) {
        String filename = this.getFilename();
        CompilerLogEvent.logError(filename, lineNumber, this.formatMessage("err_internalCompilerError", ""));
    }

    private void reportInternalError(Throwable ex, int lineNumber) {
        String filename = this.getFilename();
        CompilerLogEvent.logError(filename, lineNumber, this.formatMessage("err_internalCompilerError", ""), ex);
    }

    private String formatMessage(String msg, Object[] args) {
        try {
            MessageFormat mess = new MessageFormat(this.rsrc.getString(msg));
            return mess.format(args);
        }
        catch (Exception ex) {
            EhiLogger.logError((String)"Internal compiler error", (Throwable)ex);
            return "Internal compiler error [" + ex.getLocalizedMessage() + "]";
        }
    }

    private String formatMessage(String msg, String arg) {
        return this.formatMessage(msg, new Object[]{arg});
    }

    private String formatMessage(String msg, String arg1, String arg2) {
        return this.formatMessage(msg, new Object[]{arg1, arg2});
    }

    private String formatMessage(String msg, String arg1, String arg2, String arg3) {
        return this.formatMessage(msg, new Object[]{arg1, arg2, arg3});
    }

    public static void panic() {
        throw new ANTLRError();
    }

    private LineForm findLineFormByExplanation(Container scope, String explanation) {
        Model model = (Model)scope.getContainerOrSame(Model.class);
        Iterator iter = model.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof LineForm) || !explanation.equals(((LineForm)obj).getExplanation())) continue;
            return (LineForm)obj;
        }
        return null;
    }

    private Table createImplicitLineAttrStructure(Container container, Viewable table, int lineNumber) {
        Table result = new Table();
        ++this.numIli1LineAttrStructures;
        try {
            result.setName("LineAttrib" + this.numIli1LineAttrStructures);
            result.setIdentifiable(false);
            result.setIli1LineAttrStruct(true);
            if (container instanceof Topic && table != null) {
                ((Topic)container).addBefore(result, table);
            } else if (container instanceof Model && table != null) {
                ((Model)container).addBefore(result, table);
            } else {
                container.add(result);
            }
        }
        catch (Exception ex) {
            this.reportInternalError(ex, lineNumber);
        }
        return result;
    }

    private int countElements(Container container, Class klass) {
        int numMatchingElements = 0;
        Iterator iter = container.iterator();
        while (iter.hasNext()) {
            if (!klass.isInstance(iter.next())) continue;
            ++numMatchingElements;
        }
        return numMatchingElements;
    }

    private LineForm addLineFormIfNoSuchExplanation(Container scope, String explanation, int line) {
        LineForm result = this.findLineFormByExplanation(scope, explanation);
        if (result != null) {
            return result;
        }
        Model model = (Model)scope.getContainerOrSame(Model.class);
        if (!model.isContracted()) {
            this.reportWarning(this.formatMessage("err_lineForm_ili1_artificialContract", model.getName()), line);
            try {
                Contract contract = new Contract(this.rsrc.getString("err_lineForm_ili1_artificialContractorName"), this.rsrc.getString("err_lineForm_ili1_artificialContractExplanation"));
                model.addContract(contract);
            }
            catch (Exception ex) {
                this.reportError(ex, line);
                Ili1Parser.panic();
            }
        }
        try {
            result = new LineForm(this.formatMessage("err_lineForm_ili1_artificialName", Integer.toString(this.countElements(model, LineForm.class) + 1)));
            result.setExplanation(explanation);
            model.add(result);
        }
        catch (Exception ex) {
            this.reportError(ex, line);
        }
        return result;
    }

    private String getIliDoc() throws TokenStreamException {
        String ilidoc = null;
        CommonHiddenStreamToken cmtToken = this.filter.getHiddenBefore((CommonHiddenStreamToken)this.LT(1));
        if (cmtToken != null) {
            ilidoc = cmtToken.getText().trim();
            if (ilidoc.startsWith("/**")) {
                ilidoc = ilidoc.substring(3);
            }
            if (ilidoc.endsWith("*/")) {
                ilidoc = ilidoc.substring(0, ilidoc.length() - 2);
            }
            LineNumberReader lines = new LineNumberReader(new StringReader(ilidoc.trim()));
            StringBuilder buf = new StringBuilder();
            String sep = "";
            try {
                String line;
                while ((line = lines.readLine()) != null) {
                    if ((line = line.trim()).startsWith("*")) {
                        line = line.substring(1).trim();
                    }
                    buf.append(sep);
                    buf.append(line);
                    sep = "\n";
                }
            }
            catch (IOException ex) {
                EhiLogger.logError((Throwable)ex);
            }
            ilidoc = buf.toString();
            if (ilidoc.length() == 0) {
                ilidoc = null;
            }
        }
        return ilidoc;
    }

    private Settings getMetaValues() throws TokenStreamException {
        CommonHiddenStreamToken cmtToken;
        ArrayList<CommonHiddenStreamToken> docs = new ArrayList<CommonHiddenStreamToken>();
        for (cmtToken = ((CommonHiddenStreamToken)this.LT(1)).getHiddenBefore(); cmtToken != null; cmtToken = cmtToken.getHiddenBefore()) {
            if (cmtToken.getType() != 78) continue;
            docs.add(0, cmtToken);
        }
        Iterator doci = docs.iterator();
        StringBuilder metaValuesText = new StringBuilder();
        String sep = "";
        while (doci.hasNext()) {
            cmtToken = (CommonHiddenStreamToken)doci.next();
            String valueText = cmtToken.getText().trim();
            metaValuesText.append(sep + valueText);
            sep = ";";
        }
        Settings metaValues = null;
        try {
            metaValues = MetaValue.parseMetaValues(metaValuesText.toString());
        }
        catch (ANTLRException ex) {
            this.reportError("failed to parse Metavalue <" + metaValuesText.toString() + ">", this.LT(1).getLine());
        }
        return metaValues;
    }

    protected Ili1Parser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public Ili1Parser(TokenBuffer tokenBuf) {
        this(tokenBuf, 1);
    }

    protected Ili1Parser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public Ili1Parser(TokenStream lexer) {
        this(lexer, 1);
    }

    public Ili1Parser(ParserSharedInputState state) {
        super(state, 1);
        this.tokenNames = _tokenNames;
    }

    public final boolean interlisDescription(TransferDescription td1) throws RecognitionException, TokenStreamException {
        boolean canProceed = true;
        this.td = td1;
        this.modelInterlis = this.td.INTERLIS;
        this.predefinedBooleanType = Type.findReal(this.td.INTERLIS.BOOLEAN.getType());
        this.predefinedScalSystemClass = this.td.INTERLIS.SCALSYSTEM;
        this.predefinedCoordSystemClass = this.td.INTERLIS.COORDSYSTEM;
        try {
            this.interlis1Def();
        }
        catch (NoViableAltException nvae) {
            if (this.inputState.guessing == 0) {
                this.reportError(this.rsrc.getString("err_notIliDescription"));
                canProceed = false;
            }
            throw nvae;
        }
        return canProceed;
    }

    protected final void interlis1Def() throws RecognitionException, TokenStreamException {
        Token transferName = null;
        Token modelName = null;
        Token modelName2 = null;
        Token endDot = null;
        DataModel model = null;
        Ili1Format format = new Ili1Format();
        String ilidoc = null;
        Settings metaValues = null;
        try {
            this.match(10);
            transferName = this.LT(1);
            this.match(7);
            this.match(11);
            if (this.inputState.guessing == 0) {
                model = new DataModel();
                try {
                    this.td.setName(transferName.getText());
                    model.setName(transferName.getText());
                    model.setIliVersion("1");
                }
                catch (Exception ex) {
                    this.reportError(ex, transferName.getLine());
                }
            }
            if (this.LA(1) == 14) {
                this.ili1_domainDefs(model);
            } else if (this.LA(1) != 12) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.inputState.guessing == 0) {
                ilidoc = this.getIliDoc();
                metaValues = this.getMetaValues();
            }
            this.match(12);
            modelName = this.LT(1);
            this.match(7);
            if (this.inputState.guessing == 0) {
                try {
                    model.setName(modelName.getText());
                    model.setSourceLine(modelName.getLine());
                    model.setFileName(this.getFilename());
                    model.setDocumentation(ilidoc);
                    model.setMetaValues(metaValues);
                    String translationOfName = this.externalMetaAttrs.getMetaAttrValue(model.getName(), "ili2c.translationOf");
                    if (translationOfName != null) {
                        Model translationOf = (Model)this.td.getElement(Model.class, translationOfName);
                        if (translationOf == null) {
                            this.reportError(this.formatMessage("err_noSuchModel", translationOfName), modelName.getLine());
                        } else {
                            model.setTranslationOf(translationOf.getName(), translationOf.getModelVersion());
                        }
                    }
                }
                catch (Exception ex) {
                    this.reportError(ex, transferName.getLine());
                }
                try {
                    this.td.add(model);
                }
                catch (Exception ex) {
                    this.reportError(ex, transferName.getLine());
                }
            }
            if (this.LA(1) == 14) {
                this.ili1_domainDefs(model);
            } else if (this.LA(1) != 16) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            int _cnt1411 = 0;
            while (true) {
                if (this.LA(1) != 16) {
                    if (_cnt1411 >= 1) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.ili1_topic(model);
                ++_cnt1411;
            }
            this.match(8);
            modelName2 = this.LT(1);
            this.match(7);
            endDot = this.LT(1);
            this.match(13);
            if (this.inputState.guessing == 0) {
                if (!model.getName().equals(modelName2.getText())) {
                    this.reportError(this.formatMessage("err_end_mismatch", "MODEL " + model.getName(), model.getName(), modelName2.getText()), modelName2.getLine());
                }
                try {
                    ArrayList<Ili2cSemanticException> errs = new ArrayList<Ili2cSemanticException>();
                    model.checkIntegrity(errs);
                    this.reportError(errs);
                }
                catch (Ili2cSemanticException ex) {
                    this.reportError(ex);
                }
                catch (Exception ex) {
                    this.reportError(ex, endDot.getLine());
                }
            }
            if (this.LA(1) == 51) {
                this.ili1_derivatives(model);
            } else if (this.LA(1) != 52 && this.LA(1) != 57) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            while (this.LA(1) == 52) {
                this.ili1_view(model);
            }
            this.ili1_format(format);
            this.ili1_encoding(format);
            if (this.inputState.guessing == 0) {
                this.td.setIli1Format(format);
            }
            this.match(1);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_0);
            }
            throw ex;
        }
    }

    protected final Enumeration enumeration(Type extending) throws RecognitionException, TokenStreamException {
        Token lp = null;
        LinkedList<Enumeration.Element> elements = new LinkedList<Enumeration.Element>();
        Enumeration enumer = null;
        try {
            lp = this.LT(1);
            this.match(4);
            Enumeration.Element curElement = this.enumElement(extending);
            if (this.inputState.guessing == 0) {
                elements.add(curElement);
            }
            while (this.LA(1) == 5) {
                this.match(5);
                curElement = this.enumElement(extending);
                if (this.inputState.guessing != 0) continue;
                for (Enumeration.Element ele : elements) {
                    if (!ele.getName().equals(curElement.getName())) continue;
                    this.reportError(this.formatMessage("err_enumerationType_DupEle", curElement.getName()), curElement.getSourceLine());
                    break;
                }
                elements.add(curElement);
            }
            this.match(6);
            if (this.inputState.guessing == 0) {
                enumer = new Enumeration(elements);
                enumer.setFinal(false);
                enumer.setSourceLine(lp.getLine());
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_1);
            }
            throw ex;
        }
        return enumer;
    }

    protected final Enumeration.Element enumElement(Type extending) throws RecognitionException, TokenStreamException {
        Token en = null;
        Enumeration subEnum = null;
        Object curEnum = null;
        Enumeration.Element ee = null;
        boolean lineNumber = false;
        String ilidoc = null;
        Settings metaValues = null;
        try {
            if (this.inputState.guessing == 0) {
                ilidoc = this.getIliDoc();
                metaValues = this.getMetaValues();
            }
            en = this.LT(1);
            this.match(7);
            if (this.LA(1) == 4) {
                subEnum = this.enumeration(extending);
            } else if (this.LA(1) != 5 && this.LA(1) != 6) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.inputState.guessing == 0) {
                if (subEnum == null) {
                    ee = new Enumeration.Element(en.getText());
                    ee.setDocumentation(ilidoc);
                    ee.setMetaValues(metaValues);
                    ee.setSourceLine(en.getLine());
                } else {
                    ee = new Enumeration.Element(en.getText(), subEnum);
                    ee.setDocumentation(ilidoc);
                    ee.setMetaValues(metaValues);
                    ee.setSourceLine(en.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_2);
            }
            throw ex;
        }
        return ee;
    }

    protected final void end(Element elt) throws RecognitionException, TokenStreamException {
        Token nam = null;
        try {
            this.match(8);
            nam = this.LT(1);
            this.match(7);
            if (this.inputState.guessing == 0 && elt != null && !nam.getText().equals(elt.getName())) {
                this.reportError(this.formatMessage("err_end_mismatch", elt.toString(), elt.getName(), nam.getText()), nam.getLine());
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_3);
            }
            throw ex;
        }
    }

    protected final int posInteger() throws RecognitionException, TokenStreamException {
        Token p = null;
        int i = 0;
        try {
            p = this.LT(1);
            this.match(9);
            if (this.inputState.guessing == 0) {
                try {
                    i = Integer.parseInt(p.getText());
                }
                catch (Exception ex) {
                    this.reportInternalError(ex, p.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_4);
            }
            throw ex;
        }
        return i;
    }

    protected final void ili1_domainDefs(Container container) throws RecognitionException, TokenStreamException {
        Token domainName = null;
        Model model = (Model)container.getContainerOrSame(Model.class);
        Topic topic = (Topic)container.getContainerOrSame(Topic.class);
        Type type = null;
        String ilidoc = null;
        Settings metaValues = null;
        try {
            this.match(14);
            int _cnt1417 = 0;
            while (true) {
                if (this.LA(1) != 7) {
                    if (_cnt1417 < 1) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    break;
                }
                if (this.inputState.guessing == 0) {
                    ilidoc = this.getIliDoc();
                    metaValues = this.getMetaValues();
                }
                domainName = this.LT(1);
                this.match(7);
                this.match(15);
                type = this.ili1_attributeType(model, topic, null);
                this.match(11);
                if (this.inputState.guessing == 0) {
                    Domain domain = null;
                    try {
                        domain = new Domain();
                        domain.setSourceLine(domainName.getLine());
                        domain.setName(domainName.getText());
                        domain.setDocumentation(ilidoc);
                        domain.setMetaValues(metaValues);
                        if (type != null) {
                            domain.setType(type);
                        }
                        domain.setAbstract(false);
                        domain.setFinal(false);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, domainName.getLine());
                        try {
                            domain = new Domain();
                            domain.setName(domainName.getText());
                            domain.setAbstract(false);
                            domain.setFinal(false);
                        }
                        catch (Exception ex2) {
                            Ili1Parser.panic();
                        }
                    }
                    try {
                        if (domain != null) {
                            container.add(domain);
                        }
                    }
                    catch (Exception ex) {
                        this.reportError(ex, domainName.getLine());
                    }
                }
                ++_cnt1417;
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_5);
            }
            throw ex;
        }
    }

    protected final void ili1_topic(Model model) throws RecognitionException, TokenStreamException {
        block18: {
            Token topicName = null;
            Topic topic = null;
            String ilidoc = null;
            Settings metaValues = null;
            try {
                if (this.inputState.guessing == 0) {
                    ilidoc = this.getIliDoc();
                    metaValues = this.getMetaValues();
                }
                this.match(16);
                topicName = this.LT(1);
                this.match(7);
                this.match(15);
                if (this.inputState.guessing == 0) {
                    this.ili1assocs = new ArrayList();
                    topic = new Topic();
                    try {
                        topic.setSourceLine(topicName.getLine());
                        topic.setName(topicName.getText());
                        topic.setDocumentation(ilidoc);
                        topic.setMetaValues(metaValues);
                        topic.setAbstract(false);
                        model.add(topic);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, topicName.getLine());
                    }
                }
                int _cnt1420 = 0;
                while (true) {
                    if (this.LA(1) == 17 || this.LA(1) == 18) {
                        this.ili1_table(topic);
                    } else if (this.LA(1) == 14) {
                        this.ili1_domainDefs(topic);
                    } else {
                        if (_cnt1420 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    ++_cnt1420;
                }
                this.end(topic);
                this.match(13);
                if (this.inputState.guessing != 0) break block18;
                for (AssociationDef assoc : this.ili1assocs) {
                    String assocBasename;
                    int uniqueName = 2;
                    String assocName = assoc.getName();
                    assocName = assocBasename = assocName.substring(0, assocName.indexOf(58));
                    boolean assocNameConflict = false;
                    do {
                        assocNameConflict = false;
                        Iterator elei = topic.iterator();
                        while (elei.hasNext()) {
                            Element ele = (Element)elei.next();
                            if (ele == assoc || !ele.getName().equals(assocName)) continue;
                            assocNameConflict = true;
                            break;
                        }
                        if (!assocNameConflict) {
                            try {
                                assoc.setName(assocName);
                            }
                            catch (PropertyVetoException ex) {
                                assocNameConflict = true;
                            }
                        }
                        if (!assocNameConflict) continue;
                        assocName = assocBasename + Integer.toString(uniqueName);
                        ++uniqueName;
                    } while (assocNameConflict);
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_6);
                }
                throw ex;
            }
        }
    }

    protected final void ili1_derivatives(Model mainModel) throws RecognitionException, TokenStreamException {
        Token derivativeName = null;
        Token derivativeName2 = null;
        try {
            this.match(51);
            derivativeName = this.LT(1);
            this.match(7);
            if (this.LA(1) == 14) {
                this.ili1_domainDefs(mainModel);
            } else if (this.LA(1) != 16) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            int _cnt1478 = 0;
            while (true) {
                if (this.LA(1) != 16) {
                    if (_cnt1478 >= 1) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.ili1_topic(mainModel);
                ++_cnt1478;
            }
            this.match(8);
            derivativeName2 = this.LT(1);
            this.match(7);
            if (this.inputState.guessing == 0 && !derivativeName.getText().equals(derivativeName2.getText())) {
                this.reportError(this.formatMessage("err_end_mismatch", "DERIVATIVES " + derivativeName.getText(), derivativeName.getText(), derivativeName2.getText()), derivativeName2.getLine());
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_7);
            }
            throw ex;
        }
    }

    protected final void ili1_view(Model mainModel) throws RecognitionException, TokenStreamException {
        Token viewName = null;
        Token viewName2 = null;
        try {
            this.match(52);
            viewName = this.LT(1);
            this.match(7);
            while (this.LA(1) == 7) {
                this.match(7);
                this.match(13);
                this.match(7);
                this.match(19);
                this.ili1_viewDef();
                while (this.LA(1) == 5) {
                    this.match(5);
                    this.ili1_viewDef();
                }
                this.match(11);
            }
            this.match(8);
            viewName2 = this.LT(1);
            this.match(7);
            this.match(13);
            if (this.inputState.guessing == 0) {
                this.reportWarning(this.formatMessage("err_view_ili1", viewName.getText()), viewName.getLine());
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_7);
            }
            throw ex;
        }
    }

    protected final void ili1_format(Ili1Format format) throws RecognitionException, TokenStreamException {
        int lineSize = 0;
        int tidSize = 0;
        try {
            this.match(57);
            if (this.LA(1) == 58) {
                this.match(58);
                if (this.inputState.guessing == 0) {
                    format.isFree = true;
                }
            } else if (this.LA(1) == 59) {
                this.match(59);
                this.match(44);
                this.match(60);
                this.match(15);
                lineSize = this.posInteger();
                this.match(5);
                this.match(61);
                this.match(15);
                tidSize = this.posInteger();
                if (this.inputState.guessing == 0) {
                    format.isFree = true;
                    format.lineSize = lineSize;
                    format.tidSize = tidSize;
                }
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(11);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_8);
            }
            throw ex;
        }
    }

    protected final void ili1_encoding(Ili1Format format) throws RecognitionException, TokenStreamException {
        try {
            this.match(62);
            if (this.LA(1) == 63) {
                this.ili1_font(format);
            } else if (this.LA(1) != 64) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.ili1_specialCharacter(format);
            this.ili1_transferId(format);
            this.match(8);
            this.match(13);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_0);
            }
            throw ex;
        }
    }

    protected final Type ili1_attributeType(Model forModel, Topic forTopic, Viewable table) throws RecognitionException, TokenStreamException {
        Type type = null;
        try {
            switch (this.LA(1)) {
                case 4: 
                case 24: 
                case 25: 
                case 26: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 36: 
                case 37: 
                case 38: {
                    type = this.ili1_baseType(forModel);
                    break;
                }
                case 39: {
                    type = this.ili1_lineType(forModel, forTopic);
                    break;
                }
                case 41: 
                case 42: {
                    type = this.ili1_areaType(forModel, forTopic, table);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_9);
            }
            throw ex;
        }
        return type;
    }

    protected final void ili1_table(Topic topic) throws RecognitionException, TokenStreamException {
        Token tableName = null;
        Token tableName2 = null;
        boolean optional = false;
        Table table = null;
        this.ili1AttrCounter = 0;
        String ilidoc = null;
        Settings metaValues = null;
        try {
            if (this.inputState.guessing == 0) {
                ilidoc = this.getIliDoc();
                metaValues = this.getMetaValues();
            }
            if (this.LA(1) == 17) {
                this.match(17);
                if (this.inputState.guessing == 0) {
                    optional = true;
                }
            } else if (this.LA(1) != 18) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(18);
            tableName = this.LT(1);
            this.match(7);
            this.match(15);
            if (this.inputState.guessing == 0) {
                table = new Table();
                this.ili1TableRefAttrs = new HashMap();
                try {
                    table.setName(tableName.getText());
                    table.setSourceLine(tableName.getLine());
                    table.setDocumentation(ilidoc);
                    table.setMetaValues(metaValues);
                    table.setAbstract(false);
                    table.setIli1Optional(optional);
                    topic.add(table);
                }
                catch (Exception ex) {
                    this.reportError(ex, tableName.getLine());
                }
            }
            int _cnt1424 = 0;
            while (true) {
                if (this.LA(1) == 7) {
                    this.ili1_attribute(table);
                    if (this.inputState.guessing == 0) {
                        ++this.ili1AttrCounter;
                    }
                } else {
                    if (_cnt1424 >= 1) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                ++_cnt1424;
            }
            this.ili1_identifications(table);
            this.match(8);
            tableName2 = this.LT(1);
            this.match(7);
            this.match(11);
            if (this.inputState.guessing == 0) {
                this.ili1TableRefAttrs = null;
                if (!table.getName().equals(tableName2.getText())) {
                    this.reportError(this.formatMessage("err_end_mismatch", "TABLE " + table.getName(), table.getName(), tableName2.getText()), tableName2.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_10);
            }
            throw ex;
        }
    }

    protected final void ili1_attribute(Table table) throws RecognitionException, TokenStreamException {
        block35: {
            Token attributeName = null;
            Token col = null;
            Token tabnam = null;
            Token expl = null;
            boolean optional = false;
            Type type = null;
            LocalAttribute attrib = null;
            Model model = (Model)table.getContainer(Model.class);
            Topic topic = (Topic)table.getContainer(Topic.class);
            String ilidoc = null;
            Settings metaValues = null;
            String explText = null;
            try {
                if (this.inputState.guessing == 0) {
                    ilidoc = this.getIliDoc();
                    metaValues = this.getMetaValues();
                }
                attributeName = this.LT(1);
                this.match(7);
                col = this.LT(1);
                this.match(19);
                if (this.LA(1) == 17) {
                    this.match(17);
                    if (this.inputState.guessing == 0) {
                        optional = true;
                    }
                } else if (!_tokenSet_11.member(this.LA(1))) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (_tokenSet_12.member(this.LA(1))) {
                    type = this.ili1_localAttributeType(model, topic, table);
                    if (this.inputState.guessing == 0) {
                        attrib = new LocalAttribute();
                        attrib.setDocumentation(ilidoc);
                        attrib.setMetaValues(metaValues);
                    }
                } else if (this.LA(1) == 20) {
                    this.match(20);
                    tabnam = this.LT(1);
                    this.match(7);
                    if (this.inputState.guessing == 0) {
                        AssociationDef assoc = new AssociationDef();
                        assoc.setSourceLine(tabnam.getLine());
                        Table referred = (Table)topic.getRealElement(Table.class, tabnam.getText());
                        if (referred == null) {
                            this.reportError(this.formatMessage("err_noSuchTable", tabnam.getText(), topic.toString()), tabnam.getLine());
                            assoc.setDirty(true);
                        }
                        if (referred == table) {
                            this.reportError(this.formatMessage("err_relAttribute_recursive", attributeName.getText(), tabnam.getText()), tabnam.getLine());
                            assoc.setDirty(true);
                        }
                        try {
                            String thisRoleName = table.getName();
                            String oppendRoleName = attributeName.getText();
                            int uniqueName = 2;
                            String thisRoleBasename = thisRoleName;
                            if (thisRoleName.equals(oppendRoleName)) {
                                thisRoleName = thisRoleName + Integer.toString(uniqueName);
                                ++uniqueName;
                            }
                            boolean roleNameConflict = false;
                            do {
                                roleNameConflict = false;
                                if (referred.getElement(AttributeDef.class, thisRoleName) != null) {
                                    roleNameConflict = true;
                                } else {
                                    Iterator<RoleDef> rolei = referred.getOpposideRoles();
                                    while (rolei.hasNext()) {
                                        RoleDef targetOppRole = rolei.next();
                                        if (!targetOppRole.getName().equals(thisRoleName)) continue;
                                        roleNameConflict = true;
                                        break;
                                    }
                                }
                                if (!roleNameConflict) continue;
                                thisRoleName = thisRoleBasename + Integer.toString(uniqueName);
                                ++uniqueName;
                            } while (roleNameConflict);
                            String assocName = thisRoleName + oppendRoleName + ":" + this.ili1assocs.size();
                            assoc.setName(assocName);
                            RoleDef role1 = new RoleDef(true);
                            role1.setSourceLine(tabnam.getLine());
                            role1.setIli1AttrIdx(this.ili1AttrCounter);
                            role1.setName(thisRoleName);
                            ReferenceType role1ref = new ReferenceType();
                            role1ref.setReferred(table);
                            role1.setReference(role1ref);
                            role1.setCardinality(new Cardinality(0L, Long.MAX_VALUE));
                            assoc.add(role1);
                            RoleDef role2 = new RoleDef(true);
                            role2.setSourceLine(tabnam.getLine());
                            role2.setName(oppendRoleName);
                            ReferenceType role2ref = new ReferenceType();
                            role2ref.setReferred(referred);
                            role2.setReference(role2ref);
                            role2.setCardinality(new Cardinality(optional ? 0L : 1L, 1L));
                            assoc.add(role2);
                            topic.add(assoc);
                            assoc.fixupRoles();
                            this.ili1assocs.add(assoc);
                            this.ili1TableRefAttrs.put(attributeName.getText(), role2);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, tabnam.getLine());
                        }
                    }
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.LA(1) == 21) {
                    expl = this.LT(1);
                    this.match(21);
                    if (this.inputState.guessing == 0) {
                        explText = expl.getText();
                        this.reportWarning(this.formatMessage("err_attribute_ili1_constraintLost", attributeName.getText()), expl.getLine());
                    }
                } else if (this.LA(1) != 11) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(11);
                if (this.inputState.guessing != 0 || attrib == null) break block35;
                try {
                    attrib.setName(attributeName.getText());
                    attrib.setSourceLine(attributeName.getLine());
                }
                catch (Exception ex) {
                    this.reportError(ex, attributeName.getLine());
                    Ili1Parser.panic();
                }
                try {
                    type.setMandatory(!optional);
                }
                catch (Exception ex) {
                    this.reportError(ex, col.getLine());
                }
                try {
                    ((AttributeDef)attrib).setDomain(type);
                }
                catch (Exception ex) {
                    this.reportError(ex, col.getLine());
                }
                attrib.setExplanation(explText);
                try {
                    table.add(attrib);
                }
                catch (Exception ex) {
                    this.reportError(ex, col.getLine());
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_13);
                }
                throw ex;
            }
        }
    }

    protected final void ili1_identifications(Table table) throws RecognitionException, TokenStreamException {
        block17: {
            Token ident = null;
            Token anam = null;
            Token bnam = null;
            Token semi = null;
            LinkedList<String> ll = null;
            boolean ignore = false;
            boolean selfStanding = false;
            try {
                if (this.LA(1) == 22) {
                    this.match(22);
                    this.match(23);
                    break block17;
                }
                if (this.LA(1) == 23) {
                    ident = this.LT(1);
                    this.match(23);
                    int _cnt1433 = 0;
                    while (true) {
                        block18: {
                            if (this.LA(1) != 7) {
                                if (_cnt1433 < 1) {
                                    throw new NoViableAltException(this.LT(1), this.getFilename());
                                }
                                break block17;
                            }
                            anam = this.LT(1);
                            this.match(7);
                            if (this.inputState.guessing == 0) {
                                selfStanding = false;
                                ll = new LinkedList<String>();
                                ll.add(anam.getText());
                            }
                            while (this.LA(1) == 5) {
                                this.match(5);
                                bnam = this.LT(1);
                                this.match(7);
                                if (this.inputState.guessing != 0) continue;
                                ll.add(bnam.getText());
                            }
                            semi = this.LT(1);
                            this.match(11);
                            if (this.inputState.guessing == 0) {
                                try {
                                    UniqueEl uel = new UniqueEl();
                                    for (int i = 0; !ignore && i < ll.size(); ++i) {
                                        ObjectPath path;
                                        String attrnam = (String)ll.get(i);
                                        AttributeDef curAttribute = (AttributeDef)table.getRealElement(AttributeDef.class, attrnam);
                                        if (curAttribute != null) {
                                            PathEl[] attrRef = new AttributeRef[]{new AttributeRef(curAttribute)};
                                            path = new ObjectPath(table, attrRef);
                                            uel.addAttribute(path);
                                            continue;
                                        }
                                        if (!this.ili1TableRefAttrs.containsKey(attrnam)) {
                                            this.reportError(this.formatMessage("err_attributePath_unknownAttr_short", attrnam, table.toString()), semi.getLine());
                                            ignore = true;
                                            continue;
                                        }
                                        PathEl[] roleRef = new PathElAbstractClassRole[]{new PathElAbstractClassRole((RoleDef)this.ili1TableRefAttrs.get(attrnam))};
                                        path = new ObjectPath(table, roleRef);
                                        uel.addAttribute(path);
                                        selfStanding = true;
                                    }
                                    if (!ignore) {
                                        UniquenessConstraint constr = new UniquenessConstraint();
                                        constr.setElements(uel);
                                        constr.setSelfStanding(selfStanding);
                                        constr.setSourceLine(ident.getLine());
                                        table.add(constr);
                                        break block18;
                                    }
                                    this.reportWarning("IDENT constraint lost", semi.getLine());
                                }
                                catch (Exception ex) {
                                    this.reportError(ex, semi.getLine());
                                }
                            }
                        }
                        ++_cnt1433;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_14);
                }
                throw ex;
            }
        }
    }

    protected final Type ili1_localAttributeType(Model forModel, Topic forTopic, Viewable table) throws RecognitionException, TokenStreamException {
        Type type = null;
        try {
            type = this.ili1_type(forModel, forTopic, table);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_15);
            }
            throw ex;
        }
        return type;
    }

    protected final Type ili1_type(Model forModel, Topic forTopic, Viewable table) throws RecognitionException, TokenStreamException {
        Type type;
        block16: {
            Token nam = null;
            type = null;
            try {
                if (_tokenSet_16.member(this.LA(1))) {
                    type = this.ili1_attributeType(forModel, forTopic, table);
                    break block16;
                }
                if (this.LA(1) == 7) {
                    nam = this.LT(1);
                    this.match(7);
                    if (this.inputState.guessing != 0) break block16;
                    Domain domain = null;
                    if (forTopic != null) {
                        domain = (Domain)forTopic.getRealElement(Domain.class, nam.getText());
                        if (domain == null) {
                            domain = (Domain)forModel.getRealElement(Domain.class, nam.getText());
                        }
                        if (domain == null) {
                            this.reportError(this.formatMessage("err_domainRef_notInModelOrTopic", nam.getText(), forTopic.toString(), "MODEL " + forModel.getName()), nam.getLine());
                            try {
                                domain = new Domain();
                                domain.setName(nam.getText());
                                forTopic.add(domain);
                            }
                            catch (Exception ex) {
                                Ili1Parser.panic();
                            }
                        }
                    } else {
                        domain = (Domain)forModel.getRealElement(Domain.class, nam.getText());
                        if (domain == null) {
                            this.reportError(this.formatMessage("err_domainRef_notInModel", nam.getText(), "MODEL " + forModel.getName()), nam.getLine());
                            try {
                                domain = new Domain();
                                domain.setName(nam.getText());
                                forModel.add(domain);
                            }
                            catch (Exception ex) {
                                Ili1Parser.panic();
                            }
                        }
                    }
                    type = new TypeAlias();
                    try {
                        ((TypeAlias)type).setAliasing(domain);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, nam.getLine());
                    }
                    break block16;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_9);
                }
                throw ex;
            }
        }
        return type;
    }

    protected final Type ili1_baseType(Model containingModel) throws RecognitionException, TokenStreamException {
        Type type = null;
        try {
            switch (this.LA(1)) {
                case 24: {
                    type = this.ili1_coord2();
                    break;
                }
                case 25: {
                    type = this.ili1_coord3();
                    break;
                }
                case 29: {
                    type = this.ili1_dim1Type();
                    break;
                }
                case 30: {
                    type = this.ili1_dim2Type(containingModel);
                    break;
                }
                case 31: 
                case 32: 
                case 33: {
                    type = this.ili1_angleType(containingModel);
                    break;
                }
                case 26: {
                    type = this.ili1_numericRange();
                    break;
                }
                case 34: {
                    type = this.ili1_textType();
                    break;
                }
                case 36: {
                    type = this.ili1_dateType();
                    break;
                }
                case 4: {
                    type = this.ili1_enumerationType();
                    break;
                }
                case 37: {
                    type = this.ili1_horizAlignment();
                    break;
                }
                case 38: {
                    type = this.ili1_vertAlignment();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_9);
            }
            throw ex;
        }
        return type;
    }

    protected final LineType ili1_lineType(Model forModel, Topic forTopic) throws RecognitionException, TokenStreamException {
        PolylineType type = null;
        try {
            this.match(39);
            if (this.inputState.guessing == 0) {
                type = new PolylineType();
            }
            this.ili1_form(type, forModel);
            this.ili1_controlPoints(type, forModel, forTopic);
            boolean synPredMatched1453 = false;
            if (this.LA(1) == 40) {
                int _m1453 = this.mark();
                synPredMatched1453 = true;
                ++this.inputState.guessing;
                try {
                    this.match(40);
                }
                catch (RecognitionException pe) {
                    synPredMatched1453 = false;
                }
                this.rewind(_m1453);
                --this.inputState.guessing;
            }
            if (synPredMatched1453) {
                this.ili1_intersectionDef(type);
            } else if (!_tokenSet_9.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_9);
            }
            throw ex;
        }
        return type;
    }

    protected final LineType ili1_areaType(Model forModel, Topic forTopic, Viewable table) throws RecognitionException, TokenStreamException {
        SurfaceOrAreaType type = null;
        Container scope = forTopic != null ? forTopic : forModel;
        try {
            if (this.LA(1) == 41) {
                this.match(41);
                if (this.inputState.guessing == 0) {
                    type = new SurfaceType(true);
                }
                this.ili1_form(type, forModel);
                this.ili1_controlPoints(type, forModel, forTopic);
                boolean synPredMatched1458 = false;
                if (this.LA(1) == 40) {
                    int _m1458 = this.mark();
                    synPredMatched1458 = true;
                    ++this.inputState.guessing;
                    try {
                        this.match(40);
                    }
                    catch (RecognitionException pe) {
                        synPredMatched1458 = false;
                    }
                    this.rewind(_m1458);
                    --this.inputState.guessing;
                }
                if (synPredMatched1458) {
                    this.ili1_intersectionDef(type);
                } else if (!_tokenSet_9.member(this.LA(1))) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            } else if (this.LA(1) == 42) {
                this.match(42);
                if (this.inputState.guessing == 0) {
                    type = new AreaType();
                }
                this.ili1_form(type, forModel);
                this.ili1_controlPoints(type, forModel, forTopic);
                this.ili1_intersectionDef(type);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            boolean synPredMatched1461 = false;
            if (this.LA(1) == 43) {
                int _m1461 = this.mark();
                synPredMatched1461 = true;
                ++this.inputState.guessing;
                try {
                    this.match(43);
                }
                catch (RecognitionException pe) {
                    synPredMatched1461 = false;
                }
                this.rewind(_m1461);
                --this.inputState.guessing;
            }
            if (synPredMatched1461) {
                this.ili1_lineAttributes(type, scope, table);
            } else if (!_tokenSet_9.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_9);
            }
            throw ex;
        }
        return type;
    }

    protected final CoordType ili1_coord2() throws RecognitionException, TokenStreamException {
        CoordType type;
        block10: {
            Token coord = null;
            type = null;
            try {
                coord = this.LT(1);
                this.match(24);
                PrecisionDecimal eMin = this.ili1_decimal();
                PrecisionDecimal nMin = this.ili1_decimal();
                PrecisionDecimal eMax = this.ili1_decimal();
                PrecisionDecimal nMax = this.ili1_decimal();
                if (this.inputState.guessing != 0) break block10;
                NumericType easting = null;
                NumericType northing = null;
                try {
                    easting = new NumericType(eMin, eMax);
                }
                catch (Exception ex) {
                    this.reportError(ex, coord.getLine());
                }
                try {
                    northing = new NumericType(nMin, nMax);
                }
                catch (Exception ex) {
                    this.reportError(ex, coord.getLine());
                }
                if (easting != null && northing != null) {
                    try {
                        type = new CoordType(new NumericType[]{easting, northing}, 2, 1);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, coord.getLine());
                    }
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_9);
                }
                throw ex;
            }
        }
        return type;
    }

    protected final CoordType ili1_coord3() throws RecognitionException, TokenStreamException {
        CoordType type;
        block12: {
            Token coord = null;
            type = null;
            try {
                coord = this.LT(1);
                this.match(25);
                PrecisionDecimal eMin = this.ili1_decimal();
                PrecisionDecimal nMin = this.ili1_decimal();
                PrecisionDecimal hMin = this.ili1_decimal();
                PrecisionDecimal eMax = this.ili1_decimal();
                PrecisionDecimal nMax = this.ili1_decimal();
                PrecisionDecimal hMax = this.ili1_decimal();
                if (this.inputState.guessing != 0) break block12;
                NumericType easting = null;
                NumericType northing = null;
                NumericType height = null;
                try {
                    easting = new NumericType(eMin, eMax);
                }
                catch (Exception ex) {
                    this.reportError(ex, coord.getLine());
                }
                try {
                    northing = new NumericType(nMin, nMax);
                }
                catch (Exception ex) {
                    this.reportError(ex, coord.getLine());
                }
                try {
                    height = new NumericType(hMin, hMax);
                }
                catch (Exception ex) {
                    this.reportError(ex, coord.getLine());
                }
                if (easting != null && northing != null && height != null) {
                    try {
                        type = new CoordType(new NumericType[]{easting, northing, height}, 2, 1);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, coord.getLine());
                    }
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_9);
                }
                throw ex;
            }
        }
        return type;
    }

    protected final NumericType ili1_dim1Type() throws RecognitionException, TokenStreamException {
        Token dim1 = null;
        NumericType type = null;
        PrecisionDecimal min = null;
        PrecisionDecimal max = null;
        try {
            dim1 = this.LT(1);
            this.match(29);
            min = this.ili1_decimal();
            max = this.ili1_decimal();
            if (this.inputState.guessing == 0) {
                try {
                    type = new NumericType(min, max);
                    type.setUnit(this.td.INTERLIS.METER);
                }
                catch (Exception ex) {
                    this.reportError(ex, dim1.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_9);
            }
            throw ex;
        }
        return type;
    }

    protected final NumericType ili1_dim2Type(Model inModel) throws RecognitionException, TokenStreamException {
        NumericType type;
        block8: {
            Token dim2 = null;
            type = null;
            PrecisionDecimal min = null;
            PrecisionDecimal max = null;
            ComposedUnit m2 = null;
            try {
                dim2 = this.LT(1);
                this.match(30);
                min = this.ili1_decimal();
                max = this.ili1_decimal();
                if (this.inputState.guessing != 0) break block8;
                m2 = (ComposedUnit)inModel.getRealElement(ComposedUnit.class, this.rsrc.getString("err_unit_ili1_DIM2_name"));
                if (m2 == null) {
                    try {
                        m2 = new ComposedUnit();
                        m2.setName(this.rsrc.getString("err_unit_ili1_DIM2_name"));
                        m2.setDocName(this.rsrc.getString("err_unit_ili1_DIM2_docName"));
                        m2.setComposedUnits(new ComposedUnit.Composed[]{new ComposedUnit.Composed('*', this.td.INTERLIS.METER), new ComposedUnit.Composed('*', this.td.INTERLIS.METER)});
                        inModel.addPreLast(m2);
                    }
                    catch (Exception ex) {
                        this.reportInternalError(dim2.getLine());
                        Ili1Parser.panic();
                    }
                }
                try {
                    type = new NumericType(min, max);
                    type.setUnit(m2);
                }
                catch (Exception ex) {
                    this.reportError(ex, dim2.getLine());
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_9);
                }
                throw ex;
            }
        }
        return type;
    }

    protected final NumericType ili1_angleType(Model containingModel) throws RecognitionException, TokenStreamException {
        Token radians = null;
        Token degrees = null;
        Token grads = null;
        NumericType type = null;
        PrecisionDecimal min = null;
        PrecisionDecimal max = null;
        Unit u = null;
        int lineNumber = 0;
        try {
            switch (this.LA(1)) {
                case 31: {
                    radians = this.LT(1);
                    this.match(31);
                    if (this.inputState.guessing != 0) break;
                    u = this.td.INTERLIS.RADIAN;
                    lineNumber = radians.getLine();
                    break;
                }
                case 32: {
                    degrees = this.LT(1);
                    this.match(32);
                    if (this.inputState.guessing != 0) break;
                    lineNumber = degrees.getLine();
                    u = (Unit)containingModel.getRealElement(Unit.class, this.rsrc.getString("err_unit_ili1_DEGREES_name"));
                    if (u != null) break;
                    try {
                        NumericallyDerivedUnit.Factor byPi = new NumericallyDerivedUnit.Factor('/', PrecisionDecimal.PI);
                        NumericallyDerivedUnit.Factor times180 = new NumericallyDerivedUnit.Factor('*', new PrecisionDecimal("180.0"));
                        NumericallyDerivedUnit degr = new NumericallyDerivedUnit();
                        degr.setName(this.rsrc.getString("err_unit_ili1_DEGREES_name"));
                        degr.setDocName(this.rsrc.getString("err_unit_ili1_DEGREES_docName"));
                        degr.setExtending(this.td.INTERLIS.RADIAN);
                        degr.setConversionFactors(new NumericallyDerivedUnit.Factor[]{times180, byPi});
                        u = degr;
                        containingModel.addPreLast(degr);
                    }
                    catch (Exception ex) {
                        this.reportInternalError(ex, degrees.getLine());
                    }
                    break;
                }
                case 33: {
                    grads = this.LT(1);
                    this.match(33);
                    if (this.inputState.guessing != 0) break;
                    lineNumber = grads.getLine();
                    u = (Unit)containingModel.getRealElement(Unit.class, this.rsrc.getString("err_unit_ili1_GRADS_docName"));
                    if (u != null) break;
                    try {
                        NumericallyDerivedUnit.Factor byPi = new NumericallyDerivedUnit.Factor('/', PrecisionDecimal.PI);
                        NumericallyDerivedUnit.Factor times200 = new NumericallyDerivedUnit.Factor('*', new PrecisionDecimal("200.0"));
                        NumericallyDerivedUnit gon = new NumericallyDerivedUnit();
                        gon.setName(this.rsrc.getString("err_unit_ili1_GRADS_docName"));
                        gon.setDocName(this.rsrc.getString("err_unit_ili1_GRADS_docName"));
                        gon.setExtending(this.td.INTERLIS.RADIAN);
                        gon.setConversionFactors(new NumericallyDerivedUnit.Factor[]{times200, byPi});
                        u = gon;
                        containingModel.addPreLast(gon);
                    }
                    catch (Exception ex) {
                        this.reportInternalError(ex, grads.getLine());
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            min = this.ili1_decimal();
            max = this.ili1_decimal();
            if (this.inputState.guessing == 0) {
                try {
                    type = new NumericType(min, max);
                    type.setUnit(u);
                }
                catch (Exception ex) {
                    this.reportError(ex, lineNumber);
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_9);
            }
            throw ex;
        }
        return type;
    }

    protected final NumericType ili1_numericRange() throws RecognitionException, TokenStreamException {
        Token lbrac = null;
        NumericType type = null;
        PrecisionDecimal min = null;
        PrecisionDecimal max = null;
        try {
            lbrac = this.LT(1);
            this.match(26);
            min = this.ili1_decimal();
            this.match(27);
            max = this.ili1_decimal();
            this.match(28);
            if (this.inputState.guessing == 0) {
                try {
                    type = new NumericType(min, max);
                }
                catch (Exception ex) {
                    this.reportError(ex, lbrac.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_9);
            }
            throw ex;
        }
        return type;
    }

    protected final TextType ili1_textType() throws RecognitionException, TokenStreamException {
        Token star = null;
        TextType type = null;
        int numChars = 0;
        try {
            this.match(34);
            star = this.LT(1);
            this.match(35);
            numChars = this.posInteger();
            if (this.inputState.guessing == 0) {
                try {
                    type = new TextType(numChars);
                }
                catch (Exception ex) {
                    if (numChars < 1) {
                        type = new TextType(1);
                    }
                    this.reportError(ex, star.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_9);
            }
            throw ex;
        }
        return type;
    }

    protected final TypeAlias ili1_dateType() throws RecognitionException, TokenStreamException {
        Token date = null;
        TypeAlias type = null;
        try {
            date = this.LT(1);
            this.match(36);
            if (this.inputState.guessing == 0) {
                type = new TypeAlias();
                try {
                    type.setAliasing(this.td.INTERLIS.INTERLIS_1_DATE);
                }
                catch (Exception ex) {
                    this.reportInternalError(ex, date.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_9);
            }
            throw ex;
        }
        return type;
    }

    protected final EnumerationType ili1_enumerationType() throws RecognitionException, TokenStreamException {
        EnumerationType type = null;
        Enumeration enumer = null;
        try {
            enumer = this.enumeration(null);
            if (this.inputState.guessing == 0) {
                type = new EnumerationType();
                try {
                    type.setEnumeration(enumer);
                }
                catch (Exception ex) {
                    this.reportError(ex, 0);
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_9);
            }
            throw ex;
        }
        return type;
    }

    protected final TypeAlias ili1_horizAlignment() throws RecognitionException, TokenStreamException {
        Token halign = null;
        TypeAlias type = null;
        try {
            halign = this.LT(1);
            this.match(37);
            if (this.inputState.guessing == 0) {
                type = new TypeAlias();
                try {
                    type.setAliasing(this.td.INTERLIS.HALIGNMENT);
                }
                catch (Exception ex) {
                    this.reportInternalError(ex, halign.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_9);
            }
            throw ex;
        }
        return type;
    }

    protected final TypeAlias ili1_vertAlignment() throws RecognitionException, TokenStreamException {
        Token valign = null;
        TypeAlias type = null;
        try {
            valign = this.LT(1);
            this.match(38);
            if (this.inputState.guessing == 0) {
                type = new TypeAlias();
                try {
                    type.setAliasing(this.td.INTERLIS.VALIGNMENT);
                }
                catch (Exception ex) {
                    this.reportInternalError(ex, valign.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_9);
            }
            throw ex;
        }
        return type;
    }

    protected final PrecisionDecimal ili1_decimal() throws RecognitionException, TokenStreamException {
        Token d = null;
        Token p = null;
        Token n = null;
        PrecisionDecimal dec = null;
        try {
            switch (this.LA(1)) {
                case 73: {
                    d = this.LT(1);
                    this.match(73);
                    if (this.inputState.guessing == 0) {
                        dec = new PrecisionDecimal(d.getText());
                    }
                    break;
                }
                case 9: {
                    p = this.LT(1);
                    this.match(9);
                    if (this.inputState.guessing == 0) {
                        dec = new PrecisionDecimal(p.getText());
                    }
                    break;
                }
                case 74: {
                    n = this.LT(1);
                    this.match(74);
                    if (this.inputState.guessing == 0) {
                        dec = new PrecisionDecimal(n.getText());
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_17);
            }
            throw ex;
        }
        return dec;
    }

    protected final void ili1_form(LineType lineType, Model forModel) throws RecognitionException, TokenStreamException {
        block9: {
            Token with = null;
            LinkedList<LineForm> lineFormList = null;
            LineForm curLineForm = null;
            LineForm[] lineForms = null;
            try {
                with = this.LT(1);
                this.match(44);
                this.match(4);
                curLineForm = this.ili1_lineForm(forModel);
                if (this.inputState.guessing == 0) {
                    lineFormList = new LinkedList<LineForm>();
                    if (curLineForm != null) {
                        lineFormList.add(curLineForm);
                    }
                }
                while (this.LA(1) == 5) {
                    this.match(5);
                    curLineForm = this.ili1_lineForm(forModel);
                    if (this.inputState.guessing != 0 || curLineForm == null) continue;
                    lineFormList.add(curLineForm);
                }
                this.match(6);
                if (this.inputState.guessing != 0) break block9;
                lineForms = lineFormList.toArray(new LineForm[lineFormList.size()]);
                try {
                    if (lineType != null) {
                        lineType.setLineForms(lineForms);
                    }
                }
                catch (Exception ex) {
                    this.reportError(ex, with.getLine());
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_18);
                }
                throw ex;
            }
        }
    }

    protected final void ili1_controlPoints(LineType lineType, Model inModel, Topic inTopic) throws RecognitionException, TokenStreamException {
        Token vertex = null;
        Token base = null;
        Type type = null;
        Domain controlPointDomain = null;
        try {
            vertex = this.LT(1);
            this.match(49);
            type = this.ili1_type(inModel, inTopic, null);
            boolean synPredMatched1470 = false;
            if (this.LA(1) == 50) {
                int _m1470 = this.mark();
                synPredMatched1470 = true;
                ++this.inputState.guessing;
                try {
                    this.match(50);
                }
                catch (RecognitionException pe) {
                    synPredMatched1470 = false;
                }
                this.rewind(_m1470);
                --this.inputState.guessing;
            }
            if (synPredMatched1470) {
                base = this.LT(1);
                this.match(50);
                this.match(21);
                if (this.inputState.guessing == 0) {
                    this.reportWarning(this.rsrc.getString("err_lineType_ili1_baseLost"), base.getLine());
                }
            } else if (!_tokenSet_9.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.inputState.guessing == 0) {
                Type realType = Type.findReal(type);
                if (realType != null) {
                    if (realType instanceof CoordType) {
                        if (!(type instanceof TypeAlias)) {
                            controlPointDomain = new Domain();
                            try {
                                int numDomains = 0;
                                Iterator iter = inModel.iterator();
                                while (iter.hasNext()) {
                                    if (!(iter.next() instanceof Domain)) continue;
                                    ++numDomains;
                                }
                                controlPointDomain.setName(this.formatMessage("err_domain_artificialName", Integer.toString(numDomains + 1)));
                                controlPointDomain.setType(type);
                                inModel.addPreLast(controlPointDomain);
                            }
                            catch (Exception ex) {
                                this.reportError(ex, vertex.getLine());
                                controlPointDomain = null;
                            }
                        } else {
                            controlPointDomain = ((TypeAlias)type).getAliasing();
                        }
                    } else {
                        this.reportError(this.formatMessage("err_lineType_vertexNotCoordType", type.toString()), vertex.getLine());
                    }
                }
                if (lineType != null) {
                    try {
                        lineType.setControlPointDomain(controlPointDomain);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, vertex.getLine());
                    }
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_9);
            }
            throw ex;
        }
    }

    protected final void ili1_intersectionDef(LineType lineType) throws RecognitionException, TokenStreamException {
        Token without = null;
        PrecisionDecimal maxOverlap = null;
        try {
            without = this.LT(1);
            this.match(40);
            this.match(47);
            this.match(48);
            maxOverlap = this.ili1_decimal();
            if (this.inputState.guessing == 0 && lineType != null && maxOverlap != null) {
                try {
                    lineType.setMaxOverlap(maxOverlap);
                }
                catch (Exception ex) {
                    this.reportError(ex, without.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_9);
            }
            throw ex;
        }
    }

    protected final void ili1_lineAttributes(LineType lineType, Container scope, Viewable table) throws RecognitionException, TokenStreamException {
        Token att = null;
        Table lineAttrStruct = null;
        try {
            att = this.LT(1);
            this.match(43);
            this.match(15);
            if (this.inputState.guessing == 0) {
                lineAttrStruct = this.createImplicitLineAttrStructure(scope, table, att.getLine());
                try {
                    ((SurfaceOrAreaType)lineType).setLineAttributeStructure(lineAttrStruct);
                }
                catch (Exception ex) {
                    this.reportInternalError(ex, att.getLine());
                    Ili1Parser.panic();
                }
            }
            int _cnt1473 = 0;
            while (true) {
                if (this.LA(1) != 7) {
                    if (_cnt1473 >= 1) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.ili1_attribute(lineAttrStruct);
                ++_cnt1473;
            }
            if (this.LA(1) == 22 || this.LA(1) == 23) {
                this.ili1_identifications(lineAttrStruct);
            } else if (this.LA(1) != 8) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(8);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_9);
            }
            throw ex;
        }
    }

    protected final LineForm ili1_lineForm(Model forModel) throws RecognitionException, TokenStreamException {
        Token expl = null;
        LineForm lineForm = null;
        try {
            switch (this.LA(1)) {
                case 45: {
                    this.match(45);
                    if (this.inputState.guessing == 0) {
                        lineForm = this.td.INTERLIS.STRAIGHTS;
                    }
                    break;
                }
                case 46: {
                    this.match(46);
                    if (this.inputState.guessing == 0) {
                        lineForm = this.td.INTERLIS.ARCS;
                    }
                    break;
                }
                case 21: {
                    expl = this.LT(1);
                    this.match(21);
                    if (this.inputState.guessing == 0) {
                        lineForm = this.addLineFormIfNoSuchExplanation(forModel, expl.getText(), expl.getLine());
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_2);
            }
            throw ex;
        }
        return lineForm;
    }

    protected final void ili1_viewDef() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 53: {
                    this.match(53);
                    this.match(7);
                    this.match(21);
                    break;
                }
                case 44: {
                    this.match(44);
                    this.match(54);
                    this.match(7);
                    break;
                }
                case 55: {
                    this.match(55);
                    this.match(7);
                    if (this.LA(1) == 44) {
                        this.match(44);
                        this.match(54);
                        break;
                    }
                    if (this.LA(1) != 5) {
                        if (this.LA(1) == 11) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    break;
                }
                case 56: {
                    this.match(56);
                    this.match(7);
                    this.match(13);
                    this.match(7);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_19);
            }
            throw ex;
        }
    }

    protected final void ili1_font(Ili1Format format) throws RecognitionException, TokenStreamException {
        Token expl = null;
        try {
            this.match(63);
            this.match(15);
            expl = this.LT(1);
            this.match(21);
            this.match(11);
            if (this.inputState.guessing == 0) {
                format.font = expl.getText();
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_20);
            }
            throw ex;
        }
    }

    protected final void ili1_specialCharacter(Ili1Format format) throws RecognitionException, TokenStreamException {
        int blankCode = 95;
        int undefinedCode = 64;
        int continueCode = 92;
        try {
            this.match(64);
            this.match(15);
            if (this.LA(1) == 65) {
                this.match(65);
            } else if (this.LA(1) == 9 || this.LA(1) == 72) {
                blankCode = this.code();
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(5);
            this.match(66);
            this.match(15);
            if (this.LA(1) == 65) {
                this.match(65);
            } else if (this.LA(1) == 9 || this.LA(1) == 72) {
                undefinedCode = this.code();
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(5);
            this.match(67);
            this.match(15);
            if (this.LA(1) == 65) {
                this.match(65);
            } else if (this.LA(1) == 9 || this.LA(1) == 72) {
                continueCode = this.code();
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(11);
            if (this.inputState.guessing == 0) {
                format.blankCode = blankCode;
                format.undefinedCode = undefinedCode;
                format.continueCode = continueCode;
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_21);
            }
            throw ex;
        }
    }

    protected final void ili1_transferId(Ili1Format format) throws RecognitionException, TokenStreamException {
        Token exp = null;
        try {
            this.match(68);
            this.match(15);
            switch (this.LA(1)) {
                case 69: {
                    this.match(69);
                    if (this.inputState.guessing != 0) break;
                    format.tidKind = 1;
                    break;
                }
                case 70: {
                    this.match(70);
                    if (this.inputState.guessing != 0) break;
                    format.tidKind = 2;
                    break;
                }
                case 71: {
                    this.match(71);
                    if (this.inputState.guessing != 0) break;
                    format.tidKind = 3;
                    break;
                }
                case 21: {
                    exp = this.LT(1);
                    this.match(21);
                    if (this.inputState.guessing != 0) break;
                    format.tidKind = 4;
                    format.tidExplanation = exp.getText();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(11);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_14);
            }
            throw ex;
        }
    }

    protected final int code() throws RecognitionException, TokenStreamException {
        int i;
        block7: {
            Token p = null;
            Token h = null;
            i = 0;
            try {
                if (this.LA(1) == 9) {
                    p = this.LT(1);
                    this.match(9);
                    if (this.inputState.guessing == 0) {
                        i = Integer.parseInt(p.getText());
                    }
                    break block7;
                }
                if (this.LA(1) == 72) {
                    h = this.LT(1);
                    this.match(72);
                    if (this.inputState.guessing == 0) {
                        i = Integer.parseInt(h.getText().substring(2), 16);
                    }
                    break block7;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_19);
                }
                throw ex;
            }
        }
        return i;
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{2L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] data = new long[]{1135795513591904L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] data = new long[]{96L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] data = new long[]{8192L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_4() {
        long[] data = new long[]{1135795513591840L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_5() {
        long[] data = new long[]{479488L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_6() {
        long[] data = new long[]{65792L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_7() {
        long[] data = new long[]{0x210000000000000L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_8() {
        long[] data = new long[]{0x4000000000000000L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_9() {
        long[] data = new long[]{1135795513591808L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_10() {
        long[] data = new long[]{409856L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_11() {
        long[] data = new long[]{7661803274384L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_12() {
        long[] data = new long[]{7661802225808L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_13() {
        long[] data = new long[]{12583296L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_14() {
        long[] data = new long[]{256L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_15() {
        long[] data = new long[]{0x200800L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_16() {
        long[] data = new long[]{7661802225680L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_17() {
        long[] data = new long[]{1135795916245504L, 1536L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_18() {
        long[] data = new long[]{0x2000000000000L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_19() {
        long[] data = new long[]{2080L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_20() {
        long[] data = new long[]{0L, 1L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_21() {
        long[] data = new long[]{0L, 16L, 0L, 0L};
        return data;
    }
}

