/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.av2geobau;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import java.io.File;
import java.io.IOException;
import org.interlis2.av2geobau.Av2geobau;

public class Main {
    public static final String APP_NAME = "av2geobau";
    public static final String APP_JAR = "av2geobau.jar";
    private static String version = null;
    private static final String SETTINGS_FILE = System.getProperty("user.home") + "/.av2geobau";

    public static void main(String[] args) {
        File dxfFile;
        File itfFile;
        boolean ok;
        int dataFileCount;
        int argi;
        Settings settings = new Settings();
        settings.setValue("org.interlis2.av2geobau.ilidirs", "%ITF_DIR;http://models.interlis.ch/;%JAR_DIR/ilimodels");
        String appHome = Main.getAppHome();
        Object xtfFile = null;
        Object httpProxyHost = null;
        Object httpProxyPort = null;
        boolean doGui = false;
        for (argi = 0; argi < args.length; ++argi) {
            String arg = args[argi];
            if (arg.equals("--trace")) {
                EhiLogger.getInstance().setTraceFilter(false);
                continue;
            }
            if (arg.equals("--modeldir")) {
                settings.setValue("org.interlis2.av2geobau.ilidirs", args[++argi]);
                continue;
            }
            if (arg.equals("--config")) {
                settings.setValue("org.interlis2.av2geobau.configfile", args[++argi]);
                continue;
            }
            if (arg.equals("--perimeter")) {
                settings.setValue("org.interlis2.av2geobau.perimeter", args[++argi]);
                continue;
            }
            if (arg.equals("--log")) {
                settings.setValue("org.interlis2.av2geobau.log", args[++argi]);
                continue;
            }
            if (arg.equals("--proxy")) {
                settings.setValue("ch.interlis.ili2c.http_proxy_host", args[++argi]);
                continue;
            }
            if (arg.equals("--proxyPort")) {
                settings.setValue("ch.interlis.ili2c.http_proxy_port", args[++argi]);
                continue;
            }
            if (arg.equals("--version")) {
                Main.printVersion();
                return;
            }
            if (arg.equals("--help")) {
                Main.printVersion();
                System.err.println();
                Main.printDescription();
                System.err.println();
                Main.printUsage();
                System.err.println();
                System.err.println("OPTIONS");
                System.err.println();
                System.err.println("--config file         config file to control mapping.");
                System.err.println("--perimeter WKT       perimeter as WKT polygon, that is used to limit the conversion.");
                System.err.println("--log file            text file, that receives conversion results.");
                System.err.println("--modeldir %ITF_DIR;http://models.interlis.ch/;%JAR_DIR/ilimodels list of directories/repositories with ili-files.");
                System.err.println("--proxy host          proxy server to access model repositories.");
                System.err.println("--proxyPort port      proxy port to access model repositories.");
                System.err.println("--trace               enable trace messages.");
                System.err.println("--help                Display this help text.");
                System.err.println("--version             Display the version of av2geobau.");
                System.err.println();
                return;
            }
            if (!arg.startsWith("-")) break;
            EhiLogger.logAdaption((String)(arg + ": unknown option; ignored"));
        }
        if ((dataFileCount = args.length - argi) != 2 && dataFileCount == 0) {
            EhiLogger.logError((String)"av2geobau: wrong number of arguments");
            System.exit(2);
        }
        System.exit((ok = Av2geobau.convert(itfFile = new File(args[argi++]), dxfFile = new File(args[argi++]), settings)) ? 0 : 1);
    }

    public static void readSettings(Settings settings) {
        File file = new File(SETTINGS_FILE);
        try {
            if (file.exists()) {
                settings.load(file);
            }
        }
        catch (IOException ex) {
            EhiLogger.logError((String)("failed to load settings from file " + SETTINGS_FILE), (Throwable)ex);
        }
    }

    public static void writeSettings(Settings settings) {
        File file = new File(SETTINGS_FILE);
        try {
            settings.store(file, "av2geobau settings");
        }
        catch (IOException ex) {
            EhiLogger.logError((String)("failed to settings settings to file " + SETTINGS_FILE), (Throwable)ex);
        }
    }

    protected static void printVersion() {
        System.err.println("av2geobau, Version " + Main.getVersion());
        System.err.println("  Developed by Eisenhut Informatik AG, CH-3400 Burgdorf");
    }

    protected static void printDescription() {
        System.err.println("DESCRIPTION");
        System.err.println("  Converts an ITF/DM01 file to a DXF/geobau.");
    }

    protected static void printUsage() {
        System.err.println("USAGE");
        System.err.println("  java -jar av2geobau.jar [Options] in.itf out.dxf");
    }

    public static String getVersion() {
        if (version == null) {
            java.util.ResourceBundle resVersion = java.util.ResourceBundle.getBundle(ResourceBundle.class2qpackageName(Main.class) + ".Version");
            StringBuffer ret = new StringBuffer(20);
            ret.append(resVersion.getString("version"));
            ret.append('-');
            ret.append(resVersion.getString("versionCommit"));
            version = ret.toString();
        }
        return version;
    }

    public static String getAppHome() {
        String[] classpaths;
        for (String classpath : classpaths = System.getProperty("java.class.path").split(System.getProperty("path.separator"))) {
            File file;
            String jarName;
            if (!classpath.toLowerCase().endsWith(".jar") || !(jarName = (file = new File(classpath)).getName()).toLowerCase().startsWith(APP_NAME) || !(file = new File(file.getAbsolutePath())).exists()) continue;
            return file.getParent();
        }
        return null;
    }
}

