/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.av2geobau.impl;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DxfUtil {
    private static final DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
    private static final DecimalFormat[] decimalFormats = new DecimalFormat[]{new DecimalFormat("#0", dfs), new DecimalFormat("#0.0", dfs), new DecimalFormat("#0.00", dfs), new DecimalFormat("#0.000", dfs), new DecimalFormat("#0.0000", dfs), new DecimalFormat("#0.00000", dfs), new DecimalFormat("#0.000000", dfs), new DecimalFormat("#0.0000000", dfs), new DecimalFormat("#0.00000000", dfs), new DecimalFormat("#0.000000000", dfs), new DecimalFormat("#0.0000000000", dfs), new DecimalFormat("#0.00000000000", dfs), new DecimalFormat("#0.000000000000", dfs)};

    private DxfUtil() {
    }

    private static String int34car(int code) {
        if (code < 10) {
            return "  " + Integer.toString(code);
        }
        if (code < 100) {
            return " " + Integer.toString(code);
        }
        return Integer.toString(code);
    }

    private static String int6car(int value) {
        String s = "     " + Integer.toString(value);
        return s.substring(s.length() - 6, s.length());
    }

    public static String toString(int code, String value) {
        return DxfUtil.int34car(code) + "\r\n" + value + "\r\n";
    }

    public static String toString(int code, int value) {
        return DxfUtil.int34car(code) + "\r\n" + DxfUtil.int6car(value) + "\r\n";
    }

    public static String toString(int code, float value, int decimalPartLength) {
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException("unexpeced value " + value);
        }
        return DxfUtil.int34car(code) + "\r\n" + decimalFormats[decimalPartLength].format(value) + "\r\n";
    }

    public static String toString(int code, double value, int decimalPartLength) {
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException("unexpeced value " + value);
        }
        return DxfUtil.int34car(code) + "\r\n" + decimalFormats[decimalPartLength].format(value) + "\r\n";
    }

    public static String toString(int code, Object value) {
        if (value instanceof String) {
            return DxfUtil.toString(code, (String)value);
        }
        if (value instanceof Integer) {
            return DxfUtil.toString(code, (Integer)value);
        }
        if (value instanceof Float) {
            return DxfUtil.toString(code, ((Float)value).floatValue(), 3);
        }
        if (value instanceof Double) {
            return DxfUtil.toString(code, (Double)value, 6);
        }
        return DxfUtil.toString(code, value.toString());
    }
}

