/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.av2geobau;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.LogListener;
import ch.ehi.basics.logging.StdListener;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.Ili2c;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.metamodel.Ili2cMetaAttrs;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ilirepository.IliManager;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.ItfReader2;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.iox_j.IoxUtility;
import ch.interlis.iox_j.filter.TranslateToOrigin;
import ch.interlis.iox_j.logging.FileLogger;
import ch.interlis.iox_j.logging.StdLogger;
import ch.interlis.iox_j.statistics.IoxStatistics;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import org.interlis2.av2geobau.Main;
import org.interlis2.av2geobau.impl.DxfUtil;
import org.interlis2.av2geobau.impl.DxfWriter;
import org.interlis2.av2geobau.impl.Mapper;

public class Av2geobau {
    public static final String DM01_IT = "MD01MUCH24MN95I";
    public static final String DM01_FR = "MD01MOCH24MN95F";
    public static final String DM01_DE = "DM01AVCH24LV95D";
    public static final String SETTING_DEFAULT_ILIDIRS = "%ITF_DIR;http://models.interlis.ch/;%JAR_DIR/ilimodels";
    public static final String SETTING_ILIDIRS = "org.interlis2.av2geobau.ilidirs";
    public static final String SETTING_APPHOME = "org.interlis2.av2geobau.appHome";
    public static final String SETTING_CONFIGFILE = "org.interlis2.av2geobau.configfile";
    public static final String SETTING_PERIMETER = "org.interlis2.av2geobau.perimeter";
    public static final String SETTING_LOGFILE = "org.interlis2.av2geobau.log";
    public static final String ITF_DIR = "%ITF_DIR";
    public static final String JAR_DIR = "%JAR_DIR";

    public static boolean convert(File itfFile, File dxfFile, Settings settings) {
        return new Av2geobau().doConversion(itfFile, dxfFile, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doConversion(File itfFile, File dxfFile, Settings settings) {
        boolean ret;
        StdLogger logStderr;
        block41: {
            TransferDescription td;
            Geometry perimeter;
            FileLogger logfile;
            block38: {
                boolean bl;
                block39: {
                    if (itfFile == null) {
                        EhiLogger.logError((String)"no ITF file given");
                        return false;
                    }
                    if (dxfFile == null) {
                        EhiLogger.logError((String)"no DXF file given");
                        return false;
                    }
                    if (settings == null) {
                        settings = new Settings();
                    }
                    String logFilename = settings.getValue(SETTING_LOGFILE);
                    logfile = null;
                    logStderr = null;
                    ret = false;
                    if (logFilename != null) {
                        logfile = new FileLogger(new File(logFilename));
                        EhiLogger.getInstance().addListener((LogListener)logfile);
                    }
                    logStderr = new StdLogger(logFilename);
                    EhiLogger.getInstance().addListener((LogListener)logStderr);
                    EhiLogger.getInstance().removeListener((LogListener)StdListener.getInstance());
                    String configFilename = settings.getValue(SETTING_CONFIGFILE);
                    String perimeterWKT = settings.getValue(SETTING_PERIMETER);
                    String appHome = settings.getValue(SETTING_APPHOME);
                    EhiLogger.logState((String)("av2geobau-" + Main.getVersion()));
                    EhiLogger.logState((String)("ili2c-" + Ili2c.getVersion()));
                    EhiLogger.logState((String)("iox-ili-" + IoxUtility.getVersion()));
                    EhiLogger.logState((String)("maxMemory " + Runtime.getRuntime().maxMemory() / 1024L + " KB"));
                    EhiLogger.logState((String)("itfFile <" + itfFile.getPath() + ">"));
                    EhiLogger.logState((String)("dxfFile <" + dxfFile.getPath() + ">"));
                    if (configFilename != null) {
                        EhiLogger.logState((String)("configFile <" + configFilename + ">"));
                    }
                    perimeter = null;
                    if (perimeterWKT != null) {
                        EhiLogger.logState((String)("perimeter <" + perimeterWKT + ">"));
                        try {
                            perimeter = new WKTReader().read(perimeterWKT);
                        }
                        catch (ParseException e) {
                            throw new IllegalArgumentException("failed to parse perimeter", e);
                        }
                    }
                    td = null;
                    String modelFromItf = ch.interlis.iox_j.utility.IoxUtility.getModelFromXtf(itfFile.getPath());
                    if (!(modelFromItf.equals(DM01_DE) || modelFromItf.equals(DM01_FR) || modelFromItf.equals(DM01_IT))) {
                        throw new IllegalArgumentException("only DM01AVCH24LV95D, MD01MOCH24MN95F or MD01MUCH24MN95I supported");
                    }
                    String[] models = null;
                    Ili2cMetaAttrs ili2cMetaAttrs = new Ili2cMetaAttrs();
                    if (modelFromItf.equals(DM01_FR) || modelFromItf.equals(DM01_IT)) {
                        ili2cMetaAttrs.setMetaAttrValue(modelFromItf, "ili2c.translationOf", DM01_DE);
                        models = new String[]{DM01_DE, modelFromItf};
                    } else {
                        models = new String[]{DM01_DE};
                    }
                    td = Av2geobau.compileIli(models, null, itfFile.getAbsoluteFile().getParentFile().getAbsolutePath(), appHome, settings, ili2cMetaAttrs);
                    if (td != null) break block38;
                    bl = false;
                    if (logfile == null) break block39;
                    logfile.close();
                    EhiLogger.getInstance().removeListener((LogListener)logfile);
                    logfile = null;
                }
                if (logStderr != null) {
                    EhiLogger.getInstance().addListener((LogListener)StdListener.getInstance());
                    EhiLogger.getInstance().removeListener((LogListener)logStderr);
                    logStderr = null;
                }
                return bl;
            }
            try {
                TranslateToOrigin languageFilter = null;
                languageFilter = new TranslateToOrigin(td, settings);
                EhiLogger.logState((String)"convert data...");
                IoxStatistics statistics = null;
                try {
                    statistics = new IoxStatistics(td, settings);
                    ItfReader2 ioxReader = new ItfReader2(itfFile, true);
                    ioxReader.setModel(td);
                    statistics.setFilename(itfFile.getPath());
                    BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dxfFile), "ISO-8859-1"));
                    Mapper itf2dxf = new Mapper();
                    itf2dxf.setPerimeter(perimeter);
                    try {
                        String dxfFragment;
                        IomObject iomObjDxf;
                        this.writeBlocks(fw);
                        fw.write(DxfUtil.toString(0, "SECTION"));
                        fw.write(DxfUtil.toString(2, "ENTITIES"));
                        IoxEvent event = null;
                        do {
                            event = ioxReader.read();
                            statistics.add(event);
                            if (languageFilter != null) {
                                event = languageFilter.filter(event);
                            }
                            itf2dxf.addInput(event);
                            if (!(event instanceof ObjectEvent)) continue;
                            iomObjDxf = itf2dxf.getMappedObject();
                            while (iomObjDxf != null) {
                                dxfFragment = DxfWriter.feature2Dxf(iomObjDxf);
                                fw.write(dxfFragment);
                                iomObjDxf = itf2dxf.getMappedObject();
                            }
                        } while (!(event instanceof EndTransferEvent));
                        iomObjDxf = itf2dxf.getMappedObject();
                        while (iomObjDxf != null) {
                            dxfFragment = DxfWriter.feature2Dxf(iomObjDxf);
                            fw.write(dxfFragment);
                            iomObjDxf = itf2dxf.getMappedObject();
                        }
                        fw.write(DxfUtil.toString(0, "ENDSEC"));
                        fw.write(DxfUtil.toString(0, "EOF"));
                    }
                    finally {
                        if (languageFilter != null) {
                            languageFilter.close();
                        }
                        if (ioxReader != null) {
                            try {
                                ioxReader.close();
                            }
                            catch (IoxException e) {
                                EhiLogger.logError((Throwable)e);
                            }
                            ioxReader = null;
                        }
                        if (itf2dxf != null) {
                            itf2dxf.close();
                            itf2dxf = null;
                        }
                        if (fw != null) {
                            ((Writer)fw).close();
                            fw = null;
                        }
                    }
                    statistics.write2logger();
                    if (logStderr.hasSeenErrors()) {
                        EhiLogger.logState((String)"...conversion failed");
                    } else {
                        EhiLogger.logState((String)"...conversion done");
                        ret = true;
                    }
                }
                catch (Throwable ex) {
                    if (statistics != null) {
                        statistics.write2logger();
                    }
                    EhiLogger.logError((Throwable)ex);
                    EhiLogger.logState((String)"...conversion failed");
                }
                if (logfile == null) break block41;
            }
            catch (Throwable throwable) {
                if (logfile != null) {
                    logfile.close();
                    EhiLogger.getInstance().removeListener(logfile);
                    logfile = null;
                }
                if (logStderr != null) {
                    EhiLogger.getInstance().addListener((LogListener)StdListener.getInstance());
                    EhiLogger.getInstance().removeListener((LogListener)logStderr);
                    logStderr = null;
                }
                throw throwable;
            }
            logfile.close();
            EhiLogger.getInstance().removeListener((LogListener)logfile);
            logfile = null;
        }
        if (logStderr != null) {
            EhiLogger.getInstance().addListener((LogListener)StdListener.getInstance());
            EhiLogger.getInstance().removeListener((LogListener)logStderr);
            logStderr = null;
        }
        return ret;
    }

    private void writeBlocks(Writer fw) throws IOException {
        fw.write(DxfUtil.toString(0, "SECTION"));
        fw.write(DxfUtil.toString(2, "BLOCKS"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "GPBOL"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "0.5"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "GPROH"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "0.5"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "GPPFA"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "0.5"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "GPUV"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "0.1"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "GPSTE"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "0.7"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "GPKST"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "0.7"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "GPKRZ"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "0.5"));
        fw.write(DxfUtil.toString(0, "LINE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "-0.849"));
        fw.write(DxfUtil.toString(20, "-0.849"));
        fw.write(DxfUtil.toString(30, "0.000"));
        fw.write(DxfUtil.toString(11, "-0.283"));
        fw.write(DxfUtil.toString(21, "-0.283"));
        fw.write(DxfUtil.toString(31, "0.000"));
        fw.write(DxfUtil.toString(0, "LINE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "-0.284"));
        fw.write(DxfUtil.toString(20, "0.284"));
        fw.write(DxfUtil.toString(30, "0.000"));
        fw.write(DxfUtil.toString(11, "-0.849"));
        fw.write(DxfUtil.toString(21, "0.849"));
        fw.write(DxfUtil.toString(31, "0.000"));
        fw.write(DxfUtil.toString(0, "LINE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.283"));
        fw.write(DxfUtil.toString(20, "0.283"));
        fw.write(DxfUtil.toString(30, "0.000"));
        fw.write(DxfUtil.toString(11, "0.849"));
        fw.write(DxfUtil.toString(21, "0.849"));
        fw.write(DxfUtil.toString(31, "0.000"));
        fw.write(DxfUtil.toString(0, "LINE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.849"));
        fw.write(DxfUtil.toString(20, "-0.849"));
        fw.write(DxfUtil.toString(30, "0.000"));
        fw.write(DxfUtil.toString(11, "0.283"));
        fw.write(DxfUtil.toString(21, "-0.283"));
        fw.write(DxfUtil.toString(31, "0.000"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "HGP"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "1.5"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "LFP1"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "0.8"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "1.3"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "LFP2"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "0.8"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "1.3"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "HFP1"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "1.0"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "HFP2"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "1.0"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "HFP3"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "1.0"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "LFP3ST"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "0.8"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "1.3"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "LFP3BO"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "1.0"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "LFP3UV"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "0.3"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "LFP3KR"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "0.4"));
        fw.write(DxfUtil.toString(0, "LINE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "-0.849"));
        fw.write(DxfUtil.toString(20, "-0.849"));
        fw.write(DxfUtil.toString(30, "0.000"));
        fw.write(DxfUtil.toString(11, "-0.283"));
        fw.write(DxfUtil.toString(21, "-0.283"));
        fw.write(DxfUtil.toString(31, "0.000"));
        fw.write(DxfUtil.toString(0, "LINE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "-0.284"));
        fw.write(DxfUtil.toString(20, "0.284"));
        fw.write(DxfUtil.toString(30, "0.000"));
        fw.write(DxfUtil.toString(11, "-0.849"));
        fw.write(DxfUtil.toString(21, "0.849"));
        fw.write(DxfUtil.toString(31, "0.000"));
        fw.write(DxfUtil.toString(0, "LINE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.283"));
        fw.write(DxfUtil.toString(20, "0.283"));
        fw.write(DxfUtil.toString(30, "0.000"));
        fw.write(DxfUtil.toString(11, "0.849"));
        fw.write(DxfUtil.toString(21, "0.849"));
        fw.write(DxfUtil.toString(31, "0.000"));
        fw.write(DxfUtil.toString(0, "LINE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.849"));
        fw.write(DxfUtil.toString(20, "-0.849"));
        fw.write(DxfUtil.toString(30, "0.000"));
        fw.write(DxfUtil.toString(11, "0.283"));
        fw.write(DxfUtil.toString(21, "-0.283"));
        fw.write(DxfUtil.toString(31, "0.000"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "1.200667"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "BLOCK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(70, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(2, "EOPNT"));
        fw.write(DxfUtil.toString(0, "CIRCLE"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(10, "0.0"));
        fw.write(DxfUtil.toString(20, "0.0"));
        fw.write(DxfUtil.toString(30, "0.0"));
        fw.write(DxfUtil.toString(40, "0.4"));
        fw.write(DxfUtil.toString(0, "ENDBLK"));
        fw.write(DxfUtil.toString(8, "0"));
        fw.write(DxfUtil.toString(0, "ENDSEC"));
    }

    public static TransferDescription compileIli(String[] modelName, File ilifile, String itfDir, String appHome, Settings settings, Ili2cMetaAttrs ili2cMetaAttrs) {
        ArrayList<String> modeldirv = new ArrayList<String>();
        String ilidirs = settings.getValue(SETTING_ILIDIRS);
        if (ilidirs == null) {
            ilidirs = SETTING_DEFAULT_ILIDIRS;
        }
        EhiLogger.logState((String)("ilidirs <" + ilidirs + ">"));
        String[] modeldirs = ilidirs.split(";");
        HashSet ilifiledirs = new HashSet();
        for (int modeli = 0; modeli < modeldirs.length; ++modeli) {
            String m = modeldirs[modeli];
            if (m.contains(ITF_DIR)) {
                if ((m = m.replace(ITF_DIR, itfDir)) == null || m.length() <= 0 || modeldirv.contains(m)) continue;
                modeldirv.add(m);
                continue;
            }
            if (m.contains(JAR_DIR)) {
                if (appHome == null) continue;
                m = m.replace(JAR_DIR, appHome);
                modeldirv.add(m);
                continue;
            }
            if (m == null || m.length() <= 0) continue;
            modeldirv.add(m);
        }
        ch.interlis.ili2c.Main.setHttpProxySystemProperties(settings);
        TransferDescription td = null;
        Configuration ili2cConfig = null;
        if (ilifile != null) {
            IliManager repositoryManager = (IliManager)settings.getTransientObject("ch.interlis.ili2c.customIliManager");
            if (repositoryManager == null) {
                repositoryManager = new IliManager();
                settings.setTransientObject("ch.interlis.ili2c.customIliManager", (Object)repositoryManager);
            }
            try {
                repositoryManager.setRepositories(modeldirv.toArray(new String[0]));
                ArrayList<String> ilifiles = new ArrayList<String>();
                ilifiles.add(ilifile.getPath());
                ili2cConfig = repositoryManager.getConfigWithFiles(ilifiles, ili2cMetaAttrs);
                ili2cConfig.setGenerateWarnings(false);
            }
            catch (Ili2cException ex) {
                EhiLogger.logError((Throwable)ex);
                return null;
            }
        }
        ArrayList<String> modelv = new ArrayList<String>();
        if (modelName != null) {
            for (String m : modelName) {
                if (m == null) continue;
                modelv.add(m);
            }
        }
        try {
            IliManager modelManager = new IliManager();
            modelManager.setRepositories(modeldirv.toArray(new String[0]));
            ili2cConfig = modelManager.getConfig(modelv, 0.0, ili2cMetaAttrs);
            ili2cConfig.setGenerateWarnings(false);
        }
        catch (Ili2cException ex) {
            EhiLogger.logError((Throwable)ex);
            return null;
        }
        Ili2c.logIliFiles(ili2cConfig);
        td = ch.interlis.ili2c.Main.runCompiler(ili2cConfig, settings, ili2cMetaAttrs);
        return td;
    }
}

