/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.xtf;

import ch.interlis.ili2c.generator.XSD24Generator;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.View;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.xtf.XtfReader;
import ch.interlis.iom_j.xtf.XtfStartTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxFactoryCollection;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox_j.DefaultIoxFactoryCollection;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.IoxIliReader;
import ch.interlis.iox_j.IoxSyntaxException;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Xtf24Reader
implements IoxReader,
IoxIliReader {
    private XMLEventReader xmlreader = null;
    private IoxFactoryCollection factory = new DefaultIoxFactoryCollection();
    private InputStream inputFile = null;
    private ArrayList<String> models = new ArrayList();
    private Topic currentTopic = null;
    private Set<String> filterTopics = null;
    private TransferDescription td;
    private int state = 0;
    private static final int STATE_START = 0;
    private static final int STATE_AFTER_STARTTRANSFER = 1;
    private static final int STATE_AFTER_STARTBASKET = 2;
    private static final int STATE_AFTER_OBJECT = 3;
    private static final int STATE_AFTER_ENDBASKET = 4;
    private static final int STATE_AFTER_ENDTRANSFER = 5;
    private HashMap<QName, Topic> iliTopics = null;
    private HashMap<QName, Viewable> iliClasses = null;
    private HashMap<Viewable, HashMap<QName, Element>> iliProperties = null;
    private static final String NAMESPACE_ILIXMLBASE = "http://www.interlis.ch/xtf/2.4/";
    private static final String NAMESPACE_ILIXMLBASE_INTERLIS = "http://www.interlis.ch/xtf/2.4/INTERLIS";
    public static final String XMLNS_XTF24 = "http://www.interlis.ch/xtf/2.4/INTERLIS";
    private static final String NAMESPACE_GEOM = "http://www.interlis.ch/geometry/1.0";
    private static final String NAMESPACE_XMLSCHEMA = "http://www.w3.org/2001/XMLSchema-instance";
    private static final QName QNAME_XML_HEADERSECTION = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "headersection");
    private static final QName QNAME_XML_HEADERSECTION_SENDER = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "sender");
    private static final QName QNAME_XML_HEADERSECTION_COMMENT = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "comment");
    private static final QName QNAME_XML_DATASECTION = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "datasection");
    private static final QName QNAME_XML_MODELS = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "models");
    private static final QName QNAME_XML_MODEL = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "model");
    private static final QName QNAME_ILI_BID = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "bid");
    private static final QName QNAME_ILI_TID = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "tid");
    private static final QName QNAME_ILI_ORDERPOS = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "order_pos");
    private static final QName QNAME_ILI_OPERATION = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "operation");
    private static final QName QNAME_ILI_TRANSFER = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "transfer");
    private static final QName QNAME_ILI_REF = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "ref");
    private static final QName QNAME_ILI_DELETE = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "delete");
    private static final QName QNAME_ILI_STARTSTATE = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "startstate");
    private static final QName QNAME_ILI_ENDSTATE = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "endstate");
    private static final QName QNAME_ILI_KIND = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "kind");
    private static final QName QNAME_ILI_DOMAIN = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "domains");
    private static final QName QNAME_ILI_CONSISTENCY = new QName("http://www.interlis.ch/xtf/2.4/INTERLIS", "consistency");
    private static final QName QNAME_GEOM_COORD = new QName("http://www.interlis.ch/geometry/1.0", "coord");
    private static final QName QNAME_GEOM_ARC = new QName("http://www.interlis.ch/geometry/1.0", "arc");
    private static final QName QNAME_GEOM_MULTICOORD = new QName("http://www.interlis.ch/geometry/1.0", "multicoord");
    private static final QName QNAME_GEOM_POLYLINE = new QName("http://www.interlis.ch/geometry/1.0", "polyline");
    private static final QName QNAME_GEOM_MULTIPOLYLINE = new QName("http://www.interlis.ch/geometry/1.0", "multipolyline");
    private static final QName QNAME_GEOM_LINESTRING = new QName("http://www.interlis.ch/geometry/1.0", "linestring");
    private static final QName QNAME_GEOM_ORIENTABLECURVE = new QName("http://www.interlis.ch/geometry/1.0", "orientablecurve");
    private static final QName QNAME_GEOM_COMPOSITECURVE = new QName("http://www.interlis.ch/geometry/1.0", "compositecurve");
    private static final QName QNAME_GEOM_SURFACE = new QName("http://www.interlis.ch/geometry/1.0", "surface");
    private static final QName QNAME_GEOM_MULTISURFACE = new QName("http://www.interlis.ch/geometry/1.0", "multisurface");
    private static final QName QNAME_GEOM_AREA = new QName("http://www.interlis.ch/geometry/1.0", "area");
    private static final QName QNAME_GEOM_MULTIAREA = new QName("http://www.interlis.ch/geometry/1.0", "multiarea");
    private static final QName QNAME_GEOM_EXTERIOR = new QName("http://www.interlis.ch/geometry/1.0", "exterior");
    private static final QName QNAME_GEOM_INTERIOR = new QName("http://www.interlis.ch/geometry/1.0", "interior");
    private int hsOid = 0;

    public Xtf24Reader(InputStream in) throws IoxException {
        this.init(in);
    }

    public Xtf24Reader(InputStreamReader in) throws IoxException {
    }

    public Xtf24Reader(File xtffile) throws IoxException {
        try {
            this.inputFile = new FileInputStream(xtffile);
            this.init(this.inputFile);
        }
        catch (IOException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    public static IoxReader createReader(File xtffile) throws IoxException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader reader = null;
        FileInputStream in = null;
        XMLEvent event = null;
        try {
            in = new FileInputStream(xtffile);
            reader = inputFactory.createXMLEventReader(in);
            event = reader.nextEvent();
            while (event != null && !event.isStartElement()) {
                event = reader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            throw new IoxException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new IoxException((Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
                reader = null;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                in = null;
            }
        }
        if (event != null) {
            String ns = event.asStartElement().getName().getNamespaceURI();
            if (ns.equals("http://www.interlis.ch/xtf/2.4/INTERLIS")) {
                return new Xtf24Reader(xtffile);
            }
            if (ns.equals("http://www.interlis.ch/INTERLIS2.3")) {
                return new XtfReader(xtffile);
            }
            if (ns.equals("http://www.interlis.ch/INTERLIS2.2")) {
                return new XtfReader(xtffile);
            }
            throw new IoxException("unexpected namesapce " + ns);
        }
        return new XtfReader(xtffile);
    }

    private void init(InputStream in) throws IoxException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try {
            this.xmlreader = inputFactory.createXMLEventReader(in);
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    @Override
    public void setModel(TransferDescription td) {
        this.td = td;
    }

    public void close() throws IoxException {
        this.xmlreader = null;
        if (this.inputFile != null) {
            try {
                this.inputFile.close();
            }
            catch (IOException ex) {
                throw new IoxException((Throwable)ex);
            }
            this.inputFile = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IoxEvent read() throws IoxException {
        IomObject iomObj = null;
        try {
            XMLEvent event = null;
            do {
                StartElement element;
                if (this.state == 0) {
                    event = this.xmlreader.nextEvent();
                    if (!event.isStartDocument()) {
                        throw new IoxSyntaxException(this.event2msgtext(event));
                    }
                    event = this.xmlreader.nextEvent();
                    event = this.skipSpacesAndGetNextEvent(event);
                    if (!event.isStartElement() || !event.asStartElement().getName().equals(QNAME_ILI_TRANSFER)) {
                        throw new IoxSyntaxException(this.event2msgtext(event));
                    }
                    event = this.xmlreader.nextEvent();
                    event = this.skipSpacesAndGetNextEvent(event);
                    XtfStartTransferEvent startTransferEvent = null;
                    if (!event.isStartElement() || !event.asStartElement().getName().equals(QNAME_XML_HEADERSECTION)) {
                        throw new IoxSyntaxException(this.event2msgtext(event));
                    }
                    startTransferEvent = new XtfStartTransferEvent();
                    event = this.readHeaderSection(event, startTransferEvent);
                    event = this.xmlreader.nextEvent();
                    event = this.skipSpacesAndGetNextEvent(event);
                    if (!event.isStartElement() || !event.asStartElement().getName().equals(QNAME_XML_DATASECTION)) {
                        throw new IoxSyntaxException(this.event2msgtext(event));
                    }
                    HashMap<String, IomObject> modelx = new HashMap<String, IomObject>();
                    for (String modelName : this.models) {
                        IomObject model = this.createIomObject("iom04.metamodel.ModelEntry", this.hsNextOid());
                        model.setattrvalue("model", modelName);
                        modelx.put(model.getobjectoid(), model);
                    }
                    startTransferEvent.setHeaderObjects(modelx);
                    this.state = 1;
                    return startTransferEvent;
                }
                if (this.state == 1) {
                    event = this.xmlreader.nextEvent();
                    if ((event = this.skipSpacesAndGetNextEvent(event)).isStartElement()) {
                        element = (StartElement)event;
                        this.currentTopic = this.getIliTopic(element.getName());
                        if (this.currentTopic == null) {
                            if (this.filterTopics == null) throw new IoxSyntaxException("Unknown topic <" + element.getName() + ">");
                            event = this.skipBasket(event);
                            this.state = 4;
                        } else {
                            if (this.filterTopics == null || this.filterTopics.contains(this.currentTopic.getScopedName())) {
                                this.state = 2;
                                return this.createStartBasket(element);
                            }
                            event = this.skipBasket(event);
                            this.state = 4;
                        }
                    } else {
                        if (!event.isEndElement()) throw new IoxSyntaxException(this.event2msgtext(event));
                        return this.readEndTransfer(event);
                    }
                }
                if (this.state == 2) {
                    event = this.xmlreader.nextEvent();
                    if ((event = this.skipSpacesAndGetNextEvent(event)).isStartElement()) {
                        this.state = 3;
                        iomObj = this.readObject(event);
                        this.setOperation(event.asStartElement(), iomObj);
                        this.setConsistency(event.asStartElement(), iomObj);
                        return new ObjectEvent(iomObj);
                    }
                    if (event.isEndElement()) {
                        this.state = 4;
                        return new EndBasketEvent();
                    }
                }
                if (this.state == 3) {
                    event = this.xmlreader.nextEvent();
                    if ((event = this.skipSpacesAndGetNextEvent(event)).isStartElement()) {
                        iomObj = this.readObject(event);
                        this.setOperation(event.asStartElement(), iomObj);
                        this.setConsistency(event.asStartElement(), iomObj);
                        return new ObjectEvent(iomObj);
                    }
                    if (event.isEndElement()) {
                        this.state = 4;
                        return new EndBasketEvent();
                    }
                }
                if (this.state != 4) continue;
                event = this.xmlreader.nextEvent();
                if ((event = this.skipSpacesAndGetNextEvent(event)).isStartElement()) {
                    element = (StartElement)event;
                    this.currentTopic = this.getIliTopic(element.getName());
                    if (this.currentTopic == null) {
                        if (this.filterTopics == null) throw new IoxSyntaxException("Unknown topic <" + element.getName() + ">");
                        event = this.skipBasket(event);
                        this.state = 4;
                        continue;
                    }
                    if (this.filterTopics == null || this.filterTopics.contains(this.currentTopic.getScopedName())) {
                        this.state = 2;
                        return this.createStartBasket(element);
                    }
                    event = this.skipBasket(event);
                    this.state = 4;
                    continue;
                }
                if (!event.isEndElement()) continue;
                return this.readEndTransfer(event);
            } while (this.state != 5);
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private XMLEvent skipBasket(XMLEvent event) throws XMLStreamException {
        XMLEvent ret = Xtf24Reader.skip(this.xmlreader);
        return ret;
    }

    static XMLEvent skip(XMLEventReader parser) throws XMLStreamException {
        int elemenetLevel = 0;
        XMLEvent event = null;
        event = parser.nextEvent();
        while (!event.isEndDocument()) {
            switch (event.getEventType()) {
                case 1: {
                    ++elemenetLevel;
                    break;
                }
                case 2: {
                    --elemenetLevel;
                }
            }
            if (elemenetLevel < 0) break;
            event = parser.nextEvent();
        }
        return event;
    }

    private IoxEvent readEndTransfer(XMLEvent event) throws IoxSyntaxException, XMLStreamException {
        if (!event.isEndElement() || !event.asEndElement().getName().equals(QNAME_XML_DATASECTION)) {
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        event = this.xmlreader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        if (event.isEndElement() && event.asEndElement().getName().equals(QNAME_ILI_TRANSFER)) {
            event = this.xmlreader.nextEvent();
            if ((event = this.skipSpacesAndGetNextEvent(event)).isEndDocument()) {
                this.state = 5;
                return new EndTransferEvent();
            }
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        throw new IoxSyntaxException(this.event2msgtext(event));
    }

    private IomObject readObject(XMLEvent event) throws IoxException {
        try {
            if (!event.isStartElement()) {
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            if (event.asStartElement().getName().equals(QNAME_ILI_DELETE)) {
                return this.deleteObject(event);
            }
            StartElement element = (StartElement)event;
            Viewable viewable = this.getIliClass(element.getName());
            if (viewable == null) {
                throw new IoxException("class or association " + element.getName().getLocalPart() + " not found");
            }
            Attribute oid = element.getAttributeByName(QNAME_ILI_TID);
            if (element.getAttributeByName(QNAME_ILI_BID) != null) {
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            IomObject iomObj = null;
            iomObj = oid != null ? this.createIomObject(viewable.getScopedName(), oid.getValue()) : this.createIomObject(viewable.getScopedName(), null);
            iomObj.setobjectline(element.getLocation().getLineNumber());
            event = this.xmlreader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
            while (this.xmlreader.hasNext() && !event.isEndElement()) {
                this.readAttribute(event, iomObj, viewable);
                event = this.xmlreader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
            }
            if (!event.isEndElement()) {
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            return iomObj;
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private IoxEvent createStartBasket(StartElement element) throws XMLStreamException, IoxException {
        QName gmlId = QNAME_ILI_BID;
        Attribute bid = element.getAttributeByName(gmlId);
        if (bid != null) {
            StartBasketEvent newObj = new StartBasketEvent(this.currentTopic.getScopedName(), bid.getValue());
            newObj = this.setState(element, newObj);
            newObj = this.setIncrementalKind(element, newObj);
            newObj = this.setDomain(element, newObj);
            newObj = this.setConsistency(element, newObj);
            return newObj;
        }
        throw new IoxSyntaxException(this.event2msgtext(element));
    }

    private IomObject deleteObject(XMLEvent event) throws IoxException {
        IomObject objToDelete;
        block4: {
            objToDelete = null;
            try {
                if (event.asStartElement().getAttributeByName(QNAME_ILI_TID) != null) {
                    objToDelete = this.createIomObject(QNAME_ILI_DELETE.getLocalPart(), event.asStartElement().getAttributeByName(QNAME_ILI_TID).getValue());
                    event = this.xmlreader.nextEvent();
                    if ((event = this.skipSpacesAndGetNextEvent(event)).isStartElement()) {
                        throw new IoxException("ili:delete links without tid is not yet implemented.");
                    }
                    break block4;
                }
                throw new IoxException("ili:delete object needs tid");
            }
            catch (XMLStreamException ex) {
                throw new IoxException((Throwable)ex);
            }
        }
        return objToDelete;
    }

    private XMLEvent readHeaderSection(XMLEvent startElementHeaderSection, XtfStartTransferEvent xtfEvent) throws IoxException {
        try {
            XMLEvent event = null;
            if (!startElementHeaderSection.asStartElement().getName().equals(QNAME_XML_HEADERSECTION)) {
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            event = this.xmlreader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
            if (!event.isStartElement() || !event.asStartElement().getName().equals(QNAME_XML_MODELS)) {
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            event = this.readHeaderSectionModels(event);
            if (event.isEndElement()) {
                if (event.asEndElement().getName().equals(QNAME_XML_HEADERSECTION)) {
                    if (this.models.size() == 0) {
                        throw new IoxException("expected at least 1 model.");
                    }
                    return event;
                }
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            int senderCount = 0;
            int commentCount = 0;
            while (event.isStartElement() && (event.asStartElement().getName().equals(QNAME_XML_HEADERSECTION_SENDER) || event.asStartElement().getName().equals(QNAME_XML_HEADERSECTION_COMMENT))) {
                StringBuffer value;
                if (event.asStartElement().getName().equals(QNAME_XML_HEADERSECTION_SENDER)) {
                    if (senderCount == 0) {
                        event = this.xmlreader.nextEvent();
                        event = this.skipCommentary(event);
                        value = new StringBuffer();
                        event = this.readSimpleContent(event, value);
                        xtfEvent.setSender(value.toString());
                        if (value != null && value.toString().isEmpty()) {
                            throw new IoxException("sender defined, but empty.");
                        }
                        if (!event.isEndElement() || !event.asEndElement().getName().equals(QNAME_XML_HEADERSECTION_SENDER)) {
                            throw new IoxSyntaxException(this.event2msgtext(event));
                        }
                        event = this.xmlreader.nextEvent();
                        event = this.skipSpacesAndGetNextEvent(event);
                    } else if (senderCount > 1) {
                        throw new IoxSyntaxException(this.event2msgtext(event));
                    }
                    ++senderCount;
                    continue;
                }
                if (event.asStartElement().getName().equals(QNAME_XML_HEADERSECTION_COMMENT)) {
                    if (commentCount == 0) {
                        event = this.xmlreader.nextEvent();
                        event = this.skipCommentary(event);
                        value = new StringBuffer();
                        event = this.readSimpleContent(event, value);
                        xtfEvent.setComment(value.toString());
                        if (value != null && value.toString().isEmpty()) {
                            throw new IoxException("comments defined, but empty.");
                        }
                        if (!event.isEndElement() || !event.asEndElement().getName().equals(QNAME_XML_HEADERSECTION_COMMENT)) {
                            throw new IoxSyntaxException(this.event2msgtext(event));
                        }
                        event = this.xmlreader.nextEvent();
                        event = this.skipSpacesAndGetNextEvent(event);
                    } else if (commentCount > 1) {
                        throw new IoxSyntaxException(this.event2msgtext(event));
                    }
                    ++commentCount;
                    continue;
                }
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            if (event.isEndElement()) {
                if (event.asEndElement().getName().equals(QNAME_XML_HEADERSECTION)) {
                    return event;
                }
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private XMLEvent readHeaderSectionModels(XMLEvent startElementModels) throws IoxException, XMLStreamException {
        XMLEvent event = null;
        if (!startElementModels.isStartElement() || !startElementModels.asStartElement().getName().equals(QNAME_XML_MODELS)) {
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        event = this.xmlreader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        if (event.isEndElement()) {
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        this.models = new ArrayList();
        while (event.isStartElement() && event.asStartElement().getName().equals(QNAME_XML_MODEL)) {
            event = this.readModel(event);
        }
        if (event.isEndElement() && event.asEndElement().getName().equals(QNAME_XML_MODELS)) {
            if (this.models.size() == 0) {
                throw new IoxException("expected at least 1 model.");
            }
        } else {
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        event = this.xmlreader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        return event;
    }

    private XMLEvent readModel(XMLEvent startElementModel) throws IoxException, XMLStreamException {
        XMLEvent event = null;
        if (!startElementModel.isStartElement() || !startElementModel.asStartElement().getName().equals(QNAME_XML_MODEL)) {
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        event = this.xmlreader.nextEvent();
        if (event.isCharacters()) {
            this.models.add(event.asCharacters().getData());
            event = this.xmlreader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
        }
        if (!event.isEndElement() || !event.asEndElement().getName().equals(QNAME_XML_MODEL)) {
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        event = this.xmlreader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        return event;
    }

    private XMLEvent skipCommentary(XMLEvent event) throws IoxSyntaxException, XMLStreamException {
        while (event.getEventType() == 5) {
            event = this.xmlreader.nextEvent();
        }
        return event;
    }

    private XMLEvent readSimpleContent(XMLEvent event, StringBuffer value) throws XMLStreamException, IoxSyntaxException {
        event = this.skipCommentary(event);
        while (event.isCharacters()) {
            Characters characters = (Characters)event;
            value.append(characters.getData());
            event = this.xmlreader.nextEvent();
            event = this.skipCommentary(event);
        }
        return event;
    }

    private IomObject setOperation(StartElement element, IomObject iomObj) throws IoxException {
        Attribute operation = element.getAttributeByName(QNAME_ILI_OPERATION);
        if (operation != null) {
            String attrValue = operation.getValue();
            if (attrValue.equals("INSERT")) {
                iomObj.setobjectoperation(0);
            } else if (attrValue.equals("UPDATE")) {
                iomObj.setobjectoperation(1);
            } else if (attrValue.equals("DELETE")) {
                iomObj.setobjectoperation(2);
            } else {
                throw new IoxSyntaxException("unexpected operation <" + attrValue + ">");
            }
        }
        return iomObj;
    }

    private IomObject setConsistency(StartElement element, IomObject iomObj) throws IoxException {
        Attribute consistency = element.getAttributeByName(QNAME_ILI_CONSISTENCY);
        if (consistency != null) {
            String attrValue = consistency.getValue();
            if (attrValue.equals("COMPLETE")) {
                iomObj.setobjectoperation(0);
            } else if (attrValue.equals("INCOMPLETE")) {
                iomObj.setobjectoperation(1);
            } else {
                throw new IoxSyntaxException("unexpected consistency <" + attrValue + ">");
            }
        }
        return iomObj;
    }

    private StartBasketEvent setState(StartElement element, StartBasketEvent startBasketEvent) throws IoxException {
        Iterator<Attribute> codingObjIter = element.getAttributes();
        while (codingObjIter.hasNext()) {
            Attribute codingObj = codingObjIter.next();
            if (codingObj.getName().equals(QNAME_ILI_STARTSTATE)) {
                startBasketEvent.setStartstate(codingObj.getValue());
                continue;
            }
            if (!codingObj.getName().equals(QNAME_ILI_ENDSTATE)) continue;
            startBasketEvent.setEndstate(codingObj.getValue());
        }
        return startBasketEvent;
    }

    private StartBasketEvent setIncrementalKind(StartElement element, StartBasketEvent startBasketEvent) throws IoxException {
        Iterator<Attribute> codingObjIter = element.getAttributes();
        while (codingObjIter.hasNext()) {
            Attribute codingObj = codingObjIter.next();
            if (!codingObj.getName().equals(QNAME_ILI_KIND)) continue;
            if (codingObj.getValue().equals("FULL")) {
                startBasketEvent.setKind(0);
                continue;
            }
            if (codingObj.getValue().equals("UPDATE")) {
                startBasketEvent.setKind(1);
                continue;
            }
            if (!codingObj.getValue().equals("INITIAL")) continue;
            startBasketEvent.setKind(2);
        }
        return startBasketEvent;
    }

    private StartBasketEvent setDomain(StartElement element, StartBasketEvent startBasketEvent) throws IoxException {
        Iterator<Attribute> codingObjIter = element.getAttributes();
        Object genericAndConcreteDomains = null;
        while (codingObjIter.hasNext()) {
            Attribute codingObj = codingObjIter.next();
            if (!codingObj.getName().equals(QNAME_ILI_DOMAIN)) continue;
            Map<String, String> domains = Xtf24Reader.parseDomains(codingObj.getValue());
            for (String genericDomain : domains.keySet()) {
                startBasketEvent.addDomain(genericDomain, domains.get(genericDomain));
            }
        }
        return startBasketEvent;
    }

    public static Map<String, String> parseDomains(String domainValue) {
        String[] genericAndConcreteDomains;
        HashMap<String, String> ret = new HashMap<String, String>();
        if (domainValue == null || domainValue.trim().length() == 0) {
            return ret;
        }
        for (String singleDomain : genericAndConcreteDomains = domainValue.split(" ")) {
            String[] domains = singleDomain.split("=");
            ret.put(domains[0], domains[1]);
        }
        return ret;
    }

    private StartBasketEvent setConsistency(StartElement element, StartBasketEvent startBasketEvent) throws IoxException {
        Iterator<Attribute> codingObjIter = element.getAttributes();
        while (codingObjIter.hasNext()) {
            Attribute codingObj = codingObjIter.next();
            if (!codingObj.getName().equals(QNAME_ILI_CONSISTENCY)) continue;
            if (codingObj.getValue().equals("COMPLETE")) {
                startBasketEvent.setConsistency(0);
                continue;
            }
            if (!codingObj.getValue().equals("INCOMPLETE")) continue;
            startBasketEvent.setConsistency(1);
        }
        return startBasketEvent;
    }

    private static XMLEvent collectXMLElement(XMLEventReader reader, XMLEvent event, StringWriter strw) throws XMLStreamException {
        XMLOutputFactory xmloutputf = XMLOutputFactory.newInstance();
        xmloutputf.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        XMLEventFactory xmlef = XMLEventFactory.newInstance();
        XMLEventWriter xmlw = xmloutputf.createXMLEventWriter(strw);
        xmlw.add(event);
        int inHeader = 1;
        while (reader.hasNext()) {
            event = reader.nextEvent();
            xmlw.add(event);
            switch (event.getEventType()) {
                case 1: {
                    ++inHeader;
                    break;
                }
                case 2: {
                    --inHeader;
                }
            }
            if (inHeader == 0 && event.getEventType() == 2) break;
            if (inHeader >= 0) continue;
            throw new IllegalStateException("inHeader < 0");
        }
        xmlw.flush();
        xmlw.close();
        return event;
    }

    private XMLEvent skipSpacesAndGetNextEvent(XMLEvent event) throws XMLStreamException, IoxSyntaxException {
        while (event.isCharacters() || event.getEventType() == 5) {
            Characters characters;
            if (event.isCharacters() && event.getEventType() != 5 && !(characters = (Characters)event).isWhiteSpace()) {
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            event = this.xmlreader.nextEvent();
        }
        return event;
    }

    private String event2msgtext(XMLEvent event) {
        String output = "";
        if (event instanceof StartElement) {
            output = "unexpected start element " + event.asStartElement().getName().getLocalPart();
        } else if (event instanceof EndElement) {
            output = "unexpected end element " + event.asEndElement().getName().getLocalPart();
        } else if (event instanceof Characters) {
            output = "unexpected characters " + ((Characters)event).getData();
        }
        return output;
    }

    private void setupNameMapping() {
        this.iliTopics = new HashMap();
        this.iliClasses = new HashMap();
        this.iliProperties = new HashMap();
        if (this.td == null) {
            return;
        }
        HashMap def2name = XSD24Generator.createDef2NameMapping((TransferDescription)this.td);
        for (Object modelObj : this.td) {
            if (!(modelObj instanceof Model)) continue;
            Model model = (Model)modelObj;
            String modelNameSpace = this.getModelXmlNamespace(model);
            for (Object topicObj : model) {
                Table aClass;
                if (topicObj instanceof Topic) {
                    Topic topic = (Topic)topicObj;
                    String topicName = (String)def2name.get(topic);
                    QName topicQName = new QName(modelNameSpace, topicName);
                    this.iliTopics.put(topicQName, topic);
                    for (Object classObj : topic) {
                        View view;
                        if (!(classObj instanceof Viewable) || classObj instanceof View && (!topic.isViewTopic() || (view = (View)classObj).isTransient())) continue;
                        Viewable aClass2 = (Viewable)classObj;
                        String className = (String)def2name.get(aClass2);
                        QName classQName = new QName(modelNameSpace, className);
                        this.setupViewable(aClass2, classQName);
                    }
                    continue;
                }
                if (!(topicObj instanceof Table) || (aClass = (Table)topicObj).isAbstract()) continue;
                String className = (String)def2name.get(aClass);
                QName classQName = new QName(modelNameSpace, className);
                this.setupViewable((Viewable)aClass, classQName);
            }
        }
    }

    private void setupViewable(Viewable aClass, QName classQName) {
        HashMap<QName, Element> transferElements = null;
        this.iliClasses.put(classQName, aClass);
        Iterator elementIter = aClass.getAttributesAndRoles2();
        transferElements = new HashMap<QName, Element>();
        while (elementIter.hasNext()) {
            ViewableTransferElement obj = (ViewableTransferElement)elementIter.next();
            Element element = (Element)obj.obj;
            Element rootEle = this.getRootEle(element);
            Model modelOfElement = (Model)rootEle.getContainer(Model.class);
            String elementNs = this.getModelXmlNamespace(modelOfElement);
            QName eleQName = new QName(elementNs, element.getName());
            transferElements.put(eleQName, element);
        }
        this.iliProperties.put(aClass, transferElements);
    }

    private Element getRootEle(Element element) {
        RoleDef rootEle = null;
        if (element instanceof RoleDef) {
            RoleDef role = (RoleDef)element;
            rootEle = role.getRootExtending();
        } else if (element instanceof AttributeDef) {
            AttributeDef attr = (AttributeDef)element;
            rootEle = attr.getRootExtending();
        } else {
            throw new IllegalStateException("unexpected class " + element.getClass().getName());
        }
        if (rootEle != null) {
            return rootEle;
        }
        return element;
    }

    private String getModelXmlNamespace(Model model) {
        String modelNameSpace = model.getXmlns();
        if (modelNameSpace == null) {
            modelNameSpace = NAMESPACE_ILIXMLBASE + model.getName();
        }
        return modelNameSpace;
    }

    private Topic getIliTopic(QName qName) {
        if (this.iliTopics == null) {
            this.setupNameMapping();
        }
        return this.iliTopics.get(qName);
    }

    private Viewable getIliClass(QName qName) {
        if (this.iliClasses == null) {
            this.setupNameMapping();
        }
        return this.iliClasses.get(qName);
    }

    private Element getIliProperty(Viewable aClass, QName qName) throws IoxException {
        if (this.iliProperties == null) {
            this.setupNameMapping();
        }
        HashMap<QName, Element> iliPropIter = this.iliProperties.get(aClass);
        return iliPropIter.get(qName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readAttribute(XMLEvent event, IomObject iomObj, Viewable viewable) throws XMLStreamException, IoxException {
        try {
            if (!event.isStartElement()) {
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            StartElement attrStartElement = (StartElement)event;
            QName qName = attrStartElement.getName();
            Element prop = this.getIliProperty(viewable, qName);
            if (prop == null) {
                throw new IoxSyntaxException(attrStartElement.getLocation().getLineNumber(), "unexpected element: " + qName + " in " + viewable.getScopedName());
            }
            String attrName = prop.getName();
            if (prop instanceof RoleDef) {
                RoleDef role = (RoleDef)prop;
                AssociationDef association = (AssociationDef)role.getContainer();
                if (!(association instanceof Viewable)) {
                    viewable = association;
                }
                iomObj = this.readReference(viewable, iomObj, attrStartElement, (Element)role, association);
                event = this.xmlreader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
                attrName = null;
                if (this.xmlreader.peek().isEndElement()) return;
                event = this.skipSpacesAndGetNextEvent(event);
                return;
            }
            if (attrStartElement.getAttributeByName(QNAME_ILI_REF) != null) {
                this.readReference(viewable, iomObj, attrStartElement, prop, null);
                event = this.xmlreader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
                if (this.xmlreader.peek().isEndElement()) return;
                event = this.skipSpacesAndGetNextEvent(event);
                return;
            }
            if (!(prop instanceof AttributeDef)) throw new IoxSyntaxException(this.event2msgtext(event));
            event = this.xmlreader.nextEvent();
            event = this.skipCommentary(event);
            StringBuffer characterValue = new StringBuffer();
            if (event.isCharacters()) {
                if ((event = this.readSimpleContent(event, characterValue)).isEndElement()) {
                    ((Iom_jObject)iomObj).addattrvalue(attrName, characterValue.toString());
                } else {
                    characterValue = null;
                }
            }
            if (event.isStartElement()) {
                if (event.asStartElement().getName().equals(QNAME_GEOM_COORD)) {
                    event = this.xmlreader.nextEvent();
                    if (!(event = this.skipSpacesAndGetNextEvent(event)).isStartElement()) {
                        throw new IoxSyntaxException(this.event2msgtext(event));
                    }
                    IomObject returnedSegment = this.readSegment(event, "COORD");
                    if (returnedSegment.getattrcount() == 0) {
                        throw new IoxException("expected coord. unexpected event: " + event.asStartElement().getName().getLocalPart());
                    }
                    iomObj.addattrobj(attrName, returnedSegment);
                    event = this.xmlreader.nextEvent();
                    event = this.skipSpacesAndGetNextEvent(event);
                    if (!event.isEndElement()) throw new IoxSyntaxException(this.event2msgtext(event));
                    return;
                }
                if (event.asStartElement().getName().equals(QNAME_GEOM_MULTICOORD)) {
                    IomObject multicoord = this.readMultiCoord(event);
                    iomObj.addattrobj(attrName, multicoord);
                    event = this.xmlreader.nextEvent();
                    event = this.skipSpacesAndGetNextEvent(event);
                    if (!event.isEndElement()) throw new IoxSyntaxException(this.event2msgtext(event));
                    return;
                }
                if (event.asStartElement().getName().equals(QNAME_GEOM_POLYLINE)) {
                    IomObject polyline = this.readPolyline(event);
                    if (polyline.getattrcount() == 0) {
                        throw new IoxException("expected polyline. unexpected event: " + event.asStartElement().getName().getLocalPart());
                    }
                    iomObj.addattrobj(attrName, polyline);
                    event = this.xmlreader.nextEvent();
                    event = this.skipSpacesAndGetNextEvent(event);
                    if (!event.isEndElement()) throw new IoxSyntaxException(this.event2msgtext(event));
                    return;
                }
                if (event.asStartElement().getName().equals(QNAME_GEOM_MULTIPOLYLINE)) {
                    IomObject multiPolyline = this.readMultiPolyline(event);
                    if (multiPolyline.getattrcount() == 0) {
                        throw new IoxException("expected multipolyline. unexpected event: " + event.asStartElement().getName().getLocalPart());
                    }
                    iomObj.addattrobj(attrName, multiPolyline);
                    event = this.xmlreader.nextEvent();
                    event = this.skipSpacesAndGetNextEvent(event);
                    if (!event.isEndElement()) throw new IoxSyntaxException(this.event2msgtext(event));
                    return;
                }
                if (event.asStartElement().getName().equals(QNAME_GEOM_LINESTRING)) throw new IoxException("unsupported geometry " + event.asStartElement().getName().getLocalPart());
                if (event.asStartElement().getName().equals(QNAME_GEOM_ORIENTABLECURVE)) throw new IoxException("unsupported geometry " + event.asStartElement().getName().getLocalPart());
                if (event.asStartElement().getName().equals(QNAME_GEOM_COMPOSITECURVE)) {
                    throw new IoxException("unsupported geometry " + event.asStartElement().getName().getLocalPart());
                }
                if (event.asStartElement().getName().equals(QNAME_GEOM_SURFACE)) {
                    IomObject multiSurface = this.createIomObject("MULTISURFACE", null);
                    IomObject surface = this.readSurface(event);
                    if (surface.getattrcount() == 0) {
                        throw new IoxException("expected surface. unexpected event: " + event.asStartElement().getName().getLocalPart());
                    }
                    multiSurface.addattrobj("surface", surface);
                    if (!event.isStartElement()) {
                        throw new IoxSyntaxException(this.event2msgtext(event));
                    }
                    iomObj.addattrobj(attrName, multiSurface);
                    event = this.xmlreader.nextEvent();
                    event = this.skipSpacesAndGetNextEvent(event);
                    if (!event.isEndElement()) throw new IoxSyntaxException(this.event2msgtext(event));
                    return;
                }
                if (event.asStartElement().getName().equals(QNAME_GEOM_MULTISURFACE) || event.asStartElement().getName().equals(QNAME_GEOM_MULTIAREA)) {
                    IomObject multisurface = this.readMultiSurface(event);
                    if (multisurface.getattrcount() == 0) {
                        throw new IoxException("expected multisurface. unexpected event: " + event.asStartElement().getName().getLocalPart());
                    }
                    if (!event.isStartElement()) {
                        throw new IoxSyntaxException(this.event2msgtext(event));
                    }
                    iomObj.addattrobj(attrName, multisurface);
                    event = this.xmlreader.nextEvent();
                    event = this.skipSpacesAndGetNextEvent(event);
                    if (!event.isEndElement()) throw new IoxSyntaxException(this.event2msgtext(event));
                    return;
                }
                QName subQName = ((StartElement)event).getName();
                viewable = this.getIliClass(subQName);
                if (viewable == null) {
                    StringWriter strw = new StringWriter();
                    event = Xtf24Reader.collectXMLElement(this.xmlreader, event, strw);
                    ((Iom_jObject)iomObj).addattrvalue(attrName, strw.toString());
                    if (!event.isEndElement()) {
                        throw new IoxSyntaxException(this.event2msgtext(event));
                    }
                    event = this.xmlreader.nextEvent();
                    event = this.skipSpacesAndGetNextEvent(event);
                    return;
                }
                while (this.xmlreader.hasNext()) {
                    if (!event.isStartElement()) return;
                    IomObject structObj = this.readObject(event);
                    iomObj.addattrobj(attrName, structObj);
                    event = this.xmlreader.nextEvent();
                    event = this.skipSpacesAndGetNextEvent(event);
                }
                return;
            }
            if (!event.isEndElement()) throw new IoxSyntaxException(event.getLocation().getLineNumber(), this.event2msgtext(event));
            return;
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private IomObject readReference(Viewable aclass, IomObject iomObj, StartElement element, Element prop, AssociationDef association) throws IoxException, XMLStreamException {
        String orderPosVal;
        String refOid = element.getAttributeByName(QNAME_ILI_REF).getValue();
        if (refOid.length() < 1) {
            throw new IoxException("unexpected reference value <" + refOid + ">");
        }
        Attribute attrRefBid = element.getAttributeByName(QNAME_ILI_BID);
        String refBid = null;
        if (attrRefBid != null && (refBid = attrRefBid.getValue()).length() < 1) {
            throw new IoxException("unexpected reference value <" + refBid + ">");
        }
        Long orderPos = null;
        Attribute orderPosAttr = element.getAttributeByName(QNAME_ILI_ORDERPOS);
        if (orderPosAttr != null && (orderPosVal = orderPosAttr.getValue()) != null) {
            try {
                orderPos = Long.parseLong(orderPosVal);
            }
            catch (NumberFormatException e) {
                throw new IoxSyntaxException("unexpected orderPos <" + orderPosVal + ">", (Throwable)e);
            }
        }
        if (aclass.isExtending((Element)association)) {
            iomObj.addattrobj(prop.getName(), "REF").setobjectrefoid(refOid);
            if (refBid != null) {
                iomObj.addattrobj(prop.getName(), "REF").setobjectrefbid(refBid);
            }
            IomObject anObject = iomObj.getattrobj(prop.getName(), 0);
            if (orderPos != null) {
                anObject.setobjectreforderpos(orderPos.longValue());
            }
            if (refBid != null) {
                anObject.setobjectrefbid(refBid);
            }
        } else {
            XMLEvent peek = this.xmlreader.peek();
            XMLEvent event = null;
            if (peek.isCharacters()) {
                event = this.xmlreader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
            } else if (peek.isStartElement()) {
                event = this.xmlreader.nextEvent();
            }
            IomObject aObject = null;
            if (event != null && event.isStartElement()) {
                element = (StartElement)event;
                aObject = this.readObject(event);
                iomObj.addattrobj(prop.getName(), aObject);
            } else {
                aObject = iomObj.addattrobj(prop.getName(), "REF");
            }
            if (aObject != null) {
                aObject.setobjectrefoid(refOid);
                if (orderPos != null) {
                    aObject.setobjectreforderpos(orderPos.longValue());
                }
                if (refBid != null) {
                    aObject.setobjectrefbid(refBid);
                }
            }
        }
        return iomObj;
    }

    private IomObject readMultiSurface(XMLEvent event) throws IoxException, XMLStreamException {
        IomObject multiSurface = this.createIomObject("MULTISURFACE", null);
        event = this.xmlreader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        while (event.isStartElement() && (event.asStartElement().getName().equals(QNAME_GEOM_SURFACE) || event.asStartElement().getName().equals(QNAME_GEOM_AREA))) {
            multiSurface.addattrobj("surface", this.readSurface(event));
            event = this.xmlreader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
        }
        return multiSurface;
    }

    private IomObject readSurface(XMLEvent event) throws IoxException, XMLStreamException {
        IomObject surface = this.createIomObject("SURFACE", null);
        event = this.xmlreader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        while (event.isStartElement() && (event.asStartElement().getName().equals(QNAME_GEOM_INTERIOR) || event.asStartElement().getName().equals(QNAME_GEOM_EXTERIOR))) {
            surface.addattrobj("boundary", this.readBoundary(event));
            event = this.xmlreader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
        }
        return surface;
    }

    private IomObject readBoundary(XMLEvent event) throws IoxException, XMLStreamException {
        IomObject boundary = this.createIomObject("BOUNDARY", null);
        event = this.xmlreader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        while (event.isStartElement() && event.asStartElement().getName().equals(QNAME_GEOM_POLYLINE)) {
            boundary.addattrobj("polyline", this.readPolyline(event));
            event = this.xmlreader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
        }
        return boundary;
    }

    private IomObject readMultiPolyline(XMLEvent event) throws IoxException, XMLStreamException {
        IomObject multiPolyline = this.createIomObject("MULTIPOLYLINE", null);
        event = this.xmlreader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        while (event.isStartElement() && event.asStartElement().getName().equals(QNAME_GEOM_POLYLINE)) {
            multiPolyline.addattrobj("polyline", this.readPolyline(event));
            event = this.xmlreader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
        }
        if (multiPolyline.getattrvaluecount("polyline") == 0) {
            throw new IoxException("expected polyline. unexpected event: " + event.asStartElement().getName().getLocalPart());
        }
        return multiPolyline;
    }

    private IomObject readPolyline(XMLEvent event) throws IoxException, XMLStreamException {
        IomObject polyline = this.createIomObject("POLYLINE", null);
        event = this.xmlreader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        polyline.addattrobj("sequence", this.readSequence(event));
        return polyline;
    }

    private IomObject readSequence(XMLEvent event) throws XMLStreamException, IoxException {
        IomObject sequence = this.createIomObject("SEGMENTS", null);
        if (event.isStartElement()) {
            while (event.isStartElement()) {
                String segmentType = null;
                if (event.asStartElement().getName().equals(QNAME_GEOM_COORD)) {
                    segmentType = "COORD";
                } else if (event.asStartElement().getName().equals(QNAME_GEOM_ARC)) {
                    segmentType = "ARC";
                }
                event = this.xmlreader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
                sequence.addattrobj("segment", this.readSegment(event, segmentType));
                event = this.xmlreader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
            }
        }
        return sequence;
    }

    private IomObject readMultiCoord(XMLEvent event) throws XMLStreamException, IoxException {
        IomObject multicoord = this.createIomObject("MULTICOORD", null);
        event = this.xmlreader.nextEvent();
        if ((event = this.skipSpacesAndGetNextEvent(event)).isStartElement()) {
            while (event.isStartElement()) {
                event = this.xmlreader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
                multicoord.addattrobj("coord", this.readSegment(event, "COORD"));
                event = this.xmlreader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
            }
        }
        if (multicoord.getattrcount() == 0) {
            throw new IoxException("expected multicoord. unexpected event: " + event.asStartElement().getName().getLocalPart());
        }
        return multicoord;
    }

    private IomObject readSegment(XMLEvent event, String segmentType) throws IoxException, XMLStreamException {
        if (segmentType == null) {
            throw new IoxException("expected segment type");
        }
        IomObject segment = this.createIomObject(segmentType, null);
        SegmentType upperCaseTypeName = null;
        while (!event.isEndElement()) {
            if (event.isStartElement()) {
                String segmentTypeName = event.asStartElement().getName().getLocalPart();
                event = this.xmlreader.nextEvent();
                if (event.isEndElement()) {
                    throw new IoxException("expected coord");
                }
                if (!event.isCharacters()) {
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                upperCaseTypeName = SegmentType.valueOf(segmentTypeName.toUpperCase());
                switch (upperCaseTypeName) {
                    case C1: {
                        segment.setattrvalue("C1", event.asCharacters().getData());
                        break;
                    }
                    case C2: {
                        segment.setattrvalue("C2", event.asCharacters().getData());
                        break;
                    }
                    case C3: {
                        segment.setattrvalue("C3", event.asCharacters().getData());
                        break;
                    }
                    case A1: {
                        segment.setattrvalue("A1", event.asCharacters().getData());
                        break;
                    }
                    case A2: {
                        segment.setattrvalue("A2", event.asCharacters().getData());
                        break;
                    }
                    case R: {
                        segment.setattrvalue("R", event.asCharacters().getData());
                        break;
                    }
                    default: {
                        throw new IoxSyntaxException(this.event2msgtext(event));
                    }
                }
            }
            if ((event = this.xmlreader.nextEvent()).isStartElement()) {
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            event = this.xmlreader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
        }
        return segment;
    }

    private String hsNextOid() {
        ++this.hsOid;
        return Integer.toString(this.hsOid);
    }

    public IomObject createIomObject(String type, String oid) throws IoxException {
        return this.factory.createIomObject(type, oid);
    }

    public IoxFactoryCollection getFactory() throws IoxException {
        return this.factory;
    }

    public void setFactory(IoxFactoryCollection factory) throws IoxException {
        this.factory = factory;
    }

    @Override
    public void setTopicFilter(String[] topicNames) {
        if (topicNames == null || topicNames.length == 0) {
            this.filterTopics = null;
        } else {
            this.filterTopics = new HashSet<String>();
            for (String topicName : topicNames) {
                this.filterTopics.add(topicName);
            }
        }
    }

    @Override
    public String getMimeType() {
        return "application/interlis+xml;version=2.4";
    }

    private static enum SegmentType {
        C1,
        C2,
        C3,
        A1,
        A2,
        R;

    }
}

