/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.CGAlgorithmsDD;
import com.vividsolutions.jts.algorithm.HCoordinate;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.NotRepresentableException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;

public class RobustLineIntersector
extends LineIntersector {
    public void computeIntersection(Coordinate p, Coordinate p1, Coordinate p2) {
        this.isProper = false;
        if (Envelope.intersects(p1, p2, p) && CGAlgorithms.orientationIndex(p1, p2, p) == 0 && CGAlgorithms.orientationIndex(p2, p1, p) == 0) {
            this.isProper = true;
            if (p.equals(p1) || p.equals(p2)) {
                this.isProper = false;
            }
            this.result = 1;
            return;
        }
        this.result = 0;
    }

    protected int computeIntersect(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        boolean collinear;
        this.isProper = false;
        if (!Envelope.intersects(p1, p2, q1, q2)) {
            return 0;
        }
        int Pq1 = CGAlgorithms.orientationIndex(p1, p2, q1);
        int Pq2 = CGAlgorithms.orientationIndex(p1, p2, q2);
        if (Pq1 > 0 && Pq2 > 0 || Pq1 < 0 && Pq2 < 0) {
            return 0;
        }
        int Qp1 = CGAlgorithms.orientationIndex(q1, q2, p1);
        int Qp2 = CGAlgorithms.orientationIndex(q1, q2, p2);
        if (Qp1 > 0 && Qp2 > 0 || Qp1 < 0 && Qp2 < 0) {
            return 0;
        }
        boolean bl = collinear = Pq1 == 0 && Pq2 == 0 && Qp1 == 0 && Qp2 == 0;
        if (collinear) {
            return this.computeCollinearIntersection(p1, p2, q1, q2);
        }
        if (Pq1 == 0 || Pq2 == 0 || Qp1 == 0 || Qp2 == 0) {
            this.isProper = false;
            if (p1.equals2D(q1) || p1.equals2D(q2)) {
                this.intPt[0] = p1;
            } else if (p2.equals2D(q1) || p2.equals2D(q2)) {
                this.intPt[0] = p2;
            } else if (Pq1 == 0) {
                this.intPt[0] = new Coordinate(q1);
            } else if (Pq2 == 0) {
                this.intPt[0] = new Coordinate(q2);
            } else if (Qp1 == 0) {
                this.intPt[0] = new Coordinate(p1);
            } else if (Qp2 == 0) {
                this.intPt[0] = new Coordinate(p2);
            }
        } else {
            this.isProper = true;
            this.intPt[0] = this.intersection(p1, p2, q1, q2);
        }
        return 1;
    }

    private int computeCollinearIntersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        boolean p1q1p2 = Envelope.intersects(p1, p2, q1);
        boolean p1q2p2 = Envelope.intersects(p1, p2, q2);
        boolean q1p1q2 = Envelope.intersects(q1, q2, p1);
        boolean q1p2q2 = Envelope.intersects(q1, q2, p2);
        if (p1q1p2 && p1q2p2) {
            this.intPt[0] = q1;
            this.intPt[1] = q2;
            return 2;
        }
        if (q1p1q2 && q1p2q2) {
            this.intPt[0] = p1;
            this.intPt[1] = p2;
            return 2;
        }
        if (p1q1p2 && q1p1q2) {
            this.intPt[0] = q1;
            this.intPt[1] = p1;
            return q1.equals(p1) && !p1q2p2 && !q1p2q2 ? 1 : 2;
        }
        if (p1q1p2 && q1p2q2) {
            this.intPt[0] = q1;
            this.intPt[1] = p2;
            return q1.equals(p2) && !p1q2p2 && !q1p1q2 ? 1 : 2;
        }
        if (p1q2p2 && q1p1q2) {
            this.intPt[0] = q2;
            this.intPt[1] = p1;
            return q2.equals(p1) && !p1q1p2 && !q1p2q2 ? 1 : 2;
        }
        if (p1q2p2 && q1p2q2) {
            this.intPt[0] = q2;
            this.intPt[1] = p2;
            return q2.equals(p2) && !p1q1p2 && !q1p1q2 ? 1 : 2;
        }
        return 0;
    }

    private Coordinate intersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate intPt = this.intersectionWithNormalization(p1, p2, q1, q2);
        if (!this.isInSegmentEnvelopes(intPt)) {
            intPt = new Coordinate(RobustLineIntersector.nearestEndpoint(p1, p2, q1, q2));
        }
        if (this.precisionModel != null) {
            this.precisionModel.makePrecise(intPt);
        }
        return intPt;
    }

    private void checkDD(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2, Coordinate intPt) {
        Coordinate intPtDD = CGAlgorithmsDD.intersection(p1, p2, q1, q2);
        boolean isIn = this.isInSegmentEnvelopes(intPtDD);
        System.out.println("DD in env = " + isIn + "  --------------------- " + intPtDD);
        if (intPt.distance(intPtDD) > 1.0E-4) {
            System.out.println("Distance = " + intPt.distance(intPtDD));
        }
    }

    private Coordinate intersectionWithNormalization(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate n1 = new Coordinate(p1);
        Coordinate n2 = new Coordinate(p2);
        Coordinate n3 = new Coordinate(q1);
        Coordinate n4 = new Coordinate(q2);
        Coordinate normPt = new Coordinate();
        this.normalizeToEnvCentre(n1, n2, n3, n4, normPt);
        Coordinate intPt = this.safeHCoordinateIntersection(n1, n2, n3, n4);
        intPt.x += normPt.x;
        intPt.y += normPt.y;
        return intPt;
    }

    private Coordinate safeHCoordinateIntersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate intPt = null;
        try {
            intPt = HCoordinate.intersection(p1, p2, q1, q2);
        }
        catch (NotRepresentableException e) {
            intPt = RobustLineIntersector.nearestEndpoint(p1, p2, q1, q2);
        }
        return intPt;
    }

    private void normalizeToMinimum(Coordinate n1, Coordinate n2, Coordinate n3, Coordinate n4, Coordinate normPt) {
        normPt.x = this.smallestInAbsValue(n1.x, n2.x, n3.x, n4.x);
        normPt.y = this.smallestInAbsValue(n1.y, n2.y, n3.y, n4.y);
        n1.x -= normPt.x;
        n1.y -= normPt.y;
        n2.x -= normPt.x;
        n2.y -= normPt.y;
        n3.x -= normPt.x;
        n3.y -= normPt.y;
        n4.x -= normPt.x;
        n4.y -= normPt.y;
    }

    private void normalizeToEnvCentre(Coordinate n00, Coordinate n01, Coordinate n10, Coordinate n11, Coordinate normPt) {
        double minX0 = n00.x < n01.x ? n00.x : n01.x;
        double minY0 = n00.y < n01.y ? n00.y : n01.y;
        double maxX0 = n00.x > n01.x ? n00.x : n01.x;
        double maxY0 = n00.y > n01.y ? n00.y : n01.y;
        double minX1 = n10.x < n11.x ? n10.x : n11.x;
        double minY1 = n10.y < n11.y ? n10.y : n11.y;
        double maxX1 = n10.x > n11.x ? n10.x : n11.x;
        double maxY1 = n10.y > n11.y ? n10.y : n11.y;
        double intMinX = minX0 > minX1 ? minX0 : minX1;
        double intMaxX = maxX0 < maxX1 ? maxX0 : maxX1;
        double intMinY = minY0 > minY1 ? minY0 : minY1;
        double intMaxY = maxY0 < maxY1 ? maxY0 : maxY1;
        double intMidX = (intMinX + intMaxX) / 2.0;
        double intMidY = (intMinY + intMaxY) / 2.0;
        normPt.x = intMidX;
        normPt.y = intMidY;
        n00.x -= normPt.x;
        n00.y -= normPt.y;
        n01.x -= normPt.x;
        n01.y -= normPt.y;
        n10.x -= normPt.x;
        n10.y -= normPt.y;
        n11.x -= normPt.x;
        n11.y -= normPt.y;
    }

    private double smallestInAbsValue(double x1, double x2, double x3, double x4) {
        double x = x1;
        double xabs = Math.abs(x);
        if (Math.abs(x2) < xabs) {
            x = x2;
            xabs = Math.abs(x2);
        }
        if (Math.abs(x3) < xabs) {
            x = x3;
            xabs = Math.abs(x3);
        }
        if (Math.abs(x4) < xabs) {
            x = x4;
        }
        return x;
    }

    private boolean isInSegmentEnvelopes(Coordinate intPt) {
        Envelope env0 = new Envelope(this.inputLines[0][0], this.inputLines[0][1]);
        Envelope env1 = new Envelope(this.inputLines[1][0], this.inputLines[1][1]);
        return env0.contains(intPt) && env1.contains(intPt);
    }

    private static Coordinate nearestEndpoint(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate nearestPt = p1;
        double minDist = CGAlgorithms.distancePointLine(p1, q1, q2);
        double dist = CGAlgorithms.distancePointLine(p2, q1, q2);
        if (dist < minDist) {
            minDist = dist;
            nearestPt = p2;
        }
        if ((dist = CGAlgorithms.distancePointLine(q1, p1, p2)) < minDist) {
            minDist = dist;
            nearestPt = q1;
        }
        if ((dist = CGAlgorithms.distancePointLine(q2, p1, p2)) < minDist) {
            minDist = dist;
            nearestPt = q2;
        }
        return nearestPt;
    }
}

