/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.av2geobau.impl;

import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.iox_j.jts.Iox2jts;
import ch.interlis.iox_j.jts.Iox2jtsException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class Mapper {
    private static final double STROKE_ARC = 1.0E-4;
    private List<IomObject> out = new ArrayList<IomObject>();
    private HashMap<String, String> lfp1_tid2nummer = new HashMap();
    private GeometryFactory jtsFactory = new GeometryFactory();
    private HashMap<String, String> lfp2_tid2nummer = new HashMap();
    private HashMap<String, String> lfp3_tid2nummer = new HashMap();
    private HashMap<String, String> hfp1_tid2nummer = new HashMap();
    private HashMap<String, String> hfp2_tid2nummer = new HashMap();
    private HashMap<String, String> hfp3_tid2nummer = new HashMap();
    private HashSet<String> gebaeude = new HashSet();
    private HashSet<String> gewaesser = new HashSet();
    private HashMap<String, String> gebaeudename = new HashMap();
    private HashMap<String, String> gewaessername = new HashMap();
    private HashMap<String, String> gebaeudenummer = new HashMap();
    private HashMap<String, String> einzelobjekte = new HashMap();
    private HashSet<String> geleise = new HashSet();
    HashMap<String, String> geleisename = new HashMap();
    private HashMap<String, String> flurname_tid2name = new HashMap();
    private HashMap<String, String> ortsname_tid2name = new HashMap();
    private HashMap<String, String> gelaendename_tid2name = new HashMap();
    private HashMap<String, String> projLiegenschaften = new HashMap();
    private HashMap<String, String> projSelbstRecht = new HashMap();
    private HashMap<String, String> liegenschaften = new HashMap();
    private HashMap<String, String> selbstRecht = new HashMap();
    private HashMap<String, String> lokalisationsName = new HashMap();
    private HashMap<String, String> hausnummerReal = new HashMap();
    private HashMap<String, String> hausnummerProjektiert = new HashMap();
    private Geometry perimeter = null;

    public void addInput(IoxEvent event) {
        if (event instanceof ObjectEvent) {
            IomObject iomObj = ((ObjectEvent)event).getIomObject();
            String type = iomObj.getobjecttag();
            if (type.equals("DM01AVCH24LV95D.FixpunkteKategorie1.LFP1")) {
                this.mapLFP1(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.FixpunkteKategorie1.LFP1Pos")) {
                this.mapLFP1Pos(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.FixpunkteKategorie2.LFP2")) {
                this.mapLFP2(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.FixpunkteKategorie2.LFP2Pos")) {
                this.mapLFP2Pos(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.FixpunkteKategorie3.LFP3")) {
                this.mapLFP3(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.FixpunkteKategorie3.LFP3Pos")) {
                this.mapLFP3Pos(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.FixpunkteKategorie1.HFP1")) {
                this.mapHFP1(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.FixpunkteKategorie1.HFP1Pos")) {
                this.mapHFP1Pos(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.FixpunkteKategorie2.HFP2")) {
                this.mapHFP2(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.FixpunkteKategorie2.HFP2Pos")) {
                this.mapHFP2Pos(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.FixpunkteKategorie3.HFP3")) {
                this.mapHFP3(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.FixpunkteKategorie3.HFP3Pos")) {
                this.mapHFP3Pos(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Bodenbedeckung.ProjBoFlaeche")) {
                this.mapProjBoFlaeche(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Bodenbedeckung.BoFlaeche")) {
                this.mapBoFlaeche(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Bodenbedeckung.Gebaeudenummer")) {
                this.mapBoFlaecheGebaeudenummer(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Bodenbedeckung.GebaeudenummerPos")) {
                this.mapBoFlaecheGebaeudenummerPos(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Bodenbedeckung.Objektname")) {
                this.mapBoFlaecheObjektname(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Bodenbedeckung.ObjektnamePos")) {
                this.mapBoFlaecheObjektnamePos(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Einzelobjekte.Einzelobjekt")) {
                this.mapEinzelobjekt(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Einzelobjekte.Flaechenelement")) {
                this.mapEOFlaechenelement(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Einzelobjekte.Linienelement")) {
                this.mapEOLinienelement(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Einzelobjekte.Objektname")) {
                this.mapEOObjektname(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Einzelobjekte.ObjektnamePos")) {
                this.mapEOObjektnamePos(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Nomenklatur.Flurname")) {
                this.mapFlurname(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Nomenklatur.FlurnamePos")) {
                this.mapFlurnamePos(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Nomenklatur.Ortsname")) {
                this.mapOrtsname(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Nomenklatur.OrtsnamePos")) {
                this.mapOrtsnamePos(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Nomenklatur.Gelaendename")) {
                this.mapGelaendename(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Nomenklatur.GelaendenamePos")) {
                this.mapGelaendenamePos(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Liegenschaften.Grenzpunkt")) {
                this.mapGrenzpunkt(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Liegenschaften.ProjGrundstueck")) {
                this.mapProjGrundstueck(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Liegenschaften.ProjGrundstueckPos")) {
                this.mapProjGrundstueckPos(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Liegenschaften.ProjLiegenschaft")) {
                this.mapProjLiegenschaft(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Liegenschaften.ProjSelbstRecht")) {
                this.mapProjSelbstRecht(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Liegenschaften.Grundstueck")) {
                this.mapGrundstueck(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Liegenschaften.GrundstueckPos")) {
                this.mapGrundstueckPos(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Liegenschaften.Liegenschaft")) {
                this.mapLiegenschaft(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Liegenschaften.SelbstRecht")) {
                this.mapSelbstRecht(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Rohrleitungen.Linienelement")) {
                this.mapRLLinienelement(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Gemeindegrenzen.Hoheitsgrenzpunkt")) {
                this.mapHoheitsgrenzpunkt(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Gemeindegrenzen.Gemeindegrenze")) {
                this.mapGemeindegrenze(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Bezirksgrenzen.Bezirksgrenzabschnitt")) {
                this.mapBezirksgrenzabschnitt(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Kantonsgrenzen.Kantonsgrenzabschnitt")) {
                this.mapKantonsgrenzabschnitt(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Landesgrenzen.Landesgrenzabschnitt")) {
                this.mapLandesgrenzabschnitt(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Gebaeudeadressen.LokalisationsName")) {
                this.mapLokalisationsName(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Gebaeudeadressen.LokalisationsNamePos")) {
                this.mapLokalisationsNamePos(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Gebaeudeadressen.Gebaeudeeingang")) {
                this.mapGebaeudeeingang(iomObj);
            } else if (type.equals("DM01AVCH24LV95D.Gebaeudeadressen.HausnummerPos")) {
                this.mapHausnummerPos(iomObj);
            }
        }
    }

    public void close() {
    }

    public IomObject getMappedObject() {
        if (this.out.size() == 0) {
            return null;
        }
        IomObject ret = this.out.remove(0);
        return ret;
    }

    private String mapOri(String ori) {
        if (ori == null) {
            return null;
        }
        double val = Double.parseDouble(ori);
        ori = Double.toString((100.0 - val) * 0.9);
        return ori;
    }

    private String mapVali(String vali) {
        if (vali == null) {
            return null;
        }
        if (vali.equals("Top")) {
            return "3";
        }
        if (vali.equals("Cap")) {
            return "3";
        }
        if (vali.equals("Half")) {
            return "2";
        }
        if (vali.equals("Base")) {
            return "1";
        }
        if (vali.equals("Bottom")) {
            return "0";
        }
        return null;
    }

    private String mapHali(String hali) {
        if (hali == null) {
            return null;
        }
        if (hali.equals("Left")) {
            return "0";
        }
        if (hali.equals("Center")) {
            return "1";
        }
        if (hali.equals("Right")) {
            return "2";
        }
        return null;
    }

    private void mapLFP1(IomObject iomObj) {
        String begehbarkeit = iomObj.getattrvalue("Begehbarkeit");
        String block = null;
        String layer = null;
        if (begehbarkeit.equals("begehbar")) {
            block = "LFP1";
            layer = "01111";
        } else if (begehbarkeit.equals("nicht_begehbar")) {
            block = "LFP1";
            layer = "01112";
        } else {
            return;
        }
        String tid = iomObj.getobjectoid();
        String nummer = iomObj.getattrvalue("Nummer");
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                Coordinate coord = Iox2jts.coord2JTS(geom);
                if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.lfp1_tid2nummer.put(tid, nummer);
        String z = iomObj.getattrvalue("HoeheGeom");
        if (z != null) {
            geom.setattrvalue("C3", z);
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.BlockInsert", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.setattrvalue("block", block);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapLFP1Pos(IomObject iomObj) {
        String vali;
        String hali;
        IomObject refObj = iomObj.getattrobj("LFP1Pos_von", 0);
        String ref = refObj.getobjectrefoid();
        String nummer = this.lfp1_tid2nummer.get(ref);
        if (nummer == null) {
            return;
        }
        String layer = "01119";
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Text", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.setattrvalue("text", nummer);
        dxfObj.setattrvalue("text_size", "1.35");
        IomObject geom = iomObj.getattrobj("Pos", 0);
        if (this.perimeter != null) {
            try {
                Coordinate coord = Iox2jts.coord2JTS(geom);
                if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        dxfObj.addattrobj("geom", geom);
        String ori = this.mapOri(iomObj.getattrvalue("Ori"));
        if (ori != null) {
            dxfObj.setattrvalue("ori", ori);
        }
        if ((hali = this.mapHali(iomObj.getattrvalue("HAli"))) != null) {
            dxfObj.setattrvalue("hali", hali);
        }
        if ((vali = this.mapVali(iomObj.getattrvalue("VAli"))) != null) {
            dxfObj.setattrvalue("vali", vali);
        }
        this.out.add(dxfObj);
    }

    private void mapLFP2(IomObject iomObj) {
        String begehbarkeit = iomObj.getattrvalue("Begehbarkeit");
        String block = null;
        String layer = null;
        if (begehbarkeit.equals("begehbar")) {
            block = "LFP2";
            layer = "01121";
        } else if (begehbarkeit.equals("nicht_begehbar")) {
            block = "LFP2";
            layer = "01122";
        } else {
            return;
        }
        String tid = iomObj.getobjectoid();
        String nummer = iomObj.getattrvalue("Nummer");
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                Coordinate coord = Iox2jts.coord2JTS(geom);
                if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.lfp2_tid2nummer.put(tid, nummer);
        String z = iomObj.getattrvalue("HoeheGeom");
        if (z != null) {
            geom.setattrvalue("C3", z);
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.BlockInsert", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.setattrvalue("block", block);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapLFP2Pos(IomObject iomObj) {
        String vali;
        String hali;
        IomObject refObj = iomObj.getattrobj("LFP2Pos_von", 0);
        String ref = refObj.getobjectrefoid();
        String nummer = this.lfp2_tid2nummer.get(ref);
        if (nummer == null) {
            return;
        }
        String layer = "01129";
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Text", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.setattrvalue("text", nummer);
        dxfObj.setattrvalue("text_size", "1.35");
        IomObject geom = iomObj.getattrobj("Pos", 0);
        if (this.perimeter != null) {
            try {
                Coordinate coord = Iox2jts.coord2JTS(geom);
                if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        dxfObj.addattrobj("geom", geom);
        String ori = this.mapOri(iomObj.getattrvalue("Ori"));
        if (ori != null) {
            dxfObj.setattrvalue("ori", ori);
        }
        if ((hali = this.mapHali(iomObj.getattrvalue("HAli"))) != null) {
            dxfObj.setattrvalue("hali", hali);
        }
        if ((vali = this.mapVali(iomObj.getattrvalue("VAli"))) != null) {
            dxfObj.setattrvalue("vali", vali);
        }
        this.out.add(dxfObj);
    }

    private void mapLFP3(IomObject iomObj) {
        String punktzeichen = iomObj.getattrvalue("Punktzeichen");
        String block = null;
        String layer = null;
        if (punktzeichen.equals("Stein") || punktzeichen.equals("Kunststoffzeichen")) {
            block = "LFP3ST";
            layer = "01131";
        } else if (punktzeichen.equals("Bolzen") || punktzeichen.equals("Rohr")) {
            block = "LFP3BO";
            layer = "01132";
        } else if (punktzeichen.equals("Kreuz")) {
            block = "LFP3KR";
            layer = "01133";
        } else if (punktzeichen.equals("unversichert") || punktzeichen.equals("Pfahl")) {
            block = "LFP3UV";
            layer = "01134";
        } else {
            return;
        }
        String tid = iomObj.getobjectoid();
        String nummer = iomObj.getattrvalue("Nummer");
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                Coordinate coord = Iox2jts.coord2JTS(geom);
                if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.lfp3_tid2nummer.put(tid, nummer);
        String z = iomObj.getattrvalue("HoeheGeom");
        if (z != null) {
            geom.setattrvalue("C3", z);
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.BlockInsert", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.setattrvalue("block", block);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapLFP3Pos(IomObject iomObj) {
        String vali;
        String hali;
        IomObject refObj = iomObj.getattrobj("LFP3Pos_von", 0);
        String ref = refObj.getobjectrefoid();
        String nummer = this.lfp3_tid2nummer.get(ref);
        if (nummer == null) {
            return;
        }
        String layer = "01139";
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Text", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.setattrvalue("text", nummer);
        dxfObj.setattrvalue("text_size", "1.35");
        IomObject geom = iomObj.getattrobj("Pos", 0);
        if (this.perimeter != null) {
            try {
                Coordinate coord = Iox2jts.coord2JTS(geom);
                if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        dxfObj.addattrobj("geom", geom);
        String ori = this.mapOri(iomObj.getattrvalue("Ori"));
        if (ori != null) {
            dxfObj.setattrvalue("ori", ori);
        }
        if ((hali = this.mapHali(iomObj.getattrvalue("HAli"))) != null) {
            dxfObj.setattrvalue("hali", hali);
        }
        if ((vali = this.mapVali(iomObj.getattrvalue("VAli"))) != null) {
            dxfObj.setattrvalue("vali", vali);
        }
        this.out.add(dxfObj);
    }

    private void mapHFP1(IomObject iomObj) {
        String block = null;
        String layer = null;
        block = "HFP1";
        layer = "01141";
        String tid = iomObj.getobjectoid();
        String nummer = iomObj.getattrvalue("Nummer");
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                Coordinate coord = Iox2jts.coord2JTS(geom);
                if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.hfp1_tid2nummer.put(tid, nummer);
        String z = iomObj.getattrvalue("HoeheGeom");
        if (z != null) {
            geom.setattrvalue("C3", z);
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.BlockInsert", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.setattrvalue("block", block);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapHFP1Pos(IomObject iomObj) {
        String vali;
        String hali;
        IomObject refObj = iomObj.getattrobj("HFP1Pos_von", 0);
        String ref = refObj.getobjectrefoid();
        String nummer = this.hfp1_tid2nummer.get(ref);
        if (nummer == null) {
            return;
        }
        String layer = "01149";
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Text", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.setattrvalue("text", nummer);
        dxfObj.setattrvalue("text_size", "1.35");
        IomObject geom = iomObj.getattrobj("Pos", 0);
        if (this.perimeter != null) {
            try {
                Coordinate coord = Iox2jts.coord2JTS(geom);
                if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        dxfObj.addattrobj("geom", geom);
        String ori = this.mapOri(iomObj.getattrvalue("Ori"));
        if (ori != null) {
            dxfObj.setattrvalue("ori", ori);
        }
        if ((hali = this.mapHali(iomObj.getattrvalue("HAli"))) != null) {
            dxfObj.setattrvalue("hali", hali);
        }
        if ((vali = this.mapVali(iomObj.getattrvalue("VAli"))) != null) {
            dxfObj.setattrvalue("vali", vali);
        }
        this.out.add(dxfObj);
    }

    private void mapHFP2(IomObject iomObj) {
        String block = null;
        String layer = null;
        block = "HFP2";
        layer = "01151";
        String tid = iomObj.getobjectoid();
        String nummer = iomObj.getattrvalue("Nummer");
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                Coordinate coord = Iox2jts.coord2JTS(geom);
                if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.hfp2_tid2nummer.put(tid, nummer);
        String z = iomObj.getattrvalue("HoeheGeom");
        if (z != null) {
            geom.setattrvalue("C3", z);
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.BlockInsert", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.setattrvalue("block", block);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapHFP2Pos(IomObject iomObj) {
        String vali;
        String hali;
        IomObject refObj = iomObj.getattrobj("HFP2Pos_von", 0);
        String ref = refObj.getobjectrefoid();
        String nummer = this.hfp2_tid2nummer.get(ref);
        if (nummer == null) {
            return;
        }
        String layer = "01159";
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Text", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.setattrvalue("text", nummer);
        dxfObj.setattrvalue("text_size", "1.35");
        IomObject geom = iomObj.getattrobj("Pos", 0);
        if (this.perimeter != null) {
            try {
                Coordinate coord = Iox2jts.coord2JTS(geom);
                if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        dxfObj.addattrobj("geom", geom);
        String ori = this.mapOri(iomObj.getattrvalue("Ori"));
        if (ori != null) {
            dxfObj.setattrvalue("ori", ori);
        }
        if ((hali = this.mapHali(iomObj.getattrvalue("HAli"))) != null) {
            dxfObj.setattrvalue("hali", hali);
        }
        if ((vali = this.mapVali(iomObj.getattrvalue("VAli"))) != null) {
            dxfObj.setattrvalue("vali", vali);
        }
        this.out.add(dxfObj);
    }

    private void mapHFP3(IomObject iomObj) {
        String block = null;
        String layer = null;
        block = "HFP3";
        layer = "01161";
        String tid = iomObj.getobjectoid();
        String nummer = iomObj.getattrvalue("Nummer");
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                Coordinate coord = Iox2jts.coord2JTS(geom);
                if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.hfp3_tid2nummer.put(tid, nummer);
        String z = iomObj.getattrvalue("HoeheGeom");
        if (z != null) {
            geom.setattrvalue("C3", z);
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.BlockInsert", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.setattrvalue("block", block);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapHFP3Pos(IomObject iomObj) {
        String vali;
        String hali;
        IomObject refObj = iomObj.getattrobj("HFP3Pos_von", 0);
        String ref = refObj.getobjectrefoid();
        String nummer = this.hfp3_tid2nummer.get(ref);
        if (nummer == null) {
            return;
        }
        String layer = "01169";
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Text", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.setattrvalue("text", nummer);
        dxfObj.setattrvalue("text_size", "1.35");
        IomObject geom = iomObj.getattrobj("Pos", 0);
        if (this.perimeter != null) {
            try {
                Coordinate coord = Iox2jts.coord2JTS(geom);
                if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        dxfObj.addattrobj("geom", geom);
        String ori = this.mapOri(iomObj.getattrvalue("Ori"));
        if (ori != null) {
            dxfObj.setattrvalue("ori", ori);
        }
        if ((hali = this.mapHali(iomObj.getattrvalue("HAli"))) != null) {
            dxfObj.setattrvalue("hali", hali);
        }
        if ((vali = this.mapVali(iomObj.getattrvalue("VAli"))) != null) {
            dxfObj.setattrvalue("vali", vali);
        }
        this.out.add(dxfObj);
    }

    private void mapProjBoFlaeche(IomObject iomObj) {
        String tid = iomObj.getobjectoid();
        String art = iomObj.getattrvalue("Art");
        String layer = null;
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                Polygon jtsGeom = Iox2jts.surface2JTS(geom, 1.0E-4);
                if (!this.intersectsPerimeter((Geometry)jtsGeom)) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (!art.equals("Gebaeude")) {
            return;
        }
        layer = "01911";
        this.gebaeude.add(tid);
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Polygon2d", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapBoFlaeche(IomObject iomObj) {
        String tid = iomObj.getobjectoid();
        String art = iomObj.getattrvalue("Art");
        String layer = null;
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                Polygon jtsGeom = Iox2jts.surface2JTS(geom, 1.0E-4);
                if (!this.intersectsPerimeter((Geometry)jtsGeom)) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (art.equals("Gebaeude")) {
            layer = "01211";
            this.gebaeude.add(tid);
        } else if (art.equals("befestigt.Strasse_Weg")) {
            layer = "01221";
        } else if (art.equals("befestigt.Bahn")) {
            layer = "01222";
        } else if (art.equals("befestigt.Flugplatz")) {
            layer = "01223";
        } else if (art.equals("befestigt.Wasserbecken")) {
            layer = "01224";
        } else if (art.equals("befestigt.uebrige_befestigte")) {
            layer = "01225";
        } else if (art.equals("humusiert.Acker_Wiese_Weide")) {
            layer = "01231";
        } else if (art.equals("humusiert.Intensivkultur.Reben")) {
            layer = "01232";
        } else if (art.equals("humusiert.Intensivkultur.uebrige_Intensivkultur")) {
            layer = "01233";
        } else if (art.equals("humusiert.Gartenanlage")) {
            layer = "01234";
        } else if (art.equals("humusiert.Hoch_Flachmoor")) {
            layer = "01235";
        } else if (art.equals("humusiert.uebrige_humusierte")) {
            layer = "01236";
        } else if (art.equals("Gewaesser.fliessendes") || art.equals("Gewaesser.stehendes")) {
            layer = "01241";
            this.gewaesser.add(tid);
        } else if (art.equals("Gewaesser.Schilfguertel")) {
            layer = "01242";
        } else if (art.equals("bestockt.geschlossener_Wald")) {
            layer = "01251";
        } else if (art.equals("bestockt.uebrige_bestockte")) {
            layer = "01252";
        } else if (art.equals("vegetationslos.Fels")) {
            layer = "01261";
        } else if (art.equals("vegetationslos.Geroell_Sand")) {
            layer = "01263";
        } else if (art.equals("vegetationslos.Abbau_Deponie")) {
            layer = "01264";
        } else if (art.equals("vegetationslos.uebrige_vegetationslose")) {
            layer = "01265";
        } else if (art.equals("befestigt.Trottoir") || art.equals("befestigt.Verkehrsinsel")) {
            layer = "01332";
        } else {
            return;
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Polygon2d", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapBoFlaecheObjektname(IomObject iomObj) {
        String tid = iomObj.getobjectoid();
        IomObject refObj = iomObj.getattrobj("Objektname_von", 0);
        String ref = refObj.getobjectrefoid();
        String name = iomObj.getattrvalue("Name");
        if (this.gebaeude.contains(ref)) {
            this.gebaeudename.put(tid, name);
        } else if (this.gewaesser.contains(ref)) {
            this.gewaessername.put(tid, name);
        }
    }

    private void mapBoFlaecheObjektnamePos(IomObject iomObj) {
        IomObject refObj = iomObj.getattrobj("ObjektnamePos_von", 0);
        String ref = refObj.getobjectrefoid();
        String name = null;
        String layer = null;
        if (this.gebaeudename.containsKey(ref)) {
            name = this.gebaeudename.get(ref);
            layer = "01219";
        } else if (this.gewaessername.containsKey(ref)) {
            name = this.gewaessername.get(ref);
            layer = "01249";
        }
        if (layer != null) {
            String vali;
            String hali;
            Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Text", null);
            dxfObj.setattrvalue("layername", layer);
            dxfObj.setattrvalue("text", name);
            dxfObj.setattrvalue("text_size", "0.9");
            IomObject geom = iomObj.getattrobj("Pos", 0);
            if (this.perimeter != null) {
                try {
                    Coordinate coord = Iox2jts.coord2JTS(geom);
                    if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                        return;
                    }
                }
                catch (Iox2jtsException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            dxfObj.addattrobj("geom", geom);
            String ori = this.mapOri(iomObj.getattrvalue("Ori"));
            if (ori != null) {
                dxfObj.setattrvalue("ori", ori);
            }
            if ((hali = this.mapHali(iomObj.getattrvalue("HAli"))) != null) {
                dxfObj.setattrvalue("hali", hali);
            }
            if ((vali = this.mapVali(iomObj.getattrvalue("VAli"))) != null) {
                dxfObj.setattrvalue("vali", vali);
            }
            this.out.add(dxfObj);
        }
    }

    private void mapBoFlaecheGebaeudenummer(IomObject iomObj) {
        String tid = iomObj.getobjectoid();
        IomObject refObj = iomObj.getattrobj("Gebaeudenummer_von", 0);
        String ref = refObj.getobjectrefoid();
        String name = iomObj.getattrvalue("Nummer");
        if (this.gebaeude.contains(ref)) {
            this.gebaeudenummer.put(tid, name);
        }
    }

    private void mapBoFlaecheGebaeudenummerPos(IomObject iomObj) {
        IomObject refObj = iomObj.getattrobj("GebaeudenummerPos_von", 0);
        String ref = refObj.getobjectrefoid();
        String name = null;
        String layer = null;
        if (this.gebaeudenummer.containsKey(ref)) {
            name = this.gebaeudenummer.get(ref);
            layer = "01219";
        }
        if (layer != null) {
            String vali;
            String hali;
            Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Text", null);
            dxfObj.setattrvalue("layername", layer);
            dxfObj.setattrvalue("text", name);
            dxfObj.setattrvalue("text_size", "0.9");
            IomObject geom = iomObj.getattrobj("Pos", 0);
            if (this.perimeter != null) {
                try {
                    Coordinate coord = Iox2jts.coord2JTS(geom);
                    if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                        return;
                    }
                }
                catch (Iox2jtsException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            dxfObj.addattrobj("geom", geom);
            String ori = this.mapOri(iomObj.getattrvalue("Ori"));
            if (ori != null) {
                dxfObj.setattrvalue("ori", ori);
            }
            if ((hali = this.mapHali(iomObj.getattrvalue("HAli"))) != null) {
                dxfObj.setattrvalue("hali", hali);
            }
            if ((vali = this.mapVali(iomObj.getattrvalue("VAli"))) != null) {
                dxfObj.setattrvalue("vali", vali);
            }
            this.out.add(dxfObj);
        }
    }

    private void mapEinzelobjekt(IomObject iomObj) {
        String tid = iomObj.getobjectoid();
        String art = iomObj.getattrvalue("Art");
        this.einzelobjekte.put(tid, art);
        if (art.equals("Bahngeleise")) {
            this.geleise.add(tid);
        }
    }

    private void mapEOFlaechenelement(IomObject iomObj) {
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                Polygon jtsGeom = Iox2jts.surface2JTS(geom, 1.0E-4);
                if (!this.intersectsPerimeter((Geometry)jtsGeom)) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        IomObject refObj = iomObj.getattrobj("Flaechenelement_von", 0);
        String ref = refObj.getobjectrefoid();
        String art = this.einzelobjekte.get(ref);
        String layer = null;
        if (art.equals("uebriger_Gebaeudeteil")) {
            layer = "01311";
        } else if (art.equals("wichtige_Treppe")) {
            layer = "01312";
        } else if (art.equals("Mauer") || art.equals("massiver_Sockel")) {
            layer = "01313";
        } else if (art.equals("Aussichtsturm") || art.equals("Silo_Turm_Gasometer")) {
            layer = "01314";
        } else if (art.equals("Bruecke_Passerelle") || art.equals("Landungssteg")) {
            layer = "01316";
        } else if (art.equals("unterirdisches_Gebaeude") || art.equals("Reservoir") || art.equals("Unterstand")) {
            layer = "01321";
        } else if (art.equals("Tunnel_Unterfuehrung_Galerie")) {
            layer = "01322";
        } else if (art.equals("schmaler_Weg")) {
            layer = "01331";
        } else if (art.equals("Bahnsteig")) {
            layer = "01332";
        } else if (art.equals("eingedoltes_oeffentliches_Gewaesser")) {
            layer = "01341";
        } else if (art.equals("Uferverbauung") || art.equals("Schwelle")) {
            layer = "01342";
        } else if (art.equals("Brunnen")) {
            layer = "01351";
        } else if (art.equals("Denkmal") || art.equals("Ruine_archaeologisches_Objekt")) {
            layer = "01352";
        } else if (art.equals("weitere")) {
            layer = "01370";
        } else {
            return;
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Polygon2d", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapEOLinienelement(IomObject iomObj) {
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                LineString jtsGeom = Iox2jts.polyline2JTSlineString(geom, false, 1.0E-4);
                if (!this.intersectsPerimeter((Geometry)jtsGeom)) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        IomObject refObj = iomObj.getattrobj("Linienelement_von", 0);
        String ref = refObj.getobjectrefoid();
        String art = this.einzelobjekte.get(ref);
        String layer = null;
        if (art.equals("uebriger_Gebaeudeteil")) {
            layer = "01311";
        } else if (art.equals("wichtige_Treppe")) {
            layer = "01312";
        } else if (art.equals("Mauer") || art.equals("massiver_Sockel")) {
            layer = "01313";
        } else if (art.equals("Aussichtsturm") || art.equals("Silo_Turm_Gasometer")) {
            layer = "01314";
        } else if (art.equals("Hochkamin") || art.equals("Mast_Antenne") || art.equals("Pfeiler")) {
            layer = "01315";
        } else if (art.equals("unterirdisches_Gebaeude") || art.equals("Reservoir") || art.equals("Unterstand")) {
            layer = "01321";
        } else if (art.equals("Tunnel_Unterfuehrung_Galerie")) {
            layer = "01322";
        } else if (art.equals("schmaler_Weg")) {
            layer = "01331";
        } else if (art.equals("Bahngeleise") || art.equals("Achse")) {
            layer = "01334";
        } else if (art.equals("Gondelbahn_Sesselbahn") || art.equals("Luftseilbahn") || art.equals("Skilift") || art.equals("Faehre")) {
            layer = "01335";
        } else if (art.equals("Materialseilbahn")) {
            layer = "01336";
        } else if (art.equals("eingedoltes_oeffentliches_Gewaesser")) {
            layer = "01341";
        } else if (art.equals("Uferverbauung") || art.equals("Schwelle")) {
            layer = "01342";
        } else if (art.equals("Rinnsal")) {
            layer = "01343";
        } else if (art.equals("Brunnen")) {
            layer = "01351";
        } else if (art.equals("Denkmal") || art.equals("Ruine_archaeologisches_Objekt")) {
            layer = "01352";
        } else if (art.equals("Hochspannungsfreileitung")) {
            layer = "01364";
        } else {
            return;
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Polyline2d", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapEOPunktelement(IomObject iomObj) {
        String block;
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                Coordinate coord = Iox2jts.coord2JTS(geom);
                if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        IomObject refObj = iomObj.getattrobj("Punktelement_von", 0);
        String ref = refObj.getobjectrefoid();
        String art = this.einzelobjekte.get(ref);
        String layer = null;
        if (art.equals("Bildstock_Kruzifix")) {
            layer = "01353";
            block = "EOPNT";
        } else if (art.equals("einzelner_Fels") || art.equals("wichtiger_Einzelbaum")) {
            layer = "01361";
            block = "EOPNT";
        } else if (art.equals("Grotte_Hoehleneingang")) {
            layer = "01363";
            block = "EOPNT";
        } else {
            return;
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.BlockInsert", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.setattrvalue("block", block);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapEOObjektname(IomObject iomObj) {
        String tid = iomObj.getobjectoid();
        IomObject refObj = iomObj.getattrobj("Objektname_von", 0);
        String ref = refObj.getobjectrefoid();
        String name = iomObj.getattrvalue("Name");
        if (this.geleise.contains(ref)) {
            this.geleisename.put(tid, name);
        }
    }

    private void mapEOObjektnamePos(IomObject iomObj) {
        IomObject refObj = iomObj.getattrobj("ObjektnamePos_von", 0);
        String ref = refObj.getobjectrefoid();
        String name = null;
        String layer = null;
        if (this.geleisename.containsKey(ref)) {
            name = this.geleisename.get(ref);
            layer = "01339";
        }
        if (layer != null) {
            String vali;
            String hali;
            Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Text", null);
            dxfObj.setattrvalue("layername", layer);
            dxfObj.setattrvalue("text", name);
            dxfObj.setattrvalue("text_size", "0.9");
            IomObject geom = iomObj.getattrobj("Pos", 0);
            if (this.perimeter != null) {
                try {
                    Coordinate coord = Iox2jts.coord2JTS(geom);
                    if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                        return;
                    }
                }
                catch (Iox2jtsException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            dxfObj.addattrobj("geom", geom);
            String ori = this.mapOri(iomObj.getattrvalue("Ori"));
            if (ori != null) {
                dxfObj.setattrvalue("ori", ori);
            }
            if ((hali = this.mapHali(iomObj.getattrvalue("HAli"))) != null) {
                dxfObj.setattrvalue("hali", hali);
            }
            if ((vali = this.mapVali(iomObj.getattrvalue("VAli"))) != null) {
                dxfObj.setattrvalue("vali", vali);
            }
            this.out.add(dxfObj);
        }
    }

    private void mapFlurname(IomObject iomObj) {
        if (this.perimeter != null) {
            IomObject geom = iomObj.getattrobj("Geometrie", 0);
            try {
                Polygon jtsGeom = Iox2jts.surface2JTS(geom, 1.0E-4);
                if (!this.intersectsPerimeter((Geometry)jtsGeom)) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        String tid = iomObj.getobjectoid();
        String name = iomObj.getattrvalue("Name");
        this.flurname_tid2name.put(tid, name);
    }

    private void mapFlurnamePos(IomObject iomObj) {
        String vali;
        String hali;
        IomObject refObj = iomObj.getattrobj("FlurnamePos_von", 0);
        String ref = refObj.getobjectrefoid();
        String name = this.flurname_tid2name.get(ref);
        if (name == null) {
            return;
        }
        String layer = "01519";
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Text", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.setattrvalue("text", name);
        dxfObj.setattrvalue("text_size", "1.8");
        IomObject geom = iomObj.getattrobj("Pos", 0);
        if (this.perimeter != null) {
            try {
                Coordinate coord = Iox2jts.coord2JTS(geom);
                if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        dxfObj.addattrobj("geom", geom);
        String ori = this.mapOri(iomObj.getattrvalue("Ori"));
        if (ori != null) {
            dxfObj.setattrvalue("ori", ori);
        }
        if ((hali = this.mapHali(iomObj.getattrvalue("HAli"))) != null) {
            dxfObj.setattrvalue("hali", hali);
        }
        if ((vali = this.mapVali(iomObj.getattrvalue("VAli"))) != null) {
            dxfObj.setattrvalue("vali", vali);
        }
        this.out.add(dxfObj);
    }

    private void mapOrtsname(IomObject iomObj) {
        if (this.perimeter != null) {
            IomObject geom = iomObj.getattrobj("Geometrie", 0);
            try {
                Polygon jtsGeom = Iox2jts.surface2JTS(geom, 1.0E-4);
                if (!this.intersectsPerimeter((Geometry)jtsGeom)) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        String tid = iomObj.getobjectoid();
        String name = iomObj.getattrvalue("Name");
        this.ortsname_tid2name.put(tid, name);
    }

    private void mapOrtsnamePos(IomObject iomObj) {
        String vali;
        String hali;
        IomObject refObj = iomObj.getattrobj("OrtsnamePos_von", 0);
        String ref = refObj.getobjectrefoid();
        String name = this.ortsname_tid2name.get(ref);
        if (name == null) {
            return;
        }
        String layer = "01529";
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Text", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.setattrvalue("text", name);
        dxfObj.setattrvalue("text_size", "1.8");
        IomObject geom = iomObj.getattrobj("Pos", 0);
        if (this.perimeter != null) {
            try {
                Coordinate coord = Iox2jts.coord2JTS(geom);
                if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        dxfObj.addattrobj("geom", geom);
        String ori = this.mapOri(iomObj.getattrvalue("Ori"));
        if (ori != null) {
            dxfObj.setattrvalue("ori", ori);
        }
        if ((hali = this.mapHali(iomObj.getattrvalue("HAli"))) != null) {
            dxfObj.setattrvalue("hali", hali);
        }
        if ((vali = this.mapVali(iomObj.getattrvalue("VAli"))) != null) {
            dxfObj.setattrvalue("vali", vali);
        }
        this.out.add(dxfObj);
    }

    private void mapGelaendename(IomObject iomObj) {
        String tid = iomObj.getobjectoid();
        String name = iomObj.getattrvalue("Name");
        this.gelaendename_tid2name.put(tid, name);
    }

    private void mapGelaendenamePos(IomObject iomObj) {
        String vali;
        String hali;
        IomObject refObj = iomObj.getattrobj("GelaendenamePos_von", 0);
        String ref = refObj.getobjectrefoid();
        String name = this.gelaendename_tid2name.get(ref);
        String layer = "01539";
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Text", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.setattrvalue("text", name);
        dxfObj.setattrvalue("text_size", "1.8");
        IomObject geom = iomObj.getattrobj("Pos", 0);
        if (this.perimeter != null) {
            try {
                Coordinate coord = Iox2jts.coord2JTS(geom);
                if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        dxfObj.addattrobj("geom", geom);
        String ori = this.mapOri(iomObj.getattrvalue("Ori"));
        if (ori != null) {
            dxfObj.setattrvalue("ori", ori);
        }
        if ((hali = this.mapHali(iomObj.getattrvalue("HAli"))) != null) {
            dxfObj.setattrvalue("hali", hali);
        }
        if ((vali = this.mapVali(iomObj.getattrvalue("VAli"))) != null) {
            dxfObj.setattrvalue("vali", vali);
        }
        this.out.add(dxfObj);
    }

    private void mapGrenzpunkt(IomObject iomObj) {
        String block = null;
        String layer = null;
        String punktzeichen = iomObj.getattrvalue("Punktzeichen");
        if (punktzeichen.equals("Stein")) {
            block = "GPSTE";
            layer = "01651";
        } else if (punktzeichen.equals("Kunststoffzeichen")) {
            block = "GPKST";
            layer = "01652";
        } else if (punktzeichen.equals("Bolzen")) {
            block = "GPBOL";
            layer = "01653";
        } else if (punktzeichen.equals("Rohr")) {
            block = "GPROH";
            layer = "01654";
        } else if (punktzeichen.equals("Pfahl")) {
            block = "GPPFA";
            layer = "01655";
        } else if (punktzeichen.equals("Kreuz")) {
            block = "GPKRZ";
            layer = "01656";
        } else if (punktzeichen.equals("unversichert")) {
            block = "GPUV";
            layer = "01657";
        }
        if (layer != null) {
            String tid = iomObj.getobjectoid();
            IomObject geom = iomObj.getattrobj("Geometrie", 0);
            if (this.perimeter != null) {
                try {
                    Coordinate coord = Iox2jts.coord2JTS(geom);
                    if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                        return;
                    }
                }
                catch (Iox2jtsException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.BlockInsert", null);
            dxfObj.setattrvalue("layername", layer);
            dxfObj.setattrvalue("block", block);
            dxfObj.addattrobj("geom", geom);
            this.out.add(dxfObj);
        }
    }

    private void mapProjGrundstueck(IomObject iomObj) {
        String tid = iomObj.getobjectoid();
        String art = iomObj.getattrvalue("Art");
        String nummer = iomObj.getattrvalue("Nummer");
        if (art.equals("Liegenschaft")) {
            this.projLiegenschaften.put(tid, nummer);
        } else if (art.equals("SelbstRecht.Baurecht") || art.equals("SelbstRecht.Konzessionsrecht") || art.equals("SelbstRecht.Quellenrecht") || art.equals("SelbstRecht.weitere")) {
            this.projSelbstRecht.put(tid, nummer);
        }
    }

    private void mapProjGrundstueckPos(IomObject iomObj) {
        IomObject refObj = iomObj.getattrobj("ProjGrundstueckPos_von", 0);
        String ref = refObj.getobjectrefoid();
        String nummer = null;
        String layer = null;
        if (this.projLiegenschaften.containsKey(ref)) {
            nummer = this.projLiegenschaften.get(ref);
            layer = "01629";
        } else if (this.projSelbstRecht.containsKey(ref)) {
            nummer = "(" + this.projSelbstRecht.get(ref) + ")";
            layer = "01649";
        }
        if (nummer != null) {
            String vali;
            String hali;
            Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Text", null);
            dxfObj.setattrvalue("layername", layer);
            dxfObj.setattrvalue("text", nummer);
            dxfObj.setattrvalue("text_size", "1.35");
            IomObject geom = iomObj.getattrobj("Pos", 0);
            if (this.perimeter != null) {
                try {
                    Coordinate coord = Iox2jts.coord2JTS(geom);
                    if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                        return;
                    }
                }
                catch (Iox2jtsException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            dxfObj.addattrobj("geom", geom);
            String ori = this.mapOri(iomObj.getattrvalue("Ori"));
            if (ori != null) {
                dxfObj.setattrvalue("ori", ori);
            }
            if ((hali = this.mapHali(iomObj.getattrvalue("HAli"))) != null) {
                dxfObj.setattrvalue("hali", hali);
            }
            if ((vali = this.mapVali(iomObj.getattrvalue("VAli"))) != null) {
                dxfObj.setattrvalue("vali", vali);
            }
            this.out.add(dxfObj);
        }
    }

    private void mapProjLiegenschaft(IomObject iomObj) {
        String tid = iomObj.getobjectoid();
        String layer = null;
        layer = "01621";
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                Polygon jtsGeom = Iox2jts.surface2JTS(geom, 1.0E-4);
                if (!this.intersectsPerimeter((Geometry)jtsGeom)) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Polygon2d", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapProjSelbstRecht(IomObject iomObj) {
        String tid = iomObj.getobjectoid();
        String layer = null;
        layer = "01641";
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                Polygon jtsGeom = Iox2jts.surface2JTS(geom, 1.0E-4);
                if (!this.intersectsPerimeter((Geometry)jtsGeom)) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Polygon2d", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapGrundstueck(IomObject iomObj) {
        String tid = iomObj.getobjectoid();
        String art = iomObj.getattrvalue("Art");
        String nummer = iomObj.getattrvalue("Nummer");
        if (art.equals("Liegenschaft")) {
            this.liegenschaften.put(tid, nummer);
        } else if (art.equals("SelbstRecht.Baurecht") || art.equals("SelbstRecht.Konzessionsrecht") || art.equals("SelbstRecht.Quellenrecht") || art.equals("SelbstRecht.weitere")) {
            this.selbstRecht.put(tid, nummer);
        }
    }

    private void mapGrundstueckPos(IomObject iomObj) {
        IomObject refObj = iomObj.getattrobj("GrundstueckPos_von", 0);
        String ref = refObj.getobjectrefoid();
        String nummer = null;
        String layer = null;
        if (this.liegenschaften.containsKey(ref)) {
            nummer = this.liegenschaften.get(ref);
            layer = "01619";
        } else if (this.selbstRecht.containsKey(ref)) {
            nummer = "(" + this.selbstRecht.get(ref) + ")";
            layer = "01639";
        }
        if (nummer != null) {
            String vali;
            String hali;
            Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Text", null);
            dxfObj.setattrvalue("layername", layer);
            dxfObj.setattrvalue("text", nummer);
            dxfObj.setattrvalue("text_size", "1.35");
            IomObject geom = iomObj.getattrobj("Pos", 0);
            if (this.perimeter != null) {
                try {
                    Coordinate coord = Iox2jts.coord2JTS(geom);
                    if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                        return;
                    }
                }
                catch (Iox2jtsException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            dxfObj.addattrobj("geom", geom);
            String ori = this.mapOri(iomObj.getattrvalue("Ori"));
            if (ori != null) {
                dxfObj.setattrvalue("ori", ori);
            }
            if ((hali = this.mapHali(iomObj.getattrvalue("HAli"))) != null) {
                dxfObj.setattrvalue("hali", hali);
            }
            if ((vali = this.mapVali(iomObj.getattrvalue("VAli"))) != null) {
                dxfObj.setattrvalue("vali", vali);
            }
            this.out.add(dxfObj);
        }
    }

    private void mapLiegenschaft(IomObject iomObj) {
        String tid = iomObj.getobjectoid();
        String layer = null;
        layer = "01611";
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                Polygon jtsGeom = Iox2jts.surface2JTS(geom, 1.0E-4);
                if (!this.intersectsPerimeter((Geometry)jtsGeom)) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Polygon2d", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapSelbstRecht(IomObject iomObj) {
        String tid = iomObj.getobjectoid();
        String layer = null;
        layer = "01631";
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                Polygon jtsGeom = Iox2jts.surface2JTS(geom, 1.0E-4);
                if (!this.intersectsPerimeter((Geometry)jtsGeom)) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Polygon2d", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapRLLinienelement(IomObject iomObj) {
        String layer = "01712";
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                LineString jtsGeom = Iox2jts.polyline2JTSlineString(geom, false, 1.0E-4);
                if (!this.intersectsPerimeter((Geometry)jtsGeom)) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Polyline2d", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapHoheitsgrenzpunkt(IomObject iomObj) {
        String block = "HGP";
        String layer = "01812";
        if (layer != null) {
            String tid = iomObj.getobjectoid();
            IomObject geom = iomObj.getattrobj("Geometrie", 0);
            if (this.perimeter != null) {
                try {
                    Coordinate coord = Iox2jts.coord2JTS(geom);
                    if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                        return;
                    }
                }
                catch (Iox2jtsException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.BlockInsert", null);
            dxfObj.setattrvalue("layername", layer);
            dxfObj.setattrvalue("block", block);
            dxfObj.addattrobj("geom", geom);
            this.out.add(dxfObj);
        }
    }

    private void mapGemeindegrenze(IomObject iomObj) {
        String tid = iomObj.getobjectoid();
        String layer = null;
        layer = "01811";
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                Polygon jtsGeom = Iox2jts.surface2JTS(geom, 1.0E-4);
                if (!this.intersectsPerimeter((Geometry)jtsGeom)) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Polygon2d", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapBezirksgrenzabschnitt(IomObject iomObj) {
        String layer = "01821";
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                LineString jtsGeom = Iox2jts.polyline2JTSlineString(geom, false, 1.0E-4);
                if (!this.intersectsPerimeter((Geometry)jtsGeom)) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Polyline2d", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapKantonsgrenzabschnitt(IomObject iomObj) {
        String layer = "01831";
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                LineString jtsGeom = Iox2jts.polyline2JTSlineString(geom, false, 1.0E-4);
                if (!this.intersectsPerimeter((Geometry)jtsGeom)) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Polyline2d", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapLandesgrenzabschnitt(IomObject iomObj) {
        String layer = "01841";
        IomObject geom = iomObj.getattrobj("Geometrie", 0);
        if (this.perimeter != null) {
            try {
                LineString jtsGeom = Iox2jts.polyline2JTSlineString(geom, false, 1.0E-4);
                if (!this.intersectsPerimeter((Geometry)jtsGeom)) {
                    return;
                }
            }
            catch (Iox2jtsException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Polyline2d", null);
        dxfObj.setattrvalue("layername", layer);
        dxfObj.addattrobj("geom", geom);
        this.out.add(dxfObj);
    }

    private void mapLokalisationsName(IomObject iomObj) {
        String tid = iomObj.getobjectoid();
        String text = iomObj.getattrvalue("Text");
        this.lokalisationsName.put(tid, text);
    }

    private void mapLokalisationsNamePos(IomObject iomObj) {
        IomObject refObj = iomObj.getattrobj("LokalisationsNamePos_von", 0);
        String ref = refObj.getobjectrefoid();
        String text = null;
        String layer = null;
        if (this.lokalisationsName.containsKey(ref)) {
            text = this.lokalisationsName.get(ref);
            layer = "01229";
        }
        if (text != null) {
            String vali;
            String hali;
            Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Text", null);
            dxfObj.setattrvalue("layername", layer);
            dxfObj.setattrvalue("text", text);
            dxfObj.setattrvalue("text_size", "1.5");
            IomObject geom = iomObj.getattrobj("Pos", 0);
            if (this.perimeter != null) {
                try {
                    Coordinate coord = Iox2jts.coord2JTS(geom);
                    if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                        return;
                    }
                }
                catch (Iox2jtsException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            dxfObj.addattrobj("geom", geom);
            String ori = this.mapOri(iomObj.getattrvalue("Ori"));
            if (ori != null) {
                dxfObj.setattrvalue("ori", ori);
            }
            if ((hali = this.mapHali(iomObj.getattrvalue("HAli"))) != null) {
                dxfObj.setattrvalue("hali", hali);
            }
            if ((vali = this.mapVali(iomObj.getattrvalue("VAli"))) != null) {
                dxfObj.setattrvalue("vali", vali);
            }
            this.out.add(dxfObj);
        }
    }

    private void mapGebaeudeeingang(IomObject iomObj) {
        String tid = iomObj.getobjectoid();
        String hausnummer = iomObj.getattrvalue("Hausnummer");
        String status = iomObj.getattrvalue("Status");
        if (status.equals("real")) {
            this.hausnummerReal.put(tid, hausnummer);
        } else if (status.equals("projektiert")) {
            this.hausnummerProjektiert.put(tid, hausnummer);
        }
    }

    private void mapHausnummerPos(IomObject iomObj) {
        IomObject refObj = iomObj.getattrobj("HausnummerPos_von", 0);
        String ref = refObj.getobjectrefoid();
        String nummer = null;
        String layer = null;
        if (this.hausnummerReal.containsKey(ref)) {
            nummer = this.hausnummerReal.get(ref);
            layer = "01219";
        } else if (this.hausnummerProjektiert.containsKey(ref)) {
            nummer = this.hausnummerProjektiert.get(ref);
            layer = "01919";
        }
        if (nummer != null) {
            String vali;
            String hali;
            Iom_jObject dxfObj = new Iom_jObject("Dxf.Topic.Text", null);
            dxfObj.setattrvalue("layername", layer);
            dxfObj.setattrvalue("text", nummer);
            dxfObj.setattrvalue("text_size", "0.9");
            IomObject geom = iomObj.getattrobj("Pos", 0);
            if (this.perimeter != null) {
                try {
                    Coordinate coord = Iox2jts.coord2JTS(geom);
                    if (!this.intersectsPerimeter((Geometry)this.jtsFactory.createPoint(coord))) {
                        return;
                    }
                }
                catch (Iox2jtsException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            dxfObj.addattrobj("geom", geom);
            String ori = this.mapOri(iomObj.getattrvalue("Ori"));
            if (ori != null) {
                dxfObj.setattrvalue("ori", ori);
            }
            if ((hali = this.mapHali(iomObj.getattrvalue("HAli"))) != null) {
                dxfObj.setattrvalue("hali", hali);
            }
            if ((vali = this.mapVali(iomObj.getattrvalue("VAli"))) != null) {
                dxfObj.setattrvalue("vali", vali);
            }
            this.out.add(dxfObj);
        }
    }

    public void setPerimeter(Geometry perimeter1) {
        this.perimeter = perimeter1;
    }

    private boolean intersectsPerimeter(Geometry geom) {
        return this.perimeter.intersects(geom);
    }
}

