/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.view;

import ch.ehi.basics.i18n.ResourceBundle;
import java.io.File;
import java.io.FileFilter;

public class GenericFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private static java.util.ResourceBundle resources = ResourceBundle.getBundle(GenericFileFilter.class);
    private String description;
    private String extension;

    public GenericFileFilter(String description, String extension) {
        this.description = description;
        this.extension = extension;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String ext = GenericFileFilter.getFileExtension(f);
        if (ext != null) {
            return ext.equalsIgnoreCase(this.extension);
        }
        return false;
    }

    public static GenericFileFilter createCsvFilter() {
        return new GenericFileFilter(resources.getString("CICsvFilter"), "csv");
    }

    public static GenericFileFilter createXlsFilter() {
        return new GenericFileFilter("MS Excel", "xls");
    }

    public static GenericFileFilter createHtmlFilter() {
        return new GenericFileFilter(resources.getString("CIHtmlFilter"), "html");
    }

    public static GenericFileFilter createSqlFilter() {
        return new GenericFileFilter(resources.getString("CISqlFilter"), "sql");
    }

    public static GenericFileFilter createXmlFilter() {
        return new GenericFileFilter(resources.getString("CIXmlFilter"), "xml");
    }

    public static GenericFileFilter createXmlSchemaFilter() {
        return new GenericFileFilter(resources.getString("CIXsdFilter"), "xsd");
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getExtension() {
        return this.extension;
    }

    public static String getFileExtension(String s) {
        String ext = null;
        int i = s.lastIndexOf(46);
        if (i >= 0 && i < s.length()) {
            ext = s.substring(i + 1);
        }
        return ext;
    }

    public static String getFileExtension(File f) {
        String s = f.getName();
        return GenericFileFilter.getFileExtension(s);
    }

    public static String stripFileExtension(String s) {
        String name = s;
        int i = s.lastIndexOf(46);
        if (i >= 0 && i < s.length()) {
            name = s.substring(0, i);
        }
        return name;
    }

    public static String stripFileExtension(File f) {
        String s = f.getName();
        return GenericFileFilter.stripFileExtension(s);
    }
}

