/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractCoordType;
import ch.interlis.ili2c.metamodel.AbstractLeafElement;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.Type;
import java.util.List;

public class ContextDef
extends AbstractLeafElement {
    protected String name = null;
    private Domain generic = null;
    private Domain[] concretes = null;

    public ContextDef(String name, Domain generic, Domain[] concretes) {
        this.name = name;
        this.generic = generic;
        this.concretes = concretes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Domain getGeneric() {
        return this.generic;
    }

    public Domain[] getConcretes() {
        return this.concretes;
    }

    @Override
    public void checkIntegrity(List<Ili2cSemanticException> errs) throws IllegalStateException {
        Domain[] genericCoord;
        super.checkIntegrity(errs);
        Type genericType = this.generic.getType();
        if (genericType instanceof AbstractCoordType && !(genericCoord = (Domain[])genericType).isGeneric()) {
            throw new IllegalStateException(ContextDef.formatMessage("err_contextdef_domain_not_generic", this.generic.getName(), this.getName()));
        }
        for (Domain concrete : this.concretes) {
            concrete.getType().checkTypeExtension(genericType);
        }
        Model model = (Model)this.getContainer(Model.class);
        Domain[] concretesAllowedInImportedModel = model.resolveGenericDomainFromImportedModels(this.generic);
        if (concretesAllowedInImportedModel != null) {
            for (Domain concrete : this.concretes) {
                if (this.matchesOrExtendsAllowedDomain(concrete, concretesAllowedInImportedModel)) continue;
                throw new IllegalStateException(ContextDef.formatMessage("err_contextdef_domain_not_extending", concrete.getName(), this.generic.getName()));
            }
        }
    }

    private boolean matchesOrExtendsAllowedDomain(Domain concrete, Domain[] allowedInImportedModel) {
        for (Domain allowed : allowedInImportedModel) {
            if (concrete != allowed && !concrete.isExtendingIndirectly(allowed)) continue;
            return true;
        }
        return false;
    }
}

